/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common;

import com.kingdee.cosmic.ctrl.common.GlobalLocator;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Logger;

public class CtrlPropertyConfig {
    private static final Logger logger = LogUtil.getPackageLogger(CtrlPropertyConfig.class);
    public String url;
    public Properties properties;

    public CtrlPropertyConfig(String url) {
        this.url = url;
        this.properties = this.loadProperties();
    }

    public void setPropertyFileLocation(String fileurl) {
        this.url = fileurl;
        this.properties = this.loadProperties();
    }

    public void addProperty(String key, String value) {
        this.getProperties().put(key, value);
        this.store();
    }

    public String getProperty(String key) {
        return this.getProperties().getProperty(key);
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = this.loadProperties();
        }
        return this.properties;
    }

    private void store() {
        File configFile = GlobalLocator.getInstance().locateResourceFile(this.url);
        if (configFile != null) {
            try (FileOutputStream fos = new FileOutputStream(configFile);){
                this.properties.store(fos, "");
            }
            catch (FileNotFoundException e) {
                logger.error((Object)"FileNotFoundException:", (Throwable)e);
            }
            catch (IOException e) {
                logger.error((Object)"error:", (Throwable)e);
            }
        }
    }

    private Properties loadProperties() {
        File configFile = GlobalLocator.getInstance().locateResourceFile(this.url);
        Properties proper = null;
        if (configFile != null) {
            proper = new Properties();
            try (FileInputStream fis = new FileInputStream(configFile);){
                proper.load(fis);
            }
            catch (FileNotFoundException e) {
                logger.error((Object)"FileNotFoundException:", (Throwable)e);
            }
            catch (IOException e) {
                logger.error((Object)"IOException:", (Throwable)e);
            }
        }
        return proper;
    }
}

