/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlParsingException;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.common.GlobalLocator;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class VersionManager {
    private static Logger logger = LogUtil.getPackageLogger(VersionManager.class);
    private GlobalLocator globalLocator;
    private String localFile;
    private String resourceFile;
    private IXmlElement localRoot;

    public VersionManager(GlobalLocator gl) {
        this.globalLocator = gl;
        this.localFile = gl.makeFilePath("/CtrlConfig.xml");
        this.resourceFile = gl.makeResourcePath("/CtrlConfig.xml");
    }

    public void update() {
        IXmlElement root = null;
        ClassLoader clsLdr = this.getClass().getClassLoader();
        if (clsLdr == null) {
            clsLdr = ClassLoader.getSystemClassLoader();
        }
        try (InputStream inputStream = clsLdr.getResourceAsStream(this.resourceFile);){
            root = XmlUtil.loadRootElement((InputStream)inputStream);
        }
        catch (IOException e) {
            logger.error((Object)"", (Throwable)e);
            return;
        }
        catch (XmlParsingException e) {
            logger.error((Object)"", (Throwable)e);
            return;
        }
        IXmlElement folder = root.getChild("Folder");
        this.updateFolder(folder, null);
        if (this.localRoot != null) {
            try {
                XmlUtil.saveFile((IXmlElement)this.localRoot, (File)new File(FilenameUtils.normalize((String)this.localFile)));
            }
            catch (IOException e) {
                logger.error((Object)"", (Throwable)e);
                return;
            }
        }
    }

    private void updateFolder(IXmlElement folderNode, XMLPath parentPath) {
        for (IXmlElement child : folderNode.getChildren()) {
            String name = child.getAttribute("name");
            if (StringUtil.isEmptyString(name)) continue;
            XMLPath currentPath = new XMLPath(parentPath, child.getAttribute("name"));
            if (StringUtil.equalsIgnoreCase(child.getName(), "Folder")) {
                this.updateFolder(child, currentPath);
                continue;
            }
            if (!StringUtil.equalsIgnoreCase(child.getName(), "File")) continue;
            this.updateFile(child, currentPath);
        }
    }

    private void updateFile(IXmlElement fileNode, XMLPath path) {
        if (this.localRoot == null) {
            this.localRoot = this.getLocalFileRoot();
        }
        IXmlElement parallelNode = this.getLocalParallelNode(this.localRoot, path);
        String localVersion = parallelNode.getAttribute("version");
        float localVer = 0.0f;
        if (!StringUtil.isEmptyString(localVersion)) {
            localVer = Float.parseFloat(localVersion);
        }
        String version = fileNode.getAttribute("version");
        float ver = Float.parseFloat(version);
        String updator = fileNode.getAttribute("updator");
        if (ver > localVer) {
            String tempVar = path.getPathString();
            try {
                boolean exist = new File(FilenameUtils.normalize((String)this.globalLocator.makeFilePath(tempVar))).exists();
                if (StringUtil.isEmptyString(updator)) {
                    logger.info((Object)("Overriding file: " + tempVar));
                    this.globalLocator.createResourceFile(tempVar);
                    parallelNode.setAttribute("version", version);
                } else if (!exist) {
                    logger.info((Object)("Creating file : " + tempVar));
                    this.globalLocator.createResourceFile(tempVar);
                    parallelNode.setAttribute("version", version);
                } else {
                    logger.info((Object)("Updating file: " + updator));
                    Object cls = null;
                    cls = Class.forName(updator).newInstance();
                    IUpdator udt = null;
                    if (cls instanceof IUpdator) {
                        udt = cls;
                        if (udt.doUpdate()) {
                            logger.info((Object)"Updated successfully.");
                            parallelNode.setAttribute("version", version);
                            return;
                        }
                        logger.error((Object)"Update failed.");
                        return;
                    }
                    logger.error((Object)"Cannot locate (Updator) object.");
                }
            }
            catch (Exception e) {
                logger.error((Object)"Cannot create object(Updator) for update.", (Throwable)e);
            }
        }
    }

    private IXmlElement getLocalParallelNode(IXmlElement root, XMLPath xmlPath) {
        IXmlElement node = root;
        String[] path = xmlPath.getPath();
        for (int i = 0; i < path.length; ++i) {
            String name = path[i];
            node = this.getChildByAttribute(node, "name", name, i == path.length - 1);
        }
        return node;
    }

    private IXmlElement getChildByAttribute(IXmlElement parentNode, String attr, String attrValue, boolean isFile) {
        IXmlElement child2;
        if (parentNode == null) {
            return null;
        }
        for (IXmlElement child2 : parentNode.getChildren()) {
            if (!StringUtil.equals(child2.getAttribute(attr), attrValue)) continue;
            return child2;
        }
        child2 = isFile ? XmlUtil.createNode((String)"File") : XmlUtil.createNode((String)"Folder");
        child2.setAttribute(attr, attrValue);
        parentNode.addChild(child2);
        return child2;
    }

    private IXmlElement getLocalFileRoot() {
        IXmlElement root = null;
        try (FileInputStream fileInputStream = new FileInputStream(FilenameUtils.normalize((String)this.localFile));){
            root = XmlUtil.loadRootElement((InputStream)fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        catch (XmlParsingException xmlParsingException) {
            // empty catch block
        }
        if (root == null) {
            root = XmlUtil.createNode((String)"CtrlConfig");
            root.setAttribute("version", "1.0");
        }
        return root;
    }

    public static interface IUpdator {
        public boolean doUpdate();
    }

    private static class XMLPath {
        private XMLPath parentPath;
        private String name;

        public XMLPath(XMLPath parentPath, String name) {
            this.parentPath = parentPath;
            this.name = name;
        }

        public String getPathString() {
            XMLPath parent = this.parentPath;
            String pathStr = "/" + this.name;
            while (parent != null) {
                pathStr = "/" + parent.name + pathStr;
                parent = parent.parentPath;
            }
            return pathStr;
        }

        public String[] getPath() {
            int deep = this.getDeep();
            String[] path = new String[deep];
            XMLPath parent = this.parentPath;
            path[--deep] = this.name;
            while (parent != null) {
                path[--deep] = parent.name;
                parent = parent.parentPath;
            }
            return path;
        }

        public int getDeep() {
            XMLPath parent = this.parentPath;
            int deep = 1;
            while (parent != null) {
                parent = parent.parentPath;
                ++deep;
            }
            return deep;
        }

        public String getName() {
            return this.name;
        }
    }
}

