/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.datacenter;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonMessages;

public class DataCenterDBType {
    public static final int INT_SUPER_QUERY = -10;
    public static final int INT_DB2 = 1;
    public static final int INT_ORACLE = 2;
    public static final int INT_SQLSERVER = 3;
    public static final int INT_POSTGRESQL = 5;
    public static final int INT_MYSQL = 6;
    public static final int INT_DM = 11;
    public static final int INT_GREENPLUM = 104;
    public static final DataCenterDBType DB2 = new DataCenterDBType("DB2", 1);
    public static final DataCenterDBType ORACLE = new DataCenterDBType("ORACLE", 2);
    public static final DataCenterDBType SQLSERVER = new DataCenterDBType("SQLSERVER", 3);
    public static final DataCenterDBType MYSQL = new DataCenterDBType("MYSQL", 6);
    public static final DataCenterDBType POSTGRESQL = new DataCenterDBType("POSTGRESQL", 5);
    public static final DataCenterDBType DM = new DataCenterDBType("DM", 11);
    public static final DataCenterDBType SUPER_QUERY = new DataCenterDBType(-10);
    public static final DataCenterDBType GREENPLUM = new DataCenterDBType("Greenplum", 104);
    private String name;
    private int intValue;

    private DataCenterDBType(String name, int i) {
        this.name = name;
        this.intValue = i;
    }

    private DataCenterDBType(int i) {
        this.intValue = i;
    }

    public int intValue() {
        return this.intValue;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        switch (this.intValue) {
            case -10: {
                return CtrlCommonMessages.getMLS("superQueryName", "\u8d85\u7ea7\u67e5\u8be2");
            }
        }
        return this.name;
    }

    public static final int DataBaseConnecttoDBType(String dbName) {
        String lowerCase = dbName.toLowerCase();
        if (lowerCase.contains("db2")) {
            return 1;
        }
        if (lowerCase.contains("oracle")) {
            return 2;
        }
        if (lowerCase.contains("sqlserver")) {
            return 3;
        }
        if (lowerCase.contains("postgresql")) {
            return 5;
        }
        if (lowerCase.contains("mysql")) {
            return 6;
        }
        if (lowerCase.contains("dm")) {
            return 11;
        }
        if (lowerCase.contains("superquery")) {
            return -10;
        }
        if (lowerCase.contains("greenplum")) {
            return 104;
        }
        return -1;
    }

    public static final DataCenterDBType getDBType(int intValue) {
        switch (intValue) {
            case 1: {
                return DB2;
            }
            case 2: {
                return ORACLE;
            }
            case 3: {
                return SQLSERVER;
            }
            case 6: {
                return MYSQL;
            }
            case 5: {
                return POSTGRESQL;
            }
            case 11: {
                return DM;
            }
            case -10: {
                return SUPER_QUERY;
            }
            case 104: {
                return GREENPLUM;
            }
        }
        return null;
    }

    public static final DataCenterDBType getDBType(String strValue) {
        int intValue = Integer.parseInt(strValue);
        return DataCenterDBType.getDBType(intValue);
    }
}

