/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.layout.table;

import com.kingdee.cosmic.ctrl.common.layout.table.SizeInfo;

public final class SizeAdjustor {
    private static final int PRI_OUT = -1;
    private int _count;
    private SizeInfo[] _aInfo;
    private SizeInfo[] _aOut;
    protected int _total;
    protected int _totalMin;
    protected int _totalMax;

    public SizeAdjustor(int count) {
        this._count = count;
        this._aInfo = new SizeInfo[this._count];
        this._aOut = new SizeInfo[this._count];
        for (int i = 0; i < this._count; ++i) {
            this._aInfo[i] = new SizeInfo();
            this._aOut[i] = this._aInfo[i];
        }
    }

    public SizeAdjustor(SizeAdjustor src) {
        this._count = src._count;
        this._aInfo = new SizeInfo[this._count];
        this._aOut = new SizeInfo[this._count];
        for (int i = 0; i < this._count; ++i) {
            this._aInfo[i] = new SizeInfo();
            this._aInfo[i].copy(src._aInfo[i]);
            this._aOut[i] = this._aInfo[i];
        }
    }

    public int getCount() {
        return this._count;
    }

    public int getTotal() {
        return this._total;
    }

    public int getTotalMin() {
        return this._totalMin;
    }

    public int getTotalMax() {
        return this._totalMax;
    }

    public SizeInfo getInfoAt(int index) {
        return this._aInfo[index];
    }

    public int getOutAt(int index) {
        return this._aInfo[index]._out;
    }

    public int useSpace() {
        int percent = 0;
        int totalVal = 0;
        for (int i = this._count - 1; i >= 0; --i) {
            SizeInfo si = this._aOut[i];
            if (si._val <= -1 && si._val >= -100) {
                percent -= si._val;
                continue;
            }
            totalVal += si._val;
        }
        if (percent == 0) {
            return this.fitSpace(totalVal);
        }
        if (percent > 100) {
            percent = 100;
        }
        return this.fitSpace(totalVal * percent / 100);
    }

    public int fitSpace(int space) {
        int i;
        int j;
        int offset;
        int last;
        this.totalInfo(space);
        this.sortInfoByPri();
        if (space == this._total || this._totalMin == this._totalMax) {
            this.makeInfoOut(0, this._count - 1);
            return this._total;
        }
        if (space <= this._totalMin) {
            this.makeInfoMin(-1);
            this._total = this._totalMin;
            return this._total;
        }
        if (space >= this._totalMax) {
            this.makeInfoMin(-1);
            this._total = this.totalInfoOut();
            return this._total;
        }
        for (last = this._count - 1; last >= 0 && this._aOut[last]._pri <= -1; --last) {
        }
        boolean isRemain = space > this._total;
        int remain = offset = space - this._total;
        int pri = this._aOut[0]._pri;
        for (j = i = 0; j <= last; ++j) {
            SizeInfo si = this._aOut[j];
            if (si._pri != pri) {
                if (isRemain ? offset < 0 : offset > 0) break;
                i = j;
                pri = si._pri;
                remain = offset;
            }
            si._out = isRemain ? si._max : si._min;
            offset += si._val - si._out;
        }
        if (j < last) {
            this.makeInfoOut(j, last);
        }
        this.averageRemainSpace(i, j - 1, remain);
        this._total = space;
        return this._total;
    }

    private void averageRemainSpace(int start, int end, int offset) {
        int k;
        int valids = end - start + 1;
        block0: do {
            int n = 0;
            int valid = 0;
            for (k = start; k <= end; ++k) {
                SizeInfo si = this._aOut[k];
                if (si._hasOut) continue;
                int m = ++valid * offset / valids;
                si._out = si._val + m - n;
                if (si._out < si._min) {
                    --valids;
                    offset += si._val - si._min;
                    si._hasOut = true;
                    si._out = si._min;
                    continue block0;
                }
                if (si._out > si._max) {
                    --valids;
                    offset += si._max - si._val;
                    si._hasOut = true;
                    si._out = si._max;
                    continue block0;
                }
                n = m;
            }
        } while (k <= end);
        this.makeInfoOut(start, end);
    }

    private void totalInfo(int space) {
        this._total = 0;
        this._totalMin = 0;
        this._totalMax = 0;
        for (int i = this._count - 1; i >= 0; --i) {
            SizeInfo si = this._aOut[i];
            if (si._val <= -1 && si._val >= -100) {
                si._val = -si._val * space / 100;
            }
            si.makeValid();
            if (si._min < si._max) {
                si._out = si._val;
            } else {
                si._pri = -1;
                si._hasOut = true;
                si._out = si._min;
            }
            this._total += si._val;
            this._totalMin += si._min;
            this._totalMax += si._max;
        }
    }

    private void sortInfoByPri() {
        for (int i = 0; i < this._count; ++i) {
            int k = i;
            int priMax = this._aOut[k]._pri;
            for (int j = i + 1; j < this._count; ++j) {
                if (priMax >= this._aOut[j]._pri) continue;
                k = j;
                priMax = this._aOut[k]._pri;
            }
            if (k == i) continue;
            SizeInfo si = this._aOut[i];
            this._aOut[i] = this._aOut[k];
            this._aOut[k] = si;
        }
    }

    private void makeInfoOut(int start, int end) {
        for (int i = start; i <= end; ++i) {
            this._aOut[i]._hasOut = true;
        }
    }

    private void makeInfoMin(int pri) {
        for (int i = this._count - 1; i >= 0; --i) {
            SizeInfo si = this._aOut[i];
            if (si._pri < pri) continue;
            si._hasOut = true;
            si._out = si._min;
        }
    }

    private int totalInfoOut() {
        int total = 0;
        for (int i = this._count - 1; i >= 0; --i) {
            total += this._aOut[i]._out;
        }
        return total;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < this._count; ++i) {
            s.append("\r\n[" + i + "] <Size>" + this._aInfo[i] + "</Size>");
        }
        return "count=" + this._count + s.toString();
    }
}

