/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.layout.table2;

import com.kingdee.cosmic.ctrl.common.layout.table2.CellOccupied;
import com.kingdee.cosmic.ctrl.common.layout.table2.RowColLength;
import com.kingdee.cosmic.ctrl.common.util.ArrayUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.HashMap;

public class TableLayout2
implements LayoutManager2 {
    public static int[] ALL = null;
    private static RowColLength defaultLength = new RowColLength(1);
    private RowColLength[] rowHeights;
    private RowColLength[] colWidths;
    private int[] rowSpacings;
    private int[] colSpacings;
    private FixedLength[] fixedRowHeights;
    private FixedLength[] fixedColWidths;
    private HashMap comps = new HashMap();

    public static CellOccupied param(int row, int col) {
        return new CellOccupied(row, col);
    }

    public static CellOccupied param(int fromRow, int fromCol, int toRow, int toCol) {
        return new CellOccupied(fromRow, fromCol, toRow, toCol);
    }

    public TableLayout2(int rows, int cols) {
        if (rows <= 0 || cols <= 0) {
            throw new IllegalArgumentException("rows and cols must be greater than zero.");
        }
        this.rowHeights = new RowColLength[rows];
        this.colWidths = new RowColLength[cols];
        this.rowSpacings = new int[rows - 1];
        this.colSpacings = new int[cols - 1];
    }

    private RowColLength getRowHeight(int rowIdx) {
        if (rowIdx < 0 || rowIdx >= this.rowHeights.length) {
            throw new IllegalArgumentException("rowIdx invalid.");
        }
        if (this.rowHeights[rowIdx] == null) {
            this.rowHeights[rowIdx] = new RowColLength(1);
        }
        return this.rowHeights[rowIdx];
    }

    private void setRowHeight(int rowIdx, int value, boolean isPercent) {
        if (rowIdx < 0 || rowIdx >= this.rowHeights.length) {
            throw new IllegalArgumentException("rowIdx invalid.");
        }
        this.getRowHeight(rowIdx).setValue(value, isPercent);
    }

    private void setRowsHeight(int[] rowIdxs, int value, boolean isPercent) {
        int count = rowIdxs == null ? this.rowHeights.length : rowIdxs.length;
        for (int i = 0; i < count; ++i) {
            int rowIdx = rowIdxs == null ? i : rowIdxs[i];
            this.setRowHeight(rowIdx, value, isPercent);
        }
    }

    public void setFixedHeight(int rowIdx, int value) {
        this.setRowHeight(rowIdx, value, false);
    }

    public void setFixedHeight(int[] rowIdxs, int value) {
        this.setRowsHeight(rowIdxs, value, false);
    }

    public void setRatableHeight(int rowIdx, int value) {
        this.setRowHeight(rowIdx, value, true);
    }

    public void setRatableHeight(int[] rowIdxs, int value) {
        this.setRowsHeight(rowIdxs, value, true);
    }

    private RowColLength getColWidth(int colIdx) {
        if (colIdx < 0 || colIdx >= this.colWidths.length) {
            throw new IllegalArgumentException("colIdx invalid.");
        }
        if (this.colWidths[colIdx] == null) {
            this.colWidths[colIdx] = new RowColLength(1);
        }
        return this.colWidths[colIdx];
    }

    private void setColWidth(int colIdx, int value, boolean isPercent) {
        if (colIdx < 0 || colIdx >= this.colWidths.length) {
            throw new IllegalArgumentException("colIdx invalid.");
        }
        this.getColWidth(colIdx).setValue(value, isPercent);
    }

    private void setColsWidth(int[] colIdxs, int value, boolean isPercent) {
        int count = colIdxs == null ? this.colWidths.length : colIdxs.length;
        for (int i = 0; i < count; ++i) {
            int colIdx = colIdxs == null ? i : colIdxs[i];
            this.setColWidth(colIdx, value, isPercent);
        }
    }

    public void setFixedWidth(int colIdx, int value) {
        this.setColWidth(colIdx, value, false);
    }

    public void setFixedWidth(int[] colIdxs, int value) {
        this.setColsWidth(colIdxs, value, false);
    }

    public void setRatableWidth(int colIdx, int value) {
        this.setColWidth(colIdx, value, true);
    }

    public void setRatableWidth(int[] colIdxs, int value) {
        this.setColsWidth(colIdxs, value, true);
    }

    public void setRowSpacing(int afterRow, int spacing) {
        this.rowSpacings[afterRow] = spacing;
    }

    public void setRowsSpacing(int[] afterRows, int spacing) {
        int count = afterRows == null ? this.rowSpacings.length : afterRows.length;
        for (int i = 0; i < count; ++i) {
            int rowIdx = afterRows == null ? i : afterRows[i];
            this.setRowSpacing(rowIdx, spacing);
        }
    }

    public void setColSpacing(int afterCol, int spacing) {
        this.colSpacings[afterCol] = spacing;
    }

    public void setColsSpacing(int[] afterCols, int spacing) {
        int count = afterCols == null ? this.colSpacings.length : afterCols.length;
        for (int i = 0; i < count; ++i) {
            int colIdx = afterCols == null ? i : afterCols[i];
            this.setColSpacing(colIdx, spacing);
        }
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (!(constraints instanceof CellOccupied)) {
            throw new IllegalArgumentException("constraints must be an instance of class CellOccupied.");
        }
        this.comps.put(comp, constraints);
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
        this.fixedRowHeights = null;
        this.fixedColWidths = null;
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        throw new UnsupportedOperationException("Please use addLayoutComponent(Component, Object)");
    }

    @Override
    public void layoutContainer(Container parent) {
        this.fixPercentValue(parent);
        Component[] components = parent.getComponents();
        for (int i = 0; i < components.length; ++i) {
            CellOccupied cellOccupied;
            Component comp = components[i];
            if (!comp.isVisible() || (cellOccupied = this.getCellOccupied(comp)) == null) continue;
            Rectangle rect = this.getRect(cellOccupied);
            if (comp.getWidth() == rect.width && comp.getHeight() == rect.height && comp.getX() == rect.x && comp.getY() == rect.y) continue;
            comp.setBounds(rect.x, rect.y, rect.width, rect.height);
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        int totalHeight = 0;
        for (int i = 0; i < this.rowHeights.length; ++i) {
            if (this.getRowHeight(i).isPercent()) continue;
            totalHeight += this.getRowHeight(i).getValue();
        }
        int totalWidth = 0;
        for (int i = 0; i < this.colWidths.length; ++i) {
            if (this.getColWidth(i).isPercent()) continue;
            totalWidth += this.getColWidth(i).getValue();
        }
        return new Dimension(totalWidth, totalHeight);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.minimumLayoutSize(parent);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.comps.remove(comp);
    }

    private CellOccupied getCellOccupied(Component comp) {
        return (CellOccupied)this.comps.get(comp);
    }

    private Rectangle getRect(CellOccupied cellOccupied) {
        int x = this.fixedColWidths[cellOccupied.getFromCol()].start;
        int w = this.fixedColWidths[cellOccupied.getToCol()].start + this.fixedColWidths[cellOccupied.getToCol()].length - this.fixedColWidths[cellOccupied.getFromCol()].start;
        int y = this.fixedRowHeights[cellOccupied.getFromRow()].start;
        int h = this.fixedRowHeights[cellOccupied.getToRow()].start + this.fixedRowHeights[cellOccupied.getToRow()].length - this.fixedRowHeights[cellOccupied.getFromRow()].start;
        return new Rectangle(x, y, w, h);
    }

    private void fixPercentValue(Container parent) {
        if (this.fixedRowHeights != null) {
            return;
        }
        Insets insets = parent.getInsets();
        int parentWidth = parent.getWidth() - insets.left - insets.right;
        int parentHeight = parent.getHeight() - insets.top - insets.bottom;
        this.fixedRowHeights = new FixedLength[this.rowHeights.length];
        this.fixedColWidths = new FixedLength[this.colWidths.length];
        TableLayout2.fixPercentValue(this.rowHeights, this.fixedRowHeights, this.rowSpacings, parentHeight, insets.top);
        TableLayout2.fixPercentValue(this.colWidths, this.fixedColWidths, this.colSpacings, parentWidth, insets.left);
    }

    private static RowColLength getNotNullLength(RowColLength v) {
        return v == null ? defaultLength : v;
    }

    private static void fixPercentValue(RowColLength[] vs, FixedLength[] fixed, int[] spacing, int parentLength, int startOffset) {
        double totalFixedLen = 0.0;
        int totalPercentGross = 0;
        int useableLength = parentLength;
        boolean hasPercent = false;
        for (int i = 0; i < vs.length; ++i) {
            RowColLength v = TableLayout2.getNotNullLength(vs[i]);
            if (v.isPercent()) {
                hasPercent = true;
                totalPercentGross += v.getValue();
            } else {
                totalFixedLen += (double)v.getValue();
            }
            if (i <= 0) continue;
            useableLength -= spacing[i - 1];
        }
        useableLength = useableLength < 0 ? 0 : useableLength;
        double percentOccupied = (double)useableLength - totalFixedLen;
        int start = 0;
        for (int i = 0; i < vs.length - 1; ++i) {
            RowColLength v = TableLayout2.getNotNullLength(vs[i]);
            int length = totalFixedLen > (double)useableLength || !hasPercent ? (ArrayUtil.isEqual(totalFixedLen, 0.0) ? 0 : (v.isPercent() ? 0 : (int)((double)v.getValue() / totalFixedLen * (double)useableLength))) : (v.isPercent() ? (int)(percentOccupied * (double)v.getValue() / (double)totalPercentGross) : v.getValue());
            fixed[i] = new FixedLength(start + startOffset, length);
            start = start + length + spacing[i];
        }
        fixed[vs.length - 1] = new FixedLength(start + startOffset, parentLength - start);
    }

    private static class FixedLength {
        int start;
        int length;

        public FixedLength(int s, int l) {
            this.start = s;
            this.length = l;
        }
    }
}

