/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.restype.def;

import com.kingdee.cosmic.ctrl.common.restype.def.ResTypeDef;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

public class ResTypeDefs
implements Serializable {
    private ArrayList types = new ArrayList();

    public ResTypeDef find(String typeName) {
        ResTypeDef typeDef = null;
        for (int i = 0; i < this.types.size(); ++i) {
            ResTypeDef temp = (ResTypeDef)this.types.get(i);
            if (!typeName.equals(temp.getName())) continue;
            typeDef = temp;
            break;
        }
        if (typeDef == null && this.types.isEmpty()) {
            return null;
        }
        return typeDef;
    }

    public Iterator iterator() {
        return this.types.iterator();
    }

    public void add(ResTypeDef typeDef) {
        if (this.find(typeDef.getName()) != null) {
            return;
        }
        this.types.add(0, typeDef);
        typeDef.setExternalTypes(this);
    }

    public void trim() throws Exception {
        Iterator values = this.iterator();
        while (values.hasNext()) {
            ResTypeDef typeDef = (ResTypeDef)values.next();
            String extendDefs = typeDef.getExtendTypeNames();
            if (extendDefs == null) {
                extendDefs = "default";
            } else if (extendDefs.length() == 0) continue;
            String[] names = extendDefs.split(",");
            ArrayList<ResTypeDef> extendTypeDefs = new ArrayList<ResTypeDef>(16);
            for (int i = 0; i < names.length; ++i) {
                ResTypeDef typeRef = this.find(names[i]);
                if (typeRef == null) {
                    throw new Exception("Not found ResTypeDef:'" + names[i] + "'");
                }
                extendTypeDefs.add(typeRef);
            }
            typeDef.setExtendTypes(extendTypeDefs);
            ResTypeDefs internalDefs = typeDef.getInternalTypes();
            if (internalDefs == null) continue;
            internalDefs.trim();
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("{");
        Iterator values = this.iterator();
        while (values.hasNext()) {
            buffer.append(values.next());
            buffer.append(',');
        }
        if (buffer.length() > 1) {
            buffer.setLength(buffer.length() - 1);
        }
        buffer.append('}');
        return buffer.toString();
    }
}

