/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.restype.def;

import com.kingdee.cosmic.ctrl.common.CtrlUtil;
import com.kingdee.cosmic.ctrl.common.restype.def.ActionDef;
import com.kingdee.cosmic.ctrl.common.restype.def.ResTypeDef;
import com.kingdee.cosmic.ctrl.common.restype.def.ResTypeDefs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ResTypeTree {
    private HashMap nodesCache = new HashMap();
    private ResTypeDefs runtimeResTypes;
    private ResTypeDef runtimeResType;
    private ActionDef defaultAction;

    public static final ResTypeTree make(ResTypeDef typeDef) {
        typeDef = (ResTypeDef)CtrlUtil.Obj.safeCloneObject(typeDef);
        return new ResTypeTree(typeDef);
    }

    private ResTypeTree(ResTypeDef typeDef) {
        this.runtimeResType = typeDef;
        this.runtimeResTypes = this.makeRuntimeResTypes(typeDef);
    }

    private ResTypeDefs makeRuntimeResTypes(ResTypeDef typeDef) {
        ResTypeDefs types = new ResTypeDefs();
        ResTypeDefNode topNode = this.makeStaticResTypeTree(new ResTypeDefNode(typeDef));
        this.makeRuntimeActions(topNode);
        this.makeRuntimeProperties(topNode);
        this.makeRuntimeResTypes(topNode, types);
        return types;
    }

    public final ResTypeDefs getRuntimeResTypes() {
        return this.runtimeResTypes;
    }

    public final ResTypeDef getRuntimeResType() {
        return this.runtimeResType;
    }

    public final boolean isInheritFrom(ResTypeDef typeDef) {
        if (this.runtimeResTypes == null) {
            return false;
        }
        Iterator i = this.runtimeResTypes.iterator();
        while (i.hasNext()) {
            ResTypeDef p = (ResTypeDef)i.next();
            if (!p.getName().equals(typeDef.getName())) continue;
            return true;
        }
        return false;
    }

    public final ActionDef getDefaultAction() {
        return this.defaultAction;
    }

    public final ActionDef findAction(String name) {
        Iterator i = this.runtimeResTypes.iterator();
        while (i.hasNext()) {
            ActionDef def;
            ResTypeDef.ActionDefs actions = ((ResTypeDef)i.next()).getActionDefs();
            if (actions == null || (def = actions.get(name)) == null) continue;
            return def;
        }
        return null;
    }

    private ResTypeDefNode makeStaticResTypeTree(ResTypeDefNode childNode) {
        List extendTypes;
        ResTypeDef.ActionDefs actionDefs;
        ResTypeDefNode topNode = null;
        this.nodesCache.put(childNode.getTypeDef(), childNode);
        if (this.defaultAction == null && (actionDefs = childNode.getTypeDef().getActionDefs()) != null) {
            Iterator defs = actionDefs.iterator();
            while (defs.hasNext()) {
                ActionDef actionDef = (ActionDef)defs.next();
                if (!actionDef.isDefault() || !actionDef.isEnable()) continue;
                this.defaultAction = actionDef;
                break;
            }
        }
        if ((extendTypes = childNode.getTypeDef().getExtendTypes()) == null) {
            topNode = childNode;
        } else {
            for (ResTypeDef parentType : extendTypes) {
                ArrayList<ResTypeDefNode> children;
                ResTypeDefNode parentNode = (ResTypeDefNode)this.nodesCache.get(parentType);
                if (parentNode == null) {
                    parentNode = new ResTypeDefNode(parentType);
                }
                if ((children = parentNode.getChildren()) == null) {
                    children = new ArrayList<ResTypeDefNode>();
                    parentNode.setChildren(children);
                }
                children.add(childNode);
                ResTypeDefNode temp = this.makeStaticResTypeTree(parentNode);
                if (temp == null) continue;
                topNode = temp;
            }
        }
        return topNode;
    }

    private void makeRuntimeActions(ResTypeDefNode makeFrom) {
        int childCount;
        ResTypeDef typeDef = makeFrom.getTypeDef();
        ResTypeDef.ActionDefs actionDefs = typeDef.getActionDefs();
        if (actionDefs != null) {
            Iterator actions = actionDefs.iterator();
            while (actions.hasNext()) {
                ActionDef[] founds = new ActionDef[1];
                ActionDef actionDef = (ActionDef)actions.next();
                this.makeRuntimeAction(makeFrom, actionDef, founds);
                if (founds[0] == null) continue;
                actionDefs.add(founds[0]);
            }
        }
        ArrayList children = makeFrom.getChildren();
        int n = childCount = children == null ? 0 : children.size();
        for (int i = 0; i < childCount; ++i) {
            this.makeRuntimeActions((ResTypeDefNode)children.get(i));
        }
    }

    private void makeRuntimeResTypes(ResTypeDefNode nodeFrom, ResTypeDefs runtimeResTypes) {
        runtimeResTypes.add(nodeFrom.getTypeDef());
        ArrayList children = nodeFrom.getChildren();
        if (children != null) {
            Iterator childrenNodes = children.iterator();
            while (childrenNodes.hasNext()) {
                this.makeRuntimeResTypes((ResTypeDefNode)childrenNodes.next(), runtimeResTypes);
            }
        }
    }

    private void makeRuntimeAction(ResTypeDefNode node, ActionDef actionDef, ActionDef[] lastFounds) {
        int i;
        ArrayList children = node.getChildren();
        if (children == null) {
            return;
        }
        for (i = 0; i < children.size(); ++i) {
            ActionDef childActionDef;
            ResTypeDefNode childNode = (ResTypeDefNode)children.get(i);
            ResTypeDef childType = childNode.getTypeDef();
            ResTypeDef.ActionDefs childActionDefs = childType.getActionDefs();
            if (childActionDefs == null || (childActionDef = childActionDefs.remove(actionDef.getName())) == null) continue;
            this.uniteActionDef(childActionDef, actionDef);
            lastFounds[0] = childActionDef;
            actionDef = childActionDef;
            this.makeRuntimeAction(childNode, actionDef, lastFounds);
            return;
        }
        for (i = 0; i < children.size(); ++i) {
            this.makeRuntimeAction((ResTypeDefNode)children.get(i), actionDef, lastFounds);
        }
    }

    public void uniteActionDef(ActionDef childActionDef, ActionDef parentActionDef) {
        if (!CtrlUtil.Obj.equals(parentActionDef.getName(), childActionDef.getName())) {
            return;
        }
        if (childActionDef.getActionExecutorDef() == null) {
            childActionDef.setActionExecutorDef(parentActionDef.getActionExecutorDef());
        }
        Iterator keys = parentActionDef.getProperties().keySet().iterator();
        Iterator vals = parentActionDef.getProperties().values().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = (String)vals.next();
            if (childActionDef.getProperty(key) != null) continue;
            childActionDef.setProperty(key, value);
        }
    }

    private void makeRuntimeProperties(ResTypeDefNode typeNode) {
        ArrayList children = typeNode.getChildren();
        if (children == null) {
            return;
        }
        HashMap parentProperties = typeNode.getTypeDef().getProperties();
        if (parentProperties != null) {
            parentProperties = (HashMap)parentProperties.clone();
        }
        for (int i = 0; i < children.size(); ++i) {
            ResTypeDefNode childNode = (ResTypeDefNode)children.get(i);
            ResTypeDef childTypeDef = childNode.getTypeDef();
            HashMap childProperties = childTypeDef.getProperties();
            if (childProperties == null) {
                childProperties = parentProperties;
            } else if (parentProperties != null) {
                parentProperties.putAll(childProperties);
                childProperties = parentProperties;
            }
            childTypeDef.setProperties(childProperties);
            this.makeRuntimeProperties(childNode);
        }
    }

    private static class ResTypeDefNode {
        private ResTypeDef typeDef;
        private ArrayList children;

        ResTypeDefNode(ResTypeDef typeDef) {
            this.typeDef = typeDef;
        }

        public ResTypeDef getTypeDef() {
            return this.typeDef;
        }

        public ArrayList getChildren() {
            return this.children;
        }

        public void setChildren(ArrayList children) {
            this.children = children;
        }

        public String toString() {
            return this.typeDef.getName() + "<" + this.children + ">";
        }
    }
}

