/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.util;

import java.io.File;
import java.util.Locale;
import javax.swing.filechooser.FileFilter;

public class CustomFileFilter
extends FileFilter {
    public static final String SPLITOR = "\t";
    private String ext;
    private String desc;
    private int extLen;
    private String extLowCase;

    public CustomFileFilter(String ext, String desc) {
        this.ext = ext;
        this.desc = desc;
        this.init();
    }

    public CustomFileFilter(String extDesc) {
        int split = extDesc.indexOf(SPLITOR);
        if (split > 0) {
            this.ext = extDesc.substring(0, split);
            this.desc = extDesc.substring(split);
        } else {
            this.ext = extDesc;
            this.desc = null;
        }
        this.init();
    }

    private void init() {
        if (this.ext == null) {
            this.extLen = 0;
        } else {
            this.extLen = this.ext.length();
            this.extLowCase = this.ext.toLowerCase(Locale.ENGLISH);
        }
    }

    @Override
    public boolean accept(File file) {
        if (this.extLen == 0) {
            return true;
        }
        if (file.isDirectory()) {
            return true;
        }
        String filename = file.getName();
        int len = filename.length();
        if (len < this.extLen) {
            return false;
        }
        return this.extLowCase.equals(filename.substring(len - this.extLen).toLowerCase(Locale.ENGLISH));
    }

    @Override
    public String getDescription() {
        return this.desc;
    }
}

