/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.util;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonMessages;
import java.io.PrintWriter;
import java.io.StringWriter;

public class ExceptionUtil {
    public static String findMessage(Throwable t) {
        String msg = null;
        Throwable last = null;
        while (t != null && t != last && (msg = t.getMessage()) == null) {
            last = t;
            t = last.getCause();
        }
        return msg;
    }

    public static String makeTrace(Throwable t) {
        if (t == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.getBuffer().toString();
    }

    public static String makeMessageStack(Throwable t) {
        StringBuilder sb = new StringBuilder();
        Throwable last = null;
        while (t != null && t != last) {
            if (t.getMessage() != null) {
                sb.append("\r\n>> ");
                sb.append(t.getMessage());
            }
            last = t;
            t = last.getCause();
        }
        if (sb.length() == 0) {
            sb.append("\r\n>> ");
            sb.append(CtrlCommonMessages.getMLS("programError", "\u7a0b\u5e8f\u9519\u8bef\uff1a"));
            sb.append(last != null ? last.getClass().getName() : CtrlCommonMessages.getMLS("exceptionIsNull", "\u5f02\u5e38\u4e3a\u7a7a"));
        }
        return sb.toString();
    }

    public static Throwable findCause(Throwable t, Class type) {
        Throwable last = null;
        while (t != null && t != last) {
            if (type == t.getClass()) {
                return t;
            }
            last = t;
            t = last.getCause();
        }
        return null;
    }
}

