/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.util;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StreamUtil;
import com.kingdee.cosmic.ctrl.common.util.xml.XmlUtil;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class Xml2ObjectUtil {
    private static final Logger log = LogUtil.getLogger(Xml2ObjectUtil.class);

    public static Object loadObject(File xmlFile, Class xml2ObjectClass) {
        try {
            return Xml2ObjectUtil.loadObject(XmlUtil.loadXmlFile(xmlFile), xml2ObjectClass);
        }
        catch (Exception ex) {
            log.warn(null, (Throwable)ex);
            return null;
        }
    }

    public static Object loadObject(InputStream stream, Class xml2ObjectClass) {
        try {
            return Xml2ObjectUtil.loadObject(XmlUtil.loadXmlStream(stream), xml2ObjectClass);
        }
        catch (Exception ex) {
            log.warn(null, (Throwable)ex);
            return null;
        }
    }

    public static Object loadObject(IXmlElement e, Class xml2ObjectClass) {
        try {
            Method m = xml2ObjectClass.getMethod("toObject", IXmlElement.class);
            return m.invoke(null, e);
        }
        catch (Exception ex) {
            log.warn(null, (Throwable)ex);
            return null;
        }
    }

    public static Object loadObject(String filePath, Class xml2ObjectClass) {
        return Xml2ObjectUtil.loadObject(new File(FilenameUtils.normalize((String)filePath)), xml2ObjectClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object loadObject(Class relativeClass, String resName, Class xml2ObjectClass) {
        InputStream stream = StreamUtil.loadResource(relativeClass, resName);
        try {
            Object object = Xml2ObjectUtil.loadObject(stream, xml2ObjectClass);
            return object;
        }
        finally {
            StreamUtil.closeStream(stream);
        }
    }
}

