/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.util;

import com.kingdee.cosmic.ctrl.common.util.SectionByteInputStream;
import com.kingdee.cosmic.ctrl.common.util.SectionByteOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class ZipUtil {
    public static final float GZIPFACTOR = 0.03f;
    public static final float MAX_BUFFER = 131072.0f;
    public static final int MAGIC_LENGTH = 17;
    public static final String MAGICCODE = "###PACKER4.0.1###";

    public static byte[] pack(SectionByteOutputStream os) throws IOException {
        return ZipUtil.pack(os, 0.03f);
    }

    public static byte[] pack(SectionByteOutputStream os, float factor) throws IOException {
        return ZipUtil.pack(os, factor, MAGICCODE);
    }

    public static byte[] pack(SectionByteOutputStream os, String magicCode) throws IOException {
        return ZipUtil.pack(os, 0.03f, magicCode);
    }

    public static byte[] pack(SectionByteOutputStream os, float factor, String magicCode) throws IOException {
        float initCapacity;
        if (os == null || os.size() < 1) {
            return null;
        }
        int size = os.size();
        if (factor < 0.1f) {
            factor = 0.03f;
        }
        if ((initCapacity = (float)size * Math.min(factor, 1.0f)) > 131072.0f) {
            initCapacity = 131072.0f;
        }
        SectionByteOutputStream bout = new SectionByteOutputStream();
        ZipUtil.writeMagic(bout, size, magicCode);
        GZIPOutputStream zout = new GZIPOutputStream(bout);
        os.writeTo(zout);
        zout.flush();
        bout.flush();
        zout.close();
        bout.close();
        return bout.toByteArray();
    }

    public static byte[] pack(ByteArrayOutputStream os) throws IOException {
        return ZipUtil.pack(os, 0.03f);
    }

    public static byte[] pack(ByteArrayOutputStream os, float factor) throws IOException {
        return ZipUtil.pack(os, 0.03f, MAGICCODE);
    }

    public static byte[] pack(ByteArrayOutputStream os, String magicCode) throws IOException {
        return ZipUtil.pack(os, 0.03f, magicCode);
    }

    public static byte[] pack(ByteArrayOutputStream os, float factor, String magicCode) throws IOException {
        float initCapacity;
        if (os == null || os.size() < 1) {
            return null;
        }
        int size = os.size();
        if (factor < 0.1f) {
            factor = 0.03f;
        }
        if ((initCapacity = (float)size * Math.min(factor, 1.0f)) > 131072.0f) {
            initCapacity = 131072.0f;
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream((int)initCapacity);
        ZipUtil.writeMagic(bout, size, magicCode);
        GZIPOutputStream zout = new GZIPOutputStream(bout);
        os.writeTo(zout);
        zout.close();
        bout.close();
        return bout.toByteArray();
    }

    public static byte[] pppack(SectionByteOutputStream os) throws IOException {
        return ZipUtil.pppack(os, 0.03f);
    }

    public static byte[] pppack(SectionByteOutputStream os, float factor) throws IOException {
        return ZipUtil.pppack(os, 0.03f, MAGICCODE);
    }

    public static byte[] pppack(SectionByteOutputStream os, float factor, String magicCode) throws IOException {
        float initCapacity;
        if (os == null || os.size() < 1) {
            return null;
        }
        int size = os.size();
        if (factor < 0.1f) {
            factor = 0.03f;
        }
        if ((initCapacity = (float)size * Math.min(factor, 1.0f)) > 131072.0f) {
            initCapacity = 131072.0f;
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream((int)initCapacity);
        ZipUtil.writeMagic(bout, size, magicCode);
        GZIPOutputStream zout = new GZIPOutputStream(bout);
        os.writeTo(zout);
        zout.flush();
        bout.flush();
        zout.close();
        bout.close();
        return bout.toByteArray();
    }

    public static byte[] pppack(SectionByteOutputStream os, String magicCode) throws IOException {
        return ZipUtil.pppack(os, 0.03f, magicCode);
    }

    public static UnpackResult unpackWithMagic(byte[] source) throws IOException {
        UnpackResult ur = new UnpackResult();
        ZipUtil.unpackImpl(source, ur);
        return ur;
    }

    public static UnpackResult unpack2WithMagic(byte[] source) throws IOException {
        UnpackResult ur = new UnpackResult();
        ZipUtil.unpack2Impl(source, ur);
        return ur;
    }

    public static InputStream unpack(byte[] source) throws IOException {
        UnpackResult ur = new UnpackResult();
        ZipUtil.unpackImpl(source, ur);
        return ur.getInputStream();
    }

    public static InputStream unpack2(byte[] source) throws IOException {
        UnpackResult ur = new UnpackResult();
        ZipUtil.unpack2Impl(source, ur);
        return ur.getInputStream();
    }

    private static boolean writeMagic(OutputStream output, int size, String magicCode) throws IOException {
        if (output == null) {
            return false;
        }
        int len = magicCode.length();
        byte[] magic = new byte[17];
        int c = Math.min(17, len);
        for (int m = 0; m < c; ++m) {
            magic[m] = (byte)magicCode.charAt(m);
        }
        output.write(magic);
        for (int i = 3; i >= 0; --i) {
            output.write(size >> i * 8 & 0xFF);
        }
        return true;
    }

    private static int readMagic(ByteArrayInputStream input, UnpackResult ur) {
        int m;
        int len = 17;
        StringBuilder magic = new StringBuilder(len);
        for (m = 0; m < len; ++m) {
            magic.append((char)input.read());
        }
        if (magic.toString().equals("###KDSpread2.1###")) {
            for (m = 0; m < 128; ++m) {
                magic.append((char)input.read());
            }
        }
        ur.setMagicCode(magic.toString());
        int res = 0;
        for (int i = 0; i < 4; ++i) {
            int sz = input.read();
            if (sz < 0) {
                return 0;
            }
            if (i > 0) {
                res <<= 8;
            }
            res |= sz;
        }
        return res;
    }

    private static void unpackImpl(byte[] source, UnpackResult ur) throws IOException {
        int len;
        if (source == null || source.length < 1) {
            return;
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(source);
        int count = ZipUtil.readMagic(bin, ur);
        if (count == Integer.MAX_VALUE) {
            bin.close();
            ur.setInputStream(new ByteArrayInputStream(source));
            return;
        }
        if (count < 1) {
            bin.close();
            return;
        }
        GZIPInputStream zin = new GZIPInputStream(bin);
        SectionByteInputStream sbis = new SectionByteInputStream();
        int sectionLen = sbis.getSectionLength();
        byte[] res = null;
        int num = 0;
        while ((len = count - num) > 0) {
            int len2;
            int count2;
            res = new byte[sectionLen];
            int num2 = 0;
            int n = count2 = count < sectionLen ? count : sectionLen;
            while ((len2 = count2 - num2) >= 0) {
                int n2;
                if (len2 > 4096) {
                    len2 = 4096;
                }
                if ((n2 = zin.read(res, num2, len2)) <= 0) break;
                num2 += n2;
            }
            sbis.addBytes(res, num2);
            num += num2;
        }
        zin.close();
        bin.close();
        ur.setInputStream(num != count ? null : sbis);
    }

    private static void unpack2Impl(byte[] source, UnpackResult ur) throws IOException {
        int len;
        if (source == null || source.length < 1) {
            return;
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(source);
        int count = ZipUtil.readMagic(bin, ur);
        if (count == Integer.MAX_VALUE) {
            bin.close();
            ur.setInputStream(new ByteArrayInputStream(source));
            return;
        }
        if (count < 1) {
            bin.close();
            return;
        }
        GZIPInputStream zin = new GZIPInputStream(bin);
        byte[] res = new byte[count];
        int num = 0;
        while ((len = count - num) >= 0) {
            int n;
            if (len > 4096) {
                len = 4096;
            }
            if ((n = zin.read(res, num, len)) <= 0) break;
            num += n;
        }
        zin.close();
        bin.close();
        ur.setInputStream(num != count ? null : new ByteArrayInputStream(res));
    }

    public static class UnpackResult {
        private String _magicCode;
        private InputStream _is;

        private void setMagicCode(String magicCode) {
            this._magicCode = magicCode;
        }

        private void setInputStream(InputStream is) {
            this._is = is;
        }

        public String getMagicCode() {
            return this._magicCode;
        }

        public InputStream getInputStream() {
            return this._is;
        }
    }
}

