/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.util.xml;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlParsingException;
import com.kingdee.cosmic.ctrl.common.CtrlUtil;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StreamUtil;
import com.kingdee.cosmic.ctrl.common.util.xml.IXmlIO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;

public class XmlUtil {
    private static final Logger log = LogUtil.getPackageLogger(XmlUtil.class);
    public static final String ATTR_NAME = "name";
    public static final String ATTR_VALUE = "value";
    public static final String ATTR_TYPE = "type";

    public static Object loadChilds(IXmlElement elm, String childTag, IXmlIO io, ILoadHook hook) {
        List list = elm.searchChildren(childTag);
        int len = list.size();
        Object obj = hook.newObject(len);
        for (int i = 0; i < len; ++i) {
            hook.loadChild(obj, (IXmlElement)list.get(i), i, io);
        }
        return obj;
    }

    public static IXmlElement loadXmlStream(InputStream is) throws IOException, XmlParsingException {
        return com.kingdee.bos.qing.common.xml.XmlUtil.loadRootElement((InputStream)is);
    }

    public static IXmlElement loadXmlBytes(byte[] xmlBytes) throws IOException, XmlParsingException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlBytes);
        for (int i = 0; i < xmlBytes.length && xmlBytes[i] <= 0; ++i) {
            inputStream.read();
        }
        return com.kingdee.bos.qing.common.xml.XmlUtil.loadRootElement((InputStream)inputStream);
    }

    public static IXmlElement loadXmlFile(String filePath) throws IOException, XmlParsingException {
        return XmlUtil.loadXmlFile(new File(FilenameUtils.normalize((String)FilenameUtils.getName((String)filePath))));
    }

    public static IXmlElement loadXmlFile(File file) throws IOException, XmlParsingException {
        IXmlElement iXmlElement;
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            iXmlElement = XmlUtil.loadXmlStream(in);
        }
        catch (Throwable throwable) {
            CtrlUtil.Stream.closeStream(in);
            throw throwable;
        }
        CtrlUtil.Stream.closeStream(in);
        return iXmlElement;
    }

    public static IXmlElement loadXmlString(String s) throws IOException, XmlParsingException {
        return XmlUtil.loadXmlBytes(s.getBytes(StandardCharsets.UTF_8));
    }

    public static boolean saveXmlStream(OutputStream fos, IXmlElement elm) throws IOException {
        com.kingdee.bos.qing.common.xml.XmlUtil.save((IXmlElement)elm, (OutputStream)fos);
        return true;
    }

    public static byte[] saveXmlBytes(IXmlElement elm) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            XmlUtil.saveXmlStream(baos, elm);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    public static boolean saveXmlFile(String filePath, IXmlElement elm) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(FilenameUtils.getName((String)filePath));){
            boolean bl = XmlUtil.saveXmlStream(fos, elm);
            return bl;
        }
    }

    public static boolean saveXmlFile(File file, IXmlElement elm) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        try {
            boolean bl = XmlUtil.saveXmlStream(fos, elm);
            return bl;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            StreamUtil.closeStream(fos);
        }
    }

    public static String outputString(IXmlElement elm) {
        return com.kingdee.bos.qing.common.xml.XmlUtil.toString((IXmlElement)elm);
    }

    public static void printElement(IXmlElement elm) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            com.kingdee.bos.qing.common.xml.XmlUtil.save((IXmlElement)elm, (OutputStream)os);
            log.debug((Object)os);
        }
        catch (IOException ex) {
            log.error((Object)ex, (Throwable)ex);
        }
    }

    public static final List makeMapElements(Map map, String tagName) {
        ArrayList<IXmlElement> list = new ArrayList<IXmlElement>(map.size());
        Iterator keys = map.keySet().iterator();
        Iterator vals = map.values().iterator();
        while (keys.hasNext()) {
            IXmlElement e = com.kingdee.bos.qing.common.xml.XmlUtil.createNode((String)tagName);
            e.setAttribute(ATTR_NAME, (String)keys.next());
            Object value = vals.next();
            if (value != null) {
                List itemsE;
                if (value instanceof String) {
                    e.setAttribute(ATTR_VALUE, (String)value);
                } else if (value instanceof Object[]) {
                    itemsE = null;
                    if (value instanceof String[]) {
                        e.setAttribute(ATTR_TYPE, "String[]");
                        itemsE = XmlUtil.makeStrArrayElements((String[])value, "Item");
                    } else if (value instanceof Map[]) {
                        e.setAttribute(ATTR_TYPE, "java.util.Map[]");
                        itemsE = XmlUtil.makeMapArrayElements((Map[])value, "Item");
                    } else {
                        throw new UnsupportedOperationException("Unkown value type:" + value);
                    }
                    XmlUtil.addContent(itemsE, e);
                } else if (value instanceof Map) {
                    e.setAttribute(ATTR_TYPE, "java.util.Map");
                    itemsE = XmlUtil.makeMapElements((HashMap)value, "Property");
                    XmlUtil.addContent(itemsE, e);
                }
            }
            list.add(e);
        }
        return list;
    }

    public static List makeStrArrayElements(String[] values, String tagName) {
        ArrayList<IXmlElement> list = new ArrayList<IXmlElement>(values.length);
        for (int i = 0; i < values.length; ++i) {
            IXmlElement e = com.kingdee.bos.qing.common.xml.XmlUtil.createNode((String)tagName);
            e.addChild(com.kingdee.bos.qing.common.xml.XmlUtil.createNode((String)values[i]));
            list.add(e);
        }
        return list;
    }

    public static List makeMapArrayElements(Map[] value, String tagName) {
        ArrayList<IXmlElement> list = new ArrayList<IXmlElement>(value.length);
        for (int i = 0; i < value.length; ++i) {
            IXmlElement e = com.kingdee.bos.qing.common.xml.XmlUtil.createNode((String)tagName);
            XmlUtil.addContent(XmlUtil.makeMapElements(value[i], "Property"), e);
            list.add(e);
        }
        return list;
    }

    public static Map[] makeMapArray(List es, String tagName) {
        Map[] mapArray = new Map[es.size()];
        for (int i = 0; i < mapArray.length; ++i) {
            IXmlElement eChild = (IXmlElement)es.get(i);
            mapArray[i] = XmlUtil.makeMap(eChild.searchChildren(tagName));
        }
        return mapArray;
    }

    public static String[] makeStrArray(List es) {
        String[] strArray = new String[es.size()];
        for (int i = 0; i < strArray.length; ++i) {
            IXmlElement eChild = (IXmlElement)es.get(i);
            strArray[i] = eChild.getText();
        }
        return strArray;
    }

    public static final HashMap makeMap(List es) {
        HashMap<String, String> properties = null;
        for (IXmlElement eChild : es) {
            if (properties == null) {
                properties = new HashMap<String, String>();
            }
            String name = eChild.getAttribute(ATTR_NAME);
            Object value = eChild.getAttribute(ATTR_VALUE);
            if (value == null) {
                String type = eChild.getAttribute(ATTR_TYPE);
                if ("java.util.Map".equals(type)) {
                    value = XmlUtil.makeMap(eChild.searchChildren("Property"));
                } else if ("String[]".equals(type)) {
                    value = XmlUtil.makeStrArray(eChild.searchChildren("Item"));
                } else if ("java.util.Map[]".equals(type)) {
                    value = XmlUtil.makeMapArray(eChild.searchChildren("Item"), "Property");
                }
            }
            properties.put(name, (String)value);
        }
        return properties;
    }

    public static boolean addContent(Collection c, IXmlElement e) {
        if (null == c || c.size() == 0) {
            return false;
        }
        for (IXmlElement next : c) {
            e.addChild(next);
        }
        return true;
    }

    public static IXmlElement selectSingleNode(IXmlElement rootEle, String nodeName, String ck, String cv) {
        IXmlElement node = null;
        if (null != rootEle) {
            List elements = rootEle.searchChildren(nodeName);
            for (int i = 0; i < elements.size(); ++i) {
                IXmlElement element = (IXmlElement)elements.get(i);
                List keys = element.getAttributeKeys();
                for (String key : keys) {
                    if (!ck.equalsIgnoreCase(key) || null == element.getAttribute(ck) || !element.getAttribute(ck).equalsIgnoreCase(cv)) continue;
                    node = element;
                }
            }
        }
        return node;
    }

    public static InputStream inputSource2inputStream(InputSource inputSource) {
        InputStream inputStream = null;
        try {
            String systemID;
            if (inputSource != null && null != (systemID = inputSource.getSystemId())) {
                if (systemID.startsWith("file:")) {
                    File file = new File(FilenameUtils.normalize((String)systemID.substring(5)));
                    inputStream = new FileInputStream(file);
                } else if (systemID.startsWith("http:") || systemID.startsWith("https:")) {
                    URL url = new URL(systemID);
                    URLConnection urlConnection = url.openConnection();
                    inputStream = urlConnection.getInputStream();
                }
            }
        }
        catch (IOException err) {
            throw new AssertionError((Object)"Failed loading file");
        }
        return inputStream;
    }

    public static abstract class ASaveMap
    implements ISaveHook,
    ISaveMapHook {
        private Object[] entries;

        @Override
        public int getChildCount(Object obj) {
            this.entries = ((Map)obj).entrySet().toArray();
            return this.entries.length;
        }

        @Override
        public IXmlElement saveChild(Object obj, int index, IXmlIO io) {
            return this.saveEntry((Map.Entry)this.entries[index], io);
        }
    }

    public static interface ISaveMapHook {
        public IXmlElement saveEntry(Map.Entry var1, IXmlIO var2);
    }

    public static interface ISaveHook {
        public int getChildCount(Object var1);

        public IXmlElement saveChild(Object var1, int var2, IXmlIO var3);
    }

    public static abstract class ALoadArrayList
    implements ILoadHook,
    ILoadExHook {
        protected Object returnObj;

        @Override
        public void loadChild(Object obj, IXmlElement elm, int index, IXmlIO io) {
            if (this.loadChild(elm, io)) {
                ((ArrayList)obj).add(this.returnObj);
            }
        }

        @Override
        public Object newObject(int childCount) {
            return new ArrayList(childCount);
        }
    }

    public static abstract class ALoadHashMap
    implements ILoadHook,
    ILoadExHook {
        protected Object returnObj;
        protected Object returnKey;

        @Override
        public void loadChild(Object obj, IXmlElement elm, int index, IXmlIO io) {
            if (this.loadChild(elm, io)) {
                ((HashMap)obj).put(this.returnKey, this.returnObj);
            }
        }

        @Override
        public Object newObject(int childCount) {
            return new HashMap(childCount);
        }
    }

    public static interface ILoadExHook {
        public boolean loadChild(IXmlElement var1, IXmlIO var2);
    }

    public static interface ILoadHook {
        public Object newObject(int var1);

        public void loadChild(Object var1, IXmlElement var2, int var3, IXmlIO var4);
    }
}

