/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.variant;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonMessages;
import com.kingdee.cosmic.ctrl.common.variant.ExprErr;
import com.kingdee.cosmic.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.common.variant.Util;
import com.kingdee.cosmic.ctrl.common.variant.VarBase;
import com.kingdee.cosmic.ctrl.common.variant.Variant;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;

class VarDouble
extends VarBase {
    VarDouble() {
    }

    @Override
    protected void add(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        double leftval = (Double)left.getValue();
        if (right.getVt() < 512) {
            switch (right.getVt()) {
                case 7: {
                    Util.add(leftval, (double)((Character)right.getValue()).charValue(), result);
                    break;
                }
                case 8: {
                    int rightval = Util.booleanToInt((Boolean)right.getValue());
                    Util.add(leftval, (double)rightval, result);
                    break;
                }
                case 9: {
                    Util.add(leftval, ((BigInteger)right.getValue()).doubleValue(), result);
                    break;
                }
                case 10: {
                    result.setObject(((BigDecimal)right.getValue()).add(new BigDecimal(Double.toString(leftval))), 10);
                    break;
                }
                case 11: {
                    result.setObject(new BigDecimal((String)right.getValue()).add(new BigDecimal(Double.toString(leftval))), 10);
                    break;
                }
                case 12: {
                    Util.add(leftval, (double)((Date)right.getValue()).getTime(), result);
                    break;
                }
                case 13: {
                    Util.add(leftval, right.doubleValue(), result);
                    break;
                }
                case 15: {
                    left.add((Variant)right.getValue(), result);
                    break;
                }
                case 0: {
                    result.setVariant(left);
                    break;
                }
                default: {
                    ExprErr.goError(64L, CtrlCommonMessages.getMLS("unsupportedDataTypeOperation", "\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u7684\u8fd0\u7b97"));
                }
            }
        }
    }

    @Override
    protected void subtract(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        double leftval = (Double)left.getValue();
        if (right.getVt() < 512) {
            switch (right.getVt()) {
                case 7: {
                    Util.subtract(leftval, (double)((Character)right.getValue()).charValue(), result);
                    break;
                }
                case 8: {
                    int rightval = Util.booleanToInt((Boolean)right.getValue());
                    Util.subtract(leftval, (double)rightval, result);
                    break;
                }
                case 9: {
                    Util.subtract(leftval, ((BigInteger)right.getValue()).doubleValue(), result);
                    break;
                }
                case 10: {
                    result.setObject(new BigDecimal(Double.toString(leftval)).subtract((BigDecimal)right.getValue()), 10);
                    break;
                }
                case 11: {
                    result.setObject(new BigDecimal(Double.toString(leftval)).subtract(new BigDecimal((String)right.getValue())), 10);
                    break;
                }
                case 12: {
                    Util.subtract(leftval, (double)((Date)right.getValue()).getTime(), result);
                    break;
                }
                case 13: {
                    Util.subtract(leftval, right.doubleValue(), result);
                    break;
                }
                case 15: {
                    left.subtract((Variant)right.getValue(), result);
                    break;
                }
                case 0: {
                    result.setVariant(left);
                    break;
                }
                default: {
                    ExprErr.goError(64L, CtrlCommonMessages.getMLS("unsupportedDataTypeOperation", "\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u7684\u8fd0\u7b97"));
                }
            }
        }
    }

    @Override
    protected void multiply(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        double leftval = (Double)left.getValue();
        if (right.getVt() < 512) {
            switch (right.getVt()) {
                case 7: {
                    Util.multiply(leftval, (double)((Character)right.getValue()).charValue(), result);
                    break;
                }
                case 8: {
                    int rightval = Util.booleanToInt((Boolean)right.getValue());
                    Util.multiply(leftval, (double)rightval, result);
                    break;
                }
                case 9: {
                    Util.multiply(leftval, ((BigInteger)right.getValue()).doubleValue(), result);
                    break;
                }
                case 10: {
                    result.setObject(new BigDecimal(Double.toString(leftval)).multiply((BigDecimal)right.getValue()), 10);
                    break;
                }
                case 11: {
                    result.setObject(new BigDecimal(Double.toString(leftval)).multiply(new BigDecimal((String)right.getValue())), 10);
                    break;
                }
                case 12: {
                    Util.multiply(leftval, (double)((Date)right.getValue()).getTime(), result);
                    break;
                }
                case 13: {
                    Util.multiply(leftval, right.doubleValue(), result);
                    break;
                }
                case 15: {
                    left.multiply((Variant)right.getValue(), result);
                    break;
                }
                case 0: {
                    result.setObject(BigDecimal.valueOf(0.0), 10);
                    break;
                }
                default: {
                    ExprErr.goError(64L, CtrlCommonMessages.getMLS("unsupportedDataTypeOperation", "\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u7684\u8fd0\u7b97"));
                }
            }
        }
    }

    @Override
    protected void divide(Variant left, Variant right, Variant result) throws SyntaxErrorException {
    }

    @Override
    protected void mod(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        double leftval = (Double)left.getValue();
        if (right.getVt() < 512) {
            switch (right.getVt()) {
                case 7: {
                    Util.mod(leftval, (double)((Character)right.getValue()).charValue(), result);
                    break;
                }
                case 8: {
                    int rightval = Util.booleanToInt((Boolean)right.getValue());
                    Util.mod(leftval, (double)rightval, result);
                    break;
                }
                case 9: {
                    Util.mod(leftval, (double)right.floatValue(), result);
                    break;
                }
                case 10: {
                    Util.mod(leftval, right.doubleValue(), result);
                    break;
                }
                case 11: {
                    Variant vright = new Variant();
                    if (right.isNumeric(vright)) {
                        this.mod(left, vright, result);
                        break;
                    }
                    ExprErr.goError(64L, CtrlCommonMessages.getMLS("unsupportedDataTypeOperation", "\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u7684\u8fd0\u7b97"));
                    break;
                }
                case 12: {
                    Util.mod(leftval, (double)((Date)right.getValue()).getTime(), result);
                    break;
                }
                case 13: {
                    Util.mod(leftval, right.doubleValue(), result);
                    break;
                }
                case 15: {
                    left.mod((Variant)right.getValue(), result);
                    break;
                }
                default: {
                    ExprErr.goError(64L, CtrlCommonMessages.getMLS("unsupportedDataTypeOperation", "\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u7684\u8fd0\u7b97"));
                }
            }
        }
    }

    @Override
    protected void and(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        double leftval = (Double)left.getValue();
        if (right.getVt() < 512) {
            switch (right.getVt()) {
                case 7: {
                    Util.and(leftval, (double)((Character)right.getValue()).charValue(), result);
                    break;
                }
                case 8: {
                    int rightval = Util.booleanToInt((Boolean)right.getValue());
                    Util.and(leftval, (double)rightval, result);
                    break;
                }
                case 9: {
                    Util.and(leftval, ((BigInteger)right.getValue()).doubleValue(), result);
                    break;
                }
                case 10: {
                    result.setObject(BigInteger.valueOf((long)leftval).and(((BigDecimal)right.getValue()).toBigInteger()), 9);
                    break;
                }
                case 11: {
                    result.setObject(BigInteger.valueOf((long)leftval).and(new BigInteger((String)right.getValue())), 9);
                    break;
                }
                case 12: {
                    Util.and(leftval, (double)((Date)right.getValue()).getTime(), result);
                    break;
                }
                case 13: {
                    Util.and(leftval, right.doubleValue(), result);
                    break;
                }
                case 15: {
                    left.and((Variant)right.getValue(), result);
                    break;
                }
                default: {
                    ExprErr.goError(64L, CtrlCommonMessages.getMLS("unsupportedDataTypeOperation", "\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u7684\u8fd0\u7b97"));
                }
            }
        }
    }

    @Override
    protected void or(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        double leftval = (Double)left.getValue();
        if (right.getVt() < 512) {
            switch (right.getVt()) {
                case 7: {
                    Util.or(leftval, (double)((Character)right.getValue()).charValue(), result);
                    break;
                }
                case 8: {
                    int rightval = Util.booleanToInt((Boolean)right.getValue());
                    Util.or(leftval, (double)rightval, result);
                    break;
                }
                case 9: {
                    Util.or(leftval, ((BigInteger)right.getValue()).doubleValue(), result);
                    break;
                }
                case 10: {
                    result.setObject(BigInteger.valueOf((long)leftval).or(((BigDecimal)right.getValue()).toBigInteger()), 9);
                    break;
                }
                case 11: {
                    result.setObject(BigInteger.valueOf((long)leftval).or(new BigInteger((String)right.getValue())), 9);
                    break;
                }
                case 12: {
                    Util.or(leftval, (double)((Date)right.getValue()).getTime(), result);
                    break;
                }
                case 13: {
                    Util.or(leftval, right.doubleValue(), result);
                    break;
                }
                case 15: {
                    left.or((Variant)right.getValue(), result);
                    break;
                }
                default: {
                    ExprErr.goError(64L, CtrlCommonMessages.getMLS("unsupportedDataTypeOperation", "\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u7684\u8fd0\u7b97"));
                }
            }
        }
    }

    @Override
    protected void xor(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        double leftval = (Double)left.getValue();
        if (right.getVt() < 512) {
            switch (right.getVt()) {
                case 7: {
                    Util.xor(leftval, (double)((Character)right.getValue()).charValue(), result);
                    break;
                }
                case 8: {
                    int rightval = Util.booleanToInt((Boolean)right.getValue());
                    Util.xor(leftval, (double)rightval, result);
                    break;
                }
                case 9: {
                    Util.xor(leftval, ((BigInteger)right.getValue()).doubleValue(), result);
                    break;
                }
                case 10: {
                    result.setObject(BigInteger.valueOf((long)leftval).xor(((BigDecimal)right.getValue()).toBigInteger()), 9);
                    break;
                }
                case 11: {
                    result.setObject(BigInteger.valueOf((long)leftval).xor(new BigInteger((String)right.getValue())), 9);
                    break;
                }
                case 12: {
                    Util.xor(leftval, (double)((Date)right.getValue()).getTime(), result);
                    break;
                }
                case 13: {
                    Util.xor(leftval, right.doubleValue(), result);
                    break;
                }
                case 15: {
                    left.xor((Variant)right.getValue(), result);
                    break;
                }
                default: {
                    ExprErr.goError(64L, CtrlCommonMessages.getMLS("unsupportedDataTypeOperation", "\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u7684\u8fd0\u7b97"));
                }
            }
        }
    }
}

