/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.data.meta.io;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.cosmic.ctrl.common.DataType;
import com.kingdee.cosmic.ctrl.common.util.STConverter;
import com.kingdee.cosmic.ctrl.data.DataDefType;
import com.kingdee.cosmic.ctrl.data.meta.MetaClass;
import com.kingdee.cosmic.ctrl.data.meta.MetaField;
import com.kingdee.cosmic.ctrl.data.meta.MetaLibrary;
import com.kingdee.cosmic.ctrl.data.meta.MetaPackage;
import java.util.List;
import java.util.Locale;

public class Kdr2Meta {
    private static final String T_FILE = "FILE";
    private static final String T_TYPE = "TYPE";
    private static final String T_DATABASE = "DATABASE";
    private static final String T_NAME = "NAME";
    private static final String T_NOTE = "NOTE";
    private static final String T_GROUP = "GROUP";
    private static final String T_TABLE = "TABLE";
    private static final String T_FIELD = "FIELD";
    private static final String T_TABLE_NAME = "TABLE_NAME";
    private static final String T_FIELD_NAME = "FIELD_NAME";
    private static final String T_DATA_TYPE = "DATA_TYPE";
    private static final String T_SUB = "SUB";
    private static final String V_INTEGER = "INTEGER";
    private static final String V_DOUBLE = "DOUBLE";
    private static final String V_STRING = "STRING";
    private static final String V_DATETIME = "DATETIME";
    private static final String V_CURRENCY = "CURRENCY";
    private static final String V_TABLE = "TABLE";
    private static final String V_VIEW = "VIEW";
    private static final String V_DATA = "DATA";

    public static DataDefType toDataObjType(String val) {
        if ("TABLE".equals(val)) {
            return DataDefType.DB_TABLE;
        }
        if (V_VIEW.equals(val)) {
            return DataDefType.DB_VIEW;
        }
        return DataDefType.DB_TABLE;
    }

    public static DataType toDataType(String val) {
        if (V_INTEGER.equals(val)) {
            return DataType.INTEGER;
        }
        if (V_DOUBLE.equals(val)) {
            return DataType.DOUBLE;
        }
        if (V_STRING.equals(val)) {
            return DataType.STRING;
        }
        if (V_DATETIME.equals(val)) {
            return DataType.DATETIME;
        }
        if (V_CURRENCY.equals(val)) {
            return DataType.DECIMAL;
        }
        return DataType.NULL;
    }

    public MetaLibrary transform(IXmlElement xmlRoot) {
        MetaLibrary lib = new MetaLibrary();
        this.parseKDReport(lib, xmlRoot);
        return lib;
    }

    public void parseKDReport(MetaLibrary lib, IXmlElement xmlKDReport) {
        IXmlElement xmlInfo = xmlKDReport.getChild(T_FILE);
        assert (V_DATA.equals(xmlInfo.getChild(T_TYPE)));
        lib.setAlias(xmlInfo.getChild(T_NAME).getText() + ".KDR");
        lib.setDesc(xmlInfo.getChild(T_NOTE).getText());
        IXmlElement xmlDB = xmlKDReport.getChild(T_DATABASE);
        this.parseDataBase(lib, xmlDB);
    }

    public void parseDataBase(MetaLibrary ml, IXmlElement xmlDB) {
        List xmlGroupList = xmlDB.searchChildren(T_GROUP);
        ml.setAlias(xmlDB.getChild(T_NAME).getText());
        ml.setDesc(xmlDB.getChild(T_NOTE).getText());
        int len = xmlGroupList.size();
        MetaPackage mpRoot = ml.getRootPackage();
        for (int i = 0; i < len; ++i) {
            IXmlElement xmlGroup = (IXmlElement)xmlGroupList.get(i);
            mpRoot.addPackage(this.parseGroup(xmlGroup));
        }
    }

    public MetaPackage parseGroup(IXmlElement xmlGroup) {
        MetaPackage pkg = new MetaPackage();
        pkg.setName(xmlGroup.getChild(T_NAME).getText());
        pkg.setAlias(xmlGroup.getChild(T_NAME).getText());
        pkg.setDesc(xmlGroup.getChild(T_NOTE).getText());
        DataDefType type = Kdr2Meta.toDataObjType(xmlGroup.getChild(T_SUB).getText());
        List xmlTableList = xmlGroup.searchChildren("TABLE");
        int len = xmlTableList.size();
        for (int i = 0; i < len; ++i) {
            IXmlElement xmlTable = (IXmlElement)xmlTableList.get(i);
            pkg.addClass(this.parseTable(xmlTable, type));
        }
        return pkg;
    }

    public MetaClass parseTable(IXmlElement xmlTable, DataDefType type) {
        String desc;
        MetaClass mc = new MetaClass();
        mc.setNamex(xmlTable.getChild(T_TABLE_NAME).getText(), type.getName());
        String alias = xmlTable.getChild(T_NAME).getText();
        if (alias != null) {
            mc.setAlias(alias, Locale.SIMPLIFIED_CHINESE);
            mc.setAlias(STConverter.sc2tc(alias), Locale.TRADITIONAL_CHINESE);
        }
        if ((desc = xmlTable.getChild(T_NOTE).getText()) != null) {
            mc.setDesc(desc, Locale.SIMPLIFIED_CHINESE);
            mc.setDesc(STConverter.sc2tc(desc), Locale.TRADITIONAL_CHINESE);
        }
        mc.setExpr(mc.getName());
        List xmlFieldList = xmlTable.searchChildren(T_FIELD);
        int len = xmlFieldList.size();
        for (int i = 0; i < len; ++i) {
            IXmlElement xmlField = (IXmlElement)xmlFieldList.get(i);
            mc.addField(this.parseField(xmlField));
        }
        return mc;
    }

    public MetaField parseField(IXmlElement xmlField) {
        String desc;
        MetaField mf = new MetaField();
        mf.setName(xmlField.getChild(T_FIELD_NAME).getText());
        String alias = xmlField.getChild(T_NAME).getText();
        if (alias != null) {
            mf.setAlias(alias, Locale.SIMPLIFIED_CHINESE);
            mf.setAlias(STConverter.sc2tc(alias), Locale.TRADITIONAL_CHINESE);
        }
        if ((desc = xmlField.getChild(T_NOTE).getText()) != null) {
            mf.setDesc(desc, Locale.SIMPLIFIED_CHINESE);
            mf.setDesc(STConverter.sc2tc(desc), Locale.TRADITIONAL_CHINESE);
        }
        String s = xmlField.getChild(T_DATA_TYPE).getText();
        mf.setType(Kdr2Meta.toDataType(s));
        mf.setExpr(mf.getName());
        return mf;
    }
}

