/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.data.modal;

import com.kingdee.cosmic.ctrl.common.util.LangUtil;
import com.kingdee.cosmic.ctrl.common.util.MapUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.data.modal.IDefObj;
import com.kingdee.cosmic.ctrl.data.modal.INameSpace;
import com.kingdee.util.LocaleUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class DefObj
implements IDefObj {
    public static final String P_ALIAS = "alias";
    public static final String P_DESC = "desc";
    private INameSpace nameSpace;
    private String name;
    private Map properties;

    @Override
    public Map getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        return this.properties;
    }

    public final Object getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    public final String getStrProperty(String name) {
        return (String)this.getProperty(name);
    }

    public final void setProperty(String name, Object val) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(name, val);
    }

    @Override
    public INameSpace getNameSpace() {
        return this.nameSpace;
    }

    public void setNameSpace(INameSpace nameSpace) {
        this.nameSpace = nameSpace;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getAlias() {
        return this.getAlias(Locale.CHINA);
    }

    public String getAlias(Locale l) {
        return (String)LangUtil.getProperty(this.getProperties(), P_ALIAS, l);
    }

    @Override
    public void setAlias(String alias) {
        this.setAlias(alias, Locale.CHINA);
    }

    public void setAlias(String alias, Locale l) {
        LangUtil.setProperty(this.getProperties(), P_ALIAS, l, alias);
    }

    @Override
    public String getAliasName() {
        String alias = this.getAlias();
        if (!StringUtil.isEmptyString(alias)) {
            return alias;
        }
        int i = this.name.indexOf(46);
        return i == -1 ? this.name : this.name.substring(0, i);
    }

    public String getAliasName(Locale l) {
        String alias = this.getAlias(l = "l2".equalsIgnoreCase(l.toString()) ? LocaleUtils.locale_zh_CN : ("l1".equalsIgnoreCase(l.toString()) ? LocaleUtils.locale_en_US : ("l3".equalsIgnoreCase(l.toString()) ? LocaleUtils.locale_zh_TW : LocaleUtils.locale_zh_CN)));
        if (!StringUtil.isEmptyString(alias)) {
            return alias;
        }
        int i = this.name.indexOf(46);
        return i == -1 ? this.name : this.name.substring(0, i);
    }

    @Override
    public String getDesc() {
        return this.getDesc(Locale.getDefault());
    }

    public String getDesc(Locale l) {
        return (String)LangUtil.getProperty(this.getProperties(), P_DESC, l);
    }

    @Override
    public void setDesc(String desc) {
        this.setDesc(desc, Locale.getDefault());
    }

    public void setDesc(String desc, Locale l) {
        LangUtil.setProperty(this.getProperties(), P_DESC, l, desc);
    }

    public String toString() {
        return this.getAliasName();
    }

    @Override
    public void copy(IDefObj obj) {
        if (obj.getName() != null) {
            this.setName(obj.getName());
        }
        MapUtil.add(this.getProperties(), obj.getProperties());
    }

    @Override
    public String getFullName() {
        String s;
        String name = this.getName();
        if (name == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        INameSpace ns = this.getNameSpace();
        if (ns != null && (s = ns.getString()) != null) {
            sb.append(ns.getString());
        }
        sb.append("/");
        sb.append(name);
        return sb.toString();
    }
}

