/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.expr;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.expr.ExprError;
import com.kingdee.cosmic.ctrl.kdf.expr.Parser;
import com.kingdee.cosmic.ctrl.kdf.expr.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.kdf.expr.TimeSpan;
import com.kingdee.cosmic.ctrl.kdf.expr.Variant;
import java.util.ArrayList;
import java.util.Calendar;

abstract class InnerFunction {
    private int minArgs;
    private int maxArgs;

    public InnerFunction(int minArgs, int maxArgs, String strClass) {
        this.minArgs = minArgs;
        this.maxArgs = maxArgs;
    }

    public int getMinArgs() {
        return this.minArgs;
    }

    public int getMaxArgs() {
        return this.maxArgs;
    }

    static void validNumericParam(ArrayList params, int index) throws SyntaxErrorException {
        Variant var = (Variant)params.get(index);
        if (!var.isNumeric()) {
            ExprError.functionGoError(16L, "NOT NUMBER", index + 1);
        }
    }

    static double doubleValue(ArrayList params, int index) throws SyntaxErrorException {
        InnerFunction.validNumericParam(params, index);
        return ((Variant)params.get(index)).doubleValue();
    }

    static void stringOP(ArrayList params, Variant rvarResult, String strOP) throws SyntaxErrorException {
        String str = ((Variant)params.get(0)).toString();
        int iChars = (int)InnerFunction.doubleValue(params, 1);
        if (iChars < 0) {
            ExprError.functionGoError(32L, String.valueOf(iChars), 2);
        }
        iChars = Math.min(iChars, str.length());
        if (StringUtil.equals(strOP, "left")) {
            rvarResult.setObject(str.substring(0, iChars), 11);
        } else if (StringUtil.equals(strOP, "right")) {
            int start = 0;
            if (str.length() > iChars) {
                start = str.length() - iChars;
            } else {
                iChars = str.length();
            }
            rvarResult.setObject(str.substring(start, start + iChars), 11);
        } else {
            iChars = (int)((Variant)params.get(1)).doubleValue();
            long count = str.length() * iChars;
            if (count > 32767L) {
                ExprError.functionGoError(64L, String.valueOf(iChars), 2);
            }
            StringBuilder sb = new StringBuilder((int)count);
            for (int i = 0; i < iChars; ++i) {
                sb.append(str);
            }
            rvarResult.setObject(sb.toString(), 11);
        }
    }

    static void timeGet(ArrayList params, Variant rvarResult, int index) throws SyntaxErrorException {
        Variant var = (Variant)params.get(0);
        Calendar cal = var.toCalendar();
        rvarResult.setInt(cal.get(index));
    }

    static void timeSpan(ArrayList params, Variant rvarResult, String strIndex) throws SyntaxErrorException {
        Variant var = (Variant)params.get(0);
        Calendar cal = var.toCalendar();
        TimeSpan ts = new TimeSpan(cal.getTimeInMillis() * 10000L);
        if (StringUtil.equals(strIndex, "DAYS")) {
            rvarResult.setLong(ts.getDays());
        } else if (StringUtil.equals(strIndex, "HOURS")) {
            rvarResult.setLong(ts.getHours());
        } else if (StringUtil.equals(strIndex, "MILLISECONDS")) {
            rvarResult.setLong(ts.getMilliseconds());
        } else if (StringUtil.equals(strIndex, "MINUTES")) {
            rvarResult.setLong(ts.getMinutes());
        } else if (StringUtil.equals(strIndex, "SECONDS")) {
            rvarResult.setLong(ts.getSeconds());
        } else if (StringUtil.equals(strIndex, "TICKS")) {
            rvarResult.setLong(ts.getTicks());
        } else if (StringUtil.equals(strIndex, "TOTALDAYS")) {
            rvarResult.setDouble(ts.getTotalDays());
        } else if (StringUtil.equals(strIndex, "TOTALHOURS")) {
            rvarResult.setDouble(ts.getTotalHours());
        } else if (StringUtil.equals(strIndex, "TOTALMILLISECONDS")) {
            rvarResult.setDouble(ts.getTotalMilliseconds());
        } else if (StringUtil.equals(strIndex, "TOTALMINUTES")) {
            rvarResult.setDouble(ts.getTotalMinutes());
        } else if (StringUtil.equals(strIndex, "TOTALSECONDS")) {
            rvarResult.setDouble(ts.getTotalSeconds());
        } else {
            ExprError.functionGoError(16L, "ERROR TIMESPAN FUNC", 1);
        }
    }

    public static double log(double value, double base) {
        return StrictMath.log(value) / StrictMath.log(base);
    }

    public abstract void invoke(Parser var1, ArrayList var2, Variant var3) throws SyntaxErrorException;
}

