/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.expr;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.expr.ExprError;
import com.kingdee.cosmic.ctrl.kdf.expr.MacroHelperListener;
import com.kingdee.cosmic.ctrl.kdf.expr.MacroVariable;
import com.kingdee.cosmic.ctrl.kdf.expr.Parser;
import com.kingdee.cosmic.ctrl.kdf.expr.ParserHelperListener;
import com.kingdee.cosmic.ctrl.kdf.expr.ParserState;
import com.kingdee.cosmic.ctrl.kdf.expr.RelationsListener;
import com.kingdee.cosmic.ctrl.kdf.expr.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.kdf.expr.Variant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;

public class Macro {
    private static final long TOKEN_IF = 131072L;
    private static final long TOKEN_ELSEIF = 65536L;
    private static final long TOKEN_ELSE = 32768L;
    private static final HashMap macroTokens = new HashMap();
    private HashMap items = new HashMap();
    private Parser psr = new Parser(null, null);
    private String formula;
    private int errorPos;
    private SyntaxErrorException syntaxError;
    private MacroHelperListener macroRelationsListener;

    public Macro() {
        this.psr.addParserHelperListener(new MacroParserHelper());
    }

    public void addMacroRelationsListener(MacroHelperListener macroRelationsListener) {
        this.macroRelationsListener = macroRelationsListener;
        this.psr.setSupportCellName(true);
    }

    public void setDefaultFunctionProvider(Object functionProvider) {
        this.psr.setDefaultFunctionProvider(functionProvider);
    }

    public void setDefaultFunctionProvider(ArrayList functionProviders) {
        this.psr.setDefaultFunctionProvider(functionProviders);
    }

    public Parser getParser() {
        return this.psr;
    }

    public void clearVariables() {
        if (!this.items.isEmpty()) {
            this.items.clear();
        }
        this.addMacroRelationsListener(null);
        this.setDefaultFunctionProvider(null);
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(Object depOwner, String formula) {
        this.formula = formula;
        this.psr.prepare(depOwner, formula);
    }

    public void setFormula(String formula) {
        this.setFormula(this.psr.getOwner(), formula);
    }

    public Variant getVariableValue(String variableName) {
        Object obj = this.items.get(variableName.toUpperCase(Locale.ENGLISH));
        if (obj == null) {
            return Variant.nullVariant;
        }
        assert (obj instanceof MacroVariable);
        return ((MacroVariable)obj).getValue();
    }

    public void setVariableValue(String variableName, Variant value) {
        String upperName = variableName.toUpperCase(Locale.ENGLISH);
        Object obj = this.items.get(upperName);
        if (obj == null) {
            MacroVariable item = new MacroVariable(variableName);
            item.setValue(value);
            this.items.put(upperName, item);
            return;
        }
        assert (obj instanceof MacroVariable);
        ((MacroVariable)obj).getValue().setVariant(value);
    }

    public HashMap getItems() {
        return this.items;
    }

    public boolean setTokenAlias(String existName, String alias) {
        Object obj = macroTokens.get(existName = existName.toUpperCase(Locale.ENGLISH));
        if (obj == null) {
            return false;
        }
        if (StringUtil.isEmptyString(alias)) {
            macroTokens.remove(existName);
        } else {
            macroTokens.put(alias.toUpperCase(Locale.ENGLISH), obj);
        }
        return true;
    }

    public SyntaxErrorException getSyntaxError() {
        return this.syntaxError;
    }

    public int getErrorPos() {
        return this.errorPos;
    }

    public boolean isSyntaxCheck() {
        return this.psr.isSyntaxCheck();
    }

    public boolean syntaxCheck() {
        this.psr.setSyntaxCheck(true);
        return this.safeStatement();
    }

    public boolean execute() {
        this.psr.setSyntaxCheck(false);
        return this.safeStatement();
    }

    private boolean safeStatement() {
        try {
            this.psr.prepare(this.psr.getOwner(), this.formula);
            this.psr.advance();
            if (!this.psr.meet(0x1000000000000000L)) {
                this.statement();
                if (!this.psr.meet(0x1000000000000000L)) {
                    ExprError.goError(4096L, this.psr.getCurrentWord());
                }
            }
        }
        catch (SyntaxErrorException e) {
            this.syntaxError = e;
            this.errorPos = this.psr.getParserState().getTokenPos();
            return false;
        }
        return true;
    }

    private void statement() throws SyntaxErrorException {
        block0: while (this.psr.touchToken(72057594042253312L)) {
            if (this.psr.meet(0x400000L)) {
                this.psr.advance();
                this.statement();
                this.expectToken(0x200000L);
                continue;
            }
            if (this.psr.meet(0x100000000000000L)) {
                ParserState state = this.psr.getParserState();
                String leftVariableName = this.psr.getCurrentWord();
                this.psr.advance();
                Variant var = Variant.getNewEmptyVariant();
                if (this.psr.meet(0x1000000000000L)) {
                    this.psr.setParserState(state);
                    this.psr.statement(var);
                } else if (this.psr.meet(0x10000000000000L)) {
                    this.psr.setParserState(state);
                    this.psr.statement(var);
                } else {
                    this.expectToken(0x80000000000L);
                    this.psr.statement(var);
                    String upperVariableName = leftVariableName.toUpperCase(Locale.ENGLISH);
                    MacroVariable item = (MacroVariable)this.items.get(upperVariableName);
                    if (item == null) {
                        item = new MacroVariable(leftVariableName);
                        this.items.put(upperVariableName, item);
                    }
                    item.setValue(var);
                    item.setLValue(true);
                }
                this.expectToken(0x100000L);
                continue;
            }
            do {
                this.psr.advance();
                this.expectToken(0x1000000000000L);
                Variant var = new Variant(0.0);
                this.psr.condition(var);
                boolean condition = var.booleanValue();
                this.expectToken(0x2000000000000L);
                if (this.psr.isSyntaxCheck()) {
                    this.statement();
                    while (this.psr.meet(65536L)) {
                        this.psr.advance();
                        this.psr.condition(var);
                        this.statement();
                    }
                    if (!this.psr.meet(32768L)) continue block0;
                    this.psr.advance();
                    this.statement();
                    continue block0;
                }
                if (condition) {
                    if (!this.psr.meet(0x400000L)) {
                        ExprError.goError(16384L, "{");
                    }
                    this.statement();
                    while (this.psr.meet(65536L)) {
                        this.skipBlock();
                    }
                    if (!this.psr.meet(32768L)) continue block0;
                    this.skipBlock();
                    continue block0;
                }
                int count = 0;
                while (!(this.psr.meet(0x1000000000000000L) || this.psr.touchToken(98304L) && count == 0)) {
                    if (this.psr.meet(0x200000L) && --count == 0) {
                        if (!this.psr.meet(0x200000L)) break;
                        this.psr.advance();
                        break;
                    }
                    if (this.psr.meet(0x400000L)) {
                        ++count;
                    }
                    this.psr.advance();
                }
                if (!this.psr.meet(32768L)) continue;
                this.psr.advance();
                if (!this.psr.meet(0x400000L)) {
                    ExprError.goError(16384L, "{");
                }
                this.statement();
                continue block0;
            } while (this.psr.meet(65536L));
            if (!this.psr.meet(0x1000000000000000L)) continue;
        }
    }

    private void skipBlock() throws SyntaxErrorException {
        int count = 0;
        while (true) {
            this.psr.advance();
            if (this.psr.meet(0x1000000000000000L) || this.psr.meet(0x200000L) && --count == 0) {
                if (!this.psr.meet(0x200000L)) break;
                this.psr.advance();
                break;
            }
            if (!this.psr.meet(0x400000L)) continue;
            ++count;
        }
    }

    private void expectToken(long token) throws SyntaxErrorException {
        if (!this.psr.meet(token)) {
            if (token == 0x100000L) {
                ExprError.goError(16384L, ";");
            } else if (token == 0x200000L) {
                ExprError.goError(16384L, "}");
            } else if (token == 0x80000000000L) {
                ExprError.goError(16384L, "=");
            } else if (token == 0x1000000000000L) {
                ExprError.goError(16384L, "(");
            } else if (token == 0x2000000000000L) {
                ExprError.goError(16384L, ")");
            } else if (token == 131072L) {
                ExprError.goError(16384L, "if");
            } else {
                ExprError.goError(1L, null);
            }
        }
        this.psr.advance();
    }

    static {
        macroTokens.put("IF", new Long(131072L));
        macroTokens.put("ELSE", new Long(32768L));
        macroTokens.put("{", new Long(0x400000L));
        macroTokens.put("}", new Long(0x200000L));
        macroTokens.put(";", new Long(0x100000L));
    }

    class MacroParserHelper
    implements ParserHelperListener {
        MacroParserHelper() {
        }

        @Override
        public long parseToken(Parser psr) throws SyntaxErrorException {
            String strID = psr.getCurrentWord().toUpperCase(Locale.ENGLISH);
            Object obj = macroTokens.get(strID);
            if (obj != null) {
                long token = (Long)obj;
                if (token == 32768L) {
                    ParserState ps = psr.getParserState();
                    psr.advance();
                    if (psr.meet(131072L)) {
                        token = 65536L;
                    } else {
                        psr.setParserState(ps);
                    }
                }
                return token;
            }
            return 0x400000000L;
        }

        @Override
        public void parseID(Parser psr, String id, Variant rvarResult) throws SyntaxErrorException {
            String upperID = id.toUpperCase(Locale.ENGLISH);
            Object obj = Macro.this.items.get(upperID);
            if (obj != null) {
                rvarResult.setVariant(((MacroVariable)obj).getValue());
            } else if (psr.isSyntaxCheck()) {
                MacroVariable var = new MacroVariable(id);
                var.getValue().setObject(null);
                Macro.this.items.put(upperID, var);
            } else {
                Variant varFormula = Variant.getNewEmptyVariant();
                rvarResult.setEmpty();
                if (Macro.this.macroRelationsListener == null || !Macro.this.macroRelationsListener.queryVariable(psr, id, varFormula, rvarResult) || rvarResult.isEmpty()) {
                    ExprError.goError(512L, id);
                }
            }
        }

        @Override
        public Variant getObjectInstance(Parser psr, String objectName) throws SyntaxErrorException {
            Variant varObject = Variant.getNewEmptyVariant();
            if (Macro.this.macroRelationsListener != null && Macro.this.macroRelationsListener.queryObjectInstance(psr, objectName, varObject) && !varObject.isEmpty()) {
                return varObject;
            }
            ExprError.goError(512L, objectName);
            return varObject;
        }

        @Override
        public boolean queryCell(Parser psr, RelationsListener listener, int row, int col, Variant rvarResult) throws SyntaxErrorException {
            if (Macro.this.macroRelationsListener != null) {
                return Macro.this.macroRelationsListener.queryCell(psr, listener, row, col, rvarResult);
            }
            return false;
        }

        @Override
        public String getMethodName(String funcName) {
            if (Macro.this.macroRelationsListener != null) {
                return Macro.this.macroRelationsListener.getMethodName(funcName);
            }
            return funcName;
        }

        @Override
        public void processExt(Parser psr, Variant rvarResult) throws SyntaxErrorException {
            String word = psr.getCurrentWord();
            if (word.compareTo(";") != 0 && word.compareTo("}") != 0) {
                ExprError.goError(1L, "Not Implement.");
            }
        }

        @Override
        public boolean externalMethod(Parser psr, String funcName, ArrayList params, Variant rvarResult) throws SyntaxErrorException {
            if (Macro.this.macroRelationsListener != null) {
                return Macro.this.macroRelationsListener.externalMethod(psr, funcName, params, rvarResult);
            }
            return false;
        }
    }
}

