/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.expr;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.expr.ArrayStack;
import com.kingdee.cosmic.ctrl.kdf.expr.Macro;
import com.kingdee.cosmic.ctrl.kdf.expr.MacroHelperListener;
import java.util.ArrayList;

public class MacroEngineFactory {
    private static ArrayStack macros = new ArrayStack();

    private MacroEngineFactory() {
    }

    public static synchronized Macro createMacro(MacroHelperListener macroRelationsListener, ArrayList defaultFunctionProviders, Object depOwner, String formula) {
        Macro m = null;
        m = macros.isEmpty() ? new Macro() : (Macro)macros.pop();
        m.addMacroRelationsListener(macroRelationsListener);
        m.setDefaultFunctionProvider(defaultFunctionProviders);
        m.setFormula(depOwner, MacroEngineFactory.getProperFormula(formula));
        return m;
    }

    public static synchronized void recycleMacro(Macro m) {
        if (m != null) {
            m.clearVariables();
            m.getParser().prepare(null, null);
            macros.push(m);
        }
    }

    private static String getProperFormula(String formula) {
        if (!StringUtil.isEmptyString(formula)) {
            char ch = formula.charAt(0);
            if (ch == '@') {
                return formula.substring(1);
            }
            if (ch == '=') {
                boolean hasTail;
                boolean bl = hasTail = formula.charAt(formula.length() - 1) == ';';
                if (hasTail) {
                    return "$VALUE=" + formula.substring(1);
                }
                return "$VALUE=" + formula.substring(1) + ";";
            }
        }
        return formula;
    }

    static {
        Macro m = new Macro();
        macros.push(m);
    }
}

