/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.expr;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonMessages;
import com.kingdee.cosmic.ctrl.kdf.expr.ExprError;
import com.kingdee.cosmic.ctrl.kdf.expr.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.kdf.expr.VarBase;
import com.kingdee.cosmic.ctrl.kdf.expr.Variant;
import java.util.Calendar;

class VarCalendar
extends VarBase {
    VarCalendar() {
    }

    @Override
    protected void add(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        long leftval = ((Calendar)left.getValue()).getTimeInMillis() + right.longValue();
        if (result.getVt() == 13) {
            ((Calendar)result.getValue()).setTimeInMillis(leftval);
        } else {
            Calendar cldr = Calendar.getInstance();
            cldr.setTimeInMillis(leftval);
            result.setObject(cldr, 13);
        }
    }

    @Override
    protected void subtract(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        long leftval = ((Calendar)left.getValue()).getTimeInMillis() - right.longValue();
        if (result.getVt() == 13) {
            ((Calendar)result.getValue()).setTimeInMillis(leftval);
        } else {
            Calendar cldr = Calendar.getInstance();
            cldr.setTimeInMillis(leftval);
            result.setObject(cldr, 13);
        }
    }

    @Override
    protected void multiply(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        long leftval = ((Calendar)left.getValue()).getTimeInMillis() * right.longValue();
        if (result.getVt() == 13) {
            ((Calendar)result.getValue()).setTimeInMillis(leftval);
        } else {
            Calendar cldr = Calendar.getInstance();
            cldr.setTimeInMillis(leftval);
            result.setObject(cldr, 13);
        }
    }

    @Override
    protected void divide(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        long rightval = right.longValue();
        if (rightval == 0L) {
            throw new SyntaxErrorException(2L, CtrlCommonMessages.getMLS("divisionByZero", "\u9664\u6570\u4e3a\u96f6"));
        }
        long leftval = ((Calendar)left.getValue()).getTimeInMillis() / rightval;
        if (result.getVt() == 13) {
            ((Calendar)result.getValue()).setTimeInMillis(leftval);
        } else {
            Calendar cldr = Calendar.getInstance();
            cldr.setTimeInMillis(leftval);
            result.setObject(cldr, 13);
        }
    }

    @Override
    protected void mod(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        long rightval = right.longValue();
        if (rightval == 0L) {
            throw new SyntaxErrorException(2L, CtrlCommonMessages.getMLS("divisionByZero", "\u9664\u6570\u4e3a\u96f6"));
        }
        long leftval = ((Calendar)left.getValue()).getTimeInMillis() % rightval;
        if (result.getVt() == 13) {
            ((Calendar)result.getValue()).setTimeInMillis(leftval);
        } else {
            Calendar cldr = Calendar.getInstance();
            cldr.setTimeInMillis(leftval);
            result.setObject(cldr, 13);
        }
    }

    @Override
    protected void and(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        ExprError.goError(64L, CtrlCommonMessages.getMLS("unsupportedDataTypeOperation2", "\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u8fd0\u7b97"));
    }

    @Override
    protected void or(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        ExprError.goError(64L, CtrlCommonMessages.getMLS("unsupportedDataTypeOperation2", "\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u8fd0\u7b97"));
    }

    @Override
    protected void xor(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        ExprError.goError(64L, CtrlCommonMessages.getMLS("unsupportedDataTypeOperation2", "\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u8fd0\u7b97"));
    }
}

