/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.util;

import java.io.Closeable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collection;
import org.apache.log4j.Logger;

public interface CloseUtil {
    public static final Logger logger = Logger.getLogger(CloseUtil.class);

    public static <E extends Closeable> void close(Collection<E> dataSets) {
        if (dataSets == null) {
            return;
        }
        for (Closeable o : dataSets) {
            if (o == null) continue;
            try {
                o.close();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void close(Closeable ... params) {
        for (Closeable o : params) {
            if (o == null) continue;
            try {
                o.close();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void close(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void close(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void close(Statement ps) {
        if (ps != null) {
            try {
                ps.close();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void close(Statement ps, ResultSet rs) {
        CloseUtil.close(rs);
        CloseUtil.close(ps);
    }

    public static void close(Connection conn, Statement ps, ResultSet rs) {
        CloseUtil.close(rs);
        CloseUtil.close(ps);
        CloseUtil.close(conn);
    }
}

