/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.script.miniscript;

import com.kingdee.cosmic.ctrl.script.miniscript.MiniScriptRuntimeException;
import com.kingdee.cosmic.ctrl.script.miniscript.ScriptContext;
import com.kingdee.cosmic.ctrl.script.miniscript.exec.Logger;
import com.kingdee.cosmic.ctrl.script.miniscript.exec.objs.Function;
import com.kingdee.cosmic.ctrl.script.miniscript.exec.objs.Var;
import java.util.HashMap;
import java.util.Map;

public class ScriptResult {
    private ScriptContext ctx;
    private Map varMap = new HashMap();
    private MiniScriptRuntimeException runtimeException = null;

    protected ScriptResult(ScriptContext ctx) {
        this.ctx = ctx;
    }

    public ScriptContext getScriptContext() {
        return this.ctx;
    }

    public Function defineFunction(Function f) {
        Var v = new Var(f.getName(), this.ctx.getLevel());
        return (Function)this.setVar(v, (Object)f);
    }

    public Object setVar(Var var, Object value) {
        if (this.ctx.existSystemVar(var)) {
            Logger.warn("Variable \"" + var.getName() + "\" overwrite the system default object.");
        }
        return var.setLeveledValue(value, this.varMap, this.ctx.getLevel());
    }

    public Object getVar(Var var) {
        if (this.varMap.containsKey(var)) {
            return var.getLeveledValue(this.varMap, this.ctx.getLevel());
        }
        return this.ctx.getSystemVar(var);
    }

    public boolean exitsVar(Var var) {
        return this.varMap.containsKey(var) || this.ctx.existSystemVar(var);
    }

    public Object delVar(Var var) {
        if (this.varMap.containsKey(var)) {
            return this.varMap.remove(var);
        }
        return this.ctx.delSystemVar(var);
    }

    public Object setVar(String varName, Object value) {
        return this.setVar(Var.parse(varName, this.ctx.getLevel()), value);
    }

    public Object getVar(String varName) {
        return this.getVar(Var.parse(varName, this.ctx.getLevel()));
    }

    public boolean exitsVar(String varName) {
        return this.exitsVar(Var.parse(varName, this.ctx.getLevel()));
    }

    public Object delVar(String varName) {
        return this.delVar(Var.parse(varName, this.ctx.getLevel()));
    }

    public void clearVar() {
        this.varMap.clear();
    }

    public Map getVarMap() {
        return this.varMap;
    }

    public void putVarMap(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            if (entry == null) continue;
            Object key = entry.getKey();
            if (key instanceof String) {
                this.setVar((String)key, entry.getValue());
                continue;
            }
            if (key instanceof Var) {
                this.setVar((Var)key, entry.getValue());
                continue;
            }
            Logger.warn("Input var " + key + " key-type uncorrect!");
        }
    }

    public void dumpVar() {
        Map map = this.getVarMap();
        System.out.println("----variable=" + map.size() + "----");
        for (Var key : map.keySet()) {
            key = key.getLinkHead();
            do {
                System.out.print(key.getLevel() + ":" + key.getName());
                System.out.println("=" + key.getValue());
            } while ((key = key.next()) != null);
        }
    }

    public MiniScriptRuntimeException getRuntimeException() {
        return this.runtimeException;
    }

    public boolean withException() {
        return this.runtimeException != null;
    }

    protected void setRuntimeException(MiniScriptRuntimeException exception) {
        this.runtimeException = exception;
    }
}

