/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.event.MouseInputListener;

public class CompositePane
extends JComponent {
    protected JComponent _firstComp;
    protected JComponent _secondComp;
    protected int _dividerLen = 6;
    protected float _dividerLocationPercent = 0.6f;
    protected boolean _adjustable = true;
    protected boolean _depend;
    protected Cursor _moveCursor = new Cursor(11);
    protected int _orient;

    public CompositePane(int orientation) {
        MouseHandler mh = new MouseHandler();
        this.addMouseListener(mh);
        this.addMouseMotionListener(mh);
        this._orient = orientation;
        this.setLayout(null);
        if (orientation == 0) {
            this.setPreferredSize(new Dimension(1024, 17));
        } else {
            this.setPreferredSize(new Dimension(17, 768));
        }
        this.validate();
    }

    public void setFirstCompVisible(boolean isVisible) {
        if (this._firstComp != null) {
            this._firstComp.setVisible(isVisible);
            this.validate();
            this.repaint();
        }
    }

    public void setSecondCompVisible(boolean isVisible) {
        if (this._secondComp != null) {
            this._secondComp.setVisible(isVisible);
            this.validate();
            this.repaint();
        }
    }

    public JComponent getFirstComponent() {
        return this._firstComp;
    }

    public void setFirstComponent(JComponent extComp) {
        if (this._firstComp != null) {
            this.remove(this._firstComp);
        }
        this._firstComp = extComp;
        if (this._firstComp != null) {
            this.add(this._firstComp);
            this.validate();
            this.repaint();
        }
    }

    public JComponent getSecondComponent() {
        return this._secondComp;
    }

    public void setSecondComponent(JComponent extComp) {
        if (this._secondComp != null) {
            this.remove(this._secondComp);
        }
        this._secondComp = extComp;
        if (this._secondComp != null) {
            this.add(this._secondComp);
            this.validate();
            this.repaint();
        }
    }

    public void setAdjustable(boolean b) {
        if (this._adjustable != b) {
            this._adjustable = b;
            this.doLayout();
            this.repaint();
        }
    }

    public void setDependSecondSize(boolean b) {
        this._depend = b;
    }

    @Override
    public void doLayout() {
        boolean hasLeft = this._firstComp != null && this._firstComp.isVisible();
        boolean hasRight = this._secondComp != null && this._secondComp.isVisible();
        boolean isHori = this.isHorizontal();
        if (isHori) {
            Dimension dd;
            if (this._depend && this._secondComp != null && (dd = this._secondComp.getPreferredSize()) != null && dd.width > 0) {
                this.setDividerLocation(this.getWidth() - dd.width - this._dividerLen);
            }
            int height = this.getHeight();
            if (hasLeft && hasRight) {
                int divLoc = this.getDividerLocation();
                this._firstComp.setBounds(0, 0, divLoc, height);
                this._secondComp.setBounds(divLoc + this._dividerLen, 0, this.getWidth() - divLoc - this._dividerLen, height);
            } else if (hasLeft && !hasRight) {
                this._firstComp.setBounds(0, 0, this.getWidth(), height);
            } else if (!hasLeft && hasRight) {
                this._secondComp.setBounds(0, 0, this.getWidth(), height);
            }
        } else {
            Dimension dd;
            if (this._depend && this._secondComp != null && (dd = this._secondComp.getPreferredSize()) != null && dd.height > 0) {
                this.setDividerLocation(this.getHeight() - dd.height - this._dividerLen);
            }
            int width = this.getWidth();
            if (hasLeft && hasRight) {
                int divLoc = this.getDividerLocation();
                this._firstComp.setBounds(0, 0, width, divLoc);
                this._secondComp.setBounds(0, divLoc + this._dividerLen, width, this.getHeight() - divLoc - this._dividerLen);
            } else if (hasLeft && !hasRight) {
                this._firstComp.setBounds(0, 0, width, this.getHeight());
            } else if (!hasLeft && hasRight) {
                this._secondComp.setBounds(0, 0, width, this.getHeight());
            }
        }
        if (hasRight) {
            this._secondComp.setPreferredSize(this._secondComp.getSize());
        }
        this.repaint();
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (this.isDividerVisible()) {
            this.paintDivider(g);
        }
    }

    private void paintDivider(Graphics g) {
        if (this.isHorizontal()) {
            int divLoc = this.getDividerLocation();
            int h = this.getHeight();
            g.translate(divLoc, 0);
            g.setColor(Color.WHITE);
            g.drawLine(1, 1, this._dividerLen - 2, 1);
            g.drawLine(1, 1, 1, h - 2);
            g.setColor(this.getBackground());
            g.drawLine(2, 2, 2, h - 3);
            g.drawLine(3, 2, 3, h - 3);
            g.drawLine(4, 1, 4, h - 2);
            g.drawLine(1, h - 1, this._dividerLen - 2, h - 1);
            g.setColor(new Color(128, 128, 128));
            g.drawLine(5, 0, 5, h - 1);
            g.translate(-divLoc, 0);
        } else {
            int divLoc = this.getDividerLocation();
            int w = this.getWidth();
            g.translate(0, divLoc);
            g.setColor(Color.WHITE);
            g.drawLine(1, 1, 1, this._dividerLen - 2);
            g.drawLine(1, 1, w - 2, 1);
            g.setColor(this.getBackground());
            g.drawLine(2, 2, w - 3, 2);
            g.drawLine(2, 3, w - 3, 3);
            g.drawLine(1, 4, w - 2, 4);
            g.drawLine(w - 1, 1, w - 1, this._dividerLen - 2);
            g.setColor(new Color(128, 128, 128));
            g.drawLine(0, 5, w - 1, 5);
            g.translate(0, -divLoc);
        }
    }

    private boolean isDividerVisible() {
        boolean hasLeft = this._firstComp != null && this._firstComp.isVisible();
        boolean hasRight = this._secondComp != null && this._secondComp.isVisible();
        return hasLeft && hasRight;
    }

    private int getDividerLocation() {
        if (this.isHorizontal()) {
            float location = (float)this.getWidth() * this._dividerLocationPercent;
            return Math.round(location);
        }
        float location = (float)this.getHeight() * this._dividerLocationPercent;
        return Math.round(location);
    }

    private void setDividerLocation(int value) {
        if (this.isHorizontal()) {
            if (value >= 0 && value <= this.getWidth() - this._dividerLen) {
                this._dividerLocationPercent = (float)value / (float)this.getWidth();
            }
        } else if (value >= 0 && value <= this.getHeight() - this._dividerLen) {
            this._dividerLocationPercent = (float)value / (float)this.getHeight();
        }
    }

    private boolean isHorizontal() {
        return this._orient == 0;
    }

    private class MouseHandler
    implements MouseInputListener {
        private boolean _isMouseOnDivider = false;
        private boolean _oldDepend;

        private MouseHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (CompositePane.this._adjustable) {
                int x = e.getX();
                Component comp = e.getComponent();
                if (this.isMouseOnDivider(x)) {
                    comp.setCursor(CompositePane.this._moveCursor);
                } else {
                    comp.setCursor(Cursor.getDefaultCursor());
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (CompositePane.this._adjustable) {
                int x = e.getX();
                if (this.isMouseOnDivider(x)) {
                    this._isMouseOnDivider = true;
                }
                this._oldDepend = CompositePane.this._depend;
                CompositePane.this._depend = false;
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (CompositePane.this._adjustable) {
                int x = e.getX();
                if (this._isMouseOnDivider) {
                    CompositePane.this.setCursor(CompositePane.this._moveCursor);
                    CompositePane.this.setDividerLocation(x);
                    CompositePane.this._firstComp.invalidate();
                    CompositePane.this.validate();
                    CompositePane.this.repaint();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (CompositePane.this._adjustable) {
                this._isMouseOnDivider = false;
                CompositePane.this.setCursor(Cursor.getDefaultCursor());
                CompositePane.this._depend = this._oldDepend;
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            CompositePane.this.setCursor(Cursor.getDefaultCursor());
        }

        private boolean isMouseOnDivider(int x) {
            boolean isOn = false;
            int divLoc = CompositePane.this.getDividerLocation();
            if (CompositePane.this.isDividerVisible() && x >= divLoc && x <= divLoc + CompositePane.this._dividerLen) {
                isOn = true;
            }
            return isOn;
        }
    }
}

