/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.currency;

import com.kingdee.cosmic.ctrl.common.currency.ICurrencyUpperFunction;
import com.kingdee.cosmic.ctrl.common.digitalstyle.Format;
import com.kingdee.cosmic.ctrl.common.digitalstyle.Formats;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonUIMessages;
import com.kingdee.cosmic.ctrl.common.variant.Variant;
import java.util.Locale;

public class FormatHKD
implements ICurrencyUpperFunction {
    @Override
    public String format(Locale locale, Variant variant, boolean isAddPrefix) {
        Format format;
        String result = null;
        if (locale == Locale.ENGLISH) {
            format = Formats.getFormat(CtrlCommonUIMessages.getMLS("engHkd", "[ENG-HKD]g/\u901a\u7528\u683c\u5f0f"));
        } else if (locale == Locale.SIMPLIFIED_CHINESE) {
            format = Formats.getFormat(CtrlCommonUIMessages.getMLS("rmbG", "[Rmb]G/\u901a\u7528\u683c\u5f0f;[Rmb](\u8d1f\u6570)G/\u901a\u7528\u683c\u5f0f"));
        } else if (locale == Locale.TRADITIONAL_CHINESE) {
            format = Formats.getFormat(CtrlCommonUIMessages.getMLS("chtRmbG", "[CHT-Rmb]G/\u901a\u7528\u683c\u5f0f;[CHT-Rmb](\u8d1f\u6570)G/\u901a\u7528\u683c\u5f0f"));
        } else {
            throw new RuntimeException("Not support language: " + locale);
        }
        result = format.format4Print(variant).toString();
        if (isAddPrefix && locale != Locale.ENGLISH) {
            if (locale == Locale.SIMPLIFIED_CHINESE) {
                result = CtrlCommonUIMessages.getMLS("hkd", "\u6e2f\u5143") + result;
            } else if (locale == Locale.TRADITIONAL_CHINESE) {
                result = CtrlCommonUIMessages.getMLS("hkd", "\u6e2f\u5143") + result;
            } else {
                throw new RuntimeException("Not support language: " + locale);
            }
        }
        return result;
    }
}

