/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.hyperlink;

import com.kingdee.cosmic.ctrl.common.hyperlink.HyperLink;
import com.kingdee.cosmic.ctrl.common.hyperlink.LinkToPanel;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonUIMessages;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDList;
import com.kingdee.cosmic.ctrl.swing.KDTextField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class HyperLinkWizzard
extends KDDialog {
    private KDLabel _lkTxtLb;
    private KDList _lkTypeList;
    private KDLabel _showTxtLb;
    private KDTextField _showTxtField;
    private KDButton _btnOk;
    private KDButton _btnCancel;
    private KDButton _btnDelHyperLink;
    private ArrayList _prefixs;
    private ArrayList _linkToPanels;
    private HyperLink _link;
    private boolean _isChanged;

    public HyperLinkWizzard(Frame parent) {
        super(parent, true);
        this.init();
    }

    public HyperLinkWizzard(Dialog parent) {
        super(parent, true);
        this.init();
    }

    public void registerHyperLinkPanel(String prefix, String title, LinkToPanel linkPanel) {
        if (prefix != null && title != null && linkPanel != null) {
            this._prefixs.add(prefix);
            this._linkToPanels.add(linkPanel);
            this._lkTypeList.addElement((Object)title);
            Container cp = this.getContentPane();
            cp.add((Component)((Object)linkPanel));
            linkPanel.setBounds(100, 40, 520, 210);
        }
    }

    public LinkToPanel getHyperLinkPanel(int index) {
        return (LinkToPanel)((Object)this._linkToPanels.get(index));
    }

    public void registerDefaultHyperLinkPanel(String title, LinkToPanel linkPanel) {
        if (title != null && linkPanel != null) {
            Container cp = this.getContentPane();
            cp.remove((Component)((Object)((LinkToPanel)((Object)this._linkToPanels.get(0)))));
            cp.add((Component)((Object)linkPanel));
            linkPanel.setBounds(100, 40, 520, 210);
            this._linkToPanels.set(0, linkPanel);
            this._lkTypeList.setElement((Object)title, 0);
        }
    }

    public void setHyperLink(HyperLink link, boolean textReadOnly) {
        this.setHyperLink(link, "", textReadOnly);
    }

    public void setHyperLink(HyperLink link, String showText, boolean textReadOnly) {
        this._link = link;
        this._btnDelHyperLink.setVisible(this._link != null);
        int index = 0;
        if (this._link != null) {
            index = this.getPrefixIndex(this._link);
        }
        this._lkTypeList.setSelectedIndex(index);
        this._showTxtField.setEnabled(!textReadOnly);
        this._showTxtField.setText(this._link != null ? this._link.getText() : showText);
        this.changePanel(this._lkTypeList.getSelectedIndex());
    }

    public boolean isChanged() {
        return this._isChanged;
    }

    public HyperLink getHyperLink() {
        return this._link;
    }

    private void init() {
        this.setSize(630, 318);
        this.setResizable(false);
        this.initComponents();
        this.initListeners();
        this._prefixs = new ArrayList();
        this._linkToPanels = new ArrayList();
    }

    private void initComponents() {
        Container cp = this.getContentPane();
        cp.setLayout(null);
        this._lkTxtLb = new KDLabel();
        this._lkTxtLb.setText(HyperLinkWizzard.getLocleText("connectTo", CtrlCommonUIMessages.getMLS("connectTo", "\u94fe\u63a5\u5230")));
        this._lkTypeList = new KDList();
        this._lkTypeList.setSelectionMode(0);
        this._showTxtLb = new KDLabel();
        this._showTxtLb.setText(HyperLinkWizzard.getLocleText("displayText", CtrlCommonUIMessages.getMLS("displayText", "\u8981\u663e\u793a\u7684\u6587\u5b57")));
        this._showTxtField = new KDTextField();
        this._btnOk = new KDButton(HyperLinkWizzard.getLocleText("confirm", CtrlCommonUIMessages.getMLS("ok", "\u786e\u5b9a")));
        this._btnCancel = new KDButton(HyperLinkWizzard.getLocleText("cancel", CtrlCommonUIMessages.getMLS("cancel", "\u53d6\u6d88")));
        this._btnDelHyperLink = new KDButton(HyperLinkWizzard.getLocleText("deleteHyperLink", CtrlCommonUIMessages.getMLS("deleteHyperLink", "\u5220\u9664\u8d85\u94fe\u63a5")));
        cp.add((Component)this._lkTxtLb);
        cp.add((Component)this._lkTypeList);
        cp.add((Component)this._showTxtLb);
        cp.add((Component)this._showTxtField);
        cp.add((Component)this._btnOk);
        cp.add((Component)this._btnCancel);
        cp.add((Component)this._btnDelHyperLink);
        int dx = 10;
        int dy = 10;
        int x = dx;
        int y = dy;
        int defH = 20;
        this._lkTxtLb.setBounds(x, y, 80, defH);
        this._lkTypeList.setBounds(x, y += defH + dy, 80, 240);
        y = dy;
        this._showTxtLb.setBounds(x += dx + 80, y, 130, 20);
        this._showTxtField.setBounds(x += dx + 130, y, 380, 20);
        this._btnCancel.setBounds(540, 260, 80, 20);
        this._btnOk.setBounds(450, 260, 80, 20);
        this._btnDelHyperLink.setBounds(310, 260, 130, 20);
    }

    public static String getLocleText(String key, String defaultValue) {
        return CtrlCommonUIMessages.getMLS(key, defaultValue);
    }

    private void initListeners() {
        BtnHandler bh = new BtnHandler();
        this._btnOk.addActionListener((ActionListener)bh);
        this._btnCancel.addActionListener((ActionListener)bh);
        this._btnDelHyperLink.addActionListener((ActionListener)bh);
        this._lkTypeList.addListSelectionListener((ListSelectionListener)new ListHandler());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                HyperLinkWizzard.this.closeDialog();
            }
        });
    }

    public void show() {
        this._isChanged = false;
        super.show();
    }

    private int getPrefixIndex(HyperLink link) {
        String linkTo = link.getLinkTo();
        int size = this._prefixs.size();
        for (int i = 1; i < size; ++i) {
            String prefix = (String)this._prefixs.get(i);
            if (!linkTo.startsWith(prefix)) continue;
            return i;
        }
        return 0;
    }

    private void changePanel(int index) {
        int size = this._prefixs.size();
        for (int i = 0; i < size; ++i) {
            ((LinkToPanel)((Object)this._linkToPanels.get(i))).setVisible(false);
        }
        LinkToPanel panel = (LinkToPanel)((Object)this._linkToPanels.get(index));
        panel.setVisible(true);
        String prefix = (String)this._prefixs.get(index);
        String linkTo = this._link == null ? "" : this._link.getLinkTo().substring(prefix.length());
        panel.updatePanel(linkTo);
    }

    private void closeDialog() {
        this._isChanged = false;
        this.setVisible(false);
        super.dispose();
    }

    private class ListHandler
    implements ListSelectionListener {
        private ListHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            HyperLinkWizzard.this.changePanel(HyperLinkWizzard.this._lkTypeList.getSelectedIndex());
        }
    }

    private class BtnHandler
    extends AbstractAction {
        private static final long serialVersionUID = -3687174028609410752L;

        private BtnHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == HyperLinkWizzard.this._btnOk) {
                HyperLinkWizzard.this.closeDialog();
                int index = HyperLinkWizzard.this._lkTypeList.getSelectedIndex();
                String realLinkTo = ((LinkToPanel)((Object)HyperLinkWizzard.this._linkToPanels.get(index))).getLinkTo();
                String text = HyperLinkWizzard.this._showTxtField.getText();
                if (HyperLinkWizzard.this._link == null) {
                    if (!StringUtil.isEmptyString((String)realLinkTo)) {
                        HyperLinkWizzard.this._link = new HyperLink();
                        HyperLinkWizzard.this._link.setLinkTo((String)HyperLinkWizzard.this._prefixs.get(index) + realLinkTo);
                        if (StringUtil.isEmptyString((String)text)) {
                            HyperLinkWizzard.this._link.setText(realLinkTo);
                        } else {
                            HyperLinkWizzard.this._link.setText(text);
                        }
                        HyperLinkWizzard.this._isChanged = true;
                    }
                } else {
                    HyperLink link = new HyperLink();
                    link.setLinkTo((String)HyperLinkWizzard.this._prefixs.get(index) + realLinkTo);
                    if (HyperLinkWizzard.this._showTxtField.isEnabled()) {
                        if (StringUtil.isEmptyString((String)text)) {
                            link.setText(realLinkTo);
                        } else {
                            link.setText(text);
                        }
                    } else {
                        link.setText(HyperLinkWizzard.this._link.getText());
                    }
                    if (!link.equals(HyperLinkWizzard.this._link)) {
                        HyperLinkWizzard.this._link = link;
                        HyperLinkWizzard.this._isChanged = true;
                    }
                }
            } else if (source == HyperLinkWizzard.this._btnCancel) {
                HyperLinkWizzard.this.closeDialog();
            } else if (source == HyperLinkWizzard.this._btnDelHyperLink) {
                HyperLinkWizzard.this.closeDialog();
                HyperLinkWizzard.this._link = null;
                HyperLinkWizzard.this._isChanged = true;
            }
        }
    }
}

