/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.ui;

import com.kingdee.cosmic.ctrl.common.LanguageManager;
import com.kingdee.cosmic.ctrl.common.layout.table.Cell;
import com.kingdee.cosmic.ctrl.common.layout.table.Table;
import com.kingdee.cosmic.ctrl.common.ui.MultiLangUI;
import com.kingdee.cosmic.ctrl.common.ui.TypicalDialog;
import com.kingdee.cosmic.ctrl.common.ui.WindowUtil;
import com.kingdee.cosmic.ctrl.common.util.CtrlClassUtil;
import com.kingdee.cosmic.ctrl.common.util.PathUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.swing.KDMultiLangBox;
import com.kingdee.cosmic.ctrl.swing.KDTextField;
import com.kingdee.cosmic.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.JComponent;

public class RenameDialog
extends TypicalDialog {
    public static String[] SupportHideAllExtName = new String[0];
    private String[] _hideExtNames;
    protected String _extName;
    protected KDTextField txtName;
    protected KDMultiLangBox mlbAlias;

    public RenameDialog() {
    }

    public RenameDialog(Dialog owner) {
        super(owner);
    }

    public RenameDialog(Frame owner) {
        super(owner);
    }

    @Override
    protected void todoInit() {
        super.setTitle(RenameDialog.getMLS("rename", "\u91cd\u547d\u540d"));
        this.txtName = new KDTextField();
        this.txtName.setMaxLength(128);
        this.mlbAlias = MultiLangUI.newKDMultiLangBox();
        this.mlbAlias.setMaxLength(32);
    }

    @Override
    protected void todoAddControls(Container parent, Cell thisCell) {
        super.setSize(320, 135);
        Table tab = thisCell.split(2, 1);
        tab.getStyle().clear(1);
        tab.rowStyle(0).setMarginBottom(3);
        parent.add((Component)CtrlSwingUtilities.createLabelContainer((JComponent)this.txtName, (String)RenameDialog.getMLS("name", "\u540d\u79f0"), (int)80), tab.cell(0, 0));
        parent.add((Component)CtrlSwingUtilities.createLabelContainer((JComponent)this.mlbAlias, (String)RenameDialog.getMLS("alias", "\u522b\u540d"), (int)80), tab.cell(1, 0));
        if (this.txtName.isEnabled()) {
            this.txtName.selectAll();
        }
    }

    @Override
    protected void todoActionPerformed(ActionEvent e) {
    }

    @Override
    protected void todoKeyAction(int keyCode) {
    }

    @Override
    protected boolean verify() {
        String newName = this.getNewName();
        if (StringUtil.isEmptyString((String)newName) || !PathUtil.isValidName((String)newName)) {
            WindowUtil.msgboxError(RenameDialog.getMLS("msgboxError", "\u540d\u79f0\u4e3a\u7a7a\u6216\u5305\u542b\u975e\u6cd5\u5b57\u7b26\u3002"), RenameDialog.getMLS("rename", "\u91cd\u547d\u540d"), (Component)((Object)this));
            return false;
        }
        return true;
    }

    public void setOldName(String oldName) {
        String[] oldNameAndExt = this.splitExtName(oldName);
        this.txtName.setText(oldNameAndExt[0]);
        this._extName = oldNameAndExt[1];
    }

    public String getNewName() {
        return this.txtName.getText().trim() + (this._extName == null ? "" : this._extName);
    }

    public void setOldAlias(HashMap alias) {
        MultiLangUI.toKDMultiLangBox(this.mlbAlias, alias);
    }

    public HashMap getNewAlias() {
        return MultiLangUI.fromKDMultiLangBox(this.mlbAlias);
    }

    public void setNameEnabled(boolean b) {
        this.txtName.setEnabled(b);
    }

    protected static String getMLS(String key, String defaultValue) {
        String res = CtrlClassUtil.getPackageName(RenameDialog.class) + ".resource.ui";
        return LanguageManager.getLangMessage((String)key, (String)res, (String)defaultValue);
    }

    public void setHideExtNames(String[] extNames) {
        for (int i = 0; i < extNames.length; ++i) {
            extNames[i] = "." + extNames[i];
        }
        this._hideExtNames = extNames;
    }

    private String[] getHideExtNames() {
        if (this._hideExtNames == null) {
            this._hideExtNames = new String[0];
        }
        return this._hideExtNames;
    }

    private String[] splitExtName(String name) {
        String[] result;
        block2: {
            block1: {
                result = new String[2];
                result[0] = name;
                if (this.getHideExtNames() != SupportHideAllExtName) break block1;
                int dotIdx = name.lastIndexOf(46);
                if (dotIdx <= 0) break block2;
                result[0] = name.substring(0, dotIdx);
                result[1] = name.substring(dotIdx);
                break block2;
            }
            for (int i = 0; i < this.getHideExtNames().length; ++i) {
                if (!name.endsWith(this.getHideExtNames()[i])) continue;
                result[0] = name.substring(0, name.length() - this.getHideExtNames()[i].length());
                result[1] = this.getHideExtNames()[i];
                break;
            }
        }
        return result;
    }
}

