/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.ui.editor.styled;

import com.kingdee.cosmic.ctrl.common.ui.editor.DefaultEditorStyleModel;
import com.kingdee.cosmic.ctrl.common.ui.editor.EditorStyleModel;
import com.kingdee.cosmic.ctrl.common.ui.editor.Lexer;
import com.kingdee.cosmic.ctrl.common.ui.editor.MatchedToken;
import com.kingdee.cosmic.ctrl.common.ui.editor.StyledEditor;
import java.awt.Color;

public class MiniScriptEditor
extends StyledEditor {
    public static MiniScriptEditor createSensitiveCaseEditor() {
        return new MiniScriptEditor(new MiniScriptStyledModel(){

            @Override
            public boolean isIgnoreCase() {
                return false;
            }
        });
    }

    public MiniScriptEditor() {
        this.setStyleModel(new MiniScriptStyledModel());
    }

    public MiniScriptEditor(EditorStyleModel model) {
        super(model);
    }

    public static MiniScriptEditor newInstanceSupportVarScript() {
        return new MiniScriptEditor(new MiniScriptStyledModel(){

            @Override
            protected void initStyle() {
                super.initStyle();
                this.addStyle(new MatchedToken(){

                    @Override
                    public boolean match(String token) {
                        int n = token.length();
                        if (n > 0) {
                            char ch = token.charAt(0);
                            return ch == '@' || ch == '$';
                        }
                        return false;
                    }
                }, this.createSimpleAttributeSet(Color.BLUE));
            }

            @Override
            public void beforeRun(Lexer lex) {
                super.beforeRun(lex);
                lex.delSpecialChar("@$");
            }
        });
    }

    public void addStyledKey(String dyKey, Color color) {
        MiniScriptStyledModel m = (MiniScriptStyledModel)this.getStyleModel();
        m.addStyle(new String[]{dyKey}, m.createSimpleAttributeSet(color));
    }

    static class MiniScriptStyledModel
    extends DefaultEditorStyleModel {
        public MiniScriptStyledModel() {
            this.initStyle();
        }

        protected void initStyle() {
            this.addStyle(new MatchedToken(){

                @Override
                public boolean match(String token) {
                    return token.matches("'.*'") || token.matches("\".*\"");
                }
            }, this.createSimpleAttributeSet(Color.RED));
            this.addStyle(new MatchedToken(){

                @Override
                public boolean match(String token) {
                    return token.matches("[\\d]+(([Ll])|(\\.[\\d]+([DdFf])?))?");
                }
            }, this.createSimpleAttributeSet(Color.RED));
            String keys = "sys,system,if,else,for,foreach,while,do,switch,case,default,break,continue,exit,true,false,null,this,var,function,return,new,arguments";
            this.addStyle(keys.split(","), this.createSimpleAttributeSet(new Color(0x3366FF)));
            keys = "importPackage,raise,print,println,sleep,now,cmd,toInt,toLong,toFloat,toDouble,toNumber,toStr,toBoolean,round,trunc,runJava,createArray,createObject,fopen,fclose,readStream";
            this.addStyle(keys.split(","), this.createSimpleAttributeSet(new Color(0xFF00FF)));
            keys = "miniscript,version,author";
            this.addStyle(keys.split(","), this.createSimpleAttributeSet(Color.CYAN.darker()));
            keys = "~`!@#$%^&*()-=_+[]{};':\",./<>?\\|";
            this.addStyle(keys.split(""), this.createSimpleAttributeSet(Color.GRAY));
        }
    }
}

