/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.ui.horizontaltree;

import com.kingdee.cosmic.ctrl.common.ui.horizontaltree.HorizontalTree;
import com.kingdee.cosmic.ctrl.common.ui.horizontaltree.IHorizontalTreeCustomView;
import com.kingdee.cosmic.ctrl.common.ui.horizontaltree.IHorizontalTreeNode;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;

public class DefaultHorizontalTreeView
implements IHorizontalTreeCustomView {
    private HorizontalTree _tree;

    @Override
    public void refresh() {
        Dimension dim = this._tree.confirmNodesPosition();
        this._tree.addCtrl();
        this._tree.getCtrl().setPreferredSize(dim);
        this._tree.getCtrl().revalidate();
        this._tree.getCtrl().repaint();
    }

    @Override
    public void setHorizontalTree(HorizontalTree tree) {
        this._tree = tree;
    }

    protected HorizontalTree getHorizontalTree() {
        return this._tree;
    }

    @Override
    public Dimension calculateNodeSize(IHorizontalTreeNode node) {
        return new Dimension(100, 50);
    }

    @Override
    public int getBeanpodBusWidth() {
        return 20;
    }

    @Override
    public int getBeanpodSiblingGap() {
        return 6;
    }

    @Override
    public int getCousinGap() {
        return 30;
    }

    @Override
    public int getLevelDistance() {
        return 40;
    }

    @Override
    public int getSiblingGap() {
        return 16;
    }

    @Override
    public void drawPreceding(Graphics g, IHorizontalTreeNode node, int x, int y) {
        int upMidY = y - this.getLevelDistance() / 2;
        g.drawLine(x, y, x, upMidY);
    }

    @Override
    public void drawFollowing(Graphics g, IHorizontalTreeNode node, int x1, int x2, int xParentAss, int yParentAss, int yChildren) {
        int downMidY = yChildren - this.getLevelDistance() / 2;
        g.drawLine(xParentAss, yParentAss, xParentAss, downMidY);
        g.drawLine(x1, downMidY, x2, downMidY);
    }

    @Override
    public void drawNode(Graphics g, IHorizontalTreeNode node, int x, int y, int width, int height) {
        g.drawRect(x, y, width, height);
        if (node.getValue() != null) {
            g.drawString(node.getValue().toString(), x + 2, y + height - 2);
        }
    }

    @Override
    public void drawRelation(Graphics g, Object relation, int x, int y, int width, int height) {
        if (relation != null) {
            String temp = relation.toString();
            int strWidth = g.getFontMetrics().stringWidth(temp);
            int strHeight = g.getFontMetrics().getHeight();
            g.drawString(temp, x += (width - strWidth) / 2, y += (height - strHeight) / 2 + strHeight);
        }
    }

    @Override
    public void drawBeanpodBus(Graphics g, IHorizontalTreeNode node, int x, int y, int[] xBeans, int[] yBeans) {
        int lastBeanIdx = xBeans.length - 1;
        g.drawLine(x, y, x, yBeans[lastBeanIdx]);
        for (int i = 0; i <= lastBeanIdx; ++i) {
            g.drawLine(x, yBeans[i], xBeans[i], yBeans[i]);
        }
    }

    @Override
    public void addCtrl(Container parentCtrl, IHorizontalTreeNode node, int x, int y, int width, int height) {
    }
}

