/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.ui.joineditor;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonUIMessages;
import com.kingdee.cosmic.ctrl.common.layout.table.Cell;
import com.kingdee.cosmic.ctrl.common.ui.TypicalDialog;
import com.kingdee.cosmic.ctrl.common.ui.WindowUtil;
import com.kingdee.cosmic.ctrl.common.ui.joineditor.ModelLine;
import com.kingdee.cosmic.ctrl.swing.KDLabelContainer;
import com.kingdee.cosmic.ctrl.swing.KDScrollPane;
import com.kingdee.cosmic.ctrl.swing.KDSpinner;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;

public class PropertyDialog
extends TypicalDialog {
    private PropertyPanel pp;

    public PropertyDialog() {
    }

    public PropertyDialog(Frame owner) {
        super(owner);
    }

    public PropertyDialog(Dialog owner) {
        super(owner);
    }

    @Override
    protected void todoInit() {
        this.setTitle(CtrlCommonUIMessages.getMLS("linkAttributes", "\u94fe\u63a5\u5c5e\u6027"));
        this.setSize(396, 240);
        this.setResizable(false);
        this.pp = new PropertyPanel();
    }

    @Override
    protected void todoAddControls(Container parent, Cell thisCell) {
        parent.add((Component)this.pp, thisCell);
    }

    @Override
    protected void todoActionPerformed(ActionEvent e) {
    }

    @Override
    protected void todoKeyAction(int keyCode) {
    }

    public void changeLineProperty(ModelLine line) {
        this.pp.changeLineProperty(line);
    }

    public void initLineProperty(ModelLine line) {
        this.pp.initLineProperty(line);
    }

    private class PropertyPanel
    extends JPanel {
        private JTextArea txtFromTo;
        private JRadioButton radInner;
        private JRadioButton radLeft;
        private JRadioButton radRight;
        private JRadioButton radFull;
        private KDSpinner spiIndex;
        private JRadioButton radEqual;
        private JRadioButton radLessThan;
        private JRadioButton radLessThanEqual;
        private JRadioButton radMoreThan;
        private JRadioButton radMoreThanEqual;
        private JRadioButton radNotEqual;

        public PropertyPanel() {
            this.init();
            this.installComponent();
            this.installListener();
        }

        private void init() {
            this.txtFromTo = new JTextArea();
            this.txtFromTo.setEnabled(false);
            this.radInner = new JRadioButton(CtrlCommonUIMessages.getMLS("innerJoin", "\u5185\u90e8\u8054\u63a5"));
            this.radLeft = new JRadioButton(CtrlCommonUIMessages.getMLS("leftOuterJoin", "\u5de6\u5916\u90e8\u8054\u63a5"));
            this.radRight = new JRadioButton(CtrlCommonUIMessages.getMLS("rightOuterJoin", "\u53f3\u5916\u90e8\u8054\u63a5"));
            this.radFull = new JRadioButton(CtrlCommonUIMessages.getMLS("fullJoin", "\u5168\u8054\u63a5"));
            ButtonGroup bg1 = new ButtonGroup();
            bg1.add(this.radInner);
            bg1.add(this.radLeft);
            bg1.add(this.radRight);
            bg1.add(this.radFull);
            this.spiIndex = new KDSpinner();
            ((SpinnerNumberModel)this.spiIndex.getModel()).setMaximum(Integer.valueOf(99));
            ((SpinnerNumberModel)this.spiIndex.getModel()).setMinimum(Integer.valueOf(1));
            this.radEqual = new JRadioButton("=");
            this.radLessThan = new JRadioButton("<");
            this.radLessThanEqual = new JRadioButton("<=");
            this.radMoreThan = new JRadioButton(">");
            this.radMoreThanEqual = new JRadioButton(">=");
            this.radNotEqual = new JRadioButton("<>");
            ButtonGroup bg2 = new ButtonGroup();
            bg2.add(this.radEqual);
            bg2.add(this.radLessThan);
            bg2.add(this.radLessThanEqual);
            bg2.add(this.radMoreThan);
            bg2.add(this.radMoreThanEqual);
            bg2.add(this.radNotEqual);
        }

        private void installComponent() {
            JPanel panType = new JPanel(null);
            panType.setBorder(BorderFactory.createTitledBorder(CtrlCommonUIMessages.getMLS("linkType", "\u7c7b\u578b")));
            panType.add(this.radInner);
            panType.add(this.radLeft);
            panType.add(this.radRight);
            panType.add(this.radFull);
            this.radInner.setBounds(10, 20, 120, 18);
            this.radLeft.setBounds(10, 38, 120, 18);
            this.radRight.setBounds(10, 56, 120, 18);
            this.radFull.setBounds(10, 74, 120, 18);
            this.radInner.setOpaque(false);
            this.radLeft.setOpaque(false);
            this.radRight.setOpaque(false);
            this.radFull.setOpaque(false);
            JPanel panRelation = new JPanel(null);
            panRelation.setBorder(BorderFactory.createTitledBorder(CtrlCommonUIMessages.getMLS("relationship", "\u5173\u7cfb")));
            panRelation.add(this.radEqual);
            panRelation.add(this.radLessThan);
            panRelation.add(this.radLessThanEqual);
            panRelation.add(this.radMoreThan);
            panRelation.add(this.radMoreThanEqual);
            panRelation.add(this.radNotEqual);
            this.radEqual.setBounds(10, 20, 60, 20);
            this.radNotEqual.setBounds(10, 40, 60, 20);
            this.radLessThan.setBounds(80, 20, 60, 20);
            this.radLessThanEqual.setBounds(80, 40, 60, 20);
            this.radMoreThan.setBounds(150, 20, 60, 20);
            this.radMoreThanEqual.setBounds(150, 40, 60, 20);
            this.radEqual.setOpaque(false);
            this.radNotEqual.setOpaque(false);
            this.radLessThan.setOpaque(false);
            this.radLessThanEqual.setOpaque(false);
            this.radMoreThan.setOpaque(false);
            this.radMoreThanEqual.setOpaque(false);
            KDLabelContainer lbcIndex = new KDLabelContainer((JComponent)this.spiIndex);
            lbcIndex.setBoundLabelText(CtrlCommonUIMessages.getMLS("sequenceNumber", "\u5e8f\u53f7"));
            lbcIndex.setBoundLabelLength(80);
            lbcIndex.setBoundLabelUnderline(true);
            KDScrollPane scpFromTo = new KDScrollPane((Component)this.txtFromTo);
            scpFromTo.setHorizontalScrollBarPolicy(32);
            this.setLayout(null);
            this.add((Component)scpFromTo);
            this.add(panType);
            this.add(panRelation);
            this.add((Component)lbcIndex);
            scpFromTo.setBounds(0, 0, 370, 45);
            panType.setBounds(0, 50, 140, 100);
            panRelation.setBounds(150, 50, 220, 70);
            lbcIndex.setBounds(152, 128, 216, 20);
        }

        private void installListener() {
            ((JSpinner.DefaultEditor)this.spiIndex.getEditor()).getTextField().addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    int value = -1;
                    try {
                        value = Integer.parseInt(((JTextField)e.getSource()).getText());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    int oldValue = (Integer)PropertyPanel.this.spiIndex.getValue();
                    if (value == oldValue) {
                        return;
                    }
                    if (value < 1 || value > 99) {
                        WindowUtil.msgboxWarning(CtrlCommonUIMessages.getMLS("sequenceNumberMustBeBetween1And99", "\u5e8f\u53f7\u5fc5\u987b\u57281~99\u4e4b\u95f4\u3002"), CtrlCommonUIMessages.getMLS("linkAttributes", "\u94fe\u63a5\u5c5e\u6027"), (Component)((Object)PropertyDialog.this));
                        PropertyPanel.this.spiIndex.requestFocus();
                    }
                }
            });
        }

        private int getTypeResult() {
            if (this.radInner.isSelected()) {
                return 1;
            }
            if (this.radLeft.isSelected()) {
                return 2;
            }
            if (this.radRight.isSelected()) {
                return 3;
            }
            return 4;
        }

        private void setTypeValue(int value) {
            switch (value) {
                case 1: {
                    this.radInner.setSelected(true);
                    break;
                }
                case 2: {
                    this.radLeft.setSelected(true);
                    break;
                }
                case 3: {
                    this.radRight.setSelected(true);
                    break;
                }
                default: {
                    this.radFull.setSelected(true);
                }
            }
        }

        private int getRelationResult() {
            if (this.radEqual.isSelected()) {
                return 16;
            }
            if (this.radNotEqual.isSelected()) {
                return 32;
            }
            if (this.radLessThan.isSelected()) {
                return 48;
            }
            if (this.radLessThanEqual.isSelected()) {
                return 64;
            }
            if (this.radMoreThan.isSelected()) {
                return 80;
            }
            return 96;
        }

        private void setRelationValue(int value) {
            switch (value) {
                case 16: {
                    this.radEqual.setSelected(true);
                    break;
                }
                case 32: {
                    this.radNotEqual.setSelected(true);
                    break;
                }
                case 48: {
                    this.radLessThan.setSelected(true);
                    break;
                }
                case 64: {
                    this.radLessThanEqual.setSelected(true);
                    break;
                }
                case 80: {
                    this.radMoreThan.setSelected(true);
                    break;
                }
                case 96: {
                    this.radMoreThanEqual.setSelected(true);
                    break;
                }
            }
        }

        public void changeLineProperty(ModelLine line) {
            line.setIndex((Integer)this.spiIndex.getValue());
            line.setType(this.getTypeResult());
            line.setRelation(this.getRelationResult());
        }

        public void initLineProperty(ModelLine line) {
            this.spiIndex.setValue((Object)line.getIndex());
            this.setTypeValue(line.getType());
            this.setRelationValue(line.getRelation());
            this.txtFromTo.setText(line.toString());
        }
    }
}

