/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.ui.tree;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonUIMessages;
import com.kingdee.cosmic.ctrl.common.ui.WindowUtil;
import com.kingdee.cosmic.ctrl.common.ui.tree.ATreeController;
import com.kingdee.cosmic.ctrl.common.ui.tree.ITreeAction;
import com.kingdee.cosmic.ctrl.common.ui.tree.TreeUI;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.swing.KDTree;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public abstract class ATreeAction
extends AbstractAction
implements ITreeAction {
    private static Logger log = LogUtil.getPackageLogger(ATreeAction.class);
    private ATreeController treeCtrl;
    private Object[] visibleCategories;

    public ATreeAction(Object nameVal, ATreeController treeCtrl) {
        this.treeCtrl = treeCtrl;
        this.putValue("Name", nameVal);
    }

    public String getTitle() {
        return this.getValue("Name").toString();
    }

    public ATreeController getTreeCtrl() {
        return this.treeCtrl;
    }

    public TreeUI getTreeUI() {
        return this.treeCtrl.getTreeUI();
    }

    public Object[] getVisibleCategories() {
        return this.visibleCategories;
    }

    public void setVisibleCategories(Object[] visibleCategories) {
        this.visibleCategories = visibleCategories;
    }

    public boolean isVisibleCategory(Object obj) {
        if (this.visibleCategories == null) {
            return true;
        }
        for (int i = 0; i < this.visibleCategories.length; ++i) {
            if (this.visibleCategories[i] != obj) continue;
            return true;
        }
        return false;
    }

    public void showException(String msg, Throwable ex) {
        WindowUtil.showException(msg, ex, this.getTitle(), (Component)((Object)this.getTreeUI()));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block3: {
            if (log.isDebugEnabled()) {
                log.debug((Object)this.makeActionInfo());
            }
            try {
                this.doAction(e);
            }
            catch (Exception ex) {
                if (this.treeCtrl != null && this.treeCtrl.handleException(ex)) break block3;
                this.showException(ex);
            }
        }
    }

    protected void showException(Exception ex) {
        String msg = this.getTitle() + CtrlCommonUIMessages.getMLS("operationFailed", "\u64cd\u4f5c\u5931\u8d25\uff0c\u8fde\u63a5\u65ad\u5f00\u6216\u8005\u6a21\u677f\u5df2\u635f\u574f\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u4ee5\u83b7\u53d6\u8be6\u7ec6\u4fe1\u606f\uff01");
        log.error((Object)msg, (Throwable)ex);
        this.showException(msg, ex);
    }

    protected String makeActionInfo() {
        KDTree tree;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTitle());
        TreeUI tui = this.treeCtrl.getTreeUI();
        if (tui != null && (tree = tui.getTree()) != null) {
            TreePath[] paths = tree.getSelectionPaths();
            for (int i = 0; i < paths.length; ++i) {
                sb.append(this.getTreeCtrl().makePathText(paths[i]));
                sb.append("; ");
            }
        }
        return sb.toString();
    }

    @Override
    public abstract boolean isVisible(TreePath[] var1);

    public abstract void doAction(ActionEvent var1) throws Exception;
}

