/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.ui.tree;

import com.kingdee.cosmic.ctrl.common.ui.tree.ATreeController;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.util.ArrayList;
import java.util.List;

public class TreeUINode
extends DefaultKingdeeTreeNode {
    private static final long serialVersionUID = -6932967529019442608L;
    private String name;
    private String alias;
    private Object category;
    private boolean childrenLoaded = false;
    private ATreeController hook;
    private List leafNodes;
    private String extText;

    public TreeUINode(String name) {
        this.setName(name);
    }

    public final List getLeafNodes() {
        if (this.leafNodes == null) {
            int z = this.getChildCount();
            this.leafNodes = new ArrayList(z);
            for (int i = 0; i < z; ++i) {
                TreeUINode tn = (TreeUINode)((Object)this.getChildAt(i));
                if (tn.getAllowsChildren()) continue;
                this.leafNodes.add(tn);
            }
        }
        return this.leafNodes;
    }

    public ATreeController getHook() {
        return this.hook;
    }

    public void setHook(ATreeController hook) {
        this.hook = hook;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.syncText();
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
        this.syncText();
    }

    public Object getCategory() {
        return this.category;
    }

    public void setCategory(Object type) {
        this.category = type;
    }

    protected void syncText() {
        this.setText(TreeUINode.makeText(this.name, this.alias, this.extText));
    }

    public static String makeText(String name, String alias) {
        return TreeUINode.makeText(name, alias, null);
    }

    public static String makeText(String name, String alias, String extText) {
        boolean haveAlias;
        StringBuilder sb = new StringBuilder();
        boolean bl = haveAlias = !StringUtil.isEmptyString((String)alias);
        if ("/".equals(name)) {
            if (haveAlias) {
                sb.append(alias);
            } else {
                sb.append(name);
            }
        } else {
            if (haveAlias) {
                sb.append(alias);
                sb.append(" (");
            }
            sb.append(name);
            if (haveAlias) {
                sb.append(')');
            }
        }
        if (extText != null && extText.length() != 0) {
            sb.append("  [").append(extText).append(']');
        }
        return sb.toString();
    }

    public boolean isChildrenLoaded() {
        return this.childrenLoaded;
    }

    public void setChildrenLoaded(boolean childLoaded) {
        this.childrenLoaded = childLoaded;
    }

    public TreeUINode getChildNode(String name) {
        int z = this.getChildCount();
        for (int i = 0; i < z; ++i) {
            TreeUINode tcnChild = (TreeUINode)((Object)this.getChildAt(i));
            if (!name.equals(tcnChild.getName())) continue;
            return tcnChild;
        }
        return null;
    }

    public final String getExtText() {
        return this.extText;
    }

    public final void setExtText(String extText) {
        this.extText = extText;
        this.syncText();
    }
}

