/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.ui.tree;

import com.kingdee.cosmic.ctrl.common.ui.tree.TreeUINode;
import com.kingdee.cosmic.ctrl.common.util.PathUtil;
import com.kingdee.cosmic.ctrl.swing.KDTree;
import com.kingdee.cosmic.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.cosmic.ctrl.swing.tree.KingdeeTreeModel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeUtil {
    public static final String makePathText(TreeUINode tn) {
        return TreeUtil.makePathText(tn.getPath());
    }

    public static final String makePathText(TreeNode[] tns) {
        if (tns == null) {
            return null;
        }
        if (tns.length == 1) {
            return "/";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < tns.length; ++i) {
            TreeUINode stn = (TreeUINode)((Object)tns[i]);
            sb.append("/").append(stn.getName());
        }
        return sb.toString();
    }

    public static final String makePathText(TreePath tp) {
        if (tp == null) {
            return null;
        }
        int len = tp.getPathCount();
        if (len == 1) {
            return "/";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < len; ++i) {
            TreeUINode stn = (TreeUINode)((Object)tp.getPathComponent(i));
            sb.append("/").append(stn.getName());
        }
        return sb.toString();
    }

    public static final TreeUINode findTreeNode(TreeUINode tnParent, String pathText) {
        String[] names = PathUtil.splitPath((String)pathText);
        int z = names.length;
        for (int i = 1; i < z; ++i) {
            if ((tnParent = tnParent.getChildNode(names[i])) != null) continue;
            return null;
        }
        return tnParent;
    }

    public static final TreePath makeTreePath(TreeUINode tnParent, String pathText) {
        String[] names = PathUtil.splitPath((String)pathText);
        int z = names.length;
        TreeUINode[] tcns = new TreeUINode[z == 0 ? 1 : z];
        tcns[0] = tnParent;
        for (int i = 1; i < z; ++i) {
            tcns[i] = tcns[i - 1].getChildNode(names[i]);
            if (tcns[i] != null) continue;
            return null;
        }
        return new TreePath((Object[])tcns);
    }

    public static final TreeUINode findAncestor(TreeUINode tn, Object category) {
        while (tn != null && !category.equals(tn.getCategory())) {
            tn = (TreeUINode)((Object)tn.getParent());
        }
        return tn;
    }

    public static final void applyTextPattern(KingdeeTreeModel model, TreeUINode node, String pattern) {
        List leafNodes = node.getLeafNodes();
        int i = 0;
        int z = node.getChildCount();
        while (i < z) {
            TreeUINode tnChild = (TreeUINode)((Object)node.getChildAt(i));
            if (tnChild.getAllowsChildren()) {
                if (tnChild.isChildrenLoaded()) {
                    TreeUtil.applyTextPattern(model, tnChild, pattern);
                }
                ++i;
                continue;
            }
            model.removeNodeFromParent((MutableTreeNode)((Object)tnChild));
            --z;
        }
        for (TreeUINode tnChild : leafNodes) {
            String text = tnChild.getText();
            if (pattern != null && -1 == text.indexOf(pattern)) continue;
            model.insertNodeInto((MutableTreeNode)((Object)tnChild), (MutableTreeNode)((Object)node), 0);
        }
    }

    public static final DefaultKingdeeTreeNode[] getCheckedNodes(KDTree tree) {
        ArrayList<DefaultKingdeeTreeNode> list = new ArrayList<DefaultKingdeeTreeNode>();
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)tree.getModel().getRoot();
        Enumeration e = root.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)e.nextElement();
            if (!node.isCheckBoxVisible() || !node.isChecked()) continue;
            list.add(node);
        }
        DefaultKingdeeTreeNode[] nodes = new DefaultKingdeeTreeNode[list.size()];
        return list.toArray(nodes);
    }
}

