/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.util.render;

import com.kingdee.cosmic.ctrl.kdf.util.render.AbstractBasicRender;
import com.kingdee.cosmic.ctrl.kdf.util.render.BorderRenderMath;
import com.kingdee.cosmic.ctrl.kdf.util.render.IBorderHolder;
import com.kingdee.cosmic.ctrl.kdf.util.style.LineStyle;
import com.kingdee.cosmic.ctrl.kdf.util.style.PenStyle;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class BorderRender
extends AbstractBasicRender {
    public static final int DRAW_LEFT = 1;
    public static final int DRAW_TOP = 2;
    public static final int DRAW_RIGHT = 4;
    public static final int DRAW_BOTTOM = 8;
    public static final int DRAW_DIAGONALLEFT = 16;
    public static final int DRAW_DIAGONALRIGHT = 32;
    public static final int DRAW_FOURSIDES = 15;
    public static final int DRAW_ONE_CELL = 51;
    private IBorderHolder _holder;
    private boolean _calcFactor = true;
    private boolean _autoSetMode = true;
    private boolean _speedMode;
    private Style _aroundStyles0;
    private Style _aroundStyles1;
    private Style _aroundStyles2;
    private Style _aroundStyles3;
    private Style _aroundStyles4;
    private Style _aroundStyles5;
    private Style _aroundStyles6;
    private Style _aroundStyles7;
    private Style _style;
    private LineStyle _lineStyle;
    private PenStyle _penStyle;
    private Color _color;
    private boolean isUseInt = false;

    public BorderRender() {
        this(false);
    }

    public BorderRender(boolean isUseInt) {
        this.isUseInt = isUseInt;
    }

    public BorderRender(IBorderHolder holder) {
        this(holder, false);
    }

    public BorderRender(IBorderHolder holder, boolean isUseInt) {
        this._holder = holder;
        this.isUseInt = isUseInt;
    }

    public void setCalcFactor(boolean b) {
        this._calcFactor = b;
    }

    public void setAutoSetMode(boolean b) {
        this._autoSetMode = b;
    }

    public boolean isAutoSetMode() {
        return this._autoSetMode;
    }

    public void setSpeedMode(boolean b) {
        this._speedMode = b;
    }

    public void setHolder(IBorderHolder holder) {
        this._holder = holder;
    }

    private boolean initDrawStyle(Styles.Position pos) {
        boolean canDraw = false;
        this._lineStyle = this._style.getBorderLineStyle(pos);
        if (!this._lineStyle.isNullBorder()) {
            this._penStyle = this._style.getBorderPenStyle(pos);
            this._color = this._style.getBorderColor(pos);
            if (this.isBlackWhite() && !Color.WHITE.equals(this._color)) {
                this._color = Color.BLACK;
            }
            canDraw = true;
        }
        return canDraw;
    }

    private int getLeftFactor() {
        LineStyle tempLs = null;
        tempLs = this._style.getBorderLineStyle(Styles.Position.DIAGONALLEFT);
        int d1 = tempLs.getBits();
        tempLs = this._style.getBorderLineStyle(Styles.Position.TOP);
        int h1 = tempLs.getBits();
        int d2 = 0;
        tempLs = null;
        if (this._aroundStyles0 != null) {
            tempLs = this._aroundStyles0.getBorderLineStyle(Styles.Position.DIAGONALRIGHT);
            d2 = tempLs.getBits();
        }
        tempLs = null;
        if (this._aroundStyles0 != null) {
            tempLs = this._aroundStyles0.getBorderLineStyle(Styles.Position.TOP);
        }
        if ((tempLs == null || tempLs.isNullBorder()) && this._aroundStyles1 != null) {
            tempLs = this._aroundStyles1.getBorderLineStyle(Styles.Position.BOTTOM);
        }
        int h2 = 0;
        if (tempLs != null) {
            h2 = tempLs.getBits();
        }
        tempLs = this._style.getBorderLineStyle(Styles.Position.DIAGONALRIGHT);
        int d3 = tempLs.getBits();
        tempLs = this._style.getBorderLineStyle(Styles.Position.BOTTOM);
        int h3 = tempLs.getBits();
        int d4 = 0;
        tempLs = null;
        if (this._aroundStyles0 != null) {
            tempLs = this._aroundStyles0.getBorderLineStyle(Styles.Position.DIAGONALLEFT);
            d4 = tempLs.getBits();
        }
        tempLs = null;
        if (this._aroundStyles7 != null) {
            tempLs = this._aroundStyles7.getBorderLineStyle(Styles.Position.TOP);
        }
        if ((tempLs == null || tempLs.isNullBorder()) && this._aroundStyles0 != null) {
            tempLs = this._aroundStyles0.getBorderLineStyle(Styles.Position.BOTTOM);
        }
        int h4 = 0;
        if (tempLs != null) {
            h4 = tempLs.getBits();
        }
        int f1 = BorderRenderMath.calPartFactor(BorderRenderMath.getWeightB(d1), BorderRenderMath.getWeightB(h1), BorderRenderMath.getWeightA(h2));
        int f2 = BorderRenderMath.calPartFactor(BorderRenderMath.getWeightB(d2), BorderRenderMath.getWeightB(h2), BorderRenderMath.getWeightA(h1));
        int f3 = BorderRenderMath.calPartFactor(BorderRenderMath.getWeightA(d3), BorderRenderMath.getWeightA(h3), BorderRenderMath.getWeightB(h4));
        int f4 = BorderRenderMath.calPartFactor(BorderRenderMath.getWeightA(d4), BorderRenderMath.getWeightA(h4), BorderRenderMath.getWeightB(h3));
        return BorderRenderMath.calFactor(f1, f2, f3, f4);
    }

    private int getTopFactor() {
        LineStyle tempLs = null;
        int d1 = 0;
        if (this._aroundStyles2 != null) {
            tempLs = this._aroundStyles2.getBorderLineStyle(Styles.Position.DIAGONALRIGHT);
            d1 = tempLs.getBits();
        }
        tempLs = null;
        if (this._aroundStyles2 != null) {
            tempLs = this._aroundStyles2.getBorderLineStyle(Styles.Position.LEFT);
        }
        if ((tempLs == null || tempLs.isNullBorder()) && this._aroundStyles1 != null) {
            tempLs = this._aroundStyles1.getBorderLineStyle(Styles.Position.RIGHT);
        }
        int h1 = 0;
        if (tempLs != null) {
            h1 = tempLs.getBits();
        }
        tempLs = this._style.getBorderLineStyle(Styles.Position.DIAGONALLEFT);
        int d2 = tempLs.getBits();
        tempLs = this._style.getBorderLineStyle(Styles.Position.LEFT);
        int h2 = tempLs.getBits();
        int d3 = 0;
        tempLs = null;
        if (this._aroundStyles2 != null) {
            tempLs = this._aroundStyles2.getBorderLineStyle(Styles.Position.DIAGONALLEFT);
            d3 = tempLs.getBits();
        }
        tempLs = null;
        if (this._aroundStyles3 != null) {
            tempLs = this._aroundStyles3.getBorderLineStyle(Styles.Position.LEFT);
        }
        if ((tempLs == null || tempLs.isNullBorder()) && this._aroundStyles2 != null) {
            tempLs = this._aroundStyles2.getBorderLineStyle(Styles.Position.RIGHT);
        }
        int h3 = 0;
        if (tempLs != null) {
            h3 = tempLs.getBits();
        }
        tempLs = this._style.getBorderLineStyle(Styles.Position.DIAGONALRIGHT);
        int d4 = tempLs.getBits();
        tempLs = this._style.getBorderLineStyle(Styles.Position.RIGHT);
        int h4 = tempLs.getBits();
        int f1 = BorderRenderMath.calPartFactor(BorderRenderMath.getWeightB(d1), BorderRenderMath.getWeightA(h1), BorderRenderMath.getWeightB(h2));
        int f2 = BorderRenderMath.calPartFactor(BorderRenderMath.getWeightA(d2), BorderRenderMath.getWeightA(h2), BorderRenderMath.getWeightB(h1));
        int f3 = BorderRenderMath.calPartFactor(BorderRenderMath.getWeightB(d3), BorderRenderMath.getWeightB(h3), BorderRenderMath.getWeightA(h4));
        int f4 = BorderRenderMath.calPartFactor(BorderRenderMath.getWeightA(d4), BorderRenderMath.getWeightB(h4), BorderRenderMath.getWeightA(h3));
        return BorderRenderMath.calFactor(f1, f2, f3, f4);
    }

    private int getRightFactor() {
        LineStyle tempLs = null;
        int d1 = 0;
        if (this._aroundStyles4 != null) {
            tempLs = this._aroundStyles4.getBorderLineStyle(Styles.Position.DIAGONALLEFT);
            d1 = tempLs.getBits();
        }
        tempLs = null;
        if (this._aroundStyles4 != null) {
            tempLs = this._aroundStyles4.getBorderLineStyle(Styles.Position.TOP);
        }
        if ((tempLs == null || tempLs.isNullBorder()) && this._aroundStyles3 != null) {
            tempLs = this._aroundStyles3.getBorderLineStyle(Styles.Position.BOTTOM);
        }
        int h1 = 0;
        if (tempLs != null) {
            h1 = tempLs.getBits();
        }
        tempLs = this._style.getBorderLineStyle(Styles.Position.DIAGONALRIGHT);
        int d2 = tempLs.getBits();
        tempLs = this._style.getBorderLineStyle(Styles.Position.TOP);
        int h2 = tempLs.getBits();
        int d3 = 0;
        if (this._aroundStyles4 != null) {
            tempLs = this._aroundStyles4.getBorderLineStyle(Styles.Position.DIAGONALRIGHT);
            d3 = tempLs.getBits();
        }
        tempLs = null;
        if (this._aroundStyles5 != null) {
            tempLs = this._aroundStyles5.getBorderLineStyle(Styles.Position.TOP);
        }
        if ((tempLs == null || tempLs.isNullBorder()) && this._aroundStyles4 != null) {
            tempLs = this._aroundStyles4.getBorderLineStyle(Styles.Position.BOTTOM);
        }
        int h3 = 0;
        if (tempLs != null) {
            h3 = tempLs.getBits();
        }
        tempLs = this._style.getBorderLineStyle(Styles.Position.DIAGONALLEFT);
        int d4 = tempLs.getBits();
        tempLs = null;
        if (this._aroundStyles6 != null) {
            tempLs = this._aroundStyles6.getBorderLineStyle(Styles.Position.TOP);
        }
        if (tempLs == null || tempLs.isNullBorder()) {
            tempLs = this._style.getBorderLineStyle(Styles.Position.BOTTOM);
        }
        int h4 = 0;
        if (tempLs != null) {
            h4 = tempLs.getBits();
        }
        int f1 = BorderRenderMath.calPartFactor(BorderRenderMath.getWeightB(d1), BorderRenderMath.getWeightB(h1), BorderRenderMath.getWeightA(h2));
        int f2 = BorderRenderMath.calPartFactor(BorderRenderMath.getWeightB(d2), BorderRenderMath.getWeightB(h2), BorderRenderMath.getWeightA(h1));
        int f3 = BorderRenderMath.calPartFactor(BorderRenderMath.getWeightA(d3), BorderRenderMath.getWeightA(h3), BorderRenderMath.getWeightB(h4));
        int f4 = BorderRenderMath.calPartFactor(BorderRenderMath.getWeightA(d4), BorderRenderMath.getWeightA(h4), BorderRenderMath.getWeightB(h3));
        return BorderRenderMath.calFactor(f1, f2, f3, f4);
    }

    private int getBottomFactor() {
        LineStyle tempLs = null;
        tempLs = this._style.getBorderLineStyle(Styles.Position.DIAGONALRIGHT);
        int d1 = tempLs.getBits();
        tempLs = this._style.getBorderLineStyle(Styles.Position.LEFT);
        int h1 = tempLs.getBits();
        int d2 = 0;
        if (this._aroundStyles6 != null) {
            tempLs = this._aroundStyles6.getBorderLineStyle(Styles.Position.DIAGONALLEFT);
            d2 = tempLs.getBits();
        }
        tempLs = null;
        if (this._aroundStyles6 != null) {
            tempLs = this._aroundStyles6.getBorderLineStyle(Styles.Position.LEFT);
        }
        if ((tempLs == null || tempLs.isNullBorder()) && this._aroundStyles7 != null) {
            tempLs = this._aroundStyles7.getBorderLineStyle(Styles.Position.RIGHT);
        }
        int h2 = 0;
        if (tempLs != null) {
            h2 = tempLs.getBits();
        }
        tempLs = this._style.getBorderLineStyle(Styles.Position.DIAGONALLEFT);
        int d3 = tempLs.getBits();
        tempLs = null;
        if (this._aroundStyles4 != null) {
            tempLs = this._aroundStyles4.getBorderLineStyle(Styles.Position.LEFT);
        }
        if (tempLs == null || tempLs.isNullBorder()) {
            tempLs = this._style.getBorderLineStyle(Styles.Position.RIGHT);
        }
        int h3 = tempLs.getBits();
        int d4 = 0;
        if (this._aroundStyles6 != null) {
            tempLs = this._aroundStyles6.getBorderLineStyle(Styles.Position.DIAGONALRIGHT);
            d4 = tempLs.getBits();
        }
        tempLs = null;
        if (this._aroundStyles5 != null) {
            tempLs = this._aroundStyles5.getBorderLineStyle(Styles.Position.LEFT);
        }
        if ((tempLs == null || tempLs.isNullBorder()) && this._aroundStyles6 != null) {
            tempLs = this._aroundStyles6.getBorderLineStyle(Styles.Position.RIGHT);
        }
        int h4 = 0;
        if (tempLs != null) {
            h4 = tempLs.getBits();
        }
        int f1 = BorderRenderMath.calPartFactor(BorderRenderMath.getWeightB(d1), BorderRenderMath.getWeightA(h1), BorderRenderMath.getWeightB(h2));
        int f2 = BorderRenderMath.calPartFactor(BorderRenderMath.getWeightA(d2), BorderRenderMath.getWeightA(h2), BorderRenderMath.getWeightB(h1));
        int f3 = BorderRenderMath.calPartFactor(BorderRenderMath.getWeightB(d3), BorderRenderMath.getWeightB(h3), BorderRenderMath.getWeightA(h4));
        int f4 = BorderRenderMath.calPartFactor(BorderRenderMath.getWeightA(d4), BorderRenderMath.getWeightB(h4), BorderRenderMath.getWeightA(h3));
        return BorderRenderMath.calFactor(f1, f2, f3, f4);
    }

    private int getDiagonalLeftFactor() {
        LineStyle tempLs = null;
        tempLs = this._style.getBorderLineStyle(Styles.Position.TOP);
        if (tempLs.isNullBorder() && this._aroundStyles2 != null) {
            tempLs = this._aroundStyles2.getBorderLineStyle(Styles.Position.BOTTOM);
        }
        int h1 = tempLs.getBits();
        tempLs = this._style.getBorderLineStyle(Styles.Position.LEFT);
        if (tempLs.isNullBorder() && this._aroundStyles0 != null) {
            tempLs = this._aroundStyles0.getBorderLineStyle(Styles.Position.RIGHT);
        }
        int h2 = tempLs.getBits();
        tempLs = null;
        if (this._aroundStyles4 != null) {
            tempLs = this._aroundStyles4.getBorderLineStyle(Styles.Position.LEFT);
        }
        if (tempLs == null || tempLs.isNullBorder()) {
            tempLs = this._style.getBorderLineStyle(Styles.Position.RIGHT);
        }
        int h3 = tempLs.getBits();
        if (this._aroundStyles6 != null) {
            tempLs = this._aroundStyles6.getBorderLineStyle(Styles.Position.TOP);
        }
        if (tempLs == null || tempLs.isNullBorder()) {
            tempLs = this._style.getBorderLineStyle(Styles.Position.BOTTOM);
        }
        int h4 = tempLs.getBits();
        return BorderRenderMath.calFactor(BorderRenderMath.getWeightB(h1), BorderRenderMath.getWeightA(h2), BorderRenderMath.getWeightA(h3), BorderRenderMath.getWeightB(h4));
    }

    private int getDiagonalRightFactor() {
        LineStyle tempLs = this._style.getBorderLineStyle(Styles.Position.LEFT);
        if (tempLs.isNullBorder() && this._aroundStyles0 != null) {
            tempLs = this._aroundStyles0.getBorderLineStyle(Styles.Position.RIGHT);
        }
        int h1 = tempLs.getBits();
        if (this._aroundStyles6 != null) {
            tempLs = this._aroundStyles6.getBorderLineStyle(Styles.Position.TOP);
        }
        if (tempLs == null || tempLs.isNullBorder()) {
            tempLs = this._style.getBorderLineStyle(Styles.Position.BOTTOM);
        }
        int h2 = tempLs.getBits();
        tempLs = this._style.getBorderLineStyle(Styles.Position.TOP);
        if (tempLs.isNullBorder() && this._aroundStyles2 != null) {
            tempLs = this._aroundStyles2.getBorderLineStyle(Styles.Position.BOTTOM);
        }
        int h3 = tempLs.getBits();
        if (this._aroundStyles4 != null) {
            tempLs = this._aroundStyles4.getBorderLineStyle(Styles.Position.LEFT);
        }
        if (tempLs == null || tempLs.isNullBorder()) {
            tempLs = this._style.getBorderLineStyle(Styles.Position.RIGHT);
        }
        int h4 = tempLs.getBits();
        return BorderRenderMath.calFactor(BorderRenderMath.getWeightA(h1), BorderRenderMath.getWeightA(h2), BorderRenderMath.getWeightB(h3), BorderRenderMath.getWeightB(h4));
    }

    private void initAroundStyles(int row, int col, int drawMode) {
        this._aroundStyles0 = this._holder.getVirtualCellStyle(row, col, Styles.Dir.WEST);
        this._aroundStyles1 = this._holder.getVirtualCellStyle(row, col, Styles.Dir.WESTNORTH);
        this._aroundStyles2 = this._holder.getVirtualCellStyle(row, col, Styles.Dir.NORTH);
        this._aroundStyles3 = this._holder.getVirtualCellStyle(row, col, Styles.Dir.EASTNORTH);
        this._aroundStyles4 = this._holder.getVirtualCellStyle(row, col, Styles.Dir.EAST);
        this._aroundStyles5 = this._holder.getVirtualCellStyle(row, col, Styles.Dir.EASTSOUTH);
        this._aroundStyles6 = this._holder.getVirtualCellStyle(row, col, Styles.Dir.SOUTH);
        this._aroundStyles7 = this._holder.getVirtualCellStyle(row, col, Styles.Dir.WESTSOUTH);
    }

    private void paintLeftBorder(Graphics2D g2d, Rectangle2D rect, int factor) {
        if (this._speedMode) {
            int x1 = (int)rect.getX();
            int y1 = (int)rect.getY();
            int x2 = x1;
            int y2 = (int)rect.getHeight() + y1 - 1;
            this.paintVerticalSpeed(g2d, x1, y1, x2, y2, factor);
        } else {
            double x1 = rect.getX();
            double y1 = rect.getY();
            double x2 = x1;
            double y2 = rect.getY() + rect.getHeight() - 1.0;
            this.paintVertical(g2d, x1, y1, x2, y2, factor);
        }
    }

    private void paintRightBorder(Graphics2D g2d, Rectangle2D rect, int factor) {
        if (this._speedMode) {
            int x1 = (int)(rect.getX() + rect.getWidth() - 1.0);
            int y1 = (int)rect.getY();
            int x2 = x1;
            int y2 = y1 + (int)rect.getHeight() - 1;
            this.paintVerticalSpeed(g2d, x1, y1, x2, y2, factor);
        } else {
            double x1 = rect.getX() + rect.getWidth() - 1.0;
            double y1 = rect.getY();
            double x2 = x1;
            double y2 = rect.getY() + rect.getHeight() - 1.0;
            this.paintVertical(g2d, x1, y1, x2, y2, factor);
        }
    }

    private void paintVertical(Graphics2D g2d, double x1, double y1, double x2, double y2, int factor) {
        Line2D.Double line = new Line2D.Double();
        Stroke stroke = this._penStyle.getBaseStroke();
        g2d.setColor(this._color);
        g2d.setStroke(stroke);
        int i1 = 0;
        int i2 = 0;
        int i3 = 0;
        int i4 = 0;
        if (PenStyle.PS_SOLID == this._penStyle) {
            i1 = BorderRenderMath.getFactor1(factor);
            i2 = BorderRenderMath.getFactor2(factor);
            i3 = BorderRenderMath.getFactor3(factor);
            i4 = BorderRenderMath.getFactor4(factor);
        }
        if (this._lineStyle.isNullBorder()) {
            return;
        }
        if (this._lineStyle.isBaseBorder()) {
            int dy1 = Math.max(i1, i2);
            int dy2 = Math.max(i3, i4);
            line.x1 = x1;
            line.y1 = y1 + (double)dy1;
            if (dy1 != 0) {
                line.y1 += 1.0;
            }
            line.x2 = x2;
            line.y2 = y2 - (double)dy2;
            if (dy2 != 0) {
                line.y2 -= 1.0;
            }
            if (this.isUseInt) {
                line.x1 = (int)line.x1;
                line.x2 = (int)line.x2;
                line.y1 = (int)line.y1;
                line.y2 = (int)line.y2;
            }
            g2d.draw(line);
        } else {
            int i;
            boolean b1 = BorderRenderMath.isRise1(factor);
            boolean b2 = BorderRenderMath.isRise2(factor);
            boolean b3 = BorderRenderMath.isRise3(factor);
            boolean b4 = BorderRenderMath.isRise4(factor);
            for (i = this._lineStyle.getWeightA() - 1; i >= 0; --i) {
                if (this._lineStyle.getBit(true, i)) {
                    line.x1 = x1 + (double)i + 1.0;
                    line.y1 = b1 ? y1 - (double)i1 : y1 + (double)i1;
                    line.x2 = x2 + (double)i + 1.0;
                    line.y2 = b3 ? y2 + (double)i3 : y2 - (double)i3;
                    g2d.draw(line);
                }
                i1 = i1 > 1 ? i1 - 1 : i1;
                i3 = i3 > 1 ? i3 - 1 : i3;
            }
            for (i = this._lineStyle.getWeightB() - 1; i >= 0; --i) {
                if (this._lineStyle.getBit(false, i)) {
                    line.x1 = x1 - (double)i - 1.0;
                    line.y1 = b2 ? y1 - (double)i2 : y1 + (double)i2;
                    line.x2 = x2 - (double)i - 1.0;
                    line.y2 = b4 ? y2 + (double)i4 : y2 - (double)i4;
                    g2d.draw(line);
                }
                i2 = i2 > 1 ? i2 - 1 : i2;
                i4 = i4 > 1 ? i4 - 1 : i4;
            }
            if (this._lineStyle.isFillCenterLine()) {
                line.x1 = x1;
                line.y1 = y1;
                line.x2 = x2;
                line.y2 = y2;
                g2d.draw(line);
            }
        }
    }

    private void paintVerticalSpeed(Graphics2D g2d, int x1, int y1, int x2, int y2, int factor) {
        g2d.setColor(this._color);
        g2d.setStroke(this._penStyle.getBaseStroke());
        int i1 = 0;
        int i2 = 0;
        int i3 = 0;
        int i4 = 0;
        if (PenStyle.PS_SOLID == this._penStyle) {
            i1 = BorderRenderMath.getFactor1(factor);
            i2 = BorderRenderMath.getFactor2(factor);
            i3 = BorderRenderMath.getFactor3(factor);
            i4 = BorderRenderMath.getFactor4(factor);
        }
        if (this._lineStyle.isNullBorder()) {
            return;
        }
        if (this._lineStyle.isBaseBorder()) {
            int dy1 = Math.max(i1, i2);
            int dy2 = Math.max(i3, i4);
            int tx1 = x1;
            int ty1 = y1 + dy1;
            if (dy1 != 0) {
                ++ty1;
            }
            int ty2 = y2 - dy2;
            if (dy2 != 0) {
                --ty2;
            }
            g2d.drawLine(tx1, ty1, tx1, ty2);
        } else {
            int ty2;
            int ty1;
            int tx1;
            int i;
            boolean b1 = BorderRenderMath.isRise1(factor);
            boolean b2 = BorderRenderMath.isRise2(factor);
            boolean b3 = BorderRenderMath.isRise3(factor);
            boolean b4 = BorderRenderMath.isRise4(factor);
            for (i = this._lineStyle.getWeightA() - 1; i >= 0; --i) {
                if (this._lineStyle.getBit(true, i)) {
                    tx1 = x1 + i + 1;
                    ty1 = b1 ? y1 - i1 : y1 + i1;
                    ty2 = b3 ? y2 + i3 : y2 - i3;
                    g2d.drawLine(tx1, ty1, tx1, ty2);
                }
                i1 = i1 > 1 ? i1 - 1 : i1;
                i3 = i3 > 1 ? i3 - 1 : i3;
            }
            for (i = this._lineStyle.getWeightB() - 1; i >= 0; --i) {
                if (this._lineStyle.getBit(false, i)) {
                    tx1 = x1 - i - 1;
                    ty1 = b2 ? y1 - i2 : y1 + i2;
                    ty2 = b4 ? y2 + i4 : y2 - i4;
                    g2d.drawLine(tx1, ty1, tx1, ty2);
                }
                i2 = i2 > 1 ? i2 - 1 : i2;
                i4 = i4 > 1 ? i4 - 1 : i4;
            }
            if (this._lineStyle.isFillCenterLine()) {
                g2d.drawLine(x1, y1, x1, y2);
            }
        }
    }

    private void paintTopBorder(Graphics2D g2d, Rectangle2D rect, int factor) {
        if (this._speedMode) {
            int x1 = (int)rect.getX();
            int y1 = (int)rect.getY();
            int x2 = (int)rect.getWidth() + x1 - 1;
            int y2 = y1;
            this.paintHorizontalSpeed(g2d, x1, y1, x2, y2, factor);
        } else {
            double x1 = rect.getX();
            double y1 = rect.getY();
            double x2 = rect.getWidth() + x1 - 1.0;
            double y2 = y1;
            this.paintHorizontal(g2d, x1, y1, x2, y2, factor);
        }
    }

    private void paintBottomBorder(Graphics2D g2d, Rectangle2D rect, int factor) {
        if (this._speedMode) {
            int x1 = (int)rect.getX();
            int y1 = (int)(rect.getY() + rect.getHeight() - 1.0);
            int x2 = (int)rect.getWidth() + x1 - 1;
            int y2 = y1;
            this.paintHorizontalSpeed(g2d, x1, y1, x2, y2, factor);
        } else {
            double x1 = rect.getX();
            double y1 = rect.getY() + rect.getHeight() - 1.0;
            double x2 = rect.getWidth() + x1 - 1.0;
            double y2 = y1;
            this.paintHorizontal(g2d, x1, y1, x2, y2, factor);
        }
    }

    private void paintHorizontal(Graphics2D g2d, double x1, double y1, double x2, double y2, int factor) {
        Line2D.Double line = new Line2D.Double();
        Stroke stroke = this._penStyle.getBaseStroke();
        g2d.setColor(this._color);
        g2d.setStroke(stroke);
        int i1 = 0;
        int i2 = 0;
        int i3 = 0;
        int i4 = 0;
        if (PenStyle.PS_SOLID == this._penStyle) {
            i1 = BorderRenderMath.getFactor1(factor);
            i2 = BorderRenderMath.getFactor2(factor);
            i3 = BorderRenderMath.getFactor3(factor);
            i4 = BorderRenderMath.getFactor4(factor);
        }
        if (this._lineStyle.isBaseBorder()) {
            int dx1 = Math.max(i1, i2);
            int dx2 = Math.max(i3, i4);
            line.x1 = x1 + (double)dx1;
            if (dx1 != 0) {
                line.x1 += 1.0;
            }
            line.y1 = y1;
            line.x2 = x2 - (double)dx2;
            if (dx2 != 0) {
                line.x2 -= 1.0;
            }
            line.y2 = y2;
            if (this.isUseInt) {
                line.x1 = (int)line.x1;
                line.x2 = (int)line.x2;
                line.y1 = (int)line.y1;
                line.y2 = (int)line.y2;
            }
            g2d.draw(line);
        } else {
            int i;
            boolean b1 = BorderRenderMath.isRise1(factor);
            boolean b2 = BorderRenderMath.isRise2(factor);
            boolean b3 = BorderRenderMath.isRise3(factor);
            boolean b4 = BorderRenderMath.isRise4(factor);
            for (i = this._lineStyle.getWeightA() - 1; i >= 0; --i) {
                if (this._lineStyle.getBit(true, i)) {
                    line.x1 = b1 ? x1 - (double)i1 : x1 + (double)i1;
                    line.y1 = y1 - (double)i - 1.0;
                    line.x2 = b3 ? x2 + (double)i3 : x2 - (double)i3;
                    line.y2 = y2 - (double)i - 1.0;
                    g2d.draw(line);
                }
                i1 = i1 > 1 ? i1 - 1 : i1;
                i3 = i3 > 1 ? i3 - 1 : i3;
            }
            for (i = this._lineStyle.getWeightB() - 1; i >= 0; --i) {
                if (this._lineStyle.getBit(false, i)) {
                    line.x1 = b2 ? x1 - (double)i2 : x1 + (double)i2;
                    line.y1 = y1 + (double)i + 1.0;
                    line.x2 = b4 ? x2 + (double)i4 : x2 - (double)i4;
                    line.y2 = y2 + (double)i + 1.0;
                    g2d.draw(line);
                }
                i2 = i2 > 1 ? i2 - 1 : i2;
                i4 = i4 > 1 ? i4 - 1 : i4;
            }
            if (this._lineStyle.isFillCenterLine()) {
                line.x1 = x1;
                line.y1 = y1;
                line.x2 = x2;
                line.y2 = y2;
                g2d.draw(line);
            }
        }
    }

    private void paintHorizontalSpeed(Graphics2D g2d, int x1, int y1, int x2, int y2, int factor) {
        g2d.setColor(this._color);
        g2d.setStroke(this._penStyle.getBaseStroke());
        int i1 = 0;
        int i2 = 0;
        int i3 = 0;
        int i4 = 0;
        if (PenStyle.PS_SOLID == this._penStyle) {
            i1 = BorderRenderMath.getFactor1(factor);
            i2 = BorderRenderMath.getFactor2(factor);
            i3 = BorderRenderMath.getFactor3(factor);
            i4 = BorderRenderMath.getFactor4(factor);
        }
        if (this._lineStyle.isBaseBorder()) {
            int dx1 = Math.max(i1, i2);
            int dx2 = Math.max(i3, i4);
            int tx1 = x1 + dx1;
            if (dx1 != 0) {
                ++tx1;
            }
            int ty1 = y1;
            int tx2 = x2 - dx2;
            if (dx2 != 0) {
                --tx2;
            }
            g2d.drawLine(tx1, ty1, tx2, ty1);
        } else {
            int tx2;
            int ty1;
            int tx1;
            int i;
            boolean b1 = BorderRenderMath.isRise1(factor);
            boolean b2 = BorderRenderMath.isRise2(factor);
            boolean b3 = BorderRenderMath.isRise3(factor);
            boolean b4 = BorderRenderMath.isRise4(factor);
            for (i = this._lineStyle.getWeightA() - 1; i >= 0; --i) {
                if (this._lineStyle.getBit(true, i)) {
                    tx1 = b1 ? x1 - i1 : x1 + i1;
                    ty1 = y1 - i - 1;
                    tx2 = b3 ? x2 + i3 : x2 - i3;
                    g2d.drawLine(tx1, ty1, tx2, ty1);
                }
                i1 = i1 > 1 ? i1 - 1 : i1;
                i3 = i3 > 1 ? i3 - 1 : i3;
            }
            for (i = this._lineStyle.getWeightB() - 1; i >= 0; --i) {
                if (this._lineStyle.getBit(false, i)) {
                    tx1 = b2 ? x1 - i2 : x1 + i2;
                    ty1 = y1 + i + 1;
                    tx2 = b4 ? x2 + i4 : x2 - i4;
                    g2d.drawLine(tx1, ty1, tx2, ty1);
                }
                i2 = i2 > 1 ? i2 - 1 : i2;
                i4 = i4 > 1 ? i4 - 1 : i4;
            }
            if (this._lineStyle.isFillCenterLine()) {
                g2d.drawLine(x1, y1, x2, y1);
            }
        }
    }

    private void paintDiagonalLeftBorder(Graphics2D g2d, Rectangle2D rect, int factor) {
        Line2D.Double line = new Line2D.Double();
        Stroke stroke = this._penStyle.getBaseStroke();
        g2d.setColor(this._color);
        g2d.setStroke(stroke);
        double x1 = rect.getX();
        double y1 = rect.getY();
        double x2 = x1 + rect.getWidth() - 1.0;
        double y2 = y1 + rect.getHeight() - 1.0;
        double k = (y2 - y1) / (x2 - x1);
        double b = y2 - k * x2;
        double db = -1.0;
        if (this._lineStyle.isBaseBorder()) {
            line.x1 = x1;
            line.y1 = y1;
            line.x2 = x2;
            line.y2 = y2;
            g2d.draw(line);
        } else {
            int i;
            int i1 = BorderRenderMath.getFactor1(factor);
            int i2 = BorderRenderMath.getFactor2(factor);
            int i3 = BorderRenderMath.getFactor3(factor);
            int i4 = BorderRenderMath.getFactor4(factor);
            for (i = this._lineStyle.getWeightA() - 1; i >= 0; --i) {
                if (this._lineStyle.getBit(true, i)) {
                    line.y1 = y1 + (double)i1;
                    line.x1 = (y1 + (double)i1 - b - (double)(i + 1) * db) / k;
                    line.x2 = x2 - (double)i3;
                    line.y2 = k * (x2 - (double)i3) + b + (double)(i + 1) * db;
                    g2d.draw(line);
                }
                i1 = i1 > 1 ? i1 - 1 : i1;
                i3 = i3 > 1 ? i3 - 1 : i3;
            }
            for (i = this._lineStyle.getWeightB() - 1; i >= 0; --i) {
                if (this._lineStyle.getBit(false, i)) {
                    line.x1 = x1 + (double)i2;
                    line.y1 = k * (x1 + (double)i2) + b - (double)(i + 1) * db;
                    line.y2 = y2 - (double)i4;
                    line.x2 = (y2 - (double)i4 - b + (double)(i + 1) * db) / k;
                    g2d.draw(line);
                }
                i2 = i2 > 1 ? i2 - 1 : i2;
                i4 = i4 > 1 ? i4 - 1 : i4;
            }
            if (this._lineStyle.isFillCenterLine()) {
                line.x1 = x1;
                line.y1 = y1;
                line.x2 = x2;
                line.y2 = y2;
                g2d.draw(line);
            }
        }
    }

    private void paintDiagonalRightBorder(Graphics2D g2d, Rectangle2D rect, int factor) {
        Line2D.Double line = new Line2D.Double();
        Stroke stroke = this._penStyle.getBaseStroke();
        g2d.setColor(this._color);
        g2d.setStroke(stroke);
        double x1 = rect.getX();
        double y1 = rect.getY() + rect.getHeight() - 1.0;
        double x2 = rect.getX() + rect.getWidth() - 1.0;
        double y2 = rect.getY();
        double k = (y2 - y1) / (x2 - x1);
        double b = y2 - k * x2;
        double db = -1.0;
        if (this._lineStyle.isBaseBorder()) {
            line.x1 = x1;
            line.y1 = y1;
            line.x2 = x2;
            line.y2 = y2;
            g2d.draw(line);
        } else {
            int i;
            int i1 = BorderRenderMath.getFactor1(factor);
            int i2 = BorderRenderMath.getFactor2(factor);
            int i3 = BorderRenderMath.getFactor3(factor);
            int i4 = BorderRenderMath.getFactor4(factor);
            for (i = this._lineStyle.getWeightA() - 1; i >= 0; --i) {
                if (this._lineStyle.getBit(true, i)) {
                    line.x1 = x1 + (double)i1;
                    line.y1 = k * (x1 + (double)i1) + b + (double)(i + 1) * db;
                    line.y2 = y2 + (double)i3;
                    line.x2 = (y2 + (double)i3 - b - (double)(i + 1) * db) / k;
                    g2d.draw(line);
                }
                i1 = i1 > 1 ? i1 - 1 : i1;
                i3 = i3 > 1 ? i3 - 1 : i3;
            }
            for (i = this._lineStyle.getWeightB() - 1; i >= 0; --i) {
                if (this._lineStyle.getBit(false, i)) {
                    line.y1 = y1 - (double)i2;
                    line.x1 = (y1 - (double)i2 - b + (double)(i + 1) * db) / k;
                    line.x2 = x2 - (double)i4;
                    line.y2 = k * (x2 - (double)i4) + b - (double)(i + 1) * db;
                    g2d.draw(line);
                }
                i2 = i2 > 1 ? i2 - 1 : i2;
                i4 = i4 > 1 ? i4 - 1 : i4;
            }
            if (this._lineStyle.isFillCenterLine()) {
                line.x1 = x1;
                line.y1 = y1;
                line.x2 = x2;
                line.y2 = y2;
                g2d.draw(line);
            }
        }
    }

    @Override
    public void draw(Graphics g, Shape clip, Object borderInfo, Style style) {
        BorderInfo bi = (BorderInfo)borderInfo;
        int drawMode = bi._drawMode;
        int row = bi._row;
        int col = bi._col;
        Graphics2D g2d = (Graphics2D)g;
        Rectangle2D rect = (Rectangle2D)clip;
        this._aroundStyles0 = null;
        this._aroundStyles1 = null;
        this._aroundStyles2 = null;
        this._aroundStyles3 = null;
        this._aroundStyles4 = null;
        this._aroundStyles5 = null;
        this._aroundStyles6 = null;
        this._aroundStyles7 = null;
        this._style = style;
        if (this._holder != null) {
            this.initAroundStyles(row, col, drawMode);
        }
        if (this._autoSetMode) {
            if (this._aroundStyles4 == null) {
                drawMode |= 4;
            }
            if (this._aroundStyles6 == null) {
                drawMode |= 8;
            }
            if (this._aroundStyles0 == null) {
                drawMode |= 1;
            }
            if (this._aroundStyles2 == null) {
                drawMode |= 2;
            }
        }
        if ((drawMode & 1) > 0 && this.initDrawStyle(Styles.Position.LEFT)) {
            this.paintLeftBorder(g2d, rect, this._calcFactor ? this.getLeftFactor() : 0);
        }
        if ((drawMode & 2) > 0 && this.initDrawStyle(Styles.Position.TOP)) {
            this.paintTopBorder(g2d, rect, this._calcFactor ? this.getTopFactor() : 0);
        }
        if ((drawMode & 0x10) > 0 && this.initDrawStyle(Styles.Position.DIAGONALLEFT)) {
            this.paintDiagonalLeftBorder(g2d, rect, this._calcFactor ? this.getDiagonalLeftFactor() : 0);
        }
        if ((drawMode & 0x20) > 0 && this.initDrawStyle(Styles.Position.DIAGONALRIGHT)) {
            this.paintDiagonalRightBorder(g2d, rect, this._calcFactor ? this.getDiagonalRightFactor() : 0);
        }
        if ((drawMode & 4) > 0 && this.initDrawStyle(Styles.Position.RIGHT)) {
            this.paintRightBorder(g2d, rect, this._calcFactor ? this.getRightFactor() : 0);
        }
        if ((drawMode & 8) > 0 && this.initDrawStyle(Styles.Position.BOTTOM)) {
            this.paintBottomBorder(g2d, rect, this._calcFactor ? this.getBottomFactor() : 0);
        }
    }

    public static class BorderInfo {
        int _row;
        int _col;
        int _drawMode;

        public BorderInfo(int row, int col, int drawMode) {
            this._drawMode = drawMode;
            this._row = row;
            this._col = col;
        }

        public BorderInfo() {
            this._drawMode = 0;
            this._row = 0;
            this._col = 0;
        }

        public void set(int row, int col, int drawMode) {
            this.setRowCol(row, col);
            this._drawMode = drawMode;
        }

        public void setRowCol(int row, int col) {
            this._row = row;
            this._col = col;
        }

        public int getDrawMode() {
            return this._drawMode;
        }

        public int getRow() {
            return this._row;
        }

        public int getCol() {
            return this._col;
        }

        public BorderInfo(int drawMode) {
            this(0, 0, drawMode);
        }
    }
}

