/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.util.render;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.util.render.AbstractBasicRender;
import com.kingdee.cosmic.ctrl.kdf.util.render.SimpleTextRender;
import com.kingdee.cosmic.ctrl.kdf.util.render.TextAreaRender;
import com.kingdee.cosmic.ctrl.kdf.util.render.TextRender;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import java.awt.Graphics;
import java.awt.Shape;

public class CellTextRender
extends AbstractBasicRender {
    protected TextRender complexRender;
    protected SimpleTextRender simpleRender;
    protected TextAreaRender textAreaRender;
    private static CellTextRender instance;

    public static CellTextRender shareInstance() {
        if (instance == null) {
            instance = new CellTextRender();
        }
        return instance;
    }

    private TextRender getComplexRender() {
        if (this.complexRender == null) {
            this.complexRender = new TextRender();
        }
        this.complexRender.setBlackWhite(this.isBlackWhite());
        return this.complexRender;
    }

    private SimpleTextRender getSimpleRender() {
        if (this.simpleRender == null) {
            this.simpleRender = new SimpleTextRender();
        }
        this.simpleRender.setBlackWhite(this.isBlackWhite());
        return this.simpleRender;
    }

    private TextAreaRender getTextAreaRender() {
        if (this.textAreaRender == null) {
            this.textAreaRender = new TextAreaRender();
        }
        this.textAreaRender.setBlackWhite(this.isBlackWhite());
        return this.textAreaRender;
    }

    private int getStyleType(Style style) {
        if (style.isShrinkText() || style.getRotation() != 0 || style.isStrikeThrough() || style.isUnderline() || style.isVerticalText()) {
            return 2;
        }
        if (style.isWrapText() || !style.isClip()) {
            return 1;
        }
        return 0;
    }

    public void setIsClipString(boolean isClipString) {
        this.getSimpleRender().setIsClipString(isClipString);
    }

    public void setKeepClip(boolean b) {
        this.getSimpleRender().setKeepClip(b);
    }

    @Override
    public void draw(Graphics g, Shape clip, Object object, Style style) {
        if (null != object) {
            String text = this.getText(object);
            if (StringUtil.isEmptyString((String)text)) {
                return;
            }
            int type = this.getStyleType(style);
            if (type == 0) {
                this.getSimpleRender().draw(g, clip, text, style);
            } else if (type == 1) {
                this.getTextAreaRender().draw(g, clip, text, style);
            } else {
                this.getComplexRender().draw(g, clip, text, style);
            }
        }
    }

    public String getText(Object text) {
        return text == null ? null : String.valueOf(text);
    }

    @Override
    public float getPreferredHeight(Graphics g, Shape clip, String text, Style style, Object extObj) {
        if (StringUtil.isEmptyString((String)text)) {
            return 0.0f;
        }
        int type = this.getStyleType(style);
        if (type == 1) {
            return this.getTextAreaRender().getPreferredHeight(g, clip, text, style);
        }
        return 0.0f;
    }
}

