/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.util.render.layout;

import com.kingdee.cosmic.ctrl.common.util.ArrayUtil;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;

public class StandardUnderline {
    public static final StandardUnderline DefaultUnderline = new StandardUnderline(0.0f, 1.0f, null, true);
    private static final float DEFAULT_THICKNESS = 1.0f;
    private float shift;
    private float thicknessMultiplier;
    private float[] dashPattern;
    private boolean useThickness;
    private BasicStroke cachedStroke;

    StandardUnderline(float shift, float thicknessMultiplier, float[] dashPattern, boolean useThickness) {
        this.shift = shift;
        this.thicknessMultiplier = thicknessMultiplier;
        this.dashPattern = dashPattern;
        this.useThickness = useThickness;
        this.cachedStroke = null;
    }

    private BasicStroke createStroke(float lineThickness) {
        if (this.dashPattern == null) {
            return new BasicStroke(lineThickness);
        }
        return new BasicStroke(lineThickness, 0, 0, 10.0f, this.dashPattern, 0.0f);
    }

    private float getLineThickness(float thickness) {
        if (this.useThickness) {
            return thickness * this.thicknessMultiplier;
        }
        return 1.0f * this.thicknessMultiplier;
    }

    private Stroke getStroke(float thickness) {
        float lineThickness = this.getLineThickness(thickness);
        BasicStroke stroke = this.cachedStroke;
        if (stroke == null || !ArrayUtil.isEqual((Float)Float.valueOf(stroke.getLineWidth()), (Float)Float.valueOf(lineThickness))) {
            this.cachedStroke = stroke = this.createStroke(lineThickness);
        }
        return stroke;
    }

    void drawUnderline(Graphics2D g2d, float thickness, float x1, float x2, float y) {
        Stroke saveStroke = g2d.getStroke();
        g2d.setStroke(this.getStroke(thickness));
        g2d.draw(new Line2D.Float(x1, y + this.shift, x2, y + this.shift));
        g2d.setStroke(saveStroke);
    }

    float getLowerDrawLimit(float thickness) {
        return this.shift + this.getLineThickness(thickness);
    }

    Shape getUnderlineShape(float thickness, float x1, float x2, float y) {
        Stroke ulStroke = this.getStroke(thickness);
        Line2D.Float line = new Line2D.Float(x1, y + this.shift, x2, y + this.shift);
        return ulStroke.createStrokedShape(line);
    }
}

