/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.util.style;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonUIMessages;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.common.util.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.kdf.util.style.LineStyle;
import com.kingdee.cosmic.ctrl.kdf.util.style.Pattern;
import com.kingdee.cosmic.ctrl.kdf.util.style.PenStyle;
import com.kingdee.cosmic.ctrl.kdf.util.style.Rect;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class StyleParser {
    private static final Logger logger = LogUtil.getPackageLogger(StyleParser.class);
    private static final int Filter_V0 = 0;
    private static final int Filter_V1 = 1;
    private static final HashMap _filters = new HashMap();
    private static final HashMap _colors;

    private StyleParser() {
    }

    public static void writeStyles(IXmlElement eleStyles, Iterator iterStyles) {
        eleStyles.setAttribute("version", "1.0");
        HashMap customPenStyles = new HashMap();
        while (iterStyles.hasNext()) {
            Map.Entry e = (Map.Entry)iterStyles.next();
            ShareStyleAttributes ssa = (ShareStyleAttributes)e.getValue();
            String id = e.getKey().toString();
            IXmlElement eleStyle = StyleParser.getStyleElement(ssa, id);
            eleStyles.addChild(eleStyle);
            if (!ssa.hasBordersAttributes()) continue;
            StyleParser.getCustomPenStyle(customPenStyles, ssa, Styles.Position.LEFT);
            StyleParser.getCustomPenStyle(customPenStyles, ssa, Styles.Position.TOP);
            StyleParser.getCustomPenStyle(customPenStyles, ssa, Styles.Position.RIGHT);
            StyleParser.getCustomPenStyle(customPenStyles, ssa, Styles.Position.BOTTOM);
            StyleParser.getCustomPenStyle(customPenStyles, ssa, Styles.Position.DIAGONALLEFT);
            StyleParser.getCustomPenStyle(customPenStyles, ssa, Styles.Position.DIAGONALRIGHT);
        }
        StyleParser.writeCustomPenStyle(eleStyles, customPenStyles);
    }

    private static void getCustomPenStyle(HashMap customPenStyles, ShareStyleAttributes ssa, Styles.Position pos) {
        PenStyle ps = ssa.getBorderPenStyle(pos);
        if (ps != null && !ps.isSystem()) {
            customPenStyles.put(ps.getName(), ps);
        }
    }

    public static String colorToRGBA(Color color, boolean isOpaque) {
        StringBuilder sb = new StringBuilder("rgba(");
        String str = String.valueOf(color.getRed());
        sb.append(str).append(',');
        str = String.valueOf(color.getGreen());
        sb.append(str).append(',');
        str = String.valueOf(color.getBlue());
        sb.append(str).append(',');
        float alpha = isOpaque ? 255.0f : (float)color.getAlpha();
        alpha = (float)Math.round(alpha / 255.0f * 100.0f) / 100.0f;
        str = String.valueOf(alpha);
        sb.append(str).append(')');
        return sb.toString();
    }

    public static String colorToHex(Color color) {
        StringBuilder sb = new StringBuilder("#");
        String str = Integer.toHexString(color.getRed());
        if (str.length() < 2) {
            sb.append('0');
        }
        sb.append(str);
        str = Integer.toHexString(color.getGreen());
        if (str.length() < 2) {
            sb.append('0');
        }
        sb.append(str);
        str = Integer.toHexString(color.getBlue());
        if (str.length() < 2) {
            sb.append('0');
        }
        sb.append(str);
        if (color.getAlpha() != 255) {
            str = Integer.toHexString(color.getAlpha());
            if (str.length() < 2) {
                sb.append('0');
            }
            sb.append(str);
        }
        return sb.toString();
    }

    public static IXmlElement getStyleElement(ShareStyleAttributes ssa, String ssaName) {
        String numberFormat;
        IXmlElement eleStyle = com.kingdee.bos.qing.common.xml.XmlUtil.createNode((String)"Style");
        eleStyle.setAttribute("id", ssaName);
        StyleParser.writeXML_Font(ssa, eleStyle);
        StyleParser.writeXML_Borders(ssa, eleStyle);
        StyleParser.writeXML_Interior(ssa, eleStyle);
        StyleParser.writeXML_Alignment(ssa, eleStyle);
        StyleParser.writeXML_Protection(ssa, eleStyle);
        if (ssa.hasAttributes(ShareStyleAttributes.NUMBER_FORMAT) && !StringUtil.isEmptyString((String)(numberFormat = ssa.getNumberFormat()))) {
            IXmlElement eleNF = com.kingdee.bos.qing.common.xml.XmlUtil.createNode((String)"NumberFormat");
            eleStyle.addChild(eleNF);
            eleNF.addCData(numberFormat);
        }
        return eleStyle;
    }

    static void writeXML_Font(ShareStyleAttributes ssa, IXmlElement eleStyle) {
        if (ssa.hasFontAttributes()) {
            IXmlElement eleFont = com.kingdee.bos.qing.common.xml.XmlUtil.createNode((String)"Font");
            eleStyle.addChild(eleFont);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.FONT_NAME, "fontName", eleFont);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.FONT_SIZE, "size", eleFont);
            StyleParser.setXMLColorAttribute(ssa, ShareStyleAttributes.FONT_COLOR, "color", eleFont);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.FONT_BOLD, "bold", eleFont);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.FONT_UNDERLINE, "underline", eleFont);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.FONT_ITALIC, "italic", eleFont);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.FONT_STRIKETHROUGH, "strikethrough", eleFont);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.FONT_WEIGHT, "weight", eleFont);
        }
    }

    static void writeXML_Border(ShareStyleAttributes ssa, Styles.Position pos, IXmlElement eleBorders) {
        if (!ssa.hasBorderAttributes(pos)) {
            return;
        }
        IXmlElement eleBorder = com.kingdee.bos.qing.common.xml.XmlUtil.createNode((String)"Border");
        eleBorders.addChild(eleBorder);
        eleBorder.setAttribute("position", pos.getName());
        StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.getBorderLineStyleIndex(pos), "lineStyle", eleBorder);
        LineStyle ls = ssa.getBorderLineStyle(pos);
        if (ls != LineStyle.NULL_LINE) {
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.getBorderPenStyleIndex(pos), "penStyle", eleBorder);
            StyleParser.setXMLColorAttribute(ssa, ShareStyleAttributes.getBorderColorIndex(pos), "color", eleBorder);
        }
    }

    static void writeXML_Borders(ShareStyleAttributes ssa, IXmlElement eleStyle) {
        if (!ssa.hasBordersAttributes()) {
            return;
        }
        IXmlElement eleBorders = com.kingdee.bos.qing.common.xml.XmlUtil.createNode((String)"Borders");
        eleStyle.addChild(eleBorders);
        StyleParser.writeXML_Border(ssa, Styles.Position.LEFT, eleBorders);
        StyleParser.writeXML_Border(ssa, Styles.Position.TOP, eleBorders);
        StyleParser.writeXML_Border(ssa, Styles.Position.RIGHT, eleBorders);
        StyleParser.writeXML_Border(ssa, Styles.Position.BOTTOM, eleBorders);
        StyleParser.writeXML_Border(ssa, Styles.Position.DIAGONALLEFT, eleBorders);
        StyleParser.writeXML_Border(ssa, Styles.Position.DIAGONALRIGHT, eleBorders);
    }

    static void writeXML_Interior(ShareStyleAttributes ssa, IXmlElement eleStyle) {
        if (ssa.hasInteriorAttributes()) {
            IXmlElement eleInt = com.kingdee.bos.qing.common.xml.XmlUtil.createNode((String)"Interior");
            eleStyle.addChild(eleInt);
            StyleParser.setXMLColorAttribute(ssa, ShareStyleAttributes.BACKGROUND_COLOR, "color", eleInt);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.PATTERN, "pattern", eleInt);
            StyleParser.setXMLColorAttribute(ssa, ShareStyleAttributes.PATTERN_COLOR, "patternColor", eleInt);
        }
    }

    static void writeXML_Alignment(ShareStyleAttributes ssa, IXmlElement eleStyle) {
        if (ssa.hasAlignmentAttributes()) {
            IXmlElement eleAlignment = com.kingdee.bos.qing.common.xml.XmlUtil.createNode((String)"Alignment");
            eleStyle.addChild(eleAlignment);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.HORIZONTAL_ALIGN, "horizontal", eleAlignment);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.VERTICAL_ALIGN, "vertical", eleAlignment);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.WRAP_TEXT, "wrapText", eleAlignment);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.ROTATION, "rotate", eleAlignment);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.SHRINK_TEXT, "shrink", eleAlignment);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.LINE_SPACING, "lineSpace", eleAlignment);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.PADDING, "padding", eleAlignment);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.AUTO_CLIP, "clip", eleAlignment);
        }
    }

    static void writeXML_Protection(ShareStyleAttributes ssa, IXmlElement eleStyle) {
        if (ssa.hasProtectionAttributes()) {
            IXmlElement eleProtection = com.kingdee.bos.qing.common.xml.XmlUtil.createNode((String)"Protection");
            eleStyle.addChild(eleProtection);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.PROTECTION_HIDDED, "hidden", eleProtection);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.PROTECTION_LOCKED, "locked", eleProtection);
        }
    }

    static void setXMLAttribute(ShareStyleAttributes ssa, int index, String key, IXmlElement ele) {
        if (ssa.hasAttributes(index)) {
            Object obj = ssa.get(index);
            ele.setAttribute(key, obj.toString());
        }
    }

    static void setXMLColorAttribute(ShareStyleAttributes ssa, int index, String key, IXmlElement ele) {
        if (ssa.hasAttributes(index)) {
            Object obj = ssa.get(index);
            ele.setAttribute(key, StyleParser.colorToHex((Color)obj));
        }
    }

    public static void writeCustomPenStyle(IXmlElement eleStyles, HashMap customPenStyles) {
        Iterator i = customPenStyles.entrySet().iterator();
        if (!i.hasNext()) {
            return;
        }
        IXmlElement penStyles = com.kingdee.bos.qing.common.xml.XmlUtil.createNode((String)"PenStyles");
        eleStyles.addChild(penStyles);
        while (i.hasNext()) {
            Map.Entry e = i.next();
            PenStyle ps = (PenStyle)e.getValue();
            IXmlElement penStyle = com.kingdee.bos.qing.common.xml.XmlUtil.createNode((String)"PenStyle");
            penStyle.setAttribute("name", ps.getName());
            penStyle.setAttribute("dash", ps.getDashString());
            penStyles.addChild(penStyle);
        }
    }

    public static StyleAttributes parseDefSA(IXmlElement eleStyle) {
        StyleAttributes sa = Styles.getDefaultSA();
        try {
            String str;
            IXmlElement eleChild = eleStyle.getChild("Borders");
            if (eleChild != null) {
                Iterator i = eleChild.searchChildren("Border").iterator();
                while (i.hasNext()) {
                    StyleParser.parseBorder((IXmlElement)i.next(), sa);
                }
            }
            if ((eleChild = eleStyle.getChild("Font")) != null) {
                StyleParser.parseFont(eleChild, sa);
            }
            if ((eleChild = eleStyle.getChild("Protection")) != null) {
                StyleParser.parseProtection(eleChild, sa);
            }
            if ((eleChild = eleStyle.getChild("Interior")) != null) {
                StyleParser.parseInterior(eleChild, sa);
            }
            if ((eleChild = eleStyle.getChild("Alignment")) != null) {
                StyleParser.parseAlignment(eleChild, sa);
            }
            if ((eleChild = eleStyle.getChild("NumberFormat")) != null && (str = eleChild.getText()) != null) {
                sa.setNumberFormat(str);
            }
        }
        catch (Exception err) {
            throw new RuntimeException(CtrlCommonUIMessages.getMLS("styleParsingError", "\u89e3\u6790Style\u9519\u8bef\uff1a"), err);
        }
        return sa;
    }

    public static StyleAttributes parseSA(IXmlElement eleStyle) {
        StyleAttributes sa = Styles.getEmptySA();
        try {
            String str;
            IXmlElement eleChild = eleStyle.getChild("Borders");
            if (eleChild != null) {
                Iterator i = eleChild.searchChildren("Border").iterator();
                while (i.hasNext()) {
                    StyleParser.parseBorder((IXmlElement)i.next(), sa);
                }
            }
            if ((eleChild = eleStyle.getChild("Font")) != null) {
                StyleParser.parseFont(eleChild, sa);
            }
            if ((eleChild = eleStyle.getChild("Protection")) != null) {
                StyleParser.parseProtection(eleChild, sa);
            }
            if ((eleChild = eleStyle.getChild("Interior")) != null) {
                StyleParser.parseInterior(eleChild, sa);
            }
            if ((eleChild = eleStyle.getChild("Alignment")) != null) {
                StyleParser.parseAlignment(eleChild, sa);
            }
            if ((eleChild = eleStyle.getChild("NumberFormat")) != null && (str = eleChild.getText()) != null) {
                sa.setNumberFormat(str);
            }
        }
        catch (Exception err) {
            throw new RuntimeException(CtrlCommonUIMessages.getMLS("styleParsingError", "\u89e3\u6790Style\u9519\u8bef\uff1a"), err);
        }
        return sa;
    }

    static void parseBorder(IXmlElement eleBorder, StyleAttributes sa) {
        Styles.Position pos = Styles.Position.parse(eleBorder.getAttribute("position"));
        String value = eleBorder.getAttribute("color");
        if (value != null) {
            sa.setBorderColor(pos, StyleParser.stringToColor(value));
        }
        if ((value = eleBorder.getAttribute("penStyle")) != null) {
            sa.setBorderPenStyle(pos, PenStyle.getPenStyle(value));
        }
        if ((value = eleBorder.getAttribute("lineStyle")) != null) {
            sa.setBorderLineStyle(pos, LineStyle.getLineStyle(value));
        }
    }

    static void parseFont(IXmlElement eleFont, StyleAttributes sa) {
        String value = eleFont.getAttribute("fontName");
        if (value != null) {
            sa.setFontName(value);
        }
        if ((value = eleFont.getAttribute("size")) != null) {
            sa.setFontSize(Integer.parseInt(value));
        }
        if ((value = eleFont.getAttribute("color")) != null) {
            sa.setFontColor(StyleParser.stringToColor(value));
        }
        if ((value = eleFont.getAttribute("bold")) != null) {
            sa.setBold(Boolean.parseBoolean(value));
        }
        if ((value = eleFont.getAttribute("italic")) != null) {
            sa.setItalic(Boolean.parseBoolean(value));
        }
        if ((value = eleFont.getAttribute("strikethrough")) != null) {
            sa.setStrikeThrough(Boolean.parseBoolean(value));
        }
        if ((value = eleFont.getAttribute("underline")) != null) {
            sa.setUnderline(Boolean.parseBoolean(value));
        }
        if ((value = eleFont.getAttribute("weight")) != null) {
            sa.setWeight(Float.parseFloat(value));
        }
    }

    static void parseProtection(IXmlElement eleProtection, StyleAttributes sa) {
        String value = eleProtection.getAttribute("locked");
        if (value != null) {
            sa.setLocked(Boolean.parseBoolean(value));
        }
        if ((value = eleProtection.getAttribute("hidden")) != null) {
            sa.setHided(Boolean.parseBoolean(value));
        }
    }

    static void parseInterior(IXmlElement eleInterior, StyleAttributes sa) {
        String value = eleInterior.getAttribute("color");
        if (value != null) {
            sa.setBackground(StyleParser.stringToColor(value));
        }
        if ((value = eleInterior.getAttribute("pattern")) != null) {
            sa.setPattern(Pattern.getPattern(value));
        }
        if ((value = eleInterior.getAttribute("patternColor")) != null) {
            sa.setPatternColor(StyleParser.stringToColor(value));
        }
    }

    static void parseAlignment(IXmlElement eleAlign, StyleAttributes sa) {
        String value = eleAlign.getAttribute("rotate");
        if (value != null) {
            sa.setRotation(Integer.parseInt(value));
        }
        if ((value = eleAlign.getAttribute("horizontal")) != null) {
            sa.setHorizontalAlign(Styles.HorizontalAlignment.getAlignment(value));
        }
        if ((value = eleAlign.getAttribute("vertical")) != null) {
            sa.setVerticalAlign(Styles.VerticalAlignment.getAlignment(value));
        }
        if ((value = eleAlign.getAttribute("lineSpace")) != null) {
            sa.setLinespacing(Float.parseFloat(value));
        }
        if ((value = eleAlign.getAttribute("wrapText")) != null) {
            sa.setWrapText(Boolean.parseBoolean(value));
        }
        if ((value = eleAlign.getAttribute("shrink")) != null) {
            sa.setShrinkText(Boolean.parseBoolean(value));
        }
        if ((value = eleAlign.getAttribute("padding")) != null) {
            sa.setPadding(Rect.valueOf(value));
        }
        if ((value = eleAlign.getAttribute("clip")) != null) {
            sa.setClip(Boolean.parseBoolean(value));
        }
    }

    public static Color stringToColor(String str) {
        Object obj;
        Color color = null;
        color = str.length() == 0 ? Color.black : (str.startsWith("rgb(") ? StyleParser.parseRGB(str) : (str.charAt(0) == '#' ? StyleParser.hexToColor(str) : ((obj = _colors.get(str.toLowerCase(Locale.ENGLISH))) != null ? (Color)obj : StyleParser.hexToColor(str))));
        return color;
    }

    public static final Color hexToColor(String strColor) {
        Color color = null;
        try {
            String strR = strColor.substring(1, 3);
            String strG = strColor.substring(3, 5);
            String strB = strColor.substring(5, 7);
            if (strColor.length() > 7) {
                String strA = strColor.substring(7, 9);
                color = new Color(Integer.parseInt(strR, 16), Integer.parseInt(strG, 16), Integer.parseInt(strB, 16), Integer.parseInt(strA, 16));
            } else {
                color = new Color(Integer.parseInt(strR, 16), Integer.parseInt(strG, 16), Integer.parseInt(strB, 16));
            }
        }
        catch (Exception err) {
            throw new IllegalArgumentException(CtrlCommonUIMessages.getMLS("wrongColorExp", "\u8f93\u5165\u7684\u989c\u8272\u8868\u8fbe\u5f0f\u4e0d\u5408\u6cd5\uff0c\u6b63\u786e\u683c\u5f0f\u5982\uff1a#00ff99"), err);
        }
        return color;
    }

    public static Color parseRGB(String string) {
        int[] index = new int[]{4};
        int red = StyleParser.getColorComponent(string, index);
        int green = StyleParser.getColorComponent(string, index);
        int blue = StyleParser.getColorComponent(string, index);
        return new Color(red, green, blue);
    }

    private static int getColorComponent(String string, int[] index) {
        char aChar;
        int length = string.length();
        while (index[0] < length && (aChar = string.charAt(index[0])) != '-' && !Character.isDigit(aChar) && aChar != '.') {
            index[0] = index[0] + 1;
        }
        int start = index[0];
        if (start < length && string.charAt(index[0]) == '-') {
            index[0] = index[0] + 1;
        }
        while (index[0] < length && Character.isDigit(string.charAt(index[0]))) {
            index[0] = index[0] + 1;
        }
        if (index[0] < length && string.charAt(index[0]) == '.') {
            index[0] = index[0] + 1;
            while (index[0] < length && Character.isDigit(string.charAt(index[0]))) {
                index[0] = index[0] + 1;
            }
        }
        if (start != index[0]) {
            try {
                float value = Float.parseFloat(string.substring(start, index[0]));
                if (index[0] < length && string.charAt(index[0]) == '%') {
                    index[0] = index[0] + 1;
                    value = value * 255.0f / 100.0f;
                }
                return Math.min(255, Math.max(0, (int)value));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public static void upgrade(IXmlElement eleStyles) {
        if (eleStyles == null) {
            return;
        }
        String version = eleStyles.getAttribute("version");
        Object obj = version == null ? null : _filters.get(Float.valueOf(version));
        int upgradeFrom = obj == null ? 0 : (Integer)obj;
        switch (upgradeFrom) {
            case 0: {
                new StyleFilterV0().upgrade(eleStyles);
            }
        }
    }

    static {
        _filters.put(Float.valueOf(1.0f), 1);
        _colors = new HashMap();
        _colors.put("black", Color.BLACK);
        _colors.put("silver", new Color(192, 192, 192));
        _colors.put("gray", Color.GRAY);
        _colors.put("white", Color.WHITE);
        _colors.put("maroon", new Color(128, 0, 0));
        _colors.put("red", Color.RED);
        _colors.put("purple", new Color(128, 0, 128));
        _colors.put("fuchsia", new Color(255, 0, 255));
        _colors.put("green", Color.GREEN);
        _colors.put("lime", new Color(0, 255, 0));
        _colors.put("olive", new Color(128, 128, 0));
        _colors.put("yellow", Color.YELLOW);
        _colors.put("navy", new Color(0, 0, 128));
        _colors.put("blue", Color.BLUE);
        _colors.put("teal", new Color(0, 128, 128));
        _colors.put("aqua", new Color(0, 255, 255));
    }

    static class StyleFilterV0 {
        StyleFilterV0() {
        }

        public void upgrade(IXmlElement eleStyles) {
            List styles = eleStyles.getChildren();
            int size = styles.size();
            for (int i = 0; i < size; ++i) {
                String value;
                IXmlElement eleInterior;
                IXmlElement eleStyle = (IXmlElement)styles.get(i);
                IXmlElement eleBorders = eleStyle.getChild("Borders");
                if (eleBorders != null) {
                    List borders = eleBorders.searchChildren("Border");
                    for (IXmlElement eleBorder : borders) {
                        this.upgradeBorder(eleStyles, eleBorder);
                    }
                }
                if ((eleInterior = eleStyle.getChild("Interior")) == null || StringUtil.isEmptyString((String)(value = eleInterior.getAttribute("pattern")))) continue;
                Pattern ptn = Pattern.getPattern(Integer.parseInt(value));
                eleInterior.setAttribute("pattern", ptn.getName());
            }
        }

        private void upgradeBorder(IXmlElement eleStyles, IXmlElement eleBorder) {
            LineStyle ls = null;
            String value = eleBorder.getAttribute("lineStyle");
            if (value != null) {
                PenStyle ps = null;
                int lineStyle = Integer.parseInt(value);
                if (lineStyle == -1) {
                    String pattern = eleBorder.getChild("LinePattern").getText();
                    if (pattern != null) {
                        String[] strArray = pattern.split(" ");
                        float[] floatArray = new float[strArray.length];
                        for (int i = 0; i < strArray.length; ++i) {
                            floatArray[i] = Float.parseFloat(strArray[i]);
                        }
                        ps = PenStyle.createPenStyle(null, floatArray, false);
                        if (!ps.isSystem()) {
                            this.addToPenStyles(eleStyles, ps);
                        }
                    }
                } else {
                    switch (lineStyle) {
                        case 0: {
                            ls = LineStyle.NULL_LINE;
                            break;
                        }
                        case 1: {
                            ps = PenStyle.PS_SOLID;
                            break;
                        }
                        case 2: {
                            ps = PenStyle.PS_CONTINUOUS;
                            break;
                        }
                        case 3: {
                            ps = PenStyle.PS_DOT;
                            break;
                        }
                        case 4: {
                            ps = PenStyle.PS_DASHDOTDOT;
                            break;
                        }
                        case 5: {
                            ps = PenStyle.PS_DASHDOT;
                            break;
                        }
                        default: {
                            ls = LineStyle.NULL_LINE;
                        }
                    }
                }
                eleBorder.setAttribute("lineStyle", null);
                if (ps != null) {
                    eleBorder.setAttribute("penStyle", ps.getName());
                }
            }
            if (ls == null && (value = eleBorder.getAttribute("width")) != null) {
                int width = Integer.parseInt(value);
                ls = LineStyle.getLineStyle(width);
                eleBorder.setAttribute("width", null);
            }
            if (ls != null) {
                eleBorder.setAttribute("lineStyle", ls.getName());
            }
        }

        private void addToPenStyles(IXmlElement eleStyles, PenStyle ps) {
            IXmlElement elePenStyle;
            IXmlElement elePenStyles = eleStyles.getChild("PenStyles");
            if (elePenStyles == null) {
                elePenStyles = com.kingdee.bos.qing.common.xml.XmlUtil.createNode((String)"PenStyles");
                eleStyles.addChild(elePenStyles);
            }
            if ((elePenStyle = XmlUtil.selectSingleNode((IXmlElement)elePenStyles, (String)"PenStyle", (String)"id", (String)ps.getName())) == null) {
                elePenStyle = com.kingdee.bos.qing.common.xml.XmlUtil.createNode((String)"PenStyle");
                elePenStyle.setAttribute("Name", ps.getName());
                float[] aDash = ps.getDash();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < aDash.length; ++i) {
                    sb.append(aDash[i]);
                    sb.append(' ');
                }
                elePenStyle.setAttribute("Dash", sb.toString());
                elePenStyles.addChild(elePenStyle);
            }
        }
    }
}

