/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.util.style.styledesigner;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonUIMessages;
import com.kingdee.cosmic.ctrl.kdf.util.render.BorderRender;
import com.kingdee.cosmic.ctrl.kdf.util.style.LineStyle;
import com.kingdee.cosmic.ctrl.kdf.util.style.PenStyle;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import com.kingdee.cosmic.ctrl.kdf.util.style.styledesigner.InnerBorder;
import com.kingdee.cosmic.ctrl.kdf.util.style.styledesigner.LineSupplyCtrl;
import com.kingdee.cosmic.ctrl.kdf.util.style.styledesigner.StyleDesignerUtil;
import com.kingdee.cosmic.ctrl.kdf.util.style.styledesigner.icons.ResourceManager;
import com.kingdee.cosmic.ctrl.kdf.util.style.styledesigner.packing.IStylePane;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDComboColor;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDLabelContainer;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDSeparator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;

public class BorderPane
extends KDPanel
implements IStylePane {
    private static final long serialVersionUID = 6498920289032246449L;
    private StyleAttributes sa;
    private boolean isInnerHEnabled = false;
    private boolean isInnerVEnabled = false;
    private PreviewPanel panPreview = new PreviewPanel();
    private KDButton btnNoLine = new KDButton();
    private KDButton btnAllOuter = new KDButton();
    private KDButton btnAllInner = new KDButton();
    private JToggleButton btnTop = new JToggleButton();
    private JToggleButton btnBottom = new JToggleButton();
    private JToggleButton btnLeft = new JToggleButton();
    private JToggleButton btnRight = new JToggleButton();
    private JToggleButton btnInnerH = new JToggleButton();
    private JToggleButton btnInnerV = new JToggleButton();
    private LineSupplyCtrl panLineSupply = new LineSupplyCtrl();
    private boolean flagIsShowValueFireMe;
    private BorderRender br = new BorderRender();
    private InnerBorder innerBorder;
    private Rectangle rect;
    private StyleAttributes oldinnersa;

    public BorderPane() {
        this.initCompoments();
        this.installCompoments();
        this.installListener();
        this.br.setCalcFactor(false);
    }

    @Override
    public void setSA(StyleAttributes sa) {
        this.flagIsShowValueFireMe = true;
        this.sa = sa;
        this.syncStyle4Paint();
        this.showValue(true);
        this.flagIsShowValueFireMe = false;
    }

    private void syncStyle4Paint() {
        for (int i = StyleAttributes.BORDER_LEFT_LINESTYLE; i <= StyleAttributes.BORDER_DIAGONALRIGHT_COLOR; ++i) {
            StyleDesignerUtil.copyAttr(this.sa, StyleDesignerUtil.getSa4Paint(), i);
        }
        if (this.sa.isUnsureValue(StyleAttributes.BORDER_LEFT_LINESTYLE) || this.sa.isUnsureValue(StyleAttributes.BORDER_LEFT_PENSTYLE) || this.sa.isUnsureValue(StyleAttributes.BORDER_LEFT_COLOR)) {
            this.ensurePreviewLineStyle(Styles.Position.LEFT);
        }
        if (this.sa.isUnsureValue(StyleAttributes.BORDER_RIGHT_LINESTYLE) || this.sa.isUnsureValue(StyleAttributes.BORDER_RIGHT_PENSTYLE) || this.sa.isUnsureValue(StyleAttributes.BORDER_RIGHT_COLOR)) {
            this.ensurePreviewLineStyle(Styles.Position.RIGHT);
        }
        if (this.sa.isUnsureValue(StyleAttributes.BORDER_TOP_LINESTYLE) || this.sa.isUnsureValue(StyleAttributes.BORDER_TOP_PENSTYLE) || this.sa.isUnsureValue(StyleAttributes.BORDER_TOP_COLOR)) {
            this.ensurePreviewLineStyle(Styles.Position.TOP);
        }
        if (this.sa.isUnsureValue(StyleAttributes.BORDER_BOTTOM_LINESTYLE) || this.sa.isUnsureValue(StyleAttributes.BORDER_BOTTOM_PENSTYLE) || this.sa.isUnsureValue(StyleAttributes.BORDER_BOTTOM_COLOR)) {
            this.ensurePreviewLineStyle(Styles.Position.BOTTOM);
        }
        if (this.sa.isUnsureValue(StyleAttributes.BORDER_DIAGONALLEFT_LINESTYLE) || this.sa.isUnsureValue(StyleAttributes.BORDER_DIAGONALLEFT_PENSTYLE) || this.sa.isUnsureValue(StyleAttributes.BORDER_DIAGONALLEFT_COLOR)) {
            this.ensurePreviewLineStyle(Styles.Position.DIAGONALLEFT);
        }
        if (this.sa.isUnsureValue(StyleAttributes.BORDER_DIAGONALRIGHT_LINESTYLE) || this.sa.isUnsureValue(StyleAttributes.BORDER_DIAGONALRIGHT_PENSTYLE) || this.sa.isUnsureValue(StyleAttributes.BORDER_DIAGONALRIGHT_COLOR)) {
            this.ensurePreviewLineStyle(Styles.Position.DIAGONALRIGHT);
        }
        StyleDesignerUtil.refreshStyle4Paint();
    }

    private void ensurePreviewLineStyle(Styles.Position pos) {
        StyleDesignerUtil.getSa4Paint().setBorderLineStyle(pos, LineStyle.NULL_LINE);
    }

    private void initCompoments() {
        this.panPreview.setBorder(BorderFactory.createLoweredBevelBorder());
        this.btnNoLine.setLimitedSize(false);
        this.btnAllOuter.setLimitedSize(false);
        this.btnAllInner.setLimitedSize(false);
        this.btnNoLine.setIcon((Icon)ResourceManager.getIcon("cell_nothing_2.gif"));
        this.btnAllOuter.setIcon((Icon)ResourceManager.getIcon("cell_outframe_2.gif"));
        this.btnAllInner.setIcon((Icon)ResourceManager.getIcon("cell_inside_2.gif"));
        this.btnAllInner.setDisabledIcon((Icon)ResourceManager.getIcon("cell_inside_3.gif"));
        this.btnTop.setIcon(ResourceManager.getIcon("cell_top_horizontal_2.gif"));
        this.btnTop.setSelectedIcon(ResourceManager.getIcon("cell_top_horizontal_1.gif"));
        this.btnInnerH.setIcon(ResourceManager.getIcon("cell_mid_horizontal_2.gif"));
        this.btnInnerH.setSelectedIcon(ResourceManager.getIcon("cell_mid_horizontal_1.gif"));
        this.btnInnerH.setDisabledIcon(ResourceManager.getIcon("cell_mid_horizontal_4.gif"));
        this.btnBottom.setIcon(ResourceManager.getIcon("cell_down_horizontal_2.gif"));
        this.btnBottom.setSelectedIcon(ResourceManager.getIcon("cell_down_horizontal_1.gif"));
        this.btnLeft.setIcon(ResourceManager.getIcon("cell_left_upright_2.gif"));
        this.btnLeft.setSelectedIcon(ResourceManager.getIcon("cell_left_upright_1.gif"));
        this.btnInnerV.setIcon(ResourceManager.getIcon("cell_mid_upright_2.gif"));
        this.btnInnerV.setSelectedIcon(ResourceManager.getIcon("cell_mid_upright_1.gif"));
        this.btnInnerV.setDisabledIcon(ResourceManager.getIcon("cell_mid_upright_4.gif"));
        this.btnRight.setIcon(ResourceManager.getIcon("cell_right_upright_2.gif"));
        this.btnRight.setSelectedIcon(ResourceManager.getIcon("cell_right_upright_1.gif"));
    }

    private void installCompoments() {
        KDSeparator sprPreset = new KDSeparator();
        KDSeparator sprBorder = new KDSeparator();
        KDLabel labPreset = new KDLabel(this.getMLS("Preset", "\u9884\u7f6e"));
        KDLabel labBorder = new KDLabel(this.getMLS("Border", "\u8fb9\u6846"));
        KDLabelContainer lbcNoLine = new KDLabelContainer((JComponent)this.btnNoLine);
        KDLabelContainer lbcAllOuter = new KDLabelContainer((JComponent)this.btnAllOuter);
        KDLabelContainer lbcAllInner = new KDLabelContainer((JComponent)this.btnAllInner);
        lbcNoLine.setBoundLabelText(this.getMLS("noLine", "\u65e0"));
        lbcAllOuter.setBoundLabelText(this.getMLS("allOuter", "\u5916\u6846"));
        lbcAllInner.setBoundLabelText(this.getMLS("allInner", "\u5185\u90e8"));
        lbcNoLine.setBoundLabelAlignment(1);
        lbcAllOuter.setBoundLabelAlignment(1);
        lbcAllInner.setBoundLabelAlignment(1);
        lbcNoLine.setBoundLabelLength(20);
        lbcAllOuter.setBoundLabelLength(20);
        lbcAllInner.setBoundLabelLength(20);
        this.add((Component)labPreset);
        this.add((Component)sprPreset);
        this.add((Component)lbcNoLine);
        this.add((Component)lbcAllOuter);
        this.add((Component)lbcAllInner);
        this.add((Component)labBorder);
        this.add((Component)sprBorder);
        this.add((Component)((Object)this.panPreview));
        this.add(this.btnTop);
        this.add(this.btnInnerH);
        this.add(this.btnBottom);
        this.add(this.btnLeft);
        this.add(this.btnInnerV);
        this.add(this.btnRight);
        this.add((Component)((Object)this.panLineSupply));
        this.setLayout(null);
        labPreset.setBounds(8, 8, 50, 20);
        sprPreset.setBounds(50, 18, 240, 2);
        lbcNoLine.setBounds(60, 25, 40, 60);
        lbcAllOuter.setBounds(140, 25, 40, 60);
        lbcAllInner.setBounds(220, 25, 40, 60);
        labBorder.setBounds(8, 85, 50, 20);
        sprBorder.setBounds(50, 95, 240, 2);
        this.panPreview.setBounds(70, 110, 190, 130);
        this.btnTop.setBounds(30, 110, 30, 30);
        this.btnInnerH.setBounds(30, 160, 30, 30);
        this.btnBottom.setBounds(30, 210, 30, 30);
        this.btnLeft.setBounds(80, 250, 30, 30);
        this.btnInnerV.setBounds(150, 250, 30, 30);
        this.btnRight.setBounds(220, 250, 30, 30);
        this.panLineSupply.setBounds(300, 10, 150, 270);
    }

    public Dimension getPreferredSize() {
        return new Dimension(454, 288);
    }

    private void installListener() {
        ActionHandler actionHandler = new ActionHandler();
        this.btnNoLine.addActionListener((ActionListener)actionHandler);
        this.btnAllOuter.addActionListener((ActionListener)actionHandler);
        this.btnAllInner.addActionListener((ActionListener)actionHandler);
        this.btnTop.addActionListener(actionHandler);
        this.btnBottom.addActionListener(actionHandler);
        this.btnLeft.addActionListener(actionHandler);
        this.btnRight.addActionListener(actionHandler);
        this.btnInnerH.addActionListener(actionHandler);
        this.btnInnerV.addActionListener(actionHandler);
    }

    private void preView(Graphics2D g) {
        int w = this.panPreview.getWidth();
        int h = this.panPreview.getHeight();
        if (this.rect == null) {
            this.rect = new Rectangle(20, 20, w - 40, h - 40);
        }
        int drawBorderMark = 0;
        if (this.sa.isUnsureValue(StyleAttributes.BORDER_TOP_COLOR) || this.sa.isUnsureValue(StyleAttributes.BORDER_TOP_PENSTYLE) || this.sa.isUnsureValue(StyleAttributes.BORDER_TOP_LINESTYLE)) {
            this.initUnsurePen(g);
            g.drawLine(20, 20, w - 20, 20);
        } else {
            drawBorderMark += 2;
        }
        if (this.sa.isUnsureValue(StyleAttributes.BORDER_BOTTOM_COLOR) || this.sa.isUnsureValue(StyleAttributes.BORDER_BOTTOM_PENSTYLE) || this.sa.isUnsureValue(StyleAttributes.BORDER_BOTTOM_LINESTYLE)) {
            this.initUnsurePen(g);
            g.drawLine(20, h - 20, w - 20, h - 20);
        } else {
            drawBorderMark += 8;
        }
        if (this.sa.isUnsureValue(StyleAttributes.BORDER_LEFT_COLOR) || this.sa.isUnsureValue(StyleAttributes.BORDER_LEFT_PENSTYLE) || this.sa.isUnsureValue(StyleAttributes.BORDER_LEFT_LINESTYLE)) {
            this.initUnsurePen(g);
            g.drawLine(20, 20, 20, h - 20);
        } else {
            ++drawBorderMark;
        }
        if (this.sa.isUnsureValue(StyleAttributes.BORDER_RIGHT_COLOR) || this.sa.isUnsureValue(StyleAttributes.BORDER_RIGHT_PENSTYLE) || this.sa.isUnsureValue(StyleAttributes.BORDER_RIGHT_LINESTYLE)) {
            this.initUnsurePen(g);
            g.drawLine(w - 20, 20, w - 20, h - 20);
        } else {
            drawBorderMark += 4;
        }
        if (this.isInnerHEnabled) {
            if (this.getInnerBorder().getSA().isUnsureValue(this.getInnerBorder().BORDER_H_COLOR) || this.getInnerBorder().getSA().isUnsureValue(this.getInnerBorder().BORDER_H_PENSTYLE) || this.getInnerBorder().getSA().isUnsureValue(this.getInnerBorder().BORDER_H_LINESTYLE)) {
                this.initUnsurePen(g);
                g.drawLine(20, h / 2, w - 20, h / 2);
            } else if (this.getInnerBorder().getSA().getBorderLineStyle(this.getInnerBorder().HORIZONTAL) != LineStyle.NULL_LINE) {
                this.br.setAutoSetMode(false);
                this.br.setCalcFactor(false);
                this.br.draw(g, new Rectangle(20, h / 2, w - 40, 0), new BorderRender.BorderInfo(this.getInnerBorder().DRAW_H), this.getInnerBorder().getStyle());
                this.br.setCalcFactor(true);
                this.br.setAutoSetMode(true);
            }
        }
        if (this.isInnerVEnabled()) {
            if (this.getInnerBorder().getSA().isUnsureValue(this.getInnerBorder().BORDER_V_COLOR) || this.getInnerBorder().getSA().isUnsureValue(this.getInnerBorder().BORDER_V_PENSTYLE) || this.getInnerBorder().getSA().isUnsureValue(this.getInnerBorder().BORDER_V_LINESTYLE)) {
                this.initUnsurePen(g);
                g.drawLine(w / 2, 20, w / 2, h - 20);
            } else if (this.getInnerBorder().getSA().getBorderLineStyle(this.getInnerBorder().VERTICAL) != LineStyle.NULL_LINE) {
                this.br.setCalcFactor(false);
                this.br.setAutoSetMode(false);
                this.br.draw(g, new Rectangle(w / 2, 20, 0, h - 40), new BorderRender.BorderInfo(this.getInnerBorder().DRAW_V), this.getInnerBorder().getStyle());
                this.br.setCalcFactor(true);
                this.br.setAutoSetMode(true);
            }
        }
        this.br.draw(g, this.rect, new BorderRender.BorderInfo(drawBorderMark), StyleDesignerUtil.getStyle4Paint());
    }

    private void initUnsurePen(Graphics2D g) {
        g.setStroke(PenStyle.PS_CONTINUOUS.getStroke(2));
        g.setColor(Color.LIGHT_GRAY);
    }

    private void showValue(boolean isSyncSupply) {
        this.showOutterValue();
        this.showInnerValue();
        if (isSyncSupply) {
            this.panLineSupply.showValue(this.sa);
        }
    }

    private void showOutterValue() {
        if (this.sa.isUnsureValue(StyleAttributes.BORDER_TOP_COLOR) || this.sa.isUnsureValue(StyleAttributes.BORDER_TOP_PENSTYLE) || this.sa.isUnsureValue(StyleAttributes.BORDER_TOP_LINESTYLE) || this.sa.getBorderLineStyle(Styles.Position.TOP) == LineStyle.NULL_LINE) {
            this.btnTop.setSelected(false);
        } else {
            this.btnTop.setSelected(true);
        }
        if (this.sa.isUnsureValue(StyleAttributes.BORDER_BOTTOM_COLOR) || this.sa.isUnsureValue(StyleAttributes.BORDER_BOTTOM_PENSTYLE) || this.sa.isUnsureValue(StyleAttributes.BORDER_BOTTOM_LINESTYLE) || this.sa.getBorderLineStyle(Styles.Position.BOTTOM) == LineStyle.NULL_LINE) {
            this.btnBottom.setSelected(false);
        } else {
            this.btnBottom.setSelected(true);
        }
        if (this.sa.isUnsureValue(StyleAttributes.BORDER_LEFT_COLOR) || this.sa.isUnsureValue(StyleAttributes.BORDER_LEFT_PENSTYLE) || this.sa.isUnsureValue(StyleAttributes.BORDER_LEFT_LINESTYLE) || this.sa.getBorderLineStyle(Styles.Position.LEFT) == LineStyle.NULL_LINE) {
            this.btnLeft.setSelected(false);
        } else {
            this.btnLeft.setSelected(true);
        }
        if (this.sa.isUnsureValue(StyleAttributes.BORDER_RIGHT_COLOR) || this.sa.isUnsureValue(StyleAttributes.BORDER_RIGHT_PENSTYLE) || this.sa.isUnsureValue(StyleAttributes.BORDER_RIGHT_LINESTYLE) || this.sa.getBorderLineStyle(Styles.Position.RIGHT) == LineStyle.NULL_LINE) {
            this.btnRight.setSelected(false);
        } else {
            this.btnRight.setSelected(true);
        }
    }

    private void showInnerValue() {
        if (this.isInnerHEnabled()) {
            this.btnInnerH.setEnabled(true);
        } else {
            this.btnInnerH.setEnabled(false);
        }
        if (this.isInnerVEnabled()) {
            this.btnInnerV.setEnabled(true);
        } else {
            this.btnInnerV.setEnabled(false);
        }
        if (this.isInnerHEnabled() || this.isInnerVEnabled()) {
            this.btnAllInner.setEnabled(true);
        } else {
            this.btnAllInner.setEnabled(false);
        }
        if (!this.isInnerHEnabled() || this.getInnerBorder().getSA().isUnsureValue(this.getInnerBorder().BORDER_H_COLOR) || this.getInnerBorder().getSA().isUnsureValue(this.getInnerBorder().BORDER_H_PENSTYLE) || this.getInnerBorder().getSA().isUnsureValue(this.getInnerBorder().BORDER_H_LINESTYLE) || this.getInnerBorder().getSA().getBorderLineStyle(this.getInnerBorder().HORIZONTAL) == LineStyle.NULL_LINE) {
            this.btnInnerH.setSelected(false);
        } else {
            this.btnInnerH.setSelected(true);
        }
        if (!this.isInnerVEnabled() || this.getInnerBorder().getSA().isUnsureValue(this.getInnerBorder().BORDER_V_COLOR) || this.getInnerBorder().getSA().isUnsureValue(this.getInnerBorder().BORDER_V_PENSTYLE) || this.getInnerBorder().getSA().isUnsureValue(this.getInnerBorder().BORDER_V_LINESTYLE) || this.getInnerBorder().getSA().getBorderLineStyle(this.getInnerBorder().VERTICAL) == LineStyle.NULL_LINE) {
            this.btnInnerV.setSelected(false);
        } else {
            this.btnInnerV.setSelected(true);
        }
    }

    private String getMLS(String key, String defaultValue) {
        return CtrlCommonUIMessages.getMLS(key, defaultValue);
    }

    public boolean isInnerHEnabled() {
        return this.isInnerHEnabled;
    }

    public void setInnerHEnabled(boolean b) {
        this.isInnerHEnabled = b;
    }

    public boolean isInnerVEnabled() {
        return this.isInnerVEnabled;
    }

    public void setInnerVEnabled(boolean b) {
        this.isInnerVEnabled = b;
    }

    public KDComboColor getCbcLineColor() {
        return this.panLineSupply.getCbcLineColor();
    }

    public InnerBorder getInnerBorder() {
        if (this.innerBorder == null) {
            this.innerBorder = new InnerBorder();
        }
        return this.innerBorder;
    }

    public boolean isInnerBorderChanged() {
        StyleAttributes sa = this.getInnerSA();
        return sa != null ? !sa.equals(this.oldinnersa) : false;
    }

    public void setInnerSA(StyleAttributes sa) {
        this.oldinnersa = sa;
        this.getInnerBorder().setSA(Styles.getSA(sa));
        this.showInnerValue();
    }

    public StyleAttributes getInnerSA() {
        return this.getInnerBorder().getSA();
    }

    public void setInnerBorderConstant(Styles.Position h, Styles.Position v) {
        this.getInnerBorder().setConstant(h, v);
    }

    private class PreviewPanel
    extends KDPanel {
        private static final long serialVersionUID = 1L;

        public PreviewPanel() {
            this.setBackground(new Color(239, 239, 239));
        }

        public void paint(Graphics g) {
            super.paint(g);
            BorderPane.this.preView((Graphics2D)g);
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (BorderPane.this.flagIsShowValueFireMe) {
                return;
            }
            Object source = e.getSource();
            if (source.equals(BorderPane.this.btnNoLine)) {
                this.setBorder(Styles.Position.TOP, false);
                this.setBorder(Styles.Position.BOTTOM, false);
                this.setBorder(Styles.Position.LEFT, false);
                this.setBorder(Styles.Position.RIGHT, false);
                this.setInnerBorder(BorderPane.this.getInnerBorder().HORIZONTAL, false);
                this.setInnerBorder(BorderPane.this.getInnerBorder().VERTICAL, false);
                BorderPane.this.showValue(false);
            } else if (source.equals(BorderPane.this.btnAllOuter)) {
                this.setBorder(Styles.Position.TOP, true);
                this.setBorder(Styles.Position.BOTTOM, true);
                this.setBorder(Styles.Position.LEFT, true);
                this.setBorder(Styles.Position.RIGHT, true);
                BorderPane.this.showOutterValue();
            } else if (source.equals(BorderPane.this.btnAllInner)) {
                this.setInnerBorder(BorderPane.this.getInnerBorder().HORIZONTAL, true);
                this.setInnerBorder(BorderPane.this.getInnerBorder().VERTICAL, true);
                BorderPane.this.showInnerValue();
            } else if (source.equals(BorderPane.this.btnTop)) {
                this.setBorder(Styles.Position.TOP, BorderPane.this.btnTop.isSelected());
            } else if (source.equals(BorderPane.this.btnBottom)) {
                this.setBorder(Styles.Position.BOTTOM, BorderPane.this.btnBottom.isSelected());
            } else if (source.equals(BorderPane.this.btnLeft)) {
                this.setBorder(Styles.Position.LEFT, BorderPane.this.btnLeft.isSelected());
            } else if (source.equals(BorderPane.this.btnRight)) {
                this.setBorder(Styles.Position.RIGHT, BorderPane.this.btnRight.isSelected());
            } else if (source.equals(BorderPane.this.btnInnerH)) {
                this.setInnerBorder(BorderPane.this.getInnerBorder().HORIZONTAL, BorderPane.this.btnInnerH.isSelected());
            } else if (source.equals(BorderPane.this.btnInnerV)) {
                this.setInnerBorder(BorderPane.this.getInnerBorder().VERTICAL, BorderPane.this.btnInnerV.isSelected());
            }
            BorderPane.this.panPreview.repaint();
        }

        private void setBorder(Styles.Position position, boolean isDraw) {
            if (isDraw) {
                BorderPane.this.sa.setBorderColor(position, BorderPane.this.panLineSupply.getLineColor());
                BorderPane.this.sa.setBorderPenStyle(position, BorderPane.this.panLineSupply.getPenStyle());
                BorderPane.this.sa.setBorderLineStyle(position, BorderPane.this.panLineSupply.getLineStyle());
                StyleDesignerUtil.getSa4Paint().setBorderColor(position, BorderPane.this.panLineSupply.getLineColor());
                StyleDesignerUtil.getSa4Paint().setBorderPenStyle(position, BorderPane.this.panLineSupply.getPenStyle());
                StyleDesignerUtil.getSa4Paint().setBorderLineStyle(position, BorderPane.this.panLineSupply.getLineStyle());
            } else {
                BorderPane.this.sa.setBorderLineStyle(position, LineStyle.NULL_LINE);
                StyleDesignerUtil.getSa4Paint().setBorderLineStyle(position, LineStyle.NULL_LINE);
            }
            StyleDesignerUtil.refreshStyle4Paint();
        }

        private void setInnerBorder(Styles.Position position, boolean isDraw) {
            if (isDraw) {
                BorderPane.this.getInnerBorder().getSA().setBorderColor(position, BorderPane.this.panLineSupply.getLineColor());
                BorderPane.this.getInnerBorder().getSA().setBorderPenStyle(position, BorderPane.this.panLineSupply.getPenStyle());
                BorderPane.this.getInnerBorder().getSA().setBorderLineStyle(position, BorderPane.this.panLineSupply.getLineStyle());
            } else {
                BorderPane.this.getInnerBorder().getSA().setBorderLineStyle(position, LineStyle.NULL_LINE);
            }
            BorderPane.this.getInnerBorder().syncSA4Paint();
        }
    }
}

