/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.util.style.styledesigner;

import com.kingdee.cosmic.ctrl.kdf.util.style.Rect;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.styledesigner.LazyStyleDesigner;
import com.kingdee.cosmic.ctrl.kdf.util.style.styledesigner.packing.IStylePane;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDSpinner;
import java.awt.Component;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PaddingPane
extends KDPanel
implements IStylePane {
    private StyleAttributes sa;
    private boolean flagIsShowValueFireMe;
    private KDSpinner spnPaddingTop;
    private KDSpinner spnPaddingBottom;
    private KDSpinner spnPaddingLeft;
    private KDSpinner spnPaddingRight;

    public PaddingPane() {
        this.installCompoments();
        this.installListener();
    }

    private void installCompoments() {
        SpinnerNumberModel model = new SpinnerNumberModel(1, 0, 999, 1);
        this.spnPaddingTop = new KDSpinner((SpinnerModel)model);
        model = new SpinnerNumberModel(1, 0, 999, 1);
        this.spnPaddingBottom = new KDSpinner((SpinnerModel)model);
        model = new SpinnerNumberModel(1, 0, 999, 1);
        this.spnPaddingLeft = new KDSpinner((SpinnerModel)model);
        model = new SpinnerNumberModel(1, 0, 999, 1);
        this.spnPaddingRight = new KDSpinner((SpinnerModel)model);
        KDLabel labTop = new KDLabel(this.getMLS("top", "\u4e0a\u8fb9\u8ddd"));
        KDLabel labBottom = new KDLabel(this.getMLS("bottom", "\u4e0b\u8fb9\u8ddd"));
        KDLabel labLeft = new KDLabel(this.getMLS("left", "\u5de6\u8fb9\u8ddd"));
        KDLabel labRight = new KDLabel(this.getMLS("right", "\u53f3\u8fb9\u8ddd"));
        labTop.setUnderline(true);
        labBottom.setUnderline(true);
        labLeft.setUnderline(true);
        labRight.setUnderline(true);
        this.setLayout(null);
        this.add((Component)labTop);
        this.add((Component)labBottom);
        this.add((Component)labLeft);
        this.add((Component)labRight);
        this.add((Component)this.spnPaddingTop);
        this.add((Component)this.spnPaddingBottom);
        this.add((Component)this.spnPaddingLeft);
        this.add((Component)this.spnPaddingRight);
        labTop.setBounds(10, 10, 60, 20);
        labBottom.setBounds(10, 35, 60, 20);
        labLeft.setBounds(210, 10, 60, 20);
        labRight.setBounds(210, 35, 60, 20);
        this.spnPaddingTop.setBounds(70, 10, 60, 20);
        this.spnPaddingBottom.setBounds(70, 35, 60, 20);
        this.spnPaddingLeft.setBounds(270, 10, 60, 20);
        this.spnPaddingRight.setBounds(270, 35, 60, 20);
    }

    private void installListener() {
        ChangeHandler handler = new ChangeHandler();
        this.spnPaddingTop.addChangeListener((ChangeListener)handler);
        this.spnPaddingBottom.addChangeListener((ChangeListener)handler);
        this.spnPaddingLeft.addChangeListener((ChangeListener)handler);
        this.spnPaddingRight.addChangeListener((ChangeListener)handler);
    }

    @Override
    public void setSA(StyleAttributes sa) {
        this.flagIsShowValueFireMe = true;
        this.sa = sa;
        this.showValue();
        this.flagIsShowValueFireMe = false;
    }

    private void showValue() {
        if (this.sa.isUnsureValue(StyleAttributes.PADDING)) {
            this.spnPaddingTop.setValue((Object)0);
            this.spnPaddingBottom.setValue((Object)0);
            this.spnPaddingLeft.setValue((Object)0);
            this.spnPaddingRight.setValue((Object)0);
        } else {
            this.spnPaddingTop.setValue((Object)this.sa.getPadding().getTop());
            this.spnPaddingBottom.setValue((Object)this.sa.getPadding().getBottom());
            this.spnPaddingLeft.setValue((Object)this.sa.getPadding().getLeft());
            this.spnPaddingRight.setValue((Object)this.sa.getPadding().getRight());
        }
    }

    private String getMLS(String key, String defaultValue) {
        return LazyStyleDesigner.getMLS(key, defaultValue);
    }

    private class ChangeHandler
    implements ChangeListener {
        private ChangeHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (PaddingPane.this.flagIsShowValueFireMe) {
                return;
            }
            Object source = e.getSource();
            KDSpinner spn = (KDSpinner)source;
            int value = Integer.parseInt(spn.getValue().toString());
            Rect old = PaddingPane.this.sa.isUnsureValue(StyleAttributes.PADDING) ? new Rect(0, 0, 0, 0) : PaddingPane.this.sa.getPadding();
            Rect rect = new Rect(old.getLeft(), old.getTop(), old.getRight(), old.getBottom());
            if (source == PaddingPane.this.spnPaddingTop) {
                rect.setTop(value);
            } else if (source == PaddingPane.this.spnPaddingBottom) {
                rect.setBottom(value);
            } else if (source == PaddingPane.this.spnPaddingLeft) {
                rect.setLeft(value);
            } else if (source == PaddingPane.this.spnPaddingRight) {
                rect.setRight(value);
            }
            PaddingPane.this.sa.setPadding(rect);
        }
    }
}

