/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.util.style.styledesigner;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonUIMessages;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.styledesigner.packing.IStylePane;
import com.kingdee.cosmic.ctrl.swing.KDCheckBox;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDTextArea;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;

public class ProtectionPane
extends KDPanel
implements IStylePane {
    private static final long serialVersionUID = 1L;
    private StyleAttributes sa;
    private KDCheckBox chkLocked = new KDCheckBox();
    private KDCheckBox chkHidden = new KDCheckBox();
    private KDTextArea txaPrompt = new KDTextArea();
    private boolean flagIsShowValueFireMe;

    public ProtectionPane() {
        this.initCompoments();
        this.installCompoments();
        this.installListener();
    }

    @Override
    public void setSA(StyleAttributes sa) {
        this.flagIsShowValueFireMe = true;
        this.sa = sa;
        this.showValue();
        this.flagIsShowValueFireMe = false;
    }

    private void initCompoments() {
        this.chkLocked.setSwitch(false);
        this.chkHidden.setSwitch(false);
        this.chkLocked.setText(this.getMLS("locked", "\u9501\u5b9a"));
        this.chkHidden.setText(this.getMLS("hidden", "\u9690\u85cf"));
        this.txaPrompt.setOpaque(false);
        this.txaPrompt.setEditable(false);
        this.txaPrompt.setText(this.getMLS("protectWords", "\u53ea\u6709\u5728\u4fdd\u62a4\u5de5\u4f5c\u8868\uff08\u5728\u201c\u5de5\u5177\u201d\u83dc\u5355\u680f\u4e2d\uff0c\u9009\u4e2d\u201c\u4fdd\u62a4\u201d\u4e0b\u7684\u201c\u4fdd\u62a4\u5de5\u4f5c\u8868\u201d\uff09\u540e\uff0c\u9501\u5b9a\u5355\u5143\u683c\u6216\u9690\u85cf\u516c\u5f0f\u624d\u6709\u6548\u3002"));
        this.txaPrompt.setBorder(BorderFactory.createEmptyBorder());
    }

    private void installCompoments() {
        this.add((Component)this.chkLocked);
        this.add((Component)this.chkHidden);
        this.add((Component)this.txaPrompt);
        this.setLayout(null);
        this.chkLocked.setBounds(30, 30, 80, 21);
        this.chkHidden.setBounds(30, 51, 80, 21);
        this.txaPrompt.setBounds(30, 90, 390, 150);
    }

    public void setChkHiddenVisible(boolean isHidden) {
        this.chkHidden.setVisible(isHidden);
    }

    public Dimension getPreferredSize() {
        return new Dimension(454, 290);
    }

    private void installListener() {
        ActionHandler actionHandler = new ActionHandler();
        this.chkLocked.addActionListener((ActionListener)actionHandler);
        this.chkHidden.addActionListener((ActionListener)actionHandler);
    }

    private void showValue() {
        if (this.sa.isUnsureValue(StyleAttributes.PROTECTION_LOCKED)) {
            this.chkLocked.setSelected(64);
        } else {
            this.chkLocked.setSelected(this.sa.isLocked());
        }
        if (this.sa.isUnsureValue(StyleAttributes.PROTECTION_HIDDED)) {
            this.chkHidden.setSelected(64);
        } else {
            this.chkHidden.setSelected(this.sa.isHided());
        }
    }

    private String getMLS(String key, String defaultValue) {
        return CtrlCommonUIMessages.getMLS(key, defaultValue);
    }

    public KDCheckBox getChkHidden() {
        return this.chkHidden;
    }

    public KDCheckBox getChkLocked() {
        return this.chkLocked;
    }

    public KDTextArea getPromptTextArea() {
        return this.txaPrompt;
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ProtectionPane.this.flagIsShowValueFireMe) {
                return;
            }
            Object source = e.getSource();
            if (source.equals(ProtectionPane.this.chkLocked)) {
                ProtectionPane.this.sa.setLocked(ProtectionPane.this.chkLocked.isSelected());
            } else if (source.equals(ProtectionPane.this.chkHidden)) {
                ProtectionPane.this.sa.setHided(ProtectionPane.this.chkHidden.isSelected());
            }
        }
    }
}

