/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.util.style.styledesigner;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonUIMessages;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import com.kingdee.cosmic.ctrl.kdf.util.style.styledesigner.AlignmentPane;
import com.kingdee.cosmic.ctrl.kdf.util.style.styledesigner.BorderPane;
import com.kingdee.cosmic.ctrl.kdf.util.style.styledesigner.DigitFormatPane;
import com.kingdee.cosmic.ctrl.kdf.util.style.styledesigner.FontPane;
import com.kingdee.cosmic.ctrl.kdf.util.style.styledesigner.InteriorPane;
import com.kingdee.cosmic.ctrl.kdf.util.style.styledesigner.LinePane;
import com.kingdee.cosmic.ctrl.kdf.util.style.styledesigner.ProtectionPane;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDSeparator;
import com.kingdee.cosmic.ctrl.swing.KDTabbedPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JPanel;

public class SpreadStyleDesigner
extends KDDialog {
    private KDTabbedPane tabbedPane = new KDTabbedPane();
    private KDButton btnOK = new KDButton();
    private KDButton btnCancel = new KDButton();
    private AlignmentPane panAlignment;
    private FontPane panFont;
    private BorderPane panBorder;
    private LinePane panLine;
    private InteriorPane panInterior;
    private ProtectionPane panProtection;
    private DigitFormatPane panFormat;
    private StyleAttributes sa;
    private StyleAttributes saForModify;
    private boolean isChanged;
    public static final int SHOW_ALIGNMENT = 1;
    public static final int SHOW_FONT = 2;
    public static final int SHOW_BORDER = 4;
    public static final int SHOW_INTERIOR = 8;
    public static final int SHOW_FORMAT = 16;
    public static final int SHOW_PROTECTION = 32;
    public static final int SHOW_LINE = 64;
    private int showPanel = 63;
    private static StyleAttributes sa4Paint = Styles.getDefaultSA();
    private static Style style4Paint = Styles.getStyle(sa4Paint);

    public SpreadStyleDesigner() {
        this.initComponents();
    }

    public SpreadStyleDesigner(Frame parent) {
        this(parent, true);
    }

    public SpreadStyleDesigner(Dialog parent) {
        this(parent, true);
    }

    public SpreadStyleDesigner(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public SpreadStyleDesigner(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    private void initComponents() {
        this.setSize(486, 405);
        this.setResizable(false);
        this.getContentPane().setBackground(new Color(0xD9D9D0));
        this.btnOK.setText(SpreadStyleDesigner.getMLS("ok", "\u786e\u5b9a"));
        this.btnCancel.setText(SpreadStyleDesigner.getMLS("cancel", "\u53d6\u6d88"));
        ButtonActionHandler buttonActionHandler = new ButtonActionHandler();
        this.btnOK.addActionListener((ActionListener)buttonActionHandler);
        this.btnCancel.addActionListener((ActionListener)buttonActionHandler);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SpreadStyleDesigner.this.closeDialog();
            }
        });
        JPanel tempPane = new JPanel(null);
        tempPane.setOpaque(false);
        KDSeparator separator = new KDSeparator(0);
        this.getContentPane().setLayout(null);
        this.getContentPane().add((Component)this.tabbedPane);
        this.getContentPane().add((Component)separator);
        this.getContentPane().add(tempPane);
        this.tabbedPane.setBounds(10, 10, 460, 320);
        separator.setBounds(0, 339, 480, 2);
        tempPane.setBounds(0, 350, 480, 30);
        tempPane.add((Component)this.btnOK);
        tempPane.add((Component)this.btnCancel);
        this.btnOK.setLocation(321, 0);
        this.btnCancel.setLocation(397, 0);
        this.panAlignment = new AlignmentPane();
        this.panFont = new FontPane();
        this.panBorder = new BorderPane();
        this.panLine = new LinePane();
        this.panInterior = new InteriorPane();
        this.panFormat = new DigitFormatPane();
        this.panProtection = new ProtectionPane();
        this.panProtection.getChkHidden().setEnabled(false);
        this.reAddPanel();
    }

    private void reAddPanel() {
        this.tabbedPane.removeAll();
        if ((this.showPanel & 0x10) == 16) {
            this.tabbedPane.addTab(SpreadStyleDesigner.getMLS("tabTitleFormat", "\u6570\u5b57"), (Component)((Object)this.panFormat));
        }
        if ((this.showPanel & 1) == 1) {
            this.tabbedPane.addTab(SpreadStyleDesigner.getMLS("tabTitleAlignment", "\u5bf9\u9f50"), (Component)((Object)this.panAlignment));
        }
        if ((this.showPanel & 2) == 2) {
            this.tabbedPane.addTab(SpreadStyleDesigner.getMLS("tabTitleFont", "\u5b57\u4f53"), (Component)((Object)this.panFont));
        }
        if ((this.showPanel & 4) == 4) {
            this.tabbedPane.addTab(SpreadStyleDesigner.getMLS("tabTitleBorder", "\u8fb9\u6846"), (Component)((Object)this.panBorder));
        }
        if ((this.showPanel & 0x40) == 64) {
            this.tabbedPane.addTab(SpreadStyleDesigner.getMLS("tabTitleLine", "\u7ebf\u578b"), (Component)((Object)this.panLine));
        }
        if ((this.showPanel & 8) == 8) {
            this.tabbedPane.addTab(SpreadStyleDesigner.getMLS("tabTitleInterior", "\u56fe\u6848"), (Component)((Object)this.panInterior));
        }
        if ((this.showPanel & 0x20) == 32) {
            this.tabbedPane.addTab(SpreadStyleDesigner.getMLS("tabTitleProtection", "\u4fdd\u62a4"), (Component)((Object)this.panProtection));
        }
    }

    private void closeDialog() {
        this.isChanged = false;
        this.setVisible(false);
        this.dispose();
    }

    private StyleAttributes defaultSA() {
        return Styles.getDefaultSA();
    }

    public static String getMLS(String key, String defaultValue) {
        return CtrlCommonUIMessages.getMLS(key, defaultValue);
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public void setSA(StyleAttributes sa) {
        this.sa = sa == null ? this.defaultSA() : sa;
        this.saForModify = Styles.getSA(this.sa);
        this.panAlignment.setSA(this.saForModify);
        this.panFont.setSA(this.saForModify);
        this.panBorder.setSA(this.saForModify);
        this.panLine.setSA(this.saForModify);
        this.panInterior.setSA(this.saForModify);
        this.panFormat.setSA(this.saForModify);
        this.panProtection.setSA(this.saForModify);
    }

    public StyleAttributes getSA() {
        return this.sa;
    }

    public void setInnerBorderSA(StyleAttributes sa) {
        this.panBorder.setInnerSA(sa);
    }

    public StyleAttributes getInnerBorderSA() {
        return this.panBorder.getInnerSA();
    }

    public boolean isInnerBorderChanged() {
        return this.panBorder.isInnerBorderChanged();
    }

    public AlignmentPane getPanAlignment() {
        return this.panAlignment;
    }

    public BorderPane getPanBorder() {
        return this.panBorder;
    }

    public LinePane getPanLine() {
        return this.panLine;
    }

    public FontPane getPanFont() {
        return this.panFont;
    }

    public InteriorPane getPanInterior() {
        return this.panInterior;
    }

    public ProtectionPane getPanProtection() {
        return this.panProtection;
    }

    public DigitFormatPane getPanFormat() {
        return this.panFormat;
    }

    public void setShowPanel(int show) {
        this.showPanel = show;
        this.reAddPanel();
    }

    public int getShowPanel() {
        return this.showPanel;
    }

    public KDTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public static StyleAttributes getSa4Paint() {
        return sa4Paint;
    }

    public static void refreshStyle4Paint() {
        style4Paint = Styles.getStyle(sa4Paint);
    }

    public static Style getStyle4Paint() {
        return style4Paint;
    }

    public static void copyAttr(StyleAttributes fromSA, StyleAttributes toSA, int attr) {
        toSA.put(attr, fromSA.get(attr));
    }

    public boolean isInnerHEnabled() {
        return this.panBorder.isInnerHEnabled();
    }

    public void setInnerHEnabled(boolean b) {
        this.panBorder.setInnerHEnabled(b);
    }

    public boolean isInnerVEnabled() {
        return this.panBorder.isInnerVEnabled();
    }

    public void setInnerVEnabled(boolean b) {
        this.panBorder.setInnerVEnabled(b);
    }

    public void setInnerBorderConstant(Styles.Position h, Styles.Position v) {
        this.panBorder.setInnerBorderConstant(h, v);
    }

    private class ButtonActionHandler
    implements ActionListener {
        private ButtonActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource().equals(SpreadStyleDesigner.this.btnOK)) {
                SpreadStyleDesigner.this.closeDialog();
                if (!SpreadStyleDesigner.this.sa.equals(SpreadStyleDesigner.this.saForModify)) {
                    SpreadStyleDesigner.this.sa = Styles.getSA(SpreadStyleDesigner.this.saForModify);
                    SpreadStyleDesigner.this.isChanged = true;
                }
            } else if (e.getSource().equals(SpreadStyleDesigner.this.btnCancel)) {
                SpreadStyleDesigner.this.closeDialog();
            }
        }
    }
}

