/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.res.tool.java.db;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class HqldbUtil {
    private static final Logger logger = LogUtil.getPackageLogger(HqldbUtil.class);
    Connection conn;

    public HqldbUtil(String db_file_name_prefix) throws Exception {
        Class.forName("org.hsqldb.jdbcDriver");
        this.conn = DriverManager.getConnection("jdbc:hsqldb:" + db_file_name_prefix, "sa", "");
    }

    public void shutdown() throws SQLException {
        try (Statement st = this.conn.createStatement();){
            st.execute("SHUTDOWN");
        }
    }

    public synchronized void query(String expression) throws SQLException {
        ResultSet rs = null;
        try (Statement st = this.conn.createStatement();){
            rs = st.executeQuery(expression);
            HqldbUtil.dump(rs);
        }
    }

    public synchronized void update(String expression) throws SQLException {
        try (Statement st = this.conn.createStatement();){
            int i = st.executeUpdate(expression);
            if (i == -1) {
                System.out.println("db error : " + expression);
            }
        }
    }

    public static void dump(ResultSet rs) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int colmax = meta.getColumnCount();
        Object o = null;
        while (rs.next()) {
            for (int i = 0; i < colmax; ++i) {
                o = rs.getObject(i + 1);
                System.out.print(o.toString() + " ");
            }
            System.out.println(' ');
        }
    }

    public static void main(String[] args) {
        HqldbUtil db = null;
        try {
            db = new HqldbUtil("file:eas_hsqldb;shutdown=true");
        }
        catch (Exception ex1) {
            logger.error((Object)"err", (Throwable)ex1);
            return;
        }
        try {
            db.update("CREATE TABLE sample_table ( id INTEGER IDENTITY, str_col VARCHAR(256), num_col INTEGER)");
        }
        catch (SQLException ex1) {
            // empty catch block
        }
        try {
            db.update("INSERT INTO sample_table(str_col,num_col) VALUES('Ford', 100)");
            db.update("INSERT INTO sample_table(str_col,num_col) VALUES('Toyota', 200)");
            db.update("INSERT INTO sample_table(str_col,num_col) VALUES('Honda', 300)");
            db.update("INSERT INTO sample_table(str_col,num_col) VALUES('GM', 400)");
            db.query("SELECT * FROM sample_table WHERE num_col < 250");
            db.shutdown();
        }
        catch (SQLException ex3) {
            logger.error((Object)"err", (Throwable)ex3);
        }
    }
}

