/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.res.tool.java.stat.visitor;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonUIMessages;
import com.kingdee.cosmic.ctrl.res.tool.java.parser.syntaxtree.Block;
import com.kingdee.cosmic.ctrl.res.tool.java.parser.syntaxtree.ClassBody;
import com.kingdee.cosmic.ctrl.res.tool.java.parser.syntaxtree.ConstructorDeclaration;
import com.kingdee.cosmic.ctrl.res.tool.java.parser.syntaxtree.MethodDeclaration;
import com.kingdee.cosmic.ctrl.res.tool.java.parser.syntaxtree.MethodDeclarator;
import com.kingdee.cosmic.ctrl.res.tool.java.parser.syntaxtree.NodeChoice;
import com.kingdee.cosmic.ctrl.res.tool.java.parser.syntaxtree.NodeListOptional;
import com.kingdee.cosmic.ctrl.res.tool.java.parser.syntaxtree.NodeToken;
import com.kingdee.cosmic.ctrl.res.tool.java.stat.BaseVisitor;
import java.util.HashSet;
import java.util.Set;

public class MethodVisitor
extends BaseVisitor {
    private Set usedPrivateMethod = new HashSet();
    private Set privateMethod = new HashSet();

    private String checkMethodName(String varId) {
        StringBuilder sb = new StringBuilder();
        String pp = "[a-z]([a-z_A-Z])*";
        if (!varId.matches("[a-z]([a-z_A-Z])*")) {
            sb.append(CtrlCommonUIMessages.getMLS("badMethodNaming", "\u65b9\u6cd5\u547d\u540d\u4e0d\u89c4\u8303"));
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    private boolean isPrivateMethod(NodeToken n) {
        NodeToken buf = this.bean.preToken(n);
        while (buf != null) {
            if (this.parentSequenceWith(new Class[]{NodeChoice.class, NodeListOptional.class, MethodDeclaration.class}, buf)) {
                if ("private".equals(buf.tokenImage)) {
                    return true;
                }
            } else if (this.parentIs(ClassBody.class, buf) || this.parentIs(Block.class, buf)) {
                return false;
            }
            buf = this.bean.preToken(buf);
        }
        return false;
    }

    @Override
    public void visit(NodeToken n) {
        if (n.kind == 128) {
            if (this.parentIs(MethodDeclarator.class, n)) {
                String msg;
                this.info.incMethodCount();
                if (this.isPrivateMethod(n)) {
                    this.privateMethod.add(n);
                }
                if ((msg = this.checkMethodName(n.tokenImage)) != null && msg.length() > 0) {
                    this.info.addMethodWarningList(msg, n);
                }
            } else if (this.parentIs(ConstructorDeclaration.class, n)) {
                this.info.incMethodCount();
            } else {
                this.usedPrivateMethod.add(n.tokenImage);
            }
        }
    }

    @Override
    public void finishVisit() {
        for (NodeToken n : this.privateMethod) {
            if (this.usedPrivateMethod.contains(n.tokenImage)) continue;
            this.info.addMethodWarningList(CtrlCommonUIMessages.getMLS("unusedPrivateMethod", "\u672a\u4f7f\u7528\u7684\u79c1\u6709\u65b9\u6cd5"), n);
        }
    }
}

