/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.res.tool.resscan;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonMessages;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonUIMessages;
import com.kingdee.cosmic.ctrl.common.ui.editor.styled.JavaStyledEditor;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.res.tool.resscan.CNItem;
import com.kingdee.cosmic.ctrl.res.tool.resscan.CNSScanOption;
import com.kingdee.cosmic.ctrl.res.tool.resscan.CNScanner;
import com.kingdee.cosmic.ctrl.res.tool.resscan.ItemEntity;
import com.kingdee.cosmic.ctrl.res.tool.resscan.JavaFileFormator;
import com.kingdee.cosmic.ctrl.res.tool.resscan.ResRefactoryDlg;
import com.kingdee.cosmic.ctrl.res.tool.resscan.ResScanFrame_jbScan_actionAdapter;
import com.kingdee.cosmic.ctrl.res.tool.resscan.ResScanFrame_jbSelectFile_actionAdapter;
import com.kingdee.cosmic.ctrl.res.tool.resscan.ResScanFrame_jmRefactory_actionAdapter;
import com.kingdee.cosmic.ctrl.res.tool.resscan.ResScanFrame_jmRefresh_actionAdapter;
import com.kingdee.cosmic.ctrl.res.tool.resscan.ResScanFrame_jmRemove_actionAdapter;
import com.kingdee.cosmic.ctrl.swing.KDCheckBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class ResScanFrame
extends JFrame {
    private static final Logger logger = LogUtil.getPackageLogger(ResScanFrame.class);
    private static final long serialVersionUID = 6983488193165668768L;
    private static final String configFile = "res.properties";
    private boolean canPop = false;
    private ResRefactoryDlg resDlg = new ResRefactoryDlg(this);
    JCheckBox jcbFullString = new KDCheckBox(CtrlCommonUIMessages.getMLS("matchLongStrings", "\u5339\u914d\u957f\u5b57\u7b26\u4e32"));
    JPanel contentPane;
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JPanel jPanel3 = new JPanel();
    JPanel jPanel4 = new JPanel();
    JPanel jPanel5 = new JPanel();
    JSplitPane jSplitPane1 = new JSplitPane();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jPanel6 = new JPanel();
    JPanel jPanel7 = new JPanel();
    JScrollPane jScrollPane1 = new JScrollPane();
    BorderLayout borderLayout3 = new BorderLayout();
    JTree jTree = new JTree();
    BorderLayout borderLayout4 = new BorderLayout();
    JPanel jPanel8 = new JPanel();
    JPanel jPanel9 = new JPanel();
    JButton jbScan = new JButton();
    JLabel jLabel1 = new JLabel();
    JTextField jtPath = new JTextField();
    BorderLayout borderLayout5 = new BorderLayout();
    JScrollPane jScrollPane2 = new JScrollPane();
    JTextArea jtInfo = new JTextArea();
    JButton jbSelectFile = new JButton();
    JFileChooser jcf = new JFileChooser();
    PrintStream ps;
    JSplitPane jSplitPane2 = new JSplitPane();
    JScrollPane jScrollPane3 = new JScrollPane();
    JavaStyledEditor jtJava = new JavaStyledEditor();
    JPopupMenu jpMenu = new JPopupMenu();
    JMenuItem jmRefactory = new JMenuItem();
    JMenuItem jmRefresh = new JMenuItem();
    JMenuItem jmRemove = new JMenuItem();
    GridBagLayout gridBagLayout1 = new GridBagLayout();

    public ResScanFrame() {
        this.enableEvents(64L);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            logger.error((Object)"err", (Throwable)e);
        }
        this.init();
    }

    private void loadConfig() {
        block14: {
            try {
                if (!new File(configFile).exists()) break block14;
                Properties pros = new Properties();
                try (FileInputStream is = new FileInputStream(configFile);){
                    pros.load(is);
                }
                this.jtPath.setText(pros.getProperty("search_path", "w:\\workspace\\ctrl"));
            }
            catch (Exception e) {
                logger.error((Object)"err", (Throwable)e);
            }
        }
    }

    private void saveConfig() {
        try {
            Properties pros = new Properties();
            pros.setProperty("search_path", this.jtPath.getText().trim());
            try (FileOutputStream os = new FileOutputStream(configFile);){
                pros.store(os, this.getClass().getName());
            }
        }
        catch (Exception e) {
            logger.error((Object)"err", (Throwable)e);
        }
    }

    private void init() {
        this.setDefaultCloseOperation(2);
        this.jcf.setFileSelectionMode(2);
        ResScanFrame.setFont(this);
        this.ps = new PrintStream(new ByteArrayOutputStream(){

            @Override
            public synchronized void write(byte[] b, int off, int len) {
                SwingUtilities.invokeLater(new PrintMsgRunnable(new String(b, off, len)));
            }
        });
        System.setOut(this.ps);
        System.setErr(this.ps);
        this.jTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ResScanFrame.this.onSelectTreeNode(e.getNewLeadSelectionPath());
            }
        });
        this.jTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 3 && ResScanFrame.this.canPop) {
                    ResScanFrame.this.jpMenu.show(ResScanFrame.this.jTree, e.getX(), e.getY());
                }
            }
        });
        this.jtJava.setText(CtrlCommonUIMessages.getMLS("refactoringSteps", "\u6b65\u9aa4\uff1a\n  1)\u641c\u7d22\u6e90\u4ee3\u7801\u7684\u6c49\u5b57\u7f16\u7801\n  2)\u9009\u62e9\u5de6\u8fb9\u6587\u4ef6/\u76ee\u5f55\u91cd\u6784(\u53f3\u952e\u83dc\u5355)\n      a.\u4fee\u6539\u5c5e\u6027\u8d44\u6e90\n      b.\u751f\u6210\u8d44\u6e90(\u4ea7\u751f\u4e09\u4e2a\u8d44\u6e90\u6587\u4ef6\u548c\u4e00\u4e2a\u8d44\u6e90\u5b9a\u4f4d\u7c7b)\n      c.\u91cd\u6784\u4ee3\u7801\uff0c\u6b63\u786e\u60c5\u51b5\u4e0b\u4e0d\u9700\u8981\u518d\u624b\u5de5\u4fee\u6539\u4ee3\u7801\u3002\n\n\u8bf7\u5728\u91cd\u6784\u524d\u5907\u4efd\u4ee3\u7801\u3002"));
        this.jtJava.setEditable(false);
        this.loadConfig();
    }

    private void onSelectTreeNode(TreePath tp) {
        DefaultMutableTreeNode node;
        Object obj;
        boolean bl = this.canPop = tp != null;
        if (tp != null && (obj = (node = (DefaultMutableTreeNode)tp.getLastPathComponent()).getUserObject()) instanceof CNItem) {
            this.displayNode((CNItem)obj, node.isLeaf(), node.isLeaf() ? ((CNItem)obj).getItemCount() : node.getChildCount());
        }
    }

    private void displayNode(CNItem ci, boolean isLeaf, int childCount) {
        StringBuilder sb = new StringBuilder(ci.getFile()).append(" (").append(isLeaf ? childCount + "" : childCount + CtrlCommonUIMessages.getMLS("childNodeCount", "\u4e2a\u5b50\u8282\u70b9")).append(")\n");
        if (isLeaf) {
            int m = ci.getItemCount();
            for (int i = 0; i < m; ++i) {
                ItemEntity ie = ci.getItem(i);
                sb.append("  ").append(i + 1).append(")\t").append(ie.toString2()).append("\n");
            }
        }
        sb.append(ci.getMemo());
        this.jtInfo.setText(sb.toString());
        this.jtInfo.setCaretPosition(0);
        if (new File(FilenameUtils.normalize((String)ci.getFile())).isDirectory()) {
            this.jtJava.setText(null);
        } else {
            JavaFileFormator.showCNFile(ci, (JTextPane)((Object)this.jtJava));
        }
    }

    public static void setFont(Component cc) {
        cc.setFont(new Font(CtrlCommonMessages.getMLS((String)"yahei", (String)"\u5fae\u8f6f\u96c5\u9ed1"), 0, 13));
        if (cc instanceof Container) {
            Container c = (Container)cc;
            for (int i = 0; i < c.getComponentCount(); ++i) {
                ResScanFrame.setFont(c.getComponent(i));
            }
        }
    }

    private void jbInit() throws Exception {
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(this.borderLayout1);
        this.setSize(new Dimension(800, 600));
        this.setTitle(CtrlCommonUIMessages.getMLS("sourceCodeResourceRefactoring", "\u6e90\u4ee3\u7801\u8d44\u6e90\u91cd\u6784"));
        this.jPanel1.setLayout(this.borderLayout2);
        this.jPanel6.setLayout(this.borderLayout3);
        this.jPanel7.setLayout(this.borderLayout4);
        this.jbScan.setText(CtrlCommonUIMessages.getMLS("searchChineseInSource", "\u641c\u7d22\u6e90\u4ee3\u7801\u6c49\u5b57"));
        this.jbScan.addActionListener(new ResScanFrame_jbScan_actionAdapter(this));
        this.jLabel1.setText(CtrlCommonUIMessages.getMLS("filePath", "\u6587\u4ef6/\u8def\u5f84"));
        this.jtPath.setPreferredSize(new Dimension(300, 25));
        this.jtPath.setText("");
        this.jPanel8.setLayout(this.borderLayout5);
        this.jtInfo.setEditable(false);
        this.jtInfo.setText("");
        this.jbSelectFile.setMargin(new Insets(1, 7, 1, 7));
        this.jbSelectFile.setText("...");
        this.jbSelectFile.addActionListener(new ResScanFrame_jbSelectFile_actionAdapter(this));
        this.jSplitPane2.setOrientation(0);
        this.jtJava.setText("");
        this.jmRefactory.setText(CtrlCommonUIMessages.getMLS("refactor", "\u91cd\u6784"));
        this.jmRefactory.addActionListener(new ResScanFrame_jmRefactory_actionAdapter(this));
        this.jmRefresh.setText(CtrlCommonUIMessages.getMLS("refresh", "\u5237\u65b0"));
        this.jmRefresh.addActionListener(new ResScanFrame_jmRefresh_actionAdapter(this));
        this.jmRemove.setText(CtrlCommonUIMessages.getMLS("remove", "\u79fb\u9664"));
        this.jmRemove.addActionListener(new ResScanFrame_jmRemove_actionAdapter(this));
        this.jPanel9.setLayout(this.gridBagLayout1);
        this.contentPane.add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.jSplitPane1, "Center");
        this.jSplitPane1.add((Component)this.jPanel6, "left");
        this.jPanel6.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.jTree, null);
        this.jSplitPane1.add((Component)this.jPanel7, "right");
        this.jPanel7.add((Component)this.jPanel8, "Center");
        this.jPanel8.add((Component)this.jSplitPane2, "Center");
        this.jSplitPane2.add((Component)this.jScrollPane2, "top");
        this.jSplitPane2.add((Component)this.jScrollPane3, "bottom");
        this.jScrollPane3.getViewport().add((Component)((Object)this.jtJava), null);
        this.jScrollPane2.getViewport().add((Component)this.jtInfo, null);
        this.jPanel7.add((Component)this.jPanel9, "North");
        this.jPanel9.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanel9.add((Component)this.jtPath, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 0), 0, 0));
        this.jPanel9.add((Component)this.jbSelectFile, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.jPanel9.add((Component)this.jcbFullString, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 10), 0, 0));
        this.jPanel9.add((Component)this.jbScan, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 10), 0, 0));
        this.contentPane.add((Component)this.jPanel2, "South");
        this.contentPane.add((Component)this.jPanel3, "West");
        this.contentPane.add((Component)this.jPanel4, "East");
        this.contentPane.add((Component)this.jPanel5, "North");
        this.jpMenu.add(this.jmRefactory);
        this.jpMenu.add(this.jmRefresh);
        this.jpMenu.add(this.jmRemove);
        this.jSplitPane1.setDividerLocation(200);
        this.jSplitPane2.setDividerLocation(300);
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            System.exit(0);
        }
    }

    void jbScan_actionPerformed(ActionEvent e) {
        String path = this.jtPath.getText().trim();
        if (path == null) {
            this.jtPath.requestFocus();
            return;
        }
        CNSScanOption.isFullString = this.jcbFullString.isSelected();
        ScanThread st = new ScanThread(path, false);
        st.start();
        this.saveConfig();
    }

    private void setTreeData(List list, String path, boolean append) {
        CNItem ci;
        int base;
        DefaultMutableTreeNode root;
        Collections.sort(list);
        String curSearchPath = path;
        if (append) {
            root = (DefaultMutableTreeNode)this.jTree.getModel().getRoot();
            path = (String)root.getUserObject();
        } else {
            root = new DefaultMutableTreeNode(path);
            DefaultTreeModel dm = new DefaultTreeModel(root);
            this.jTree.setModel(dm);
        }
        path = path.replace('/', '\\');
        if (new File(FilenameUtils.normalize((String)path)).isDirectory()) {
            base = path.length();
            if (path.endsWith("\\")) {
                --base;
            }
        } else {
            base = 0;
        }
        TreeSet<String> ts = new TreeSet<String>();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ci = (CNItem)list.get(i);
            if (ci.getItemCount() <= 0) continue;
            String[] s = ci.getFile().substring(base).split("\\\\");
            StringBuilder sb = new StringBuilder(ci.getFile().substring(0, base));
            for (int j = 0; j < s.length; ++j) {
                if (s[j].length() == 0) continue;
                sb.append('\\').append(s[j]);
                if (!new File(sb.toString()).isDirectory()) continue;
                ts.add(sb.toString());
            }
        }
        Iterator iter = ts.iterator();
        while (iter.hasNext()) {
            ci = new CNItem();
            ci.setDirectory(true);
            ci.setFile((String)iter.next());
            if (!ci.getFile().startsWith(path)) continue;
            if (append) {
                if (!ci.getFile().startsWith(curSearchPath)) continue;
                this.addToTree(root, ci, base);
                continue;
            }
            this.addToTree(root, ci, base);
        }
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            ci = (CNItem)list.get(i);
            if (ci.getItemCount() <= 0) continue;
            this.addToTree(root, ci, base);
        }
        if (append) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ResScanFrame.this.jTree.updateUI();
                }
            });
        }
    }

    private String buildDisplayName(String name, int base) {
        String s = name.substring(base);
        int i = s.lastIndexOf(92);
        if (i == -1) {
            return name;
        }
        return s.substring(i + 1);
    }

    private void addToTree(DefaultMutableTreeNode root, CNItem ci, int base) {
        String my = ci.getFile().substring(base);
        int level = my.length() - my.replaceAll("\\\\", "").length() + 1;
        DefaultMutableTreeNode node = new DefaultMutableTreeNode();
        ci.setDisplayName(this.buildDisplayName(ci.getFile(), base));
        node.setUserObject(ci);
        if (level == 1) {
            root.add(node);
        } else {
            DefaultMutableTreeNode pp = null;
            boolean find = false;
            String file = ci.getFile();
            Enumeration<TreeNode> en = root.breadthFirstEnumeration();
            en.nextElement();
            while (en.hasMoreElements()) {
                String r;
                int offset;
                pp = (DefaultMutableTreeNode)en.nextElement();
                CNItem obj = (CNItem)pp.getUserObject();
                if (!file.startsWith(obj.getFile() + '\\') || (offset = (r = file.substring(obj.getFile().length())).length() - r.replaceAll("\\\\", "").length()) != 1) continue;
                find = true;
                break;
            }
            if (!find) {
                pp = root;
            }
            pp.add(node);
        }
    }

    void jmRefresh_actionPerformed(ActionEvent e) {
        int i;
        DefaultMutableTreeNode[] nodes = this.getSelectedTreeNode();
        if (nodes == null) {
            this.notOnSchedul();
            return;
        }
        ArrayList<String> fList = new ArrayList<String>();
        for (int i2 = 0; i2 < nodes.length; ++i2) {
            nodes[i2].removeFromParent();
            if (!(nodes[i2].getUserObject() instanceof CNItem)) continue;
            CNItem cc = (CNItem)nodes[i2].getUserObject();
            fList.add(cc.getFile());
        }
        Collections.sort(fList);
        for (i = 0; i < fList.size(); ++i) {
            String f1 = (String)fList.get(i);
            for (int j = i + 1; j < fList.size(); ++j) {
                String f2 = (String)fList.get(j);
                if (!f2.startsWith(f1)) continue;
                fList.remove(j);
                --j;
            }
        }
        if (fList.size() > 0) {
            for (i = 0; i < fList.size(); ++i) {
                ScanThread st = new ScanThread((String)fList.get(i), true);
                st.start();
                while (!st.terminaled()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception ex) {
                        logger.error((Object)"err", (Throwable)ex);
                    }
                }
            }
        } else {
            this.notOnSchedul();
        }
    }

    void jbSelectFile_actionPerformed(ActionEvent e) {
        this.jcf.setCurrentDirectory(new File(FilenameUtils.normalize((String)this.jtPath.getText().trim())));
        if (this.jcf.showOpenDialog(this) == 0) {
            this.jtPath.setText(this.jcf.getSelectedFile().getAbsolutePath());
        }
    }

    private DefaultMutableTreeNode[] getSelectedTreeNode() {
        TreePath[] tp = this.jTree.getSelectionPaths();
        if (tp == null) {
            return null;
        }
        DefaultMutableTreeNode[] nodes = new DefaultMutableTreeNode[tp.length];
        for (int i = 0; i < tp.length; ++i) {
            nodes[i] = (DefaultMutableTreeNode)tp[i].getLastPathComponent();
        }
        return nodes;
    }

    private CNItem[] getSelectedCNItem() {
        DefaultMutableTreeNode[] node = this.getSelectedTreeNode();
        if (node != null) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < node.length; ++i) {
                Object obj = node[i].getUserObject();
                if (!(obj instanceof CNItem)) continue;
                list.add(obj);
            }
            if (list.size() == 0) {
                return null;
            }
            CNItem[] cis = new CNItem[list.size()];
            list.toArray(cis);
            return cis;
        }
        return null;
    }

    void jmRefactory_actionPerformed(ActionEvent e) {
        int i;
        DefaultMutableTreeNode[] node = this.getSelectedTreeNode();
        if (node == null) {
            this.notOnSchedul();
            return;
        }
        CNItem[] cis = null;
        ArrayList<Object> list = new ArrayList<Object>();
        for (i = 0; i < node.length; ++i) {
            Enumeration<TreeNode> em = node[i].depthFirstEnumeration();
            while (em.hasMoreElements()) {
                Object cc = ((DefaultMutableTreeNode)em.nextElement()).getUserObject();
                if (!(cc instanceof CNItem) || ((CNItem)cc).isDirectory()) continue;
                list.add(cc);
            }
        }
        if (list.size() == 0) {
            System.out.println("[Info] No file for refactory!");
        } else {
            System.out.println("\n[Refactory files]");
            int n = list.size();
            for (i = 0; i < n; ++i) {
                System.out.println(((CNItem)list.get(i)).getFile());
            }
        }
        cis = new CNItem[list.size()];
        list.toArray(cis);
        String rootPath = (String)((DefaultMutableTreeNode)this.jTree.getModel().getRoot()).getUserObject();
        if (this.resDlg.showDlg(rootPath, cis)) {
            this.onSelectTreeNode(this.jTree.getSelectionPath());
        }
    }

    private void notOnSchedul() {
        System.out.println("Current node not on schedul.");
    }

    void jmRemove_actionPerformed(ActionEvent e) {
        DefaultMutableTreeNode[] nodes;
        if (this.getSelectedCNItem() == null) {
            this.notOnSchedul();
            return;
        }
        if (JOptionPane.showConfirmDialog(this, "\u786e\u5b9a\u628a\u5f53\u524d\u8282\u70b9\u4ece\u6811\u4e2d\u5220\u9664\u5417\uff1f", CtrlCommonUIMessages.getMLS("remove", "\u79fb\u9664"), 0, 3) == 0 && (nodes = this.getSelectedTreeNode()) != null) {
            this.removeNode(nodes);
        }
    }

    private void removeNode(DefaultMutableTreeNode[] node) {
        for (int i = 0; i < node.length; ++i) {
            node[i].removeFromParent();
        }
        this.canPop = false;
        this.jTree.updateUI();
    }

    class ScanThread
    extends Thread {
        private String path;
        private boolean append;
        private boolean terminaled = false;

        ScanThread(String path, boolean append) {
            this.path = path;
            this.append = append;
        }

        @Override
        public void run() {
            try {
                this.init();
                List list = CNScanner.analyseSrcPath(this.path, ".+\\.java", new PrintWriter(System.out));
                System.out.println("\u6b63\u5728\u6784\u9020\u6811...");
                ResScanFrame.this.setTreeData(list, this.path, this.append);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                logger.error((Object)"err", (Throwable)e);
            }
            finally {
                this.myFinal();
            }
        }

        public boolean terminaled() {
            return this.terminaled;
        }

        private void init() {
            this.terminaled = false;
            ResScanFrame.this.jtInfo.setText(null);
            ResScanFrame.this.jTree.setEnabled(false);
            ResScanFrame.this.jtPath.setEnabled(false);
            ResScanFrame.this.jbSelectFile.setEnabled(false);
            ResScanFrame.this.jbScan.setEnabled(false);
        }

        private void myFinal() {
            this.terminaled = true;
            ResScanFrame.this.jTree.setEnabled(true);
            ResScanFrame.this.jtPath.setEnabled(true);
            ResScanFrame.this.jbSelectFile.setEnabled(true);
            ResScanFrame.this.jbScan.setEnabled(true);
            System.out.println("\u641c\u7d22\u5b8c\u6bd5\uff01");
            ResScanFrame.this.jTree.expandRow(0);
        }
    }

    class PrintMsgRunnable
    implements Runnable {
        String msg;

        PrintMsgRunnable(String aMsg) {
            this.msg = aMsg;
        }

        @Override
        public void run() {
            ResScanFrame.this.jtInfo.append(this.msg);
            ResScanFrame.this.jtInfo.setCaretPosition(ResScanFrame.this.jtInfo.getDocument().getLength());
        }
    }
}

