/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.ext.IExtStatusBarManager;
import com.kingdee.cosmic.ctrl.ext.KDExt;
import com.kingdee.cosmic.ctrl.kds.model.struct.event.BookChangeEvent;
import com.kingdee.cosmic.ctrl.kds.model.struct.event.SheetChangeEvent;
import com.kingdee.cosmic.ctrl.kds.model.struct.event.SheetPropertyChangeEvent;
import com.kingdee.cosmic.ctrl.swing.ISimpleStatusBarRenderer;
import com.kingdee.cosmic.ctrl.swing.KDStatusBar;
import com.kingdee.cosmic.ctrl.swing.SimpleStatusBarPart;
import com.kingdee.cosmic.ctrl.swing.SimpleStatusBarRenderer;
import com.kingdee.cosmic.ctrl.workbench.logic.PerspectiveChangeEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public final class ExtStatusBarManager
implements IExtStatusBarManager {
    private static final Logger logger = LogUtil.getPackageLogger(ExtStatusBarManager.class);
    private KDStatusBar statusBar;
    private KDExt _ext;
    private SimpleStatusBarPart part;

    public ExtStatusBarManager(KDExt ext) {
        this._ext = ext;
        this._ext.setStatusBar(this.getStatusBar());
    }

    public SimpleStatusBarPart createStatusPart_State(KDStatusBar statusBar) {
        this.part = new SimpleStatusBarPart(statusBar);
        this.part.setPreferredSize(new Dimension(300, 30));
        this.part.setHgrap(0);
        SimpleStatusBarRenderer render = new SimpleStatusBarRenderer();
        this.part.addRenderer((ISimpleStatusBarRenderer)render, (Object)"state");
        return this.part;
    }

    private KDStatusBar createDefaultStatusBar() {
        this.statusBar = new KDStatusBar();
        this.statusBar.addPart(this.createStatusPart_State(this.statusBar));
        return this.statusBar;
    }

    public KDStatusBar getStatusBar() {
        if (this.statusBar == null) {
            this.statusBar = this.createDefaultStatusBar();
        }
        return this.statusBar;
    }

    @Override
    public void changed(BookChangeEvent e) {
    }

    @Override
    public void changed(SheetChangeEvent e) {
    }

    @Override
    public void changed(SheetPropertyChangeEvent e) {
    }

    @Override
    public boolean show(Component parent, String title, String msg, int msgType) {
        final JLabel barLabel = (JLabel)this.getStatusBar().getPart(0).getRenderer(0).getComponent(this.getStatusBar());
        final Color bg = msgType == 2 ? Color.yellow : (msgType == 0 ? Color.red : (msgType == 1 ? Color.GREEN : Color.PINK));
        barLabel.setText(msg);
        new Thread(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 3; ++i) {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                barLabel.setBackground(bg);
                                barLabel.setOpaque(true);
                                barLabel.repaint();
                            }
                        });
                        Thread.sleep(200L);
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                barLabel.setOpaque(false);
                                barLabel.repaint();
                            }
                        });
                        Thread.sleep(200L);
                        continue;
                    }
                    catch (Exception e) {
                        logger.error((Object)"err", (Throwable)e);
                    }
                }
            }
        }).start();
        return true;
    }

    public void perspectiveChanged(PerspectiveChangeEvent e) {
    }

    public SimpleStatusBarPart getPart() {
        return this.part;
    }
}

