/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.ext.ExtActionManager;
import com.kingdee.cosmic.ctrl.ext.IExtWizardManager;
import com.kingdee.cosmic.ctrl.ext.KDExt;
import com.kingdee.cosmic.ctrl.ext.immit.ReportProperties;
import com.kingdee.cosmic.ctrl.ext.immit.ShowcaseConfig;
import com.kingdee.cosmic.ctrl.ext.rd.RptPerspective;
import com.kingdee.cosmic.ctrl.ext.ui.icons.ResourceManager;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.showcase.ReportViewConstraintsWizard;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import com.kingdee.cosmic.ctrl.ext.util.ShowcaseUtil;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.cosmic.ctrl.kds.io.BookIOUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.workbench.logic.PerspectiveChangeEvent;
import com.kingdee.cosmic.ctrl.workbench.ui.Perspective;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import org.apache.log4j.Logger;

class SaveAsAction
extends AbstractAction {
    private static final Logger logger = LogUtil.getPackageLogger(SaveAsAction.class);
    private KDExt _ext;
    private ISpreadWizzard wizardViewConstraints;

    SaveAsAction(KDExt ext) {
        this._ext = ext;
        this.putValue("Name", ExtActionManager.getLocalText("saveAs", "\u53e6\u5b58\u4e3a"));
        this.putValue("ShortDescription", ExtActionManager.getLocalText("saveAs", "\u53e6\u5b58\u4e3a"));
        this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_Saveas.gif"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SpreadContext context = MiscUtil.getActiveSpreadContext(this._ext);
        try {
            ReportProperties rp;
            String fileName;
            context.getStateManager().stopEditing();
            Perspective perspective = this._ext.getPerspective("Report Designer", false);
            if (perspective != null) {
                ((RptPerspective)perspective).getBeanBindManager().commitPropertySheetPanels();
            }
            if (this.wizardViewConstraints == null) {
                this.wizardViewConstraints = this._ext.getExtWizardManager().getWizard(IExtWizardManager.Wizard_ReportViewConstraints);
            }
            ShowcaseConfig config = null;
            if (this.wizardViewConstraints instanceof ReportViewConstraintsWizard) {
                config = ((ReportViewConstraintsWizard)this.wizardViewConstraints).getDefaultShowcaseConfig();
            }
            if (config != null) {
                config.setRowSpans(null);
                config.setColSpans(null);
            }
            Book book = context.getBook();
            book.setUserObject("ShowcaseConfigTemplet", config == null ? ShowcaseUtil.toShowcaseConfig(new ShowcaseConfig().toElement()) : ShowcaseUtil.toShowcaseConfig(config.toElement()));
            if (this._ext.getExtCallback().saveReportData(BookIOUtil.pack(context.getBook()), true)) {
                this.showStatusMsg(CtrlEXTMessages.getMLS("saveSuccessMsg", "\u4fdd\u5b58\u6210\u529f\uff01"), 1);
                context.getBook().getUndoManager().discardAllEdits();
            }
            if ((fileName = (rp = this._ext.getExtCallback().fetchCurrentReportProperties()).getName()) != null) {
                book.setName(fileName);
            }
            this._ext.getIExtMenuManager().perspectiveChanged(new PerspectiveChangeEvent(perspective, perspective));
            this._ext.getIExtToolbarManager().perspectiveChanged(new PerspectiveChangeEvent(perspective, perspective));
        }
        catch (IOException e1) {
            this.showStatusMsg(CtrlEXTMessages.getMLS("saveFailedMsg", "\u4fdd\u5b58\u5931\u8d25\uff01"), 0);
            logger.error((Object)"err", (Throwable)e1);
        }
    }

    private void showStatusMsg(final String msg, final int msgtype) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                SaveAsAction.this._ext.getExtStatusBarManager().show(null, "", msg, msgtype);
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    logger.error((Object)"error", (Throwable)e);
                }
                SaveAsAction.this._ext.getExtStatusBarManager().show(null, "", "", 1);
            }
        }).start();
    }
}

