/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.fulfil;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.common.i18n.model.MultiLangEnumBridge;
import com.kingdee.cosmic.ctrl.common.hyperlink.HyperLinkHandler;
import com.kingdee.cosmic.ctrl.common.hyperlink.IHyperLinkExec;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonMessages;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.cosmic.ctrl.common.ui.worker.LongTaskWorker;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.fulfil.ExecutorUtil;
import com.kingdee.cosmic.ctrl.ext.fulfil.ExportChooserDialog;
import com.kingdee.cosmic.ctrl.ext.fulfil.ExportUtil;
import com.kingdee.cosmic.ctrl.ext.fulfil.HyperLinkExecFactory;
import com.kingdee.cosmic.ctrl.ext.fulfil.SnapReportControlModel;
import com.kingdee.cosmic.ctrl.ext.fulfil.TransitionException;
import com.kingdee.cosmic.ctrl.ext.immit.AbstractExecutableHyperLinkExec;
import com.kingdee.cosmic.ctrl.ext.immit.IExtRuntimeDataProvider;
import com.kingdee.cosmic.ctrl.ext.immit.IRptRuntimeCallback;
import com.kingdee.cosmic.ctrl.ext.immit.ReportProperties;
import com.kingdee.cosmic.ctrl.ext.immit.SavedSpan;
import com.kingdee.cosmic.ctrl.ext.immit.ShowcaseConfig;
import com.kingdee.cosmic.ctrl.ext.immit.ShowcaseConfigCollection;
import com.kingdee.cosmic.ctrl.ext.immit.filter.IExtDatasetFilter;
import com.kingdee.cosmic.ctrl.ext.rd.celltree.CellTreeRenderModel4UI;
import com.kingdee.cosmic.ctrl.ext.rd.celltree.CellTreeSpreadCellTextRender;
import com.kingdee.cosmic.ctrl.ext.reporting.ReportingFactory;
import com.kingdee.cosmic.ctrl.ext.reporting.model.CommitType;
import com.kingdee.cosmic.ctrl.ext.reporting.model.design.IReportingModel;
import com.kingdee.cosmic.ctrl.ext.reporting.model.runtime.action.CommitBookAction;
import com.kingdee.cosmic.ctrl.ext.reporting.model.runtime.action.DeleteReportingDataAction;
import com.kingdee.cosmic.ctrl.ext.reporting.model.runtime.action.ExecutionLogManageAction;
import com.kingdee.cosmic.ctrl.ext.reporting.model.runtime.action.InsertReportingDataAction;
import com.kingdee.cosmic.ctrl.ext.reporting.model.runtime.editor.ExtReportingRuntimeCellEditorProvider;
import com.kingdee.cosmic.ctrl.ext.subrpt.SubReportInfo;
import com.kingdee.cosmic.ctrl.ext.ui.icons.ResourceManager;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.io.ExportSnapshotAction;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.io.OpenSnapshotAction;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.scheduler.WizardScheduler;
import com.kingdee.cosmic.ctrl.ext.util.MessageUtil;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import com.kingdee.cosmic.ctrl.ext.util.ShowcaseUtil;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.kdf.excel.AbstractDataWrapper;
import com.kingdee.cosmic.ctrl.kdf.excel.ui.Excel2007ExportController;
import com.kingdee.cosmic.ctrl.kdf.export.ExportManager;
import com.kingdee.cosmic.ctrl.kdf.export.ExporterParameter;
import com.kingdee.cosmic.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.cosmic.ctrl.kds.core.ICellDisplayProvider;
import com.kingdee.cosmic.ctrl.kds.core.IMouseController;
import com.kingdee.cosmic.ctrl.kds.core.KDSpread;
import com.kingdee.cosmic.ctrl.kds.core.OutlineGroupColHeaderUI;
import com.kingdee.cosmic.ctrl.kds.core.OutlineGroupRowHeaderUI;
import com.kingdee.cosmic.ctrl.kds.core.SpreadView;
import com.kingdee.cosmic.ctrl.kds.exec.ExecutionContext;
import com.kingdee.cosmic.ctrl.kds.exec.ExtExecutor;
import com.kingdee.cosmic.ctrl.kds.expans.event.ExtSheetChangeListener;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSetManager;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSetType;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.IExtDataSetFactory;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.FileFactory;
import com.kingdee.cosmic.ctrl.kds.frame.MvpViewManager;
import com.kingdee.cosmic.ctrl.kds.impl.PopMenuManager;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.impl.action.SpreadAction;
import com.kingdee.cosmic.ctrl.kds.impl.facade.MultiLanguageKeys;
import com.kingdee.cosmic.ctrl.kds.impl.facade.PromptPanel;
import com.kingdee.cosmic.ctrl.kds.impl.facade.tip.AbstractTipPanel;
import com.kingdee.cosmic.ctrl.kds.impl.facade.tip.DefaultTipPanel;
import com.kingdee.cosmic.ctrl.kds.impl.facade.tip.SpreadBorderLayout;
import com.kingdee.cosmic.ctrl.kds.impl.state.mouse.ColMouseController;
import com.kingdee.cosmic.ctrl.kds.impl.state.mouse.RowMouseController;
import com.kingdee.cosmic.ctrl.kds.impl.state.mouse.TableMouseController;
import com.kingdee.cosmic.ctrl.kds.io.BookIOUtil;
import com.kingdee.cosmic.ctrl.kds.io.kds.AuthorizationFailedException;
import com.kingdee.cosmic.ctrl.kds.io.kds.BookToKds;
import com.kingdee.cosmic.ctrl.kds.io.util.DiagonalHeaderImageUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.Protection;
import com.kingdee.cosmic.ctrl.kds.model.struct.Range;
import com.kingdee.cosmic.ctrl.kds.model.struct.Row;
import com.kingdee.cosmic.ctrl.kds.model.struct.Selection;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.cosmic.ctrl.kds.model.struct.SortedAttributeSpanArray;
import com.kingdee.cosmic.ctrl.kds.model.struct.Span;
import com.kingdee.cosmic.ctrl.kds.model.struct.UserObject;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.EChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.display.FlashChartDisplayResolver;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.EmbedImage;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.IImageModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.ReferredImageModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.ReferredImageResult;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.subrpt.SubReportEmbed;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.subrpt.SubReportGuiExecutor;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.subrpt.SubReportSpreadContext;
import com.kingdee.cosmic.ctrl.kds.model.struct.event.SheetChangeEvent;
import com.kingdee.cosmic.ctrl.kds.model.struct.event.SheetChangeListener;
import com.kingdee.cosmic.ctrl.kds.model.struct.filter.AlgorithmUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.NamedObjectNode;
import com.kingdee.cosmic.ctrl.kds.nio.BookDataWrapper;
import com.kingdee.cosmic.ctrl.kds.print.MultiPrintJobProvider;
import com.kingdee.cosmic.ctrl.kds.print.PrintBookTrans;
import com.kingdee.cosmic.ctrl.kds.print.PrintManager;
import com.kingdee.cosmic.ctrl.kds.util.JsonUtil;
import com.kingdee.cosmic.ctrl.print.KDPrinter;
import com.kingdee.cosmic.ctrl.print.extend.IMultiPrintJobProvider;
import com.kingdee.cosmic.ctrl.print.extend.MultiPrintJobManager;
import com.kingdee.cosmic.ctrl.print.io.PdfExport;
import com.kingdee.cosmic.ctrl.res.Resource;
import com.kingdee.cosmic.ctrl.swing.ISimpleStatusBarRenderer;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDCheckBox;
import com.kingdee.cosmic.ctrl.swing.KDComboBox;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDFrame;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDLabelContainer;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDPopupMenu;
import com.kingdee.cosmic.ctrl.swing.KDProgressBar;
import com.kingdee.cosmic.ctrl.swing.KDPromptBox;
import com.kingdee.cosmic.ctrl.swing.KDPromptSelector;
import com.kingdee.cosmic.ctrl.swing.KDScrollPane;
import com.kingdee.cosmic.ctrl.swing.KDSeparator;
import com.kingdee.cosmic.ctrl.swing.KDStatusBar;
import com.kingdee.cosmic.ctrl.swing.KDTextField;
import com.kingdee.cosmic.ctrl.swing.KDToolBar;
import com.kingdee.cosmic.ctrl.swing.KDTree;
import com.kingdee.cosmic.ctrl.swing.KDWorkButton;
import com.kingdee.cosmic.ctrl.swing.SimpleStatusBarPart;
import com.kingdee.cosmic.ctrl.swing.SimpleStatusBarRenderer;
import com.kingdee.cosmic.ctrl.swing.event.AncestorAdapter;
import com.kingdee.cosmic.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.cosmic.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.cosmic.ctrl.swing.util.SimpleFileFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.SocketException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JToolBar;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;

public class ExtGuiExecutor {
    private static final Logger logger = LogUtil.getPackageLogger(ExtGuiExecutor.class);
    public static final String KEY_TITLE = "title";
    public static final String KEY_INFO_TITLE = "infoTitle";
    public static final String KEY_REFRESH = "refresh";
    public static final String KEY_FILTER = "filter";
    public static final String KEY_FILE = "file";
    public static final String KEY_EXPORT = "export";
    public static final String KEY_EXPORT2EXCEL = "exportToExcel";
    public static final String KEY_EXPORT2EXCEL2007 = "exportToExcel2007";
    public static final String Key_ErrorOnSaveFile = "errorOnSaveFile";
    public static final String Key_ErrorOnOpenFile = "errorOnOpenFile";
    public static final String Key_ErrorOnCreateTempFile = "Key_ErrorOnCreateTempFile";
    public static final String XLS = "xls";
    public static final String XLSX = "xlsx";
    public static final String XML = "xml";
    public static final String PDF = "pdf";
    public static final String KDS = "kds";
    public static final String ISPREVIEW = "isPreview";
    public static final String KEY_SAVE_SNAPSHOT = "saveSnapshot";
    public static final String KEY_REPORT_SNAPSHOT = "reportSnapshot";
    public static final String KEY_AUTOREFRESH = "autoRefresh";
    public static final String KEY_REPORT_DISPLAY_SCHEME = "reportDisplayScheme";
    public static final String KEY_DATA_FILTERING = "dataFiltering";
    public static final String KEY_AUTOFILTER = "autoFilter";
    public static final String KEY_SHOW_ALL = "showAll";
    public static final String KEY_ADVANCED_FILTERING = "advancedFitltering";
    public static final int ALL_ACTIONS = 0;
    public static final int FILTER_ACTIONS = 1;
    public static final int PRINT_ACTIONS = 2;
    public static final int EXPORT_ACTIONS = 3;
    public static final int SNAPSHOT_VIEW_ACTIONS = 4;
    public static final int NON_SNAPSHOT_ACTIONS = 5;
    public static final int CONFIG_ACTIONS = 6;
    public static final int SAVE_SNAPSHOT_ACTIONS = 7;
    private SpreadContext _context;
    private ProgressbarGlassPane progressGlasspane;
    private Action[] _contextualActions;
    private ShowcaseConfigCollection _showcaseConfigs;
    private ExternalAuthentificator authentificator;
    private KDFrame _frame;
    protected Book _book;
    private byte[] _bookData;
    protected IExtRuntimeDataProvider _dataProvider;
    protected boolean _limit;
    private boolean _isSnapshot;
    private boolean _needExternalAuthorization;
    private SubReportGuiExecutor _subRptExecutor;
    private ShowcaseConfig templetConfig;
    private ShowcaseConfig defaultConfig;
    private long rptRunStart;
    private ProgressbarGlassPane progressGlasspane2;

    public static String getLocalText(String key) {
        return CtrlEXTMessages.getMLS(key, "NotFound");
    }

    public ShowcaseConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public long getRptRunStatt() {
        return this.rptRunStart;
    }

    public KDFrame getKDFrame() {
        return this._frame;
    }

    public ExtGuiExecutor(byte[] bookData) {
        this(bookData, null, false);
    }

    public ExtGuiExecutor(Book book, IExtRuntimeDataProvider provider, boolean limit) {
        this.init(book, provider, limit);
    }

    private void init(Book book, IExtRuntimeDataProvider provider, boolean limit) {
        this._book = book;
        if (provider == null || this._book.getUserObjectValue("EXT_EXECUTED") != null) {
            this._book.setCellDisplayMode(0);
            this._isSnapshot = true;
        }
        if (provider != null && !this._isSnapshot) {
            ReportProperties rp = provider.fetchCurrentReportProperties();
            if (rp != null) {
                this._book.getDeps().setCalcDescription("localhost", "localhost", rp.getName());
            } else {
                this._book.getDeps().setCalcDescription("localhost", "localhost", this._book.getName());
            }
        }
        this._needExternalAuthorization = !StringUtil.isEmptyString((String)this._book.getPassportGrantor());
        this._limit = limit;
        this._dataProvider = provider;
        if (this._dataProvider != null) {
            this._book.getDataSetManager().getExecutionContext().setRptRuntimeCallback(this._dataProvider.getRptRuntimeCallback(null));
            this._book.setUserObject("dataProvider", this._dataProvider);
        }
        this.configSpread();
        if (!this._isSnapshot) {
            boolean unhideRC = ExtGuiExecutor.isSecurityHidedRowsOrCols(this._book);
            for (int i = this._book.getSheetCount() - 1; i >= 0; --i) {
                Protection protection = this._book.getSheet(i).getSheetOption().getProtection(true);
                if (unhideRC) {
                    protection.deleteOperation(131072);
                    continue;
                }
                protection.appendOperation(131072);
            }
        }
    }

    public ExtGuiExecutor(byte[] bookData, IExtRuntimeDataProvider provider, boolean limit) {
        try {
            this._book = MiscUtil.unpack(bookData);
        }
        catch (Exception e) {
            MiscUtil.handleFileCheckingException(e, null);
            if (MiscUtil.shouldLog()) {
                MiscUtil.log(e);
            }
            return;
        }
        this._bookData = bookData;
        this.init(this._book, provider, limit);
    }

    private void buildActions() {
        this._contextualActions = new Action[10];
        this._contextualActions[0] = new FilterAction();
        this._contextualActions[1] = new RefreshAction();
        this._contextualActions[2] = this.createItemAction(this._context.getActionManager().getAction("Show_Print_Wizzard"), com.kingdee.cosmic.ctrl.kds.impl.icons.ResourceManager.getImageIcon("print.gif"), MultiLanguageKeys.getLocalText("KEY_PRINT"));
        this._contextualActions[3] = this.createItemAction(this._context.getActionManager().getAction("Show_PrinPreview_Wizzard"), com.kingdee.cosmic.ctrl.kds.impl.icons.ResourceManager.getImageIcon("tbtn_preview.gif"), MultiLanguageKeys.getLocalText("KEY_PRINTPREVIEW"));
        this._contextualActions[4] = this.createItemAction(this._context.getActionManager().getAction("Show_PrintSetup_Wizzard"), com.kingdee.cosmic.ctrl.kds.impl.icons.ResourceManager.getImageIcon("setup.gif"), MultiLanguageKeys.getLocalText("KEY_PRINTSETUP"));
        this._contextualActions[5] = new ExportAction();
        this._contextualActions[6] = new SnapshotAction(this);
        this._contextualActions[7] = new SchedularAction();
        this._contextualActions[9] = new FilterConfigAction();
    }

    private void configSpread() {
        this._context = new SpreadContext();
        if (MiscUtil.shouldLog()) {
            MiscUtil.log(3, MiscUtil.SIGN);
        }
        if (!this._limit && this._needExternalAuthorization) {
            this.authentificator = new ExternalAuthentificator();
            this._context.addAncestorListener((AncestorListener)((Object)this.authentificator));
        }
        MiscUtil.capacitateFiCalculation(this._context);
        this._context.getRenderManager().setUserCellDisplayProvider(new ExectorCellDisplayProvider());
        HyperLinkHandler handler = this._context.getHyperLinkHandler();
        if (this._dataProvider == null) {
            handler.setDefaultExec(new IHyperLinkExec(){

                public void execute(String linkTo) {
                    MessageUtil.msgboxInfo((Component)((Object)ExtGuiExecutor.this._context), CtrlEXTMessages.getMLS("snapshotDoesNotSupportCrossReference", "\u62a5\u8868\u5feb\u7167\u4e0d\u652f\u6301\u8054\u67e5\uff01"));
                }
            });
        } else {
            HyperLinkExecFactory.setHyperLinkHandler(this, this._context, this._dataProvider, this._limit);
            Map<String, IHyperLinkExec> execs = this._dataProvider.getContainerDefinedHyperLinkExecs();
            if (execs != null) {
                for (Map.Entry<String, IHyperLinkExec> entry : execs.entrySet()) {
                    IHyperLinkExec exec = entry.getValue();
                    if (exec instanceof AbstractExecutableHyperLinkExec) {
                        ((AbstractExecutableHyperLinkExec)exec).registerExtGuiExecutor(this);
                    }
                    handler.setExec(entry.getKey(), exec);
                }
            }
        }
        InputMap im = this._context.getSpread().getInputMap();
        im.clear();
        im.put(KeyStroke.getKeyStroke(88, 128), "Cut");
        im.put(KeyStroke.getKeyStroke(67, 128), "Copy");
        im.put(KeyStroke.getKeyStroke(86, 128), "Paste");
        im.put(KeyStroke.getKeyStroke(127, 0), "Clear_CellFormulaAndValue");
        im.put(KeyStroke.getKeyStroke(120, 128), "SAVE_SNAP_FILE");
        im.put(KeyStroke.getKeyStroke(121, 128), "OPEN_SNAP_FILE");
        ActionMap am = this._context.getSpread().getActionMap();
        am.put("SAVE_SNAP_FILE", new ExportSnapshotAction(this._book, this._context));
        am.put("OPEN_SNAP_FILE", new OpenSnapshotAction(this._context, this._dataProvider));
        for (int i = this._book.getSheetCount() - 1; i >= 0; --i) {
            this.addSystemVar(this._book.getSheet(i));
        }
        this._context.getPopMenuManager().setCoreMenuVisible(false);
        this._context.getActionManager().getAction("Fill", true).setEnabled(false);
        this._context.getActionManager().getAction("Cut", true).setEnabled(false);
        this.buildActions();
        Action[] exportActions = this.getContextualActions(3);
        for (int i = 0; i < exportActions.length; ++i) {
            this._context.getPopMenuManager().addGroupItem(exportActions[i], 3, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSystemVar(Sheet sheet) {
        if (sheet.getSheetType() == 1) {
            String sel;
            Book book = sheet.getBook();
            NamedObjectNode no = book.getNamedObject(sel = "$Selection");
            if (no != null) {
                book.getNames().remove(no);
            }
            boolean autoCalc = book.isAutoCalculate();
            String name = sheet.getSyntaxName() + "!" + sel;
            Range rg = sheet.getRange(0, 0);
            try {
                book.setAutoCalculate(false);
                if (rg.setName(name, null)) {
                    this._context.addSheetChangeListener(new ExtSheetChangeListener(), false);
                }
                if (no != null) {
                    no.updateRefsExpr();
                }
            }
            catch (SyntaxErrorException syntaxErrorException) {
            }
            finally {
                book.setAutoCalculate(autoCalc);
            }
        }
    }

    private void resumeCurrentPosition(Book book) {
        String currentSheetName = this._book.getActiveSheet().getSheetName();
        Selection select = this._book.getActiveSheet().getSheetOption().getSelection();
        int currentFirstRow = 0;
        int currentFirstCol = 0;
        int currentFirstRow2 = 0;
        int currentFirstCol2 = 0;
        if (!this._book.getActiveSheet().getSheetOption().getViewSplitInfo().isFreezed()) {
            currentFirstRow = this._book.getActiveSheet().getSheetOption().getViewSplitInfo().getFirstRow();
            currentFirstCol = this._book.getActiveSheet().getSheetOption().getViewSplitInfo().getFirstCol();
        } else {
            currentFirstRow2 = this._book.getActiveSheet().getSheetOption().getViewSplitInfo().getFirstRow2();
            currentFirstCol2 = this._book.getActiveSheet().getSheetOption().getViewSplitInfo().getFirstCol2();
        }
        this._book = book;
        this._book.getActiveSheet().getSheetOption().setSelected(false);
        this._book.setActiveSheet(currentSheetName);
        this._book.getActiveSheet().getSheetOption().getSelection().copyFrom(select);
        if (!this._book.getActiveSheet().getSheetOption().getViewSplitInfo().isFreezed()) {
            this._book.getActiveSheet().getSheetOption().getViewSplitInfo().setFirstRow(currentFirstRow);
            this._book.getActiveSheet().getSheetOption().getViewSplitInfo().setFirstCol(currentFirstCol);
        } else {
            this._book.getActiveSheet().getSheetOption().getViewSplitInfo().setFirstRow2(currentFirstRow2);
            this._book.getActiveSheet().getSheetOption().getViewSplitInfo().setFirstCol2(currentFirstCol2);
        }
    }

    public void copyCacheObjectFrom(ExecutionContext ctx) {
        this._book.getDataSetManager().getExecutionContext().copyCacheObjectFrom(ctx);
    }

    public SpreadContext getSpreadContext() {
        return this._context;
    }

    public void setBook(Book book) {
        this._book = book;
        this._context.setBook(book);
    }

    public Action[] getContextualActions() {
        return this.getContextualActions(0);
    }

    public Action[] getContextualActions(int category) {
        ArrayList<Action> actions = new ArrayList<Action>();
        if (category == 0) {
            actions.add(this._contextualActions[0]);
            actions.add(this._contextualActions[1]);
            actions.add(this._contextualActions[6]);
            actions.add(this._contextualActions[7]);
            actions.add(this._contextualActions[9]);
        } else if (category == 1) {
            actions.add(this._contextualActions[0]);
            actions.add(this._contextualActions[1]);
        } else if (category != 2 && category != 3 && category != 4) {
            if (category == 5) {
                actions.add(this._contextualActions[0]);
                actions.add(this._contextualActions[1]);
                actions.add(this._contextualActions[2]);
                actions.add(this._contextualActions[3]);
                actions.add(this._contextualActions[4]);
                actions.add(this._contextualActions[5]);
                actions.add(this._contextualActions[7]);
                actions.add(this._contextualActions[9]);
            } else if (category == 6) {
                actions.add(this._contextualActions[7]);
                actions.add(this._contextualActions[9]);
            } else if (category == 7) {
                actions.add(this._contextualActions[6]);
            }
        }
        return actions.toArray(new Action[0]);
    }

    public KDFrame executeWithinWindow() {
        try {
            if (!this.execute()) {
                return null;
            }
        }
        catch (AuthorizationFailedException e) {
            MiscUtil.handleFileCheckingException(e, null);
            return null;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (MiscUtil.shouldLog()) {
                MiscUtil.log(e);
            }
            return null;
        }
        KDFrame frame = new KDFrame();
        this.configComps(frame);
        this.configBars(frame);
        frame.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                ExtGuiExecutor.this.clearTempFile();
                super.windowClosed(e);
            }
        });
        if (this._isSnapshot) {
            frame.setTitle(ExtGuiExecutor.getLocalText(KEY_REPORT_SNAPSHOT));
        } else {
            frame.setTitle(ExtGuiExecutor.getLocalText(KEY_TITLE));
        }
        frame.setSize(400, 300);
        frame.setExtendedState(6);
        frame.setDefaultCloseOperation(2);
        frame.setVisible(true);
        this._frame = frame;
        return frame;
    }

    public boolean execute() throws AuthorizationFailedException, Exception {
        this.rptRunStart = System.currentTimeMillis();
        Map sysParams = null;
        ExecutionContext _ctx = this._book.getDataSetManager().getExecutionContext();
        if (this._isSnapshot) {
            if (this._dataProvider != null) {
                sysParams = this._dataProvider.fetchSystemParameters();
                Map factories = this._dataProvider.fetchDataSetFactories(MiscUtil.collectExtDataSetTypes(this._book), _ctx);
                _ctx.registerDataSetFactories(factories);
            }
        } else {
            long t2;
            boolean bLog;
            if (!this._limit && this._needExternalAuthorization) {
                String passportGrantor = this._book.getPassportGrantor();
                try {
                    if (!((Boolean)Class.forName(passportGrantor).getMethod("requestLicense", new Class[0]).invoke(null, new Object[0])).booleanValue()) {
                        MiscUtil.log(2, CtrlEXTMessages.getMLS("licenseRequestFailure", "\u62a5\u8868\u6267\u884c\u5668\u5411\u6807\u51c6\u4ea7\u54c1\u62a5\u8868\u5236\u4f5c\u8005\u8bf7\u6c42\u7248\u6743License\u5931\u8d25\uff0c\u7248\u6743License\u6570\u91cf\u53ef\u80fd\u4e0d\u8db3\uff01"));
                        throw new AuthorizationFailedException(CtrlEXTMessages.getMLS("licenseRequestFailure", "\u62a5\u8868\u6267\u884c\u5668\u5411\u6807\u51c6\u4ea7\u54c1\u62a5\u8868\u5236\u4f5c\u8005\u8bf7\u6c42\u7248\u6743License\u5931\u8d25\uff0c\u7248\u6743License\u6570\u91cf\u53ef\u80fd\u4e0d\u8db3\uff01"));
                    }
                    MiscUtil.log(2, CtrlEXTMessages.getMLS("licenseRequestSuccess", "\u62a5\u8868\u6267\u884c\u5668\u5411\u6807\u51c6\u4ea7\u54c1\u62a5\u8868\u5236\u4f5c\u8005\u8bf7\u6c42\u7248\u6743License\u6210\u529f\uff01"));
                }
                catch (Throwable t) {
                    MiscUtil.log(2, CtrlEXTMessages.getMLS("licenseRequestUnknownException", "\u62a5\u8868\u6267\u884c\u5668\u5411\u6807\u51c6\u4ea7\u54c1\u62a5\u8868\u5236\u4f5c\u8005\u8bf7\u6c42\u7248\u6743License\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u672a\u77e5\u5f02\u5e38\uff1a"));
                    MiscUtil.log(t);
                    throw new AuthorizationFailedException(CtrlEXTMessages.getMLS("licenseRequestConsoleOutput", "\u62a5\u8868\u6267\u884c\u5668\u5411\u6807\u51c6\u4ea7\u54c1\u62a5\u8868\u5236\u4f5c\u8005\u8bf7\u6c42\u7248\u6743License\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u53c2\u8003\u63a7\u5236\u53f0\u8f93\u51fa\u3002"), t);
                }
            }
            ExtDataSet[] datasets = MiscUtil.collectExtDataSets(this._book);
            _ctx.setUseDemoData(this.shouldUseDemoData());
            if (this._limit) {
                _ctx.registerDataSetCacheObject(ISPREVIEW, Boolean.TRUE);
            }
            long t1 = (bLog = MiscUtil.shouldLog()) ? System.currentTimeMillis() : 0L;
            IExtDatasetFilter datasetFilter = this._dataProvider.fetchDataSetFilter(datasets, _ctx);
            long l = t2 = bLog ? System.currentTimeMillis() : 0L;
            if (bLog) {
                MiscUtil.log(3, CtrlEXTMessages.getMLS("popupParameterInterfaceTime", "\u5f39\u51fa\u53c2\u6570\u754c\u9762\u8017\u65f6\uff1a") + (t2 - t1) + " ms");
            }
            sysParams = this._dataProvider.fetchSystemParameters();
            if (!_ctx.isUseDemoData() && datasetFilter != null) {
                this.rptRunStart = System.currentTimeMillis() - this.rptRunStart;
                Map<ExtDataSetType, IExtDataSetFactory> params = datasetFilter.filter(true);
                if (params == null) {
                    return false;
                }
                this.rptRunStart = System.currentTimeMillis() - this.rptRunStart;
                ExtExecutor.exec(this._book, this._dataProvider.fetchDataSetFactories(MiscUtil.collectExtDataSetTypes(this._book), _ctx), ExtGuiExecutor.mergeMap(params, sysParams), this._showcaseConfigs == null ? null : this._showcaseConfigs.getCurrentConfig());
            } else {
                ExtExecutor.exec(this._book, this._dataProvider.fetchDataSetFactories(MiscUtil.collectExtDataSetTypes(this._book), _ctx), ExtGuiExecutor.mergeMap(new HashMap(), sysParams), this._showcaseConfigs == null ? null : this._showcaseConfigs.getCurrentConfig());
            }
        }
        this.setBook();
        this._context.getInputMap(2).put(KeyStroke.getKeyStroke(69, 576, true), "HIDDEN_EXPORT_ACTION");
        this._context.getActionMap().put("HIDDEN_EXPORT_ACTION", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Excel2007ExportController.export((String)"c:\\test1.xlsx", (AbstractDataWrapper)new BookDataWrapper(ExtGuiExecutor.this._book));
            }
        });
        this.executeSubReport(sysParams, null);
        return true;
    }

    public void createScreenShoot() {
        int sheetCount = this._book.getSheetCount();
        for (int i = 0; i < sheetCount; ++i) {
            Sheet sheet = this._book.getSheet(i);
            List<Cell> cells = sheet.getSubReportCells();
            if (cells == null || cells.isEmpty()) continue;
            for (Cell cell : cells) {
                SubReportEmbed subRptEmbed;
                SubReportSpreadContext subContext;
                EmbedObject eObject;
                EmbedhLayer layer;
                SubReportInfo subReportInfo = cell.getSubReportInfo();
                if (subReportInfo == null || subReportInfo.getBook() == null || (layer = cell.getSheet().getEmbedments(true)).size() <= 0 || !((eObject = layer.getEmbed(layer.size() - 1)) instanceof SubReportEmbed) || !(subContext = (SubReportSpreadContext)((Object)(subRptEmbed = (SubReportEmbed)eObject).getPhysicalUI())).isShowing()) continue;
                Point p1 = subContext.getLocationOnScreen();
                int screenWidth = GraphicsEnvironment.isHeadless() ? 1920 : Toolkit.getDefaultToolkit().getScreenSize().width;
                int screenHeight = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().height;
                int w = Math.min(screenWidth - p1.x, subRptEmbed.getWidth());
                int h = screenHeight - p1.y - 38;
                Point p2 = new Point(p1.x + w, p1.y + h);
                Image image = DiagonalHeaderImageUtil.createScreenShoot(p1, p2);
                subRptEmbed.setImage(image);
            }
        }
    }

    private void executeSubReport(Map sysParams, Book book) {
        if (sysParams != null && this._subRptExecutor == null) {
            this._subRptExecutor = new SubReportGuiExecutor(this, sysParams);
        } else if (this._subRptExecutor != null && book != null) {
            this._subRptExecutor.setMainBook(book);
        }
        if (this._subRptExecutor != null) {
            this._subRptExecutor.exec();
            this._subRptExecutor.setBook();
        }
    }

    public void executeWithinWindow(Map params, String wName) {
        if (!this.check(params)) {
            return;
        }
        KDFrame frame = new KDFrame();
        this.configComps(frame);
        if (this._limit) {
            this.configBars(frame);
        } else {
            this.configBarsWithSaveSnapshot(frame);
        }
        if (!this._limit && this._dataProvider != null) {
            frame.addWindowListener((WindowListener)new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    ExtGuiExecutor.this.clearTempFile();
                    ReportProperties p = ExtGuiExecutor.this._dataProvider.fetchCurrentReportProperties();
                    if (p != null) {
                        try {
                            ExtGuiExecutor.this._dataProvider.afterTransition(p);
                        }
                        catch (TransitionException e1) {
                            MessageUtil.msgboxInfo(SwingUtilities.getWindowAncestor((Component)((Object)ExtGuiExecutor.this._context)), e1.getMessage());
                        }
                    }
                }
            });
        }
        frame.setTitle(StringUtil.isEmptyString((String)wName) ? ExtGuiExecutor.getLocalText(KEY_TITLE) : wName);
        frame.setSize(400, 300);
        frame.setExtendedState(6);
        frame.setDefaultCloseOperation(2);
        frame.setVisible(true);
        this._frame = frame;
    }

    public boolean check(Map params) {
        try {
            if (!this.execute(params)) {
                return false;
            }
        }
        catch (AuthorizationFailedException e) {
            MiscUtil.handleFileCheckingException(e, null);
            return false;
        }
        catch (Exception e) {
            ReportProperties p;
            if (MiscUtil.shouldLog()) {
                MiscUtil.log(4, CtrlEXTMessages.getMLS("reportOpenException", "\u5c1d\u8bd5\u6253\u5f00\u62a5\u8868\u53d1\u751f\u5f02\u5e38") + e);
            }
            if (this._dataProvider != null && !this._limit && (p = this._dataProvider.fetchCurrentReportProperties()) != null) {
                try {
                    this._dataProvider.afterTransition(p);
                }
                catch (TransitionException e1) {
                    MessageUtil.msgboxInfo(SwingUtilities.getWindowAncestor((Component)((Object)this._context)), e1.getMessage());
                }
            }
            return false;
        }
        return true;
    }

    public boolean execute(Map params) throws AuthorizationFailedException, Exception {
        this.rptRunStart = System.currentTimeMillis();
        if (!this._limit && this._needExternalAuthorization) {
            String passportGrantor = this._book.getPassportGrantor();
            try {
                if (!((Boolean)Class.forName(passportGrantor).getMethod("requestLicense", new Class[0]).invoke(null, new Object[0])).booleanValue()) {
                    MiscUtil.log(2, CtrlEXTMessages.getMLS("licenseRequestFailure", "\u62a5\u8868\u6267\u884c\u5668\u5411\u6807\u51c6\u4ea7\u54c1\u62a5\u8868\u5236\u4f5c\u8005\u8bf7\u6c42\u7248\u6743License\u5931\u8d25\uff0c\u7248\u6743License\u6570\u91cf\u53ef\u80fd\u4e0d\u8db3\uff01"));
                    throw new AuthorizationFailedException(CtrlEXTMessages.getMLS("licenseRequestFailure", "\u62a5\u8868\u6267\u884c\u5668\u5411\u6807\u51c6\u4ea7\u54c1\u62a5\u8868\u5236\u4f5c\u8005\u8bf7\u6c42\u7248\u6743License\u5931\u8d25\uff0c\u7248\u6743License\u6570\u91cf\u53ef\u80fd\u4e0d\u8db3\uff01"));
                }
                MiscUtil.log(2, CtrlEXTMessages.getMLS("licenseRequestSuccess", "\u62a5\u8868\u6267\u884c\u5668\u5411\u6807\u51c6\u4ea7\u54c1\u62a5\u8868\u5236\u4f5c\u8005\u8bf7\u6c42\u7248\u6743License\u6210\u529f\uff01"));
            }
            catch (Throwable t) {
                MiscUtil.log(2, CtrlEXTMessages.getMLS("licenseRequestUnknownException", "\u62a5\u8868\u6267\u884c\u5668\u5411\u6807\u51c6\u4ea7\u54c1\u62a5\u8868\u5236\u4f5c\u8005\u8bf7\u6c42\u7248\u6743License\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u672a\u77e5\u5f02\u5e38\uff1a"));
                MiscUtil.log(t);
                throw new AuthorizationFailedException(CtrlEXTMessages.getMLS("licenseRequestConsoleOutput", "\u62a5\u8868\u6267\u884c\u5668\u5411\u6807\u51c6\u4ea7\u54c1\u62a5\u8868\u5236\u4f5c\u8005\u8bf7\u6c42\u7248\u6743License\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u53c2\u8003\u63a7\u5236\u53f0\u8f93\u51fa\u3002"), t);
            }
        }
        if (this._limit) {
            this._book.getDataSetManager().getExecutionContext().registerDataSetCacheObject(ISPREVIEW, Boolean.TRUE);
        }
        this._book.getDataSetManager().getExecutionContext().setUseDemoData(this.shouldUseDemoData());
        Map sysParams = this._dataProvider.fetchSystemParameters();
        try {
            ExtExecutor.exec(this._book, this._dataProvider.fetchDataSetFactories(MiscUtil.collectExtDataSetTypes(this._book), this._book.getDataSetManager().getExecutionContext()), ExtGuiExecutor.mergeMap(params, sysParams), this._showcaseConfigs == null ? null : this._showcaseConfigs.getCurrentConfig());
        }
        catch (Exception e) {
            if (MiscUtil.shouldLog()) {
                MiscUtil.log(e);
            }
            return false;
        }
        this.setBook();
        if (!this._isSnapshot) {
            if (this._subRptExecutor == null) {
                this._subRptExecutor = new SubReportGuiExecutor(this, sysParams);
            }
            this._subRptExecutor.exec();
        }
        return true;
    }

    public static Map mergeMap(Map map1, Map map2) {
        if (map1 == null && map2 == null) {
            return null;
        }
        if (map1 != null && map2 == null) {
            return map1;
        }
        if (map1 == null && map2 != null) {
            return map2;
        }
        map2.putAll(map1);
        return map2;
    }

    private void configComps(KDFrame frame) {
        Container c = frame.getContentPane();
        c.setLayout(new BorderLayout());
        c.add((Component)((Object)this._context), "Center");
    }

    private void configBars(KDFrame frame) {
        KDToolBar tb = new KDToolBar();
        tb.setFloatable(true);
        Action[] actions = this.getToolBarActions();
        int size = actions.length;
        for (int i = 0; i < size; ++i) {
            tb.add(actions[i]);
        }
        frame.addToolBar((JToolBar)tb);
    }

    private void configBarsWithSaveSnapshot(KDFrame frame) {
        KDToolBar tb = new KDToolBar();
        tb.setFloatable(true);
        tb.add(this._contextualActions[6]);
        tb.addSeparator();
        Action[] actions = this.getToolBarActions();
        int size = actions.length;
        for (int i = 0; i < size; ++i) {
            tb.add(actions[i]);
        }
        frame.addToolBar((JToolBar)tb);
    }

    public Action[] getToolBarActions() {
        IReportingModel model;
        Action[] actions = this._limit ? this.getContextualActions(5) : this.getContextualActions(4);
        Action[] newActions = this.getReportingActionsAndInitEditorProvider();
        if (newActions != null) {
            Action[] temp = new Action[actions.length + newActions.length];
            System.arraycopy(actions, 0, temp, 0, actions.length);
            System.arraycopy(newActions, 0, temp, actions.length, newActions.length);
            actions = temp;
        }
        if ((model = this._book.getReportingModel()) != null && model.getUpdateConstraintList() != null) {
            this._context.getEditManager().setEditorProvider(new ExtReportingRuntimeCellEditorProvider(this._context.getEditManager().getEditorProvider()));
        }
        return actions;
    }

    public Action[] getReportingActionsAndInitEditorProvider() {
        CommitType currentType = ReportingFactory.getReportingBookCommitType(this._book);
        Action[] newActions = null;
        if (currentType == CommitType.UPDATE_ONLY) {
            newActions = new Action[]{new CommitBookAction(this, new RefreshAction()), new ExecutionLogManageAction(this._context)};
        } else if (currentType == CommitType.ALL) {
            newActions = new Action[]{new CommitBookAction(this, new RefreshAction()), new InsertReportingDataAction(this), new DeleteReportingDataAction(this), new ExecutionLogManageAction(this._context)};
        }
        IReportingModel model = this._book.getReportingModel();
        if (model != null && model.getUpdateConstraintList() != null) {
            this._context.getEditManager().setEditorProvider(new ExtReportingRuntimeCellEditorProvider(this._context.getEditManager().getEditorProvider()));
        }
        return newActions;
    }

    private Action createItemAction(Action a, Icon icon, String text) {
        a.putValue("SmallIcon", icon);
        a.putValue("ShortDescription", text);
        a.putValue("Name", text);
        return a;
    }

    public void setProgressPaneVisible(boolean b) {
        if (this._context == null) {
            return;
        }
        if (this.progressGlasspane == null) {
            this.progressGlasspane = new ProgressbarGlassPane(SwingUtilities.getWindowAncestor((Component)((Object)this._context)));
        }
        this.progressGlasspane.display(b);
    }

    public void setProgressPaneVisible2(boolean b, String tipText) {
        if (this._context == null) {
            return;
        }
        if (this.progressGlasspane2 == null) {
            this.progressGlasspane2 = new ProgressbarGlassPane(SwingUtilities.getWindowAncestor((Component)((Object)this._context)), tipText);
        } else {
            this.progressGlasspane2._tipText = tipText;
        }
        this.progressGlasspane2.display(b);
    }

    private void excuteLongTimeTask(Runnable runnable) {
        new Thread(runnable).start();
    }

    private void setBook() {
        this.setBook(this._context, this._book, this._dataProvider, this._isSnapshot);
    }

    public void setBook(SpreadContext context, Book book, IExtRuntimeDataProvider dataProvider, boolean isSnapshot) {
        context.setBook(book);
        KDSpread spread = context.getSpread();
        if (spread.isFreezed()) {
            SpreadView[] splitViews = new SpreadView[]{(SpreadView)spread.getView(3, 2), (SpreadView)spread.getView(2, 3), (SpreadView)spread.getView(3, 3)};
            EmbedhLayer layer = book.getActiveSheet().getEmbedments(false);
            if (layer != null) {
                int size = layer.size();
                for (int i = 0; i < size; ++i) {
                    EmbedObject eo = layer.getEmbed(i);
                    if (!(eo instanceof FlashChart)) continue;
                }
            }
        }
        for (int i = book.getSheetCount() - 1; i >= 0; --i) {
            if (!book.getSheet(i).isPageView()) continue;
            SheetBaseMath.rePageView(context);
            break;
        }
        Sheet sheet = book.getActiveSheet();
        this.doTreeInlined(context, sheet);
        this.applyDefaultShowcaseConfig(context);
        this.doResizedInRuntime(context, sheet);
        MultiPrintJobProvider provider = new MultiPrintJobProvider(book);
        MultiPrintJobManager pm = new MultiPrintJobManager((IMultiPrintJobProvider)provider);
        PrintBookTrans.loadFromBook(pm, book);
        if (!isSnapshot) {
            sheet.calcSecHidedColsNRows();
        }
        if (dataProvider != null) {
            book.set4Mobile(dataProvider.isMobileTemplate());
        }
    }

    private void doTreeInlined(SpreadContext context, Sheet sheet) {
        KDSpread spread = context.getSpread();
        SpreadView view = (SpreadView)spread.getView(0, spread.getHorizonCount() - 1);
        view.setPreferredSize(OutlineGroupColHeaderUI.getSize(view));
        view = (SpreadView)spread.getView(spread.getVerticalCount() - 1, 0);
        view.setPreferredSize(OutlineGroupRowHeaderUI.getSize(view));
    }

    private void doResizedInRuntime(final SpreadContext context, final Sheet sheet) {
        if (sheet.getUserObject("resizedInRuntime") != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    block6: {
                        try {
                            if (context instanceof SubReportSpreadContext) {
                                Thread.sleep(500L);
                            } else {
                                Thread.sleep(50L);
                            }
                        }
                        catch (InterruptedException e) {
                            if (!MiscUtil.shouldLog()) break block6;
                            MiscUtil.log(e);
                        }
                    }
                    Sheet.RowsIterator ri = sheet.getRowsIterator(0, 1048575, false);
                    while (ri.hasNext()) {
                        final Row row = ri.next();
                        if (SheetBaseMath.isHideRow(sheet, row.getRow())) continue;
                        Sheet.ICellsIterator ci = row.getCellsIterator(0, 65535, false, true);
                        boolean shouldResized = false;
                        while (ci.hasNext()) {
                            if (!ci.next().getStyle().isWrapText()) continue;
                            shouldResized = true;
                            break;
                        }
                        if (!shouldResized) continue;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                float height = SheetBaseMath.getMaxRowHeight((Graphics2D)context.getSpread().getViewManager().getView(2, 2).getGraphics(), context.getSpread(), row);
                                int rowid = row.getRow();
                                if (height > 0.0f) {
                                    context.getRangeManager().getRowRangeInBook(rowid, row.getRow()).setRowHeight((int)height + 4);
                                }
                            }
                        });
                    }
                }
            }).start();
        }
    }

    private void enablePrintActions(boolean flag) {
        Action[] actions = this.getContextualActions(2);
        int len = actions.length;
        for (int i = 0; i < len; ++i) {
            actions[i].setEnabled(flag);
        }
    }

    private void enableExportActions(boolean flag) {
        Action[] actions = this.getContextualActions(3);
        int len = actions.length;
        for (int i = 0; i < len; ++i) {
            actions[i].setEnabled(flag);
        }
    }

    private void enableSaveSnapshotActions(boolean flag) {
        Action[] actions = this.getContextualActions(7);
        int len = actions.length;
        for (int i = 0; i < len; ++i) {
            actions[i].setEnabled(flag);
        }
    }

    private void authorizeActions(ReportProperties p, SpreadContext context) {
        if (p != null) {
            boolean exportPermitted = p.isExportPermitted();
            this.enableExportActions(exportPermitted);
            this.enablePrintActions(p.isPrintPermitted());
            this.enableSaveSnapshotActions(p.isSaveSnapshotPermitted());
            SpreadAction copyAction = context.getActionManager().getAction("Copy", false);
            SpreadAction cutAction = context.getActionManager().getAction("Cut", false);
            if (copyAction != null) {
                copyAction.setEnabled(exportPermitted);
            }
            if (cutAction != null) {
                cutAction.setEnabled(exportPermitted);
            }
            if (!exportPermitted) {
                InputMap im = context.getSpread().getInputMap();
                KeyStroke copyKeyStroke = KeyStroke.getKeyStroke(67, 128);
                KeyStroke pasteKeyStroke = KeyStroke.getKeyStroke(86, 128);
                KeyStroke cutKeyStroke = KeyStroke.getKeyStroke(88, 128);
                if (im.get(copyKeyStroke) != null) {
                    im.remove(copyKeyStroke);
                }
                if (im.get(pasteKeyStroke) != null) {
                    im.remove(pasteKeyStroke);
                }
                if (im.get(cutKeyStroke) != null) {
                    im.remove(cutKeyStroke);
                }
            }
        }
    }

    private void applyDefaultShowcaseConfig(SpreadContext context) {
        if (null != this._dataProvider) {
            this.defaultConfig = new ShowcaseConfig();
            ReportProperties p = this._dataProvider.fetchCurrentReportProperties();
            try {
                UserObject userObj = this._book.getUserObject("parentPermission");
                Object value = null;
                if (userObj != null) {
                    value = userObj.getValue();
                }
                if (value instanceof String) {
                    String parentPermission = (String)value;
                    String[] permissions = parentPermission.split(";");
                    if ("1".equals(permissions[0])) {
                        p.setExportPermitted(true);
                    }
                    if ("1".equals(permissions[1])) {
                        p.setPrintPermitted(true);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)"err", (Throwable)e);
            }
            this.authorizeActions(p, context);
            if (p != null && p.isPreview()) {
                this.initDefaultConfig();
            } else {
                String str;
                String temp = (String)this._book.getUserObjectValue("ShowcaseConfigTemplet");
                if (temp == null) {
                    temp = ShowcaseUtil.toShowcaseConfig(this.defaultConfig.toElement());
                }
                if (!StringUtil.isEmptyString((String)(str = this._dataProvider.fetchShowcaseConfigWithID(temp, false)))) {
                    ShowcaseUtil.toShowcaseConfig(str, this.defaultConfig);
                    this.templetConfig = ShowcaseUtil.toShowcaseConfig(temp, new ShowcaseConfig());
                    this.templetConfig.setEditable(this.templetConfig.isEditable() || this._isSnapshot);
                    this.defaultConfig.setEditable(this.templetConfig.isEditable());
                    this.defaultConfig.setShowFormula(this.templetConfig.isShowFormula());
                    this.defaultConfig.setHideEditable(this.templetConfig.isHideEditable());
                } else {
                    this.templetConfig = ShowcaseUtil.toShowcaseConfig(temp, new ShowcaseConfig());
                    this.templetConfig.setEditable(this.templetConfig.isEditable() || this._isSnapshot);
                    this.defaultConfig.setEditable(this.templetConfig.isEditable());
                    this.defaultConfig.setShowFormula(this.templetConfig.isShowFormula());
                    this.defaultConfig.setCellSelect(this.templetConfig.isCellSelect());
                    this.defaultConfig.setRowCountVisible(this.templetConfig.isRowCountVisible());
                    this.defaultConfig.setColCountVisible(this.templetConfig.isColCountVisible());
                    this.defaultConfig.setHideEditable(this.templetConfig.isHideEditable());
                }
            }
            this.applyShowcaseConfig(context);
            this.appPermission(p);
            this.authorizeActionsWithEdit(p, context);
        }
    }

    private void initDefaultConfig() {
        String temp = (String)this._book.getUserObjectValue("ShowcaseConfigTemplet");
        if (temp != null) {
            this.templetConfig = ShowcaseUtil.toShowcaseConfig(temp, new ShowcaseConfig());
            this.templetConfig.setEditable(this.templetConfig.isEditable() || this._isSnapshot);
        }
        if (this.templetConfig != null) {
            if (this.defaultConfig == null) {
                this.defaultConfig = new ShowcaseConfig();
            }
            this.defaultConfig.setEditable(this.templetConfig.isEditable());
            this.defaultConfig.setShowFormula(this.templetConfig.isShowFormula());
            this.defaultConfig.setCellSelect(this.templetConfig.isCellSelect());
            this.defaultConfig.setRowCountVisible(this.templetConfig.isRowCountVisible());
            this.defaultConfig.setColCountVisible(this.templetConfig.isColCountVisible());
            this.defaultConfig.setHideEditable(this.templetConfig.isHideEditable());
        }
    }

    private void applyShowcaseConfig(SpreadContext context) {
        block12: {
            try {
                int index;
                if (this.defaultConfig == null) {
                    this.initDefaultConfig();
                }
                KDSpread spread = context.getSpread();
                spread.setEditable(this.defaultConfig.isEditable());
                PromptPanel pp = context.getFacadeManager().getPromptPanel();
                pp.setTextOnly(!this.defaultConfig.isShowFormula());
                context.setCellShowFormula(!this.defaultConfig.isEditable());
                IMouseController controller = spread.getMouseController(3);
                if (controller instanceof TableMouseController) {
                    ((TableMouseController)controller).setCellSelect(this.defaultConfig.isCellSelect());
                }
                if ((controller = spread.getMouseController(2)) instanceof RowMouseController) {
                    ((RowMouseController)controller).setResizable(this.defaultConfig.isHideEditable());
                }
                if ((controller = spread.getMouseController(1)) instanceof ColMouseController) {
                    ((ColMouseController)controller).setResizable(this.defaultConfig.isHideEditable());
                }
                MvpViewManager manager = spread.getViewManager();
                if (this.defaultConfig.isColCountVisible()) {
                    SpreadView colHeader;
                    for (index = 2; index <= 3 && (colHeader = (SpreadView)manager.getView(1, index)) != null; ++index) {
                        colHeader.setPreferredSize(new Dimension(colHeader.getPreferredWidth(), 1));
                    }
                }
                if (this.defaultConfig.isRowCountVisible()) {
                    SpreadView rowHeader;
                    for (index = 2; index <= 3 && (rowHeader = (SpreadView)manager.getView(index, 1)) != null; ++index) {
                        rowHeader.setPreferredSize(new Dimension(1, rowHeader.getPreferredHeight()));
                    }
                }
                InputMap im = spread.getInputMap();
                if (this.templetConfig != null && this.templetConfig.isEditable()) {
                    im.put(KeyStroke.getKeyStroke(70, 128), "Show_Find_Wizzard");
                    im.put(KeyStroke.getKeyStroke(82, 128), "Show_Find_Wizzard");
                } else {
                    im.put(KeyStroke.getKeyStroke(70, 128), "Show_Find_Only_Wizzard");
                }
            }
            catch (Exception e) {
                if (!MiscUtil.shouldLog()) break block12;
                MiscUtil.log(e);
            }
        }
    }

    private void appPermission(ReportProperties p) {
        if (p != null && this.shouldUseDemoData()) {
            p.setTipText(CtrlEXTMessages.getMLS("demoDataInCurrentReport", "\u5f53\u524d\u662f\u4e91\u62a5\u8868\u6f14\u793a\u6570\u636e\u3002\u6b63\u5f0f\u4f7f\u7528\u62a5\u8868\u7684\u6388\u6743\u7533\u8bf7\u6d41\u7a0b\u5df2\u63d0\u4ea4\u7ed9\u7ba1\u7406\u5458\u3002"));
            AbstractAction extManagerFetchAction = new AbstractAction(CtrlEXTMessages.getMLS("viewAdmin", "\u67e5\u770b\u7ba1\u7406\u5458")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExtGuiExecutor.this._dataProvider.showExtManagerListView();
                }
            };
            AbstractAction demoDataAction = new AbstractAction(CtrlEXTMessages.getMLS("deleteReportMenu", "\u5220\u9664\u62a5\u8868\u83dc\u5355")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ExtGuiExecutor.this._dataProvider.deleteDemoDataAuth()) {
                        ExtGuiExecutor.this._context.getParent().firePropertyChange("closeTab", 0L, 1L);
                    }
                }
            };
            Action[] actions = new Action[]{extManagerFetchAction, demoDataAction};
            this._context.getFacadeManager().showMessageTipPanel(p.getTipText(), true, actions);
        } else if (p != null && !p.isPreview()) {
            SavedSpan[] row = this.defaultConfig.getRowSpans();
            SavedSpan[] col = this.defaultConfig.getColSpans();
            Sheet sheet = this._context.getBook().getActiveSheet();
            this.applySpanLength(row, sheet.getRowSpans());
            this.applySpanLength(col, sheet.getColSpans());
        } else if (p != null && !p.isPublish()) {
            this._context.getFacadeManager().showMessageTipPanel(p.getTipText(), true, null);
        }
        if (this.defaultConfig.isHideEditable()) {
            for (int i = this._book.getSheetCount() - 1; i >= 0; --i) {
                this._book.getSheet(i).getSheetOption().getProtection(true).appendOperation(131072);
            }
        }
    }

    private void authorizeActionsWithEdit(ReportProperties p, SpreadContext context) {
        context.getPopMenuManager().getItem("MenuItem_Paste").getAction().setEnabled(this.defaultConfig.isEditable());
        boolean exportPermitted = p != null ? p.isExportPermitted() : false;
        PopMenuManager tempMenu = context.getPopMenuManager();
        if (exportPermitted && this.defaultConfig.isEditable()) {
            tempMenu.getItem("MenuItem_Cut").getAction().setEnabled(true);
        } else {
            tempMenu.getItem("MenuItem_Cut").getAction().setEnabled(false);
        }
        tempMenu.getItem("MenuItem_Insert").setEnabled(this.defaultConfig.isEditable());
        tempMenu.getItem("MenuItem_InsertRow").setEnabled(this.defaultConfig.isEditable());
        tempMenu.getItem("MenuItem_InsertCol").setEnabled(this.defaultConfig.isEditable());
        tempMenu.getItem("MenuItem_Delete").setEnabled(this.defaultConfig.isEditable());
        tempMenu.getItem("MenuItem_DeleteRow").setEnabled(this.defaultConfig.isEditable());
        tempMenu.getItem("MenuItem_DeleteCol").setEnabled(this.defaultConfig.isEditable());
        tempMenu.getItem("MenuItem_Clear").getAction().setEnabled(this.defaultConfig.isEditable());
    }

    private void applySpanLength(SavedSpan[] spans, SortedAttributeSpanArray array) {
        if (spans == null) {
            return;
        }
        if (spans.length == 0) {
            return;
        }
        int size = spans.length;
        for (int i = 0; i < size; ++i) {
            int start = spans[i].getStart();
            int end = spans[i].getEnd();
            int length = spans[i].getLength();
            boolean isVisible = spans[i].isVisible();
            array.setSpanAttribute(new Span(start, end), null, (Integer)length, (Boolean)isVisible, null, null, null);
        }
    }

    private boolean shouldUseDemoData() {
        return !this._dataProvider.isAuthorizedReport() && this._book.getCloudRptUuid() != null && this._book.getUserObject("CLOUD_REPORT_DEMO_BOOK_DATA") != null && this._dataProvider.isEntryFromMenu();
    }

    public void loadImageWithContext(Book book, IRptRuntimeCallback callback) {
        for (int i = 0; i < book.getSheetCount(); ++i) {
            EmbedhLayer layer;
            Sheet sheet = book.getSheet(i);
            if (sheet == null || (layer = sheet.getEmbedments(false)) == null) continue;
            for (int j = 0; j < layer.size(); ++j) {
                IImageModel model;
                EmbedObject embedObject = layer.getEmbed(j);
                if (!(embedObject instanceof EmbedImage) || !((model = ((EmbedImage)embedObject).getModel()) instanceof ReferredImageModel)) continue;
                byte[] imageData = null;
                try {
                    imageData = model.getImageData();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (imageData != null && imageData.length != 0) continue;
                String embedUid = ((ReferredImageModel)model).getEmbedUid();
                String reportId = callback.getReportId();
                ReferredImageResult referredImageResult = callback.loadReferredImage(reportId, embedUid);
                if (referredImageResult == null) continue;
                ((ReferredImageModel)model).setImageData(referredImageResult.getImageData());
            }
        }
    }

    public Book getBook() {
        return this._book;
    }

    public IExtRuntimeDataProvider getDataProvider() {
        return this._dataProvider;
    }

    public boolean getLimit() {
        return this._limit;
    }

    public boolean isSnapShot() {
        return this._isSnapshot;
    }

    public static boolean isSecurityHidedRowsOrCols(Book book) {
        String temp = (String)book.getUserObjectValue("ShowcaseConfigTemplet");
        if (!StringUtil.isEmptyString((String)temp)) {
            ShowcaseConfig config = ShowcaseUtil.toShowcaseConfig(temp, new ShowcaseConfig());
            return !config.isHideEditable();
        }
        return false;
    }

    private void clearTempFile() {
        try {
            Book book = this._context.getBook();
            ExtDataSetManager dataSetManager = book.getDataSetManager();
            int size = dataSetManager.size();
            for (int i = 0; i < size; ++i) {
                FileFactory.clearDsTemp(dataSetManager.getAt(i));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SubReportGuiExecutor getSubReportGuiExecutor() {
        return this._subRptExecutor;
    }

    static /* synthetic */ byte[] access$1002(ExtGuiExecutor x0, byte[] x1) {
        x0._bookData = x1;
        return x1;
    }

    private class ExternalAuthentificator
    extends AncestorAdapter {
        private ExternalAuthentificator() {
        }

        public void ancestorRemoved(AncestorEvent e) {
            if (!ExtGuiExecutor.this._limit && ExtGuiExecutor.this._needExternalAuthorization) {
                String passportGrantor = ExtGuiExecutor.this._book.getPassportGrantor();
                try {
                    if (((Boolean)Class.forName(passportGrantor).getMethod("releaseLicense", new Class[0]).invoke(null, new Object[0])).booleanValue()) {
                        MiscUtil.log(2, CtrlEXTMessages.getMLS("licenseReleaseSuccess", "\u62a5\u8868\u6267\u884c\u5668\u91ca\u653e\u6807\u51c6\u4ea7\u54c1\u62a5\u8868\u7248\u6743License\u6210\u529f\uff01"));
                    } else {
                        MiscUtil.log(2, CtrlEXTMessages.getMLS("licenseReleaseFailure", "\u62a5\u8868\u6267\u884c\u5668\u65e0\u6cd5\u91ca\u653e\u6807\u51c6\u4ea7\u54c1\u62a5\u8868\u7248\u6743License\uff01"));
                    }
                }
                catch (Throwable t) {
                    MiscUtil.log(2, CtrlEXTMessages.getMLS("licenseReleaseUnknownException", "\u62a5\u8868\u6267\u884c\u5668\u91ca\u653e\u6807\u51c6\u4ea7\u54c1\u62a5\u8868\u7248\u6743License\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u672a\u77e5\u5f02\u5e38\uff1a"));
                    MiscUtil.log(t);
                }
                ExtGuiExecutor.this._book = null;
                ExtGuiExecutor.access$1002(ExtGuiExecutor.this, null);
                ExtGuiExecutor.this._context.setBook(Book.Manager.getNewBook());
            }
        }
    }

    public static class ExectorCellDisplayProvider
    implements ICellDisplayProvider {
        private ArrayList extRenders = new ArrayList();
        private ArrayList extValues = new ArrayList();
        private CellTreeSpreadCellTextRender baseRender = new CellTreeSpreadCellTextRender();

        @Override
        public IBasicRender getBaseRender(Cell cell, int viewMode) {
            this.baseRender.setDrawModel(new CellTreeRenderModel4UI(cell));
            if (!this.baseRender.isRowXorColumnCellTreeDisplay() || cell.getDiagonalHeader() != null) {
                return null;
            }
            return this.baseRender;
        }

        @Override
        public Object getBaseValue(Cell cell, int viewMode) {
            if (cell.getSubReportInfo() != null) {
                return cell.getSubReportInfo();
            }
            return null;
        }

        @Override
        public ArrayList getExtRender(Cell cell, int viewMode) {
            this.extRenders.clear();
            return this.extRenders;
        }

        @Override
        public ArrayList getExtValue(Cell cell, int viewMode) {
            this.extValues.add(0, cell);
            this.extValues.add(1, cell);
            return this.extValues;
        }

        public void addRender(IBasicRender render) {
            this.extRenders.add(render);
        }
    }

    class ActionWrapper
    extends AbstractAction {
        Action _innerAction;

        ActionWrapper(Action action) {
            this._innerAction = action;
            if (action != null) {
                action.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if ("enabled".equals(evt.getPropertyName())) {
                            ActionWrapper.this.setEnabledBySelf((Boolean)evt.getNewValue());
                        }
                    }
                });
            }
        }

        @Override
        public boolean isEnabled() {
            if (this._innerAction == null) {
                return false;
            }
            return this._innerAction.isEnabled();
        }

        @Override
        public void setEnabled(boolean b) {
            if (this._innerAction != null) {
                this._innerAction.setEnabled(b);
            }
        }

        private void setEnabledBySelf(boolean b) {
            super.setEnabled(b);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this._innerAction == null) {
                MessageUtil.msgboxInfo(null, CtrlEXTMessages.getMLS("unImplemented", "\u672a\u5b9e\u73b0"));
            } else {
                this._innerAction.actionPerformed(e);
            }
        }
    }

    private class ProgressbarGlassPane
    extends JPanel {
        private Component originalGlassPane;
        private RootPaneContainer targetWindow;
        private KDProgressBar psbar;
        private KDButton btn;
        private String _tipText;

        public ProgressbarGlassPane(Window parent) {
            if (parent instanceof RootPaneContainer) {
                this.targetWindow = (RootPaneContainer)((Object)parent);
                this.originalGlassPane = this.targetWindow.getGlassPane();
            }
            this.setOpaque(false);
            this.setFocusTraversalKeysEnabled(false);
            this.psbar = new KDProgressBar();
            this.psbar.setIndeterminate(true);
            this.btn = new KDButton(CtrlEXTMessages.getMLS("runInBackground", "\u540e\u53f0\u8fd0\u884c"));
            this.btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProgressbarGlassPane.this.display(false);
                }
            });
            this.add((Component)this.psbar);
            this.add((Component)this.btn);
            this.addMouseListener(new MouseAdapter(){});
            this.setLayout(new LayoutManager(){

                @Override
                public void addLayoutComponent(String name, Component comp) {
                }

                @Override
                public void layoutContainer(Container parent) {
                    Dimension size = ProgressbarGlassPane.this.psbar.getPreferredSize();
                    ProgressbarGlassPane.this.psbar.setBounds(parent.getX() + parent.getWidth() / 2 - size.width / 2, parent.getY() + parent.getHeight() / 2 - size.height / 2, size.width, size.height);
                    size = ProgressbarGlassPane.this.btn.getPreferredSize();
                    ProgressbarGlassPane.this.btn.setBounds(parent.getX() + parent.getWidth() / 2 - size.width / 2, ProgressbarGlassPane.this.psbar.getY() + ProgressbarGlassPane.this.psbar.getHeight() + 5, size.width, size.height);
                }

                @Override
                public Dimension minimumLayoutSize(Container parent) {
                    return null;
                }

                @Override
                public Dimension preferredLayoutSize(Container parent) {
                    return null;
                }

                @Override
                public void removeLayoutComponent(Component comp) {
                }
            });
        }

        public ProgressbarGlassPane(Window parent, String tipText) {
            this(parent);
            this._tipText = tipText;
            this.remove((Component)this.btn);
        }

        public void display(boolean b) {
            if (this.originalGlassPane == null) {
                return;
            }
            if (b) {
                this.targetWindow.setGlassPane(this);
            } else {
                this.targetWindow.setGlassPane(this.originalGlassPane);
            }
            this.targetWindow.getGlassPane().setVisible(b);
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setColor(new Color(255, 255, 255, 150));
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(Color.red);
            if (this._tipText != null) {
                g.drawString(this._tipText, 500, 500);
            }
            super.paintComponent(g);
        }
    }

    private class ShowcaseChooserAction
    extends AbstractAction {
        private ShowcaseChooserAction() {
            this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_attributeset.gif"));
            String text = ExtGuiExecutor.getLocalText(ExtGuiExecutor.KEY_REPORT_DISPLAY_SCHEME);
            this.putValue("ShortDescription", text);
            this.putValue("Name", text);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ShowcaseConfig config = ExtGuiExecutor.this.templetConfig != null ? ExtGuiExecutor.this.templetConfig : new ShowcaseConfig();
            Sheet sheet = ExtGuiExecutor.this._context.getSpread().getBook().getActiveSheet();
            config.setRowSpans(this.getRowSpan(sheet));
            config.setColSpans(this.getColumnSpan(sheet));
            if (ExtGuiExecutor.this._dataProvider == null) {
                MessageUtil.msgboxInfo((Component)((Object)ExtGuiExecutor.this._context), CtrlEXTMessages.getMLS("currentViewModeDoesNotSupportReportDisplayScheme", "\u5f53\u524d\u67e5\u770b\u6a21\u5f0f\u4e0d\u652f\u6301\u62a5\u8868\u663e\u793a\u65b9\u6848\uff01"));
                return;
            }
            String configString = ExtGuiExecutor.this._dataProvider.fetchShowcaseConfigWithID(ShowcaseUtil.toShowcaseConfig(config.toElement()), true);
            if (configString != null) {
                this.applyUserSettings(ShowcaseUtil.toShowcaseConfig(configString, config));
            }
        }

        private SavedSpan[] getRowSpan(Sheet sheet) {
            return ShowcaseUtil.toSavedSpan(sheet.getRowSpans());
        }

        private SavedSpan[] getColumnSpan(Sheet sheet) {
            return ShowcaseUtil.toSavedSpan(sheet.getColSpans());
        }

        private void applyUserSettings(ShowcaseConfig current) {
            if (current == null) {
                return;
            }
            if (ExtGuiExecutor.this.templetConfig != null) {
                current.setEditable(ExtGuiExecutor.this.templetConfig.isEditable());
                current.setShowFormula(ExtGuiExecutor.this.templetConfig.isShowFormula());
                current.setHideEditable(ExtGuiExecutor.this.templetConfig.isHideEditable());
            }
            ExtGuiExecutor.this.defaultConfig = current;
            SavedSpan[] row = current.getRowSpans();
            SavedSpan[] col = current.getColSpans();
            if (ExtGuiExecutor.this._context != null) {
                Sheet sheet = ExtGuiExecutor.this._context.getBook().getActiveSheet();
                ExtGuiExecutor.this._context.getSpread().setEditable(ExtGuiExecutor.this.defaultConfig.isEditable());
                PromptPanel pp = ExtGuiExecutor.this._context.getFacadeManager().getPromptPanel();
                pp.setTextOnly(!ExtGuiExecutor.this.defaultConfig.isShowFormula());
                IMouseController controller = ExtGuiExecutor.this._context.getSpread().getMouseController(3);
                if (controller instanceof TableMouseController) {
                    ((TableMouseController)controller).setCellSelect(current.isCellSelect());
                }
                if ((controller = ExtGuiExecutor.this._context.getSpread().getMouseController(2)) instanceof RowMouseController) {
                    ((RowMouseController)controller).setResizable(ExtGuiExecutor.this.defaultConfig.isHideEditable());
                }
                if ((controller = ExtGuiExecutor.this._context.getSpread().getMouseController(1)) instanceof ColMouseController) {
                    ((ColMouseController)controller).setResizable(ExtGuiExecutor.this.defaultConfig.isHideEditable());
                }
                SpreadView colHeader = (SpreadView)ExtGuiExecutor.this._context.getSpread().getViewManager().getView(1, 2);
                if (!current.isColCountVisible()) {
                    colHeader.setPreferredSize(new Dimension(colHeader.getPreferredWidth(), 20));
                } else {
                    colHeader.setPreferredSize(new Dimension(colHeader.getPreferredWidth(), 1));
                }
                SpreadView rowHeader = (SpreadView)ExtGuiExecutor.this._context.getSpread().getViewManager().getView(2, 1);
                if (!current.isRowCountVisible()) {
                    rowHeader.setPreferredSize(new Dimension(45, rowHeader.getPreferredHeight()));
                } else {
                    rowHeader.setPreferredSize(new Dimension(1, rowHeader.getPreferredHeight()));
                }
                this.applySpanLength(row, sheet.getRowSpans());
                this.applySpanLength(col, sheet.getColSpans());
                ExtGuiExecutor.this._context.getBook().setActiveSheet(sheet);
            }
        }

        private void applySpanLength(SavedSpan[] spans, SortedAttributeSpanArray array) {
            if (spans == null) {
                return;
            }
            if (spans.length == 0) {
                return;
            }
            int size = spans.length;
            for (int i = 0; i < size; ++i) {
                int start = spans[i].getStart();
                int end = spans[i].getEnd();
                int length = spans[i].getLength();
                boolean isVisible = spans[i].isVisible();
                array.setSpanAttribute(new Span(start, end), null, (Integer)length, (Boolean)isVisible, null, null, null);
            }
        }
    }

    public static class SnapshotAction
    extends AbstractAction {
        private final ExtGuiExecutor _executor;
        private SnapStatusBarManager statusBarManager;

        public SnapshotAction(ExtGuiExecutor executor) {
            this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_Saveas.gif"));
            String text = ExtGuiExecutor.getLocalText(ExtGuiExecutor.KEY_SAVE_SNAPSHOT);
            this.putValue("ShortDescription", text);
            this.putValue("Name", text);
            this._executor = executor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                this.statusBarManager = new SnapStatusBarManager(this._executor.getKDFrame());
                ReportProperties reportProperties = this._executor.getDataProvider().fetchCurrentReportProperties();
                String reportId = reportProperties.getId();
                String snapId = null;
                ExtSnapSaverDialog saveUI = new ExtSnapSaverDialog((Frame)this._executor.getKDFrame(), reportId, snapId, this._executor.getDataProvider());
                saveUI.setTitle(CtrlEXTMessages.getMLS(ExtGuiExecutor.KEY_SAVE_SNAPSHOT, "\u4fdd\u5b58\u5feb\u7167"));
                saveUI.pack();
                saveUI.setLocationRelativeTo(null);
                saveUI.setVisible(true);
                ExtReportSnapSaveInfo value = saveUI.getValue();
                if (value == null) {
                    return;
                }
                value.setOldSnapId(snapId);
                SpreadContext ctx = this._executor.getSpreadContext();
                ctx.getStateManager().stopEditing();
                SnapReportControlModel controlModel = new SnapReportControlModel();
                controlModel.setSaveHyplink(value.isSaveHyperlink());
                String jsonValue = JsonUtil.encodeToString(value);
                this._executor.getDataProvider().saveSnapshotCall("addSnapshot", jsonValue, ExecutorUtil.generateSnapShot(ctx.getBook(), controlModel));
                this.showStatusMsg(CtrlEXTMessages.getMLS("saveSuccessMsg", "\u4fdd\u5b58\u6210\u529f\uff01"), 1);
            }
            catch (Exception ee) {
                if (MiscUtil.shouldLog()) {
                    MiscUtil.log(ee);
                }
                String message = CtrlEXTMessages.getMLS("saveFailedMsg", "\u4fdd\u5b58\u5931\u8d25\uff01");
                if (ee.getCause() != null) {
                    message = ee.getCause().getCause() != null ? message + "\u3010" + ee.getCause().getCause().getMessage() + "\u3011" : message + "\u3010" + ee.getCause().getMessage() + "\u3011";
                }
                this.showStatusMsg(message, 0);
            }
        }

        public void showStatusMsg(final String msg, final int msgtype) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    statusBarManager.show(null, "", msg, msgtype);
                    try {
                        Thread.sleep(4000L);
                    }
                    catch (InterruptedException var2) {
                        logger.error((Object)"err", (Throwable)var2);
                    }
                    statusBarManager.show(null, "", "", 1);
                }
            }).start();
        }

        public static enum ExtReportSnapPeriodType {
            EMPTY(-1, new MultiLangEnumBridge("notSet", "\u672a\u8bbe\u7f6e", Messages.ProjectName.QING_RPT_COMMON)),
            OTHER(0, new MultiLangEnumBridge("other", "\u5176\u4ed6", Messages.ProjectName.QING_RPT_COMMON)),
            YEAR(1, new MultiLangEnumBridge("year", "\u5e74", Messages.ProjectName.QING_RPT_COMMON)),
            HALF_OF_YEAR(2, new MultiLangEnumBridge("halfYear", "\u534a\u5e74", Messages.ProjectName.QING_RPT_COMMON)),
            QUARTER(3, new MultiLangEnumBridge("quarter", "\u5b63\u5ea6", Messages.ProjectName.QING_RPT_COMMON)),
            MONTH(4, new MultiLangEnumBridge("month", "\u6708", Messages.ProjectName.QING_RPT_COMMON)),
            HALF_OF_MONTH(5, new MultiLangEnumBridge("halfMonth", "\u534a\u6708", Messages.ProjectName.QING_RPT_COMMON)),
            WEEK(6, new MultiLangEnumBridge("week", "\u5468", Messages.ProjectName.QING_RPT_COMMON)),
            DAY(7, new MultiLangEnumBridge("day", "\u65e5", Messages.ProjectName.QING_RPT_COMMON));

            private final Integer value;
            private final MultiLangEnumBridge multiLangEnumBridge;

            private ExtReportSnapPeriodType(Integer value, MultiLangEnumBridge multiLangEnumBridge) {
                this.value = value;
                this.multiLangEnumBridge = multiLangEnumBridge;
            }

            public Integer getValue() {
                return this.value;
            }

            public String getDesc() {
                return this.multiLangEnumBridge.getMLS();
            }

            public static ExtReportSnapPeriodType getByValue(Integer value) {
                ExtReportSnapPeriodType type = EMPTY;
                for (ExtReportSnapPeriodType extReportSnapPeriodType : ExtReportSnapPeriodType.values()) {
                    if (!extReportSnapPeriodType.value.equals(value)) continue;
                    type = extReportSnapPeriodType;
                }
                return type;
            }
        }

        public static class ExtReportSnapSaveInfo
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private String snapId;
            private String oldSnapId;
            private String snapName;
            private String snapGroupId;
            private String snapGroupType;
            private String reportId;
            private String creatorId;
            private Date createDate;
            private String modifierId;
            private Date modifyDate;
            private ExtReportSnapPeriodType reportPeriod;
            private Date beginDate;
            private Date endDate;
            private int weekBegin;
            private boolean isSaveHyperlink = false;
            private boolean isOverwrite = false;

            public String getSnapId() {
                return this.snapId;
            }

            public void setSnapId(String snapId) {
                this.snapId = snapId;
            }

            public String getOldSnapId() {
                return this.oldSnapId;
            }

            public void setOldSnapId(String oldSnapId) {
                this.oldSnapId = oldSnapId;
            }

            public String getSnapName() {
                return this.snapName;
            }

            public void setSnapName(String snapName) {
                this.snapName = snapName;
            }

            public String getSnapGroupId() {
                return this.snapGroupId;
            }

            public void setSnapGroupId(String snapGroupId) {
                this.snapGroupId = snapGroupId;
            }

            public String getSnapGroupType() {
                return this.snapGroupType;
            }

            public void setSnapGroupType(String snapGroupType) {
                this.snapGroupType = snapGroupType;
            }

            public String getReportId() {
                return this.reportId;
            }

            public void setReportId(String reportId) {
                this.reportId = reportId;
            }

            public String getCreatorId() {
                return this.creatorId;
            }

            public void setCreatorId(String creatorId) {
                this.creatorId = creatorId;
            }

            public Date getCreateDate() {
                return this.createDate;
            }

            public void setCreateDate(Date createDate) {
                this.createDate = createDate;
            }

            public String getModifierId() {
                return this.modifierId;
            }

            public void setModifierId(String modifierId) {
                this.modifierId = modifierId;
            }

            public Date getModifyDate() {
                return this.modifyDate;
            }

            public void setModifyDate(Date modifyDate) {
                this.modifyDate = modifyDate;
            }

            public ExtReportSnapPeriodType getReportPeriod() {
                return this.reportPeriod;
            }

            public void setReportPeriod(ExtReportSnapPeriodType reportPeriod) {
                this.reportPeriod = reportPeriod;
            }

            public Date getBeginDate() {
                return this.beginDate;
            }

            public void setBeginDate(Date beginDate) {
                this.beginDate = beginDate;
            }

            public Date getEndDate() {
                return this.endDate;
            }

            public void setEndDate(Date endDate) {
                this.endDate = endDate;
            }

            public int getWeekBegin() {
                return this.weekBegin;
            }

            public void setWeekBegin(int weekBegin) {
                this.weekBegin = weekBegin;
            }

            public boolean isSaveHyperlink() {
                return this.isSaveHyperlink;
            }

            public void setSaveHyperlink(boolean saveHyperlink) {
                this.isSaveHyperlink = saveHyperlink;
            }

            public boolean isOverwrite() {
                return this.isOverwrite;
            }

            public void setOverwrite(boolean overwrite) {
                this.isOverwrite = overwrite;
            }
        }

        public static class SnapFolderF7Data {
            private String _longNumber;
            private String _name;

            public String getLongNumber() {
                return this._longNumber;
            }

            public void setLongNumber(String longNumber) {
                this._longNumber = longNumber;
            }

            public String getName() {
                return this._name;
            }

            public void setName(String name) {
                this._name = name;
            }

            public String toString() {
                return this._name;
            }
        }

        public static class ExtReportSnapFolderVO
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private String id;
            private String name;
            private String type;
            private String parentId;
            private int order;
            private List<ExtReportSnapFolderVO> children;

            public String getId() {
                return this.id;
            }

            public void setId(String id) {
                this.id = id;
            }

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public String getType() {
                return this.type;
            }

            public void setType(String type) {
                this.type = type;
            }

            public String getParentId() {
                return this.parentId;
            }

            public void setParentId(String parentId) {
                this.parentId = parentId;
            }

            public int getOrder() {
                return this.order;
            }

            public void setOrder(int order) {
                this.order = order;
            }

            public List<ExtReportSnapFolderVO> getChildren() {
                return this.children;
            }

            public void setChildren(List<ExtReportSnapFolderVO> children) {
                this.children = children;
            }
        }

        public static enum ExtReportSnapGroupType {
            PUBLIC("A", new com.kingdee.cosmic.ctrl.common.i18n.model.MultiLangEnumBridge("publicDirectory", CtrlEXTMessages.getMLS("publicDirectory", "\u516c\u5171\u76ee\u5f55"), CtrlCommonMessages.ProjectName.CTRL_EXT)),
            PERSONAL("B", new com.kingdee.cosmic.ctrl.common.i18n.model.MultiLangEnumBridge("personalDirectory", CtrlEXTMessages.getMLS("personalDirectory", "\u4e2a\u4eba\u76ee\u5f55"), CtrlCommonMessages.ProjectName.CTRL_EXT));

            private final String value;
            private final com.kingdee.cosmic.ctrl.common.i18n.model.MultiLangEnumBridge multiLangEnumBridge;

            private ExtReportSnapGroupType(String value, com.kingdee.cosmic.ctrl.common.i18n.model.MultiLangEnumBridge multiLangEnumBridge) {
                this.value = value;
                this.multiLangEnumBridge = multiLangEnumBridge;
            }

            public String getValue() {
                return this.value;
            }

            public String getDesc() {
                return this.multiLangEnumBridge.getMLS();
            }

            public static String getValueByDesc(String desc) {
                for (ExtReportSnapGroupType extReportSnapGroupType : ExtReportSnapGroupType.values()) {
                    if (!extReportSnapGroupType.getDesc().equals(desc)) continue;
                    return extReportSnapGroupType.getValue();
                }
                return null;
            }
        }

        public static class SnapStatusBarManager {
            private KDStatusBar statusBar;
            private KDFrame ui;
            private SimpleStatusBarPart part;

            public SnapStatusBarManager(KDFrame ui) {
                this.ui = ui;
                this.ui.setStatusBar(this.getStatusBar());
            }

            public KDStatusBar getStatusBar() {
                if (this.statusBar == null) {
                    this.statusBar = this.createDefaultStatusBar();
                }
                return this.statusBar;
            }

            private KDStatusBar createDefaultStatusBar() {
                this.statusBar = new KDStatusBar();
                this.statusBar.addPart(this.createStatusPartState(this.statusBar));
                return this.statusBar;
            }

            private SimpleStatusBarPart createStatusPartState(KDStatusBar statusBar) {
                this.part = new SimpleStatusBarPart(statusBar);
                this.part.setPreferredSize(new Dimension(300, 30));
                this.part.setHgrap(0);
                SimpleStatusBarRenderer render = new SimpleStatusBarRenderer();
                this.part.addRenderer((ISimpleStatusBarRenderer)render, (Object)"state");
                return this.part;
            }

            public boolean show(Component parent, String title, String msg, int msgType) {
                final JLabel barLabel = (JLabel)this.getStatusBar().getPart(0).getRenderer(0).getComponent(this.getStatusBar());
                final Color bg = msgType == 2 ? Color.yellow : (msgType == 0 ? Color.red : (msgType == 1 ? Color.GREEN : Color.PINK));
                barLabel.setText(msg);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = 0; i < 3; ++i) {
                            try {
                                SwingUtilities.invokeAndWait(new Runnable(){

                                    @Override
                                    public void run() {
                                        barLabel.setBackground(bg);
                                        barLabel.setOpaque(true);
                                        barLabel.repaint();
                                    }
                                });
                                Thread.sleep(200L);
                                SwingUtilities.invokeAndWait(new Runnable(){

                                    @Override
                                    public void run() {
                                        barLabel.setOpaque(false);
                                        barLabel.repaint();
                                    }
                                });
                                Thread.sleep(200L);
                                continue;
                            }
                            catch (Exception e) {
                                logger.error((Object)"err", (Throwable)e);
                            }
                        }
                    }
                }).start();
                return true;
            }
        }

        public static class InfoMessagePanel
        extends AbstractTipPanel
        implements TimingTarget {
            private String tipString;
            private Image image = InfoMessagePanel.createDefaultCloseImage(false);
            private Image mouseOnImage = InfoMessagePanel.createDefaultCloseImage(true);
            private URL url;
            private Dimension prefer;
            private Animator animator;
            private Component _targetPanel;
            private boolean isMouseIn = false;
            private Color background = new Color(255, 252, 193);
            private Color mouseOn = new Color(0, 0, 120);
            private Color textColor = new Color(255, 255, 255);
            private Popup closeTip;
            private Window w;
            private KDPanel _board;
            private int derection = 1;

            public static final String getTipString() {
                return CtrlEXTMessages.getMLS("pleaseSetDisplayInfo", "\u8bf7\u8bbe\u7f6e\u5c55\u793a\u4fe1\u606f");
            }

            public InfoMessagePanel(String tipString, Component targetPanel, KDPanel board) {
                this.url = DefaultTipPanel.class.getResource("tip.wav");
                this.animator = new Animator(300, (TimingTarget)this);
                this.tipString = null != tipString ? tipString : InfoMessagePanel.getTipString();
                this._targetPanel = targetPanel;
                this._board = board;
                this.prefer = new Dimension(targetPanel.getPreferredSize().width, 0);
                this.init();
                this.initListeners();
            }

            public void setBackGroundColor(Color color) {
                this.background = color;
            }

            public void setTipString(String message) {
                this.tipString = message;
            }

            private void init() {
            }

            private void initListeners() {
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        int x = this.getWidth();
                        if (x - e.getX() < 30 && e.getButton() == 1) {
                            this.hideTip();
                            this.setPreferredSize(new Dimension(0, 0));
                        }
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        isMouseIn = true;
                        this.repaint();
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        isMouseIn = false;
                        this.repaint();
                        if (closeTip != null) {
                            closeTip.hide();
                        }
                    }
                });
                this.addMouseMotionListener(new MouseMotionAdapter(){
                    Cursor cur = Cursor.getPredefinedCursor(12);
                    Cursor def = Cursor.getDefaultCursor();

                    @Override
                    public void mouseMoved(MouseEvent e) {
                        int x = this.getWidth();
                        if (x - e.getX() < 30) {
                            this.setCursor(this.cur);
                            this.showCloseTip(true, e.getPoint());
                        } else {
                            this.setCursor(this.def);
                            SwingUtilities.convertPointToScreen(e.getPoint(), (Component)((Object)this));
                            this.showCloseTip(false, e.getPoint());
                        }
                    }
                });
            }

            public void setPreferredSize(Dimension d) {
                this.prefer = d;
            }

            public Dimension getPreferredSize() {
                return this.prefer;
            }

            protected void paintComponent(Graphics g) {
                Graphics2D g2 = (Graphics2D)g.create();
                Composite c = g2.getComposite();
                if (!this.isMouseIn) {
                    g2.setColor(this.background);
                } else {
                    g2.setColor(this.mouseOn);
                }
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                if (!this.isMouseIn) {
                    g2.setColor(Color.black);
                } else {
                    g2.setColor(this.textColor);
                }
                g2.drawString(this.tipString, 10, 15);
                if (!this.isMouseIn) {
                    g2.drawImage(this.image, this.getWidth() - 15, 4, null);
                } else {
                    g2.drawImage(this.mouseOnImage, this.getWidth() - 15, 4, null);
                }
                g2.setComposite(c);
                g2.dispose();
            }

            @Override
            public synchronized void hideTip() {
                if (this.getHeight() > 0) {
                    this.animator.stop();
                    this.derection = -1;
                    this.animator.setStartDirection(Animator.Direction.FORWARD);
                    this.animator.start();
                    if (this.closeTip != null) {
                        this.closeTip.hide();
                    }
                    this.playSound();
                }
            }

            @Override
            public synchronized void showTip() {
                if (this.getHeight() == 0) {
                    this.animator.stop();
                    this.derection = 1;
                    this.animator.setStartDirection(Animator.Direction.FORWARD);
                    this.animator.start();
                    this.playSound();
                }
            }

            @Override
            public URL getTipSoundURL() {
                return this.url;
            }

            public void timingEvent(float fraction) {
                this.prefer = new Dimension(this._board.getWidth(), (int)(10.0f * (1.0f + (float)this.derection * fraction)));
                Dimension d = this._board.getSize();
                this._board.setPreferredSize(new Dimension(d.width, d.height + this.getPreferredSize().height));
                if (this._targetPanel instanceof JComponent) {
                    ((JComponent)this._targetPanel).revalidate();
                }
            }

            public synchronized void hideTipNOAnimate() {
                this.hideTip();
                this.setPreferredSize(new Dimension(0, 0));
                if (this._targetPanel instanceof JComponent) {
                    ((JComponent)this._targetPanel).revalidate();
                }
            }

            public void begin() {
            }

            public void end() {
            }

            public void repeat() {
            }

            public static BufferedImage createDefaultCloseImage(boolean isMouseOn) {
                BufferedImage image = new BufferedImage(20, 20, 2);
                Graphics2D g2 = image.createGraphics();
                g2.setColor(new Color(255, 255, 255, 0));
                g2.setClip(new Rectangle(20, 20));
                g2.fillRect(0, 0, 20, 20);
                if (isMouseOn) {
                    g2.setColor(Color.WHITE);
                } else {
                    g2.setColor(Color.BLACK);
                }
                GeneralPath path = new GeneralPath();
                path.moveTo(0.0f, 2.0f);
                path.lineTo(2.0f, 0.0f);
                path.lineTo(12.0f, 10.0f);
                path.lineTo(10.0f, 12.0f);
                path.closePath();
                g2.setClip(path);
                g2.fill(path);
                path = new GeneralPath();
                path.moveTo(0.0f, 10.0f);
                path.lineTo(2.0f, 12.0f);
                path.lineTo(12.0f, 2.0f);
                path.lineTo(10.0f, 0.0f);
                path.closePath();
                g2.setClip(path);
                g2.fill(path);
                g2.dispose();
                return image;
            }

            private void showCloseTip(boolean show, Point p) {
                JToolTip tip = new JToolTip();
                tip.setTipText(CtrlEXTMessages.getMLS("closeNotificationBar", "\u5173\u95ed\u63d0\u793a\u6761"));
                if (this.w == null) {
                    this.w = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
                }
                if (show) {
                    if (this.closeTip != null) {
                        this.closeTip.hide();
                    }
                    SwingUtilities.convertPointToScreen(p, (Component)((Object)this));
                    this.closeTip = PopupFactory.getSharedInstance().getPopup(this.w, tip, p.x - 65, p.y - 30);
                    this.closeTip.show();
                } else if (this.closeTip != null) {
                    this.closeTip.hide();
                }
            }
        }

        public static class LoadingPanel
        extends JComponent {
            private KDLabel _lblLoadingIcon;
            private KDLabel _lblLoadingNote;
            private String _note;
            private static final Icon LOADING_ICON = Resource.ICON_REFRESH;
            private int _iconSize = 50;

            public static final String getDefaultMsg() {
                return CtrlEXTMessages.getMLS("dataLoading", "\u6570\u636e\u52a0\u8f7d\u4e2d...\u8bf7\u7a0d\u540e");
            }

            public LoadingPanel() {
                this(LoadingPanel.getDefaultMsg());
            }

            public LoadingPanel(String msg) {
                this._note = msg;
                this.init();
            }

            private void init() {
                this._lblLoadingIcon = new KDLabel();
                this._lblLoadingIcon.setIcon(LOADING_ICON);
                this._lblLoadingIcon.setHorizontalAlignment(0);
                this._lblLoadingNote = new KDLabel(this._note);
                this._lblLoadingNote.setHorizontalAlignment(0);
                TableLayout2 ly = new TableLayout2(4, 3);
                ly.setFixedHeight(1, this._iconSize);
                ly.setFixedHeight(2, 26);
                ly.setRatableHeight(new int[]{0, 3}, 50);
                ly.setFixedWidth(1, this._iconSize);
                ly.setRatableWidth(new int[]{0, 2}, 50);
                this.setLayout((LayoutManager)ly);
                this.setBorder(BorderFactory.createEtchedBorder());
                this.setOpaque(false);
                this.add((Component)this._lblLoadingIcon, TableLayout2.param((int)1, (int)1));
                this.add((Component)this._lblLoadingNote, TableLayout2.param((int)2, (int)0, (int)2, (int)2));
                this.addMouseListener(new MouseAdapter(){});
            }

            @Override
            protected void paintComponent(Graphics g) {
                g.setColor(new Color(255, 255, 255, 200));
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                super.paintComponent(g);
            }

            public void setNote(String note) {
                this._note = note;
                this._lblLoadingNote.setText(note);
            }

            public void setIconSize(int iconSize) {
                this._iconSize = iconSize;
                this.removeAll();
                this.init();
            }

            public void setNoteUpdateUI(String note) {
                this._note = note;
                this._lblLoadingNote.setText(note);
                this.revalidate();
            }
        }

        public static class SnapFolderTreeLoader
        extends LongTaskWorker {
            public static final int DIALOG_MODE = 0;
            public static final int FRAME_MODE = 1;
            private Window _targetWindow;
            private int _mode;
            private KDTree _tree;
            private IExtRuntimeDataProvider _dataProvider;
            private String _selectedFolderTypeValue;

            public SnapFolderTreeLoader(KDTree tree, Window targetWindow, int mode, String selectedFolderTypeValue, IExtRuntimeDataProvider dataProvider) {
                this._tree = tree;
                this._targetWindow = targetWindow;
                this._mode = mode;
                switch (this._mode) {
                    case 0: {
                        ((KDDialog)this._targetWindow).setGlassPane((Component)new LoadingPanel());
                        break;
                    }
                    case 1: {
                        ((KDFrame)this._targetWindow).setGlassPane((Component)new LoadingPanel());
                    }
                }
                this._selectedFolderTypeValue = selectedFolderTypeValue;
                this._dataProvider = dataProvider;
            }

            public Object construct() {
                try {
                    this.doTask();
                }
                catch (Exception e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            switch (_mode) {
                                case 0: {
                                    _targetWindow.dispose();
                                    break;
                                }
                                case 1: {
                                    _targetWindow.dispose();
                                }
                            }
                            this.dealSessionException(e);
                        }
                    });
                }
                return null;
            }

            protected void dealSessionException(Exception ex) {
                Throwable ori = ex.getCause();
                if (ori instanceof IllegalStateException) {
                    throw (IllegalStateException)ori;
                }
                if (ori instanceof SocketException) {
                    throw new IllegalStateException(ori.toString());
                }
            }

            public void doTask() {
                block2: {
                    try {
                        ExtReportSnapFolderVO rootFolder = new ExtReportSnapFolderVO();
                        rootFolder.setParentId(null);
                        rootFolder.setName(this._selectedFolderTypeValue);
                        rootFolder.setType(ExtReportSnapGroupType.getValueByDesc(this._selectedFolderTypeValue));
                        String folderJsonStr = (String)this._dataProvider.saveSnapshotCall("loadSnapFolder", ExtReportSnapGroupType.getValueByDesc(this._selectedFolderTypeValue));
                        List folder = (List)new Gson().fromJson(folderJsonStr, new TypeToken<List<ExtReportSnapFolderVO>>(){}.getType());
                        rootFolder.setChildren(folder);
                        final DefaultKingdeeTreeNode root = this.createMyTreeNode(rootFolder);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                KingdeeTreeModel model = new KingdeeTreeModel((TreeNode)root);
                                _tree.setModel((TreeModel)model);
                                _tree.setRootVisible(false);
                                _tree.expandAllNodes(true, (TreeNode)root);
                                _tree.repaint();
                            }
                        });
                    }
                    catch (Exception e) {
                        if (!MiscUtil.shouldLog()) break block2;
                        MiscUtil.log(e);
                    }
                }
            }

            DefaultKingdeeTreeNode createMyTreeNode(ExtReportSnapFolderVO foler) {
                DefaultKingdeeTreeNode newNode = new DefaultKingdeeTreeNode((Object)foler);
                newNode.setText(foler.getName());
                newNode.setUserObject((Object)foler);
                List<ExtReportSnapFolderVO> children = foler.getChildren();
                if (null != children && children.size() > 0) {
                    Iterator<ExtReportSnapFolderVO> itr = children.iterator();
                    while (itr.hasNext()) {
                        newNode.add((MutableTreeNode)this.createMyTreeNode(itr.next()));
                    }
                }
                if (newNode.getChildCount() == 0) {
                    newNode.setCustomIcon(UIManager.getIcon("Tree.closedIcon"));
                }
                return newNode;
            }

            public void finished() {
                super.finished();
            }
        }

        public static class SnapFolderF7
        implements KDPromptSelector {
            private KDDialog _window;
            private KDTree _tree;
            private IExtRuntimeDataProvider _dataProvider;
            private String _selectedFolderTypeValue;
            protected boolean _isCancel;

            public SnapFolderF7(String selectedFolderTypeValue, IExtRuntimeDataProvider dataProvider) {
                this._selectedFolderTypeValue = selectedFolderTypeValue;
                this._dataProvider = dataProvider;
                this.init();
            }

            private void init() {
                Window owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
                this._window = owner instanceof Dialog ? new KDDialog((Dialog)owner) : new KDDialog((Frame)owner);
                this._tree = new KDTree();
                this._tree.setModel(null);
                this._window.setDefaultCloseOperation(1);
                KDPanel panel = new KDPanel();
                panel.setCustomInsets(new Insets(10, 10, 10, 10));
                panel.setLayout((LayoutManager)new BorderLayout(0, 0));
                panel.setBorder(BorderFactory.createLoweredBevelBorder());
                panel.add((Component)this._tree, (Object)"Center");
                panel.add((Component)new KDScrollPane((Component)this._tree));
                KDSeparator separator = new KDSeparator();
                KDWorkButton btnOk = new KDWorkButton(CtrlEXTMessages.getMLS("KEY_OK", "\u786e\u5b9a"));
                btnOk.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        _isCancel = false;
                        _window.setVisible(false);
                    }
                });
                KDWorkButton btnCancel = new KDWorkButton(CtrlEXTMessages.getMLS("KEY_CANCEL", "\u53d6\u6d88"));
                btnCancel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        _isCancel = true;
                        _window.setVisible(false);
                    }
                });
                btnOk.setPreferredSize(new Dimension(74, 21));
                btnCancel.setPreferredSize(new Dimension(74, 21));
                TableLayout2 ly = new TableLayout2(4, 5);
                ly.setRatableWidth(0, 135);
                ly.setFixedWidth(1, 74);
                ly.setFixedWidth(2, 3);
                ly.setFixedWidth(3, 74);
                ly.setFixedWidth(4, 10);
                ly.setRatableHeight(0, 351);
                ly.setFixedHeight(1, 10);
                ly.setFixedHeight(2, 21);
                ly.setFixedHeight(3, 10);
                this._window.getContentPane().setLayout((LayoutManager)ly);
                this._window.getContentPane().add((Component)panel, TableLayout2.param((int)0, (int)0, (int)0, (int)4));
                this._window.getContentPane().add((Component)separator, TableLayout2.param((int)1, (int)0, (int)1, (int)4));
                this._window.getContentPane().add((Component)btnOk, TableLayout2.param((int)2, (int)1));
                this._window.getContentPane().add((Component)btnCancel, TableLayout2.param((int)2, (int)3));
                this._window.setTitle(CtrlEXTMessages.getMLS("selectSaveDirectory", "\u9009\u62e9\u4fdd\u5b58\u76ee\u5f55"));
                this._window.setModal(true);
                this._window.setSize(230, 280);
                this._window.setLocationRelativeTo(null);
            }

            public Object getData() {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this._tree.getLastSelectedPathComponent();
                if (node == null) {
                    return KDPromptBox.DEFAULTVALUE;
                }
                ExtReportSnapFolderVO folder = (ExtReportSnapFolderVO)node.getUserObject();
                SnapFolderF7Data data = new SnapFolderF7Data();
                data.setLongNumber(folder.getId());
                data.setName(folder.getName());
                return data;
            }

            public boolean isCanceled() {
                return this._isCancel;
            }

            public void show() {
                new SnapFolderTreeLoader(this._tree, (Window)this._window, 0, this._selectedFolderTypeValue, this._dataProvider).start();
                this._window.setVisible(true);
            }
        }

        public static class ExtSnapSaverDialog
        extends KDDialog {
            private KDTextField _tfName;
            private KDPromptBox _bpLocation;
            private KDPanel _board;
            private KDWorkButton _btnSave;
            private KDWorkButton _btnClose;
            private KDComboBox _cmbSaveLocationType;
            private ExtReportSnapSaveInfo _value;
            private KDCheckBox _saveHyplink;
            private InfoMessagePanel _tipPanel;
            private String _reportID;
            private String _snapID;
            private IExtRuntimeDataProvider _dataProvider;

            public ExtSnapSaverDialog(Frame owner, String reportID, String snapID, IExtRuntimeDataProvider dataProvider) {
                super(owner);
                this._reportID = reportID;
                this._snapID = snapID;
                this._dataProvider = dataProvider;
                this.initUI();
                this.installToolBar();
                this.installListener();
            }

            private void installToolBar() {
                KDToolBar toolBar = new KDToolBar(0);
                toolBar.add((Component)this._btnSave);
                toolBar.add((Component)this._btnClose);
                this.addToolBar((JToolBar)toolBar);
            }

            private void installListener() {
                this._cmbSaveLocationType.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        String selectedValue = (String)_cmbSaveLocationType.getSelectedItem();
                        SnapFolderF7 f7 = new SnapFolderF7(selectedValue, _dataProvider);
                        _bpLocation.setSelector((KDPromptSelector)f7);
                        _bpLocation.setData(null);
                    }
                });
                this._cmbSaveLocationType.setSelectedItem((Object)ExtReportSnapGroupType.PERSONAL.getDesc());
                String selectedValue = (String)this._cmbSaveLocationType.getSelectedItem();
                SnapFolderF7 f7 = new SnapFolderF7(selectedValue, this._dataProvider);
                this._bpLocation.setSelector((KDPromptSelector)f7);
            }

            private void initUI() {
                this.setTitle(CtrlEXTMessages.getMLS(ExtGuiExecutor.KEY_SAVE_SNAPSHOT, "\u4fdd\u5b58\u5feb\u7167"));
                this.setModal(true);
                this.setDefaultCloseOperation(2);
                Dimension leftSize = new Dimension(84, 21);
                KDLabelContainer snapNameLc = new KDLabelContainer();
                snapNameLc.setBoundLabelText(CtrlEXTMessages.getMLS("snapshotName", "\u5feb\u7167\u540d\u79f0"));
                snapNameLc.setBoundLabelUnderline(true);
                snapNameLc.setPreferredSize(leftSize);
                KDLabelContainer savePathLc = new KDLabelContainer();
                savePathLc.setBoundLabelText(CtrlEXTMessages.getMLS("directory", "\u76ee\u5f55"));
                savePathLc.setBoundLabelUnderline(true);
                savePathLc.setPreferredSize(leftSize);
                KDLabelContainer savePathTypeLc = new KDLabelContainer();
                savePathTypeLc.setBoundLabelText(CtrlEXTMessages.getMLS("directoryType", "\u76ee\u5f55\u7c7b\u578b"));
                savePathTypeLc.setBoundLabelUnderline(true);
                savePathTypeLc.setPreferredSize(leftSize);
                this._saveHyplink = new KDCheckBox(CtrlEXTMessages.getMLS("saveLinkageSettings", "\u4fdd\u5b58\u8054\u67e5/\u8054\u52a8\u8bbe\u7f6e"), false);
                this._saveHyplink.setPreferredSize(leftSize);
                Dimension rightSize = new Dimension(242, 21);
                this._tfName = new KDTextField();
                this._tfName.setPreferredSize(rightSize);
                this._bpLocation = new KDPromptBox();
                this._bpLocation.setEditable(false);
                this._bpLocation.setPreferredSize(rightSize);
                this._cmbSaveLocationType = new KDComboBox(new Object[]{ExtReportSnapGroupType.PERSONAL.getDesc(), ExtReportSnapGroupType.PUBLIC.getDesc()});
                this._cmbSaveLocationType.setPreferredSize(rightSize);
                TableLayout2 panelLayout = new TableLayout2(4, 2);
                panelLayout.setFixedHeight(new int[]{0, 1, 2, 3}, 21);
                panelLayout.setFixedWidth(0, 84);
                panelLayout.setRatableWidth(1, 242);
                panelLayout.setColSpacing(0, 0);
                panelLayout.setRowsSpacing(TableLayout2.ALL, 3);
                this._board = new KDPanel((LayoutManager)panelLayout);
                this._board.setCustomInsets(new Insets(10, 10, 10, 10));
                this._board.setPreferredSize(new Dimension(346, 126));
                this._board.add((Component)snapNameLc, (Object)TableLayout2.param((int)0, (int)0));
                this._board.add((Component)this._tfName, (Object)TableLayout2.param((int)0, (int)1));
                this._board.add((Component)savePathTypeLc, (Object)TableLayout2.param((int)1, (int)0));
                this._board.add((Component)this._cmbSaveLocationType, (Object)TableLayout2.param((int)1, (int)1));
                this._board.add((Component)savePathLc, (Object)TableLayout2.param((int)2, (int)0));
                this._board.add((Component)this._bpLocation, (Object)TableLayout2.param((int)2, (int)1));
                this._board.add((Component)this._saveHyplink, (Object)TableLayout2.param((int)3, (int)0, (int)3, (int)1));
                this.getContentPane().setLayout(new SpreadBorderLayout());
                this.getContentPane().add((Component)this._board, "Center");
                ActionDispatch action = new ActionDispatch();
                this._btnSave = new KDWorkButton();
                this._btnSave.setText(CtrlEXTMessages.getMLS("save", "\u4fdd\u5b58"));
                this._btnSave.setIcon((Icon)ResourceManager.getImageIcon("tbtn_Save.gif"));
                this._btnSave.addActionListener((ActionListener)action);
                this._btnClose = new KDWorkButton();
                this._btnClose.setText(CtrlEXTMessages.getMLS("KEY_CLOSE", "\u5173\u95ed"));
                this._btnClose.setIcon((Icon)ResourceManager.getImageIcon("tbtn_quit.gif"));
                this._btnClose.addActionListener((ActionListener)action);
            }

            public void actionQuit() {
                this._value = null;
                this.dispose();
            }

            public void actionSave() {
                String info = this.verifyUnEmpty();
                if (info != null) {
                    this.handleInfoTips(info);
                    return;
                }
                this._value = new ExtReportSnapSaveInfo();
                SnapFolderF7Data data = (SnapFolderF7Data)this._bpLocation.getData();
                this._value.setSnapGroupId(data.getLongNumber());
                this._value.setSnapGroupType(data.getName());
                this._value.setReportId(this._reportID);
                String newName = this._tfName.getText().trim();
                try {
                    if (newName.length() > 50) {
                        this.handleInfoTips(CtrlEXTMessages.getMLS("snapshotNameMaxLengthExceeded", "\u5feb\u7167\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc750\u4e2a\u5b57\u7b26"));
                        return;
                    }
                    if (!Pattern.matches("^([\u4e00-\u9fa5a-zA-Z_])[\u4e00-\u9fa5a-zA-Z0-9_]*$", newName)) {
                        this.handleInfoTips(CtrlEXTMessages.getMLS("snapshotNameInvalidCharacters", "\u5feb\u7167\u540d\u79f0\u53ea\u80fd\u7531\u6c49\u5b57\u3001\u5b57\u6bcd\u3001\u6570\u5b57\u6216\u4e0b\u5212\u7ebf\u7ec4\u6210\uff0c\u4e14\u4e0d\u80fd\u4ee5\u6570\u5b57\u5f00\u5934"));
                        return;
                    }
                    if (Pattern.compile("\\b(null|true|false)\\b", 2).matcher(newName).find()) {
                        this.handleInfoTips(CtrlEXTMessages.getMLS("nameError", "\u65e0\u6cd5\u4f7f\u7528\"#1\"\u4f5c\u4e3a\u540d\u79f0\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002".replace("#1", newName)));
                        return;
                    }
                    if (((Boolean)this._dataProvider.saveSnapshotCall("checkSnapNameExist", this._value.getSnapGroupId(), this._value.getReportId(), newName)).booleanValue()) {
                        this._value.setSnapName(newName);
                        boolean ok = MessageUtil.msgboxOkCancel(SwingUtilities.getWindowAncestor((Component)((Object)this)), CtrlEXTMessages.getMLS("snapshotExistsPrompt", "\u5feb\u7167\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u786e\u5b9a\u8986\u76d6\u5417\uff1f"));
                        if (ok) {
                            this._value.setOverwrite(true);
                            this.dispose();
                        } else {
                            this._value = null;
                        }
                        return;
                    }
                }
                catch (Exception e) {
                    return;
                }
                this._value.setSnapName(newName);
                this._value.setSaveHyperlink(this._saveHyplink.isSelected());
                this.dispose();
            }

            private void handleInfoTips(String info) {
                if (this._tipPanel == null) {
                    this._tipPanel = new InfoMessagePanel(info, this.getContentPane(), this._board);
                }
                this._tipPanel.setTipString(info);
                this.getContentPane().add((Component)((Object)this._tipPanel), "center_north");
                this._tipPanel.showTip();
                this.getContentPane().invalidate();
                this.getContentPane().repaint();
            }

            public ExtReportSnapSaveInfo getValue() {
                return this._value;
            }

            private String verifyUnEmpty() {
                String info = null;
                if (StringUtil.isEmptyString((String)this._tfName.getText()) || StringUtil.isEmptyString((String)this._tfName.getText().trim())) {
                    this._tfName.setText(null);
                    this.requestFocus((JComponent)this._tfName);
                    info = CtrlEXTMessages.getMLS("snapshotName2", "\u8bf7\u8f93\u5165\u5feb\u7167\u540d\u79f0\u3002");
                } else if (this._bpLocation.getData() == null || this._bpLocation.getData() == "") {
                    info = CtrlEXTMessages.getMLS("saveDirectory", "\u8bf7\u9009\u62e9\u4fdd\u5b58\u76ee\u5f55\u3002");
                }
                return info;
            }

            protected void requestFocus(final JComponent comp) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        comp.requestFocus();
                    }
                });
            }

            public void setValue(ExtReportSnapSaveInfo value) {
                this._value = value;
            }

            public void disableLocationChoices() {
                this._cmbSaveLocationType.setEnabled(false);
            }

            public class ActionDispatch
            implements ActionListener {
                @Override
                public void actionPerformed(ActionEvent e) {
                    Object obj = e.getSource();
                    if (obj == ExtSnapSaverDialog.this._btnSave) {
                        ExtSnapSaverDialog.this.actionSave();
                    } else if (obj == ExtSnapSaverDialog.this._btnClose) {
                        ExtSnapSaverDialog.this.actionQuit();
                    }
                }
            }
        }
    }

    public class SchedularAction
    extends AbstractAction {
        private WizardScheduler schedular;
        private Timer timer;

        private SchedularAction() {
            this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_autorefresh.gif"));
            String text = ExtGuiExecutor.getLocalText(ExtGuiExecutor.KEY_AUTOREFRESH);
            this.putValue("ShortDescription", text);
            this.putValue("Name", text);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.schedular == null) {
                this.schedular = new WizardScheduler();
            }
            if (ExtGuiExecutor.this._showcaseConfigs != null) {
                this.schedular.setSchedulerConfig(ExtGuiExecutor.this._showcaseConfigs.getCurrentConfig().getScheduler());
            } else {
                this.schedular.setSchedulerConfig(null);
            }
            this.schedular.show();
            ShowcaseConfig.SchedulerConfig config = this.schedular.getSchedulerConfig();
            if (ExtGuiExecutor.this._showcaseConfigs == null) {
                if (config != null) {
                    ExtGuiExecutor.this._showcaseConfigs = new ShowcaseConfigCollection();
                    ExtGuiExecutor.this._showcaseConfigs.getCurrentConfig().setScheduler(config);
                    this.restartScheduler(config);
                }
            } else if (config != null) {
                ShowcaseConfig showcaseConfig = ExtGuiExecutor.this._showcaseConfigs.getCurrentConfig();
                showcaseConfig.setScheduler(config);
                this.restartScheduler(config);
            }
        }

        private void restartScheduler(final ShowcaseConfig.SchedulerConfig sc) {
            if (this.timer != null && this.timer.isRunning()) {
                this.timer.stop();
                this.timer = null;
            }
            if (sc.isEnabled()) {
                this.timer = new Timer(sc.getStep() * 1000, new ActionListener(){
                    private int executeCount;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (!ExtGuiExecutor.this._context.isDisplayable()) {
                            SchedularAction.this.timer.stop();
                            SchedularAction.this.timer = null;
                            return;
                        }
                        if (sc.getCount() == -1 || this.executeCount < sc.getCount()) {
                            Book book = null;
                            try {
                                book = BookIOUtil.unpack(ExtGuiExecutor.this._bookData);
                                ReportProperties rp = ExtGuiExecutor.this._dataProvider.fetchCurrentReportProperties();
                                if (rp != null) {
                                    book.getDeps().setCalcDescription("localhost", "localhost", rp.getName());
                                } else {
                                    book.getDeps().setCalcDescription("localhost", "localhost", ExtGuiExecutor.this._book.getName());
                                }
                            }
                            catch (Exception e1) {
                                if (MiscUtil.shouldLog()) {
                                    MiscUtil.log(4, "SchedularAction\uff1a" + CtrlEXTMessages.getMLS("unzipBookException", "\u89e3\u538bBOOK\u65f6\u53d1\u751f\u5f02\u5e38") + e1);
                                }
                                return;
                            }
                            ExecutionContext ctx = book.getDataSetManager().getExecutionContext();
                            ExecutionContext oldctx = ExtGuiExecutor.this._book.getDataSetManager().getExecutionContext();
                            ctx.setDataSetParameters(oldctx.getDataSetParameters());
                            ctx.copyCacheObjectFrom(oldctx);
                            ctx.setRptRuntimeCallback(oldctx.getRptRuntimeCallback());
                            SpreadView tableview = (SpreadView)ExtGuiExecutor.this._context.getSpread().getView(2, 2);
                            final int firstRow = tableview.getFirstRow();
                            final int firstCol = tableview.getFirstCol();
                            ExtGuiExecutor.this.resumeCurrentPosition(book);
                            ExtGuiExecutor.this._book.getDataSetManager().getExecutionContext().setUseDemoData(ExtGuiExecutor.this.shouldUseDemoData());
                            ExtExecutor.exec(ExtGuiExecutor.this._book, ExtGuiExecutor.this._dataProvider.fetchDataSetFactories(MiscUtil.collectExtDataSetTypes(ExtGuiExecutor.this._book), ctx), oldctx.getDataSetParameters(), ExtGuiExecutor.this._showcaseConfigs == null ? null : ExtGuiExecutor.this._showcaseConfigs.getCurrentConfig());
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ExtGuiExecutor.this.executeSubReport(null, ExtGuiExecutor.this._book);
                                    ExtGuiExecutor.this.setBook();
                                    SpreadView tableview = (SpreadView)ExtGuiExecutor.this._context.getSpread().getView(2, 2);
                                    ExtGuiExecutor.this._context.getSpread().setViewRowCol(tableview, firstRow, firstCol);
                                }
                            });
                        } else {
                            SchedularAction.this.timer.stop();
                            SchedularAction.this.timer = null;
                        }
                        ++this.executeCount;
                    }
                });
                this.timer.setRepeats(true);
                this.timer.start();
            }
        }
    }

    private class FilterConfigAction
    extends AbstractAction {
        private KDWorkButton filBtn;

        private FilterConfigAction() {
            this.configBtn();
            this.putValue("ActionComponent", this.filBtn);
        }

        private void configBtn() {
            String text = ExtGuiExecutor.getLocalText(ExtGuiExecutor.KEY_DATA_FILTERING);
            this.filBtn = new KDWorkButton(text);
            KDPopupMenu pop = new KDPopupMenu();
            JCheckBoxMenuItem cItem = new JCheckBoxMenuItem(ExtGuiExecutor.this._context.getActionManager().getAction("AutoFilter"));
            cItem.setText(ExtGuiExecutor.getLocalText(ExtGuiExecutor.KEY_AUTOFILTER));
            pop.add((JMenuItem)cItem);
            ActionWrapper action1 = new ActionWrapper(ExtGuiExecutor.this._context.getActionManager().getAction("AutoFilter"));
            action1.putValue("Name", ExtGuiExecutor.getLocalText(ExtGuiExecutor.KEY_DATA_FILTERING));
            this.filBtn.setAction((Action)action1);
            this.filBtn.setText(text);
            this.filBtn.setIcon((Icon)ResourceManager.getImageIcon("tbtn_billfilter.gif"));
            ActionWrapper action = new ActionWrapper(ExtGuiExecutor.this._context.getActionManager().getAction("UnFilter"));
            action.putValue("Name", ExtGuiExecutor.getLocalText(ExtGuiExecutor.KEY_SHOW_ALL));
            pop.add((Action)action);
            final JMenuItem item = (JMenuItem)pop.getSubElements()[1];
            item.setEnabled(false);
            ExtGuiExecutor.this._context.addSheetChangeListener(new SheetChangeListener(){
                private SpreadContext context;
                {
                    this.context = ExtGuiExecutor.this._context;
                }

                @Override
                public void changed(SheetChangeEvent e) {
                    if (e.getChangedStates() == SheetChangeEvent.Changed_Resize) {
                        int start;
                        Sheet sheet = this.context.getBook().getActiveSheet();
                        CellBlock block = sheet.getAutoFilterArea();
                        if (block == null) {
                            block = sheet.getAdvancedFilterArea();
                        }
                        if (block == null) {
                            return;
                        }
                        int end = block.getRow2();
                        SortedAttributeSpanArray array = sheet.getRowSpans();
                        int size = array.size();
                        for (start = block.getRow(); start < end; ++start) {
                            boolean flag = false;
                            sheet.getRow(start, false);
                            for (int i = 0; i < size; ++i) {
                                SortedAttributeSpanArray.AttributeSpan span = (SortedAttributeSpanArray.AttributeSpan)array.get(i);
                                if (span.getStart() < start || start > span.getEnd() || span.isVisible()) continue;
                                item.setEnabled(true);
                                flag = true;
                                break;
                            }
                            if (flag) break;
                        }
                        if (start == end) {
                            item.setEnabled(false);
                        }
                    }
                }
            });
            action = new ActionWrapper(ExtGuiExecutor.this._context.getActionManager().getAction("Show_AdvancedFilter_Wizzard"));
            action.putValue("Name", ExtGuiExecutor.getLocalText(ExtGuiExecutor.KEY_ADVANCED_FILTERING));
            pop.add((Action)action);
            this.filBtn.setAssistPopup(pop);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    private class ExportAction
    extends AbstractAction {
        private ExportChooserDialog chooserDialog;
        private String subType;
        private String fileName;

        private ExportAction() {
            this.init(ExtGuiExecutor.KEY_EXPORT);
        }

        private ExportAction(String subType) {
            this();
            if (ExtGuiExecutor.KEY_EXPORT2EXCEL.equals(subType)) {
                this.subType = subType;
            } else if (ExtGuiExecutor.KEY_EXPORT2EXCEL2007.equals(subType)) {
                this.subType = subType;
            }
            this.init(this.subType);
        }

        private void init(String desc) {
            this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_Output.gif"));
            String text = ExtGuiExecutor.getLocalText(desc);
            this.putValue("ShortDescription", text);
            this.putValue("Name", text);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ExtGuiExecutor.this.createScreenShoot();
            if (this.chooserDialog == null) {
                this.chooserDialog = this.createChooserDialog();
            } else {
                this.chooserDialog.refresh();
            }
            this.chooserDialog.setLocationRelativeTo(null);
            if (this.subType == null) {
                this.chooserDialog.setVisible(true);
                int ret = this.chooserDialog.getIsImport();
                if (ret == 1) {
                    File file = this.chooserDialog.getFilePath();
                    if (file == null) {
                        return;
                    }
                    try {
                        this.fileName = file.getCanonicalPath();
                        if (new File(FilenameUtils.normalize((String)this.fileName)).exists() && !this.checkOverwrite(this.fileName)) {
                            return;
                        }
                        ExtGuiExecutor.this.setProgressPaneVisible(true);
                        ExtGuiExecutor.this.excuteLongTimeTask(new Runnable(){

                            @Override
                            public void run() {
                                ExportAction.this.saveToFile(ExportAction.this.fileName, ExportAction.this.chooserDialog.isOpenRightNow(), ExportAction.this.chooserDialog.isMegerExport());
                                ExtGuiExecutor.this.setProgressPaneVisible(false);
                            }
                        });
                    }
                    catch (IOException e1) {
                        if (MiscUtil.shouldLog()) {
                            MiscUtil.log(e1);
                        }
                        ExtGuiExecutor.this.setProgressPaneVisible(false);
                    }
                }
            }
        }

        private ExportChooserDialog createChooserDialog() {
            ExportChooserDialog chooserDialog = ExtGuiExecutor.this._isSnapshot ? new ExportChooserDialog(KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow(), ExtGuiExecutor.this._book.getName(), true) : new ExportChooserDialog(KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow(), ExtGuiExecutor.this._dataProvider.fetchCurrentReportProperties().getName());
            chooserDialog.setTitle(ExtGuiExecutor.getLocalText(ExtGuiExecutor.KEY_EXPORT));
            chooserDialog.setModal(true);
            return chooserDialog;
        }

        private void saveToFile(String fileName, boolean isOpen, boolean isMergeExport) {
            SimpleFileFilter filter = null;
            if (this.chooserDialog.getFileChooser() != null) {
                filter = this.chooserDialog.getSimpleFileFilter();
            }
            SimpleFileFilter sff = null;
            if (filter instanceof SimpleFileFilter) {
                sff = filter;
            }
            if (this.acceptExtension(sff, fileName, ExtGuiExecutor.XLS)) {
                fileName = this.addExtension(fileName, ExtGuiExecutor.XLS);
                this.exportToXls(fileName, isOpen, isMergeExport);
            } else if (this.acceptExtension(sff, fileName, ExtGuiExecutor.PDF)) {
                fileName = this.addExtension(fileName, ExtGuiExecutor.PDF);
                this.exportToPdf(fileName);
            } else if (this.acceptExtension(sff, fileName, ExtGuiExecutor.XLSX)) {
                fileName = this.addExtension(fileName, ExtGuiExecutor.XLSX);
                this.exportToXlsx(fileName, isOpen, isMergeExport);
            } else if (this.acceptExtension(sff, fileName, ExtGuiExecutor.KDS)) {
                fileName = this.addExtension(fileName, ExtGuiExecutor.KDS);
                this.exportToKds(fileName);
            }
        }

        private boolean checkOverwrite(String fileName) {
            FileFilter filter = null;
            if (this.chooserDialog.getFileChooser() != null) {
                filter = this.chooserDialog.getFileChooser().getFileFilter();
            }
            SimpleFileFilter sff = null;
            if (filter instanceof SimpleFileFilter) {
                sff = (SimpleFileFilter)filter;
            }
            if (this.acceptExtension(sff, fileName, ExtGuiExecutor.XLS)) {
                fileName = this.addExtension(fileName, ExtGuiExecutor.XLS);
            } else if (this.acceptExtension(sff, fileName, ExtGuiExecutor.PDF)) {
                fileName = this.addExtension(fileName, ExtGuiExecutor.PDF);
            } else if (this.acceptExtension(sff, fileName, ExtGuiExecutor.KDS)) {
                fileName = this.addExtension(fileName, ExtGuiExecutor.KDS);
            }
            return MessageUtil.msgboxOkCancel((Component)this.chooserDialog.getFileChooser(), CtrlEXTMessages.getMLS("fileExistsPrompt", "\u6587\u4ef6\u5df2\u7ecf\u5b58\u5728\uff0c\u786e\u8ba4\u8986\u76d6\u5417\uff1f"));
        }

        private boolean acceptExtension(SimpleFileFilter sff, String fileName, String extension) {
            if (sff != null) {
                return sff.acceptExtension(extension);
            }
            return fileName.toLowerCase(Locale.ENGLISH).endsWith(extension.toLowerCase(Locale.ENGLISH));
        }

        private String addExtension(String fileName, String extension) {
            if (fileName.toLowerCase(Locale.ENGLISH).endsWith(extension.toLowerCase(Locale.ENGLISH))) {
                return fileName;
            }
            return fileName + "." + extension;
        }

        private void exportToKds(String fileName) {
            block6: {
                try {
                    Book dstBook = null;
                    for (int sh = ExtGuiExecutor.this._book.getSheetCount() - 1; sh >= 0; --sh) {
                        Sheet sheet = ExtGuiExecutor.this._book.getSheet(sh);
                        if (!SheetBaseMath.isSecuritySheet(sheet)) continue;
                        if (dstBook == null) {
                            dstBook = BookIOUtil.unpack(BookIOUtil.pack(ExtGuiExecutor.this._book));
                        }
                        AlgorithmUtil.delHideRowsAndCols(sheet.getSecHidedRows(), sheet.getSecHidedCols(), dstBook.getSheet(sh));
                    }
                    BookToKds btk = new BookToKds();
                    try {
                        btk.export(dstBook == null ? ExtGuiExecutor.this._book : dstBook, fileName);
                    }
                    catch (IOException e) {
                        ExtGuiExecutor.this.setProgressPaneVisible(false);
                        MessageUtil.msgboxWarning((Component)((Object)ExtGuiExecutor.this._context), ExtGuiExecutor.getLocalText(ExtGuiExecutor.Key_ErrorOnSaveFile) + ":\n" + e.getMessage());
                    }
                }
                catch (Exception e1) {
                    if (!MiscUtil.shouldLog()) break block6;
                    MiscUtil.log(e1);
                }
            }
        }

        private void exportToPdf(String fileName) {
            PdfExport pdf = new PdfExport();
            PrintManager printManager = ExtGuiExecutor.this._context.getPrintManager();
            KDPrinter printer = null;
            printer = printManager.getPrinter();
            printManager.reloadPrintJob();
            printer.preParePrint();
            pdf.export(fileName, printer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void exportToXls(String fileName, boolean isOpen, boolean isMergeExport) {
            boolean autoCalc = ExtGuiExecutor.this._book.isAutoCalculate();
            if (ExtGuiExecutor.this._isSnapshot && autoCalc) {
                ExtGuiExecutor.this._book.setAutoCalculate(false);
            }
            try {
                Book dstBook = BookIOUtil.unpack(BookIOUtil.pack(ExtGuiExecutor.this._book));
                dstBook.setCalculate(false);
                int sheetCount = dstBook.getSheetCount();
                for (int sh = 0; sh < sheetCount; ++sh) {
                    Sheet oldSheet = ExtGuiExecutor.this._book.getSheetByName(dstBook.getSheetName(sh));
                    Sheet sheet = dstBook.getSheet(sh);
                    ExecutorUtil.calcDisplayValue(oldSheet, sheet);
                    EmbedhLayer oldLayer = oldSheet.getEmbedments(false);
                    if (oldLayer == null) continue;
                    EmbedhLayer newLayer = sheet.getEmbedments(false);
                    for (int i = 0; i < newLayer.size(); ++i) {
                        EmbedObject eo = newLayer.getEmbed(i);
                        if (eo instanceof FlashChart) {
                            ((FlashChart)eo).setModel(((FlashChart)oldLayer.getEmbed(i)).getModel());
                            ((FlashChart)eo).setCachedImg(((FlashChart)oldLayer.getEmbed(i)).getCachedImg());
                            ((FlashChart)eo).setSrc((FlashChart)oldLayer.getEmbed(i));
                            continue;
                        }
                        if (!(eo instanceof EChart)) continue;
                        ((EChart)eo).setModel(((EChart)oldLayer.getEmbed(i)).getModel());
                        ((EChart)eo).setCachedImg(((EChart)oldLayer.getEmbed(i)).getCachedImg());
                        ((EChart)eo).setSrc((EChart)oldLayer.getEmbed(i));
                    }
                }
                ExportManager em = new ExportManager();
                em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_TRUE, (Object)"TRUE");
                em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_FALSE, (Object)"FALSE");
                em.setExporterParmeter(ExporterParameter.EXPORT_FORMAT, (Object)"true");
                em.setExporterParmeter(ExporterParameter.EXPORT_STYLE, (Object)"true");
                em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)String.valueOf(ExtGuiExecutor.this.defaultConfig == null ? true : ExtGuiExecutor.this.defaultConfig.isShowFormula()));
                em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"false");
                em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"true");
                em.setExporterParmeter(ExporterParameter.EXPORT_HIDED_ROWS_COLUMNS, (Object)String.valueOf(ExtGuiExecutor.this.defaultConfig == null ? true : ExtGuiExecutor.this.defaultConfig.isHideEditable()));
                em.setExporterParmeter(ExporterParameter.EXPORT_MERGE_BLOCKS, (Object)String.valueOf(isMergeExport));
                try {
                    FlashChartDisplayResolver x = new FlashChartDisplayResolver(dstBook);
                    x.setExportType("EXPORT_EXCEL_2003");
                    x.export(fileName, em, null, isOpen);
                    while (x.isDisp) {
                        Thread.yield();
                    }
                }
                catch (Exception e) {
                    ExtGuiExecutor.this.setProgressPaneVisible(false);
                    MessageUtil.msgboxWarning((Component)((Object)ExtGuiExecutor.this._context), ExtGuiExecutor.getLocalText(ExtGuiExecutor.Key_ErrorOnSaveFile) + ":\n" + e.getMessage());
                }
            }
            catch (Exception e1) {
                if (MiscUtil.shouldLog()) {
                    MiscUtil.log(e1);
                }
            }
            finally {
                if (ExtGuiExecutor.this._isSnapshot && autoCalc) {
                    ExtGuiExecutor.this._book.setAutoCalculate(true);
                }
            }
        }

        private void exportToXlsx(String fileName, boolean isOpen, boolean isMergeExport) {
            block4: {
                try {
                    Book tempBook = ExtGuiExecutor.this._book;
                    boolean hasFlashChart = ExportUtil.hasFlashChart(ExtGuiExecutor.this._book);
                    tempBook.setCalculate(false);
                    if (hasFlashChart) {
                        ExportUtil.setEmbedModel(tempBook, ExtGuiExecutor.this._book);
                    }
                    BookDataWrapper wrapper = new BookDataWrapper(tempBook);
                    wrapper.setExportFormula(ExtGuiExecutor.this.defaultConfig == null ? true : ExtGuiExecutor.this.defaultConfig.isShowFormula());
                    wrapper.setExportHideCols(ExtGuiExecutor.this.defaultConfig == null ? false : ExtGuiExecutor.this.defaultConfig.isHideEditable());
                    wrapper.setExportHideRows(ExtGuiExecutor.this.defaultConfig == null ? false : ExtGuiExecutor.this.defaultConfig.isHideEditable());
                    wrapper.setExportMergeBlocks(isMergeExport);
                    FlashChartDisplayResolver x = new FlashChartDisplayResolver(tempBook);
                    x.setExportType("EXPORT_EXCEL_2007");
                    x.export(fileName, null, wrapper, isOpen);
                    while (x.isDisp) {
                        Thread.yield();
                    }
                }
                catch (Exception ex) {
                    if (!MiscUtil.shouldLog()) break block4;
                    MiscUtil.log(ex);
                }
            }
        }
    }

    public static class CloudRptCommentAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IExtRuntimeDataProvider provider;

        public CloudRptCommentAction(IExtRuntimeDataProvider provider) {
            this.provider = provider;
            try (InputStream is = ResourceManager.class.getResourceAsStream("cloud.png");){
                this.putValue("SmallIcon", new ImageIcon(ImageIO.read(is).getScaledInstance(24, 18, 4)));
            }
            catch (IOException e) {
                MiscUtil.error("failed to init cloud rpt comment btn icon:" + e.getMessage());
            }
            this.putValue("isCloudRptAction", "true");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.provider.showCloudRptCommentBox();
        }
    }

    private class RefreshAction
    extends AbstractAction {
        private RefreshAction() {
            this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_Refresh.gif"));
            String text = ExtGuiExecutor.getLocalText(ExtGuiExecutor.KEY_REFRESH);
            this.putValue("ShortDescription", text);
            this.putValue("Name", text);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ExtGuiExecutor.this.rptRunStart = System.currentTimeMillis();
            Book book = null;
            try {
                book = BookIOUtil.unpack(ExtGuiExecutor.this._bookData);
                ReportProperties rp = ExtGuiExecutor.this._dataProvider.fetchCurrentReportProperties();
                if (rp != null) {
                    book.getDeps().setCalcDescription("localhost", "localhost", rp.getName());
                } else {
                    book.getDeps().setCalcDescription("localhost", "localhost", ExtGuiExecutor.this._book.getName());
                }
            }
            catch (Exception e1) {
                if (MiscUtil.shouldLog()) {
                    MiscUtil.log(4, CtrlEXTMessages.getMLS("refreshPageException", "\u5237\u65b0\u8868\u9875\u64cd\u4f5c\u4e2d\u89e3\u538bBook\u4e8c\u8fdb\u5236\u65f6\u53d1\u751f \u5f02\u5e38") + e1);
                }
                return;
            }
            ExecutionContext ctx = book.getDataSetManager().getExecutionContext();
            ExecutionContext oldctx = ExtGuiExecutor.this._book.getDataSetManager().getExecutionContext();
            ctx.setDataSetParameters(oldctx.getDataSetParameters());
            ctx.copyCacheObjectFrom(oldctx);
            IRptRuntimeCallback rptRuntimeCallback = oldctx.getRptRuntimeCallback();
            ctx.setRptRuntimeCallback(oldctx.getRptRuntimeCallback());
            ExtGuiExecutor.this.loadImageWithContext(book, rptRuntimeCallback);
            ExtGuiExecutor.this.resumeCurrentPosition(book);
            for (int i = ExtGuiExecutor.this._book.getSheetCount() - 1; i >= 0; --i) {
                ExtGuiExecutor.this.addSystemVar(ExtGuiExecutor.this._book.getSheet(i));
            }
            ExtGuiExecutor.this._book.getDataSetManager().getExecutionContext().setUseDemoData(ExtGuiExecutor.this.shouldUseDemoData());
            ExtExecutor.exec(ExtGuiExecutor.this._book, ExtGuiExecutor.this._dataProvider.fetchDataSetFactories(MiscUtil.collectExtDataSetTypes(ExtGuiExecutor.this._book), ctx), oldctx.getDataSetParameters(), ExtGuiExecutor.this._showcaseConfigs == null ? null : ExtGuiExecutor.this._showcaseConfigs.getCurrentConfig());
            ExtGuiExecutor.this.executeSubReport(null, ExtGuiExecutor.this._book);
            ExtGuiExecutor.this.setBook();
            if (ExtGuiExecutor.this._dataProvider != null) {
                ExtGuiExecutor.this._dataProvider.updateAuditTable(System.currentTimeMillis() - ExtGuiExecutor.this.rptRunStart);
            }
        }
    }

    private class FilterAction
    extends AbstractAction {
        private FilterAction() {
            this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_Filter.gif"));
            String text = ExtGuiExecutor.getLocalText(ExtGuiExecutor.KEY_FILTER);
            this.putValue("ShortDescription", text);
            this.putValue("Name", text);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ExtGuiExecutor.this.rptRunStart = System.currentTimeMillis();
            Book book = null;
            int maxRowLast = ExtGuiExecutor.this._book.getActiveSheet().getMaxRowIndex();
            KDSpread spread = ExtGuiExecutor.this._context.getSpread();
            SpreadView tableview = (SpreadView)spread.getView(spread.getVerticalCount() - 1, spread.getHorizonCount() - 1);
            int oldFirstRow = tableview.getFirstRow();
            try {
                book = MiscUtil.unpack(ExtGuiExecutor.this._bookData);
                ReportProperties rp = ExtGuiExecutor.this._dataProvider.fetchCurrentReportProperties();
                if (rp != null) {
                    book.getDeps().setCalcDescription("localhost", "localhost", rp.getName());
                } else {
                    book.getDeps().setCalcDescription("localhost", "localhost", ExtGuiExecutor.this._book.getName());
                }
            }
            catch (Exception e1) {
                if (MiscUtil.shouldLog()) {
                    MiscUtil.log(e1);
                }
                return;
            }
            ExecutionContext ctx = book.getDataSetManager().getExecutionContext();
            ExecutionContext oldctx = ExtGuiExecutor.this._book.getDataSetManager().getExecutionContext();
            ctx.setDataSetParameters(oldctx.getDataSetParameters());
            ctx.copyCacheObjectFrom(oldctx);
            ctx.setRptRuntimeCallback(oldctx.getRptRuntimeCallback());
            ExtDataSet[] datasets = MiscUtil.collectExtDataSets(book);
            long t1 = System.currentTimeMillis();
            IExtDatasetFilter filter = ExtGuiExecutor.this._dataProvider.fetchDataSetFilter(datasets, ctx);
            long t2 = System.currentTimeMillis();
            if (MiscUtil.shouldLog()) {
                MiscUtil.log(3, CtrlEXTMessages.getMLS("popupParameterInterfaceTime", "\u5f39\u51fa\u53c2\u6570\u754c\u9762\u8017\u65f6\uff1a") + (t2 - t1) + " ms");
            }
            book.getDataSetManager().getExecutionContext().setUseDemoData(ExtGuiExecutor.this.shouldUseDemoData());
            if (filter != null) {
                ExtGuiExecutor.this.rptRunStart = System.currentTimeMillis() - ExtGuiExecutor.this.rptRunStart;
                Map<ExtDataSetType, IExtDataSetFactory> params = filter.filter(true);
                if (params == null) {
                    return;
                }
                ExtGuiExecutor.this.rptRunStart = System.currentTimeMillis() - ExtGuiExecutor.this.rptRunStart;
                ExtGuiExecutor.this._context.getStateManager().stopEditing();
                ExtExecutor.exec(book, ExtGuiExecutor.this._dataProvider.fetchDataSetFactories(MiscUtil.collectExtDataSetTypes(book), ctx), ExtGuiExecutor.mergeMap(params, ExtGuiExecutor.this._dataProvider.fetchSystemParameters()), ExtGuiExecutor.this._showcaseConfigs == null ? null : ExtGuiExecutor.this._showcaseConfigs.getCurrentConfig());
            } else {
                ExtGuiExecutor.this._context.getStateManager().stopEditing();
                ExtExecutor.exec(book, ExtGuiExecutor.this._dataProvider.fetchDataSetFactories(MiscUtil.collectExtDataSetTypes(book), ctx), ExtGuiExecutor.mergeMap(new HashMap(), ExtGuiExecutor.this._dataProvider.fetchSystemParameters()), ExtGuiExecutor.this._showcaseConfigs == null ? null : ExtGuiExecutor.this._showcaseConfigs.getCurrentConfig());
            }
            ExtGuiExecutor.this.resumeCurrentPosition(book);
            ExtGuiExecutor.this.executeSubReport(null, ExtGuiExecutor.this._book);
            ExtGuiExecutor.this.setBook();
            this.scrollToMaxRow(book, maxRowLast, oldFirstRow);
            if (ExtGuiExecutor.this._dataProvider != null) {
                ExtGuiExecutor.this._dataProvider.updateAuditTable(System.currentTimeMillis() - ExtGuiExecutor.this.rptRunStart);
            }
        }

        private void scrollToMaxRow(Book book, int maxRowLast, int oldFirstRow) {
            int maxRow = book.getActiveSheet().getMaxRowIndex();
            if (maxRow < maxRowLast) {
                JScrollBar vScrollBar;
                int firstRow;
                KDSpread spread = ExtGuiExecutor.this._context.getSpread();
                SpreadView tableview = (SpreadView)spread.getView(spread.getVerticalCount() - 1, spread.getHorizonCount() - 1);
                int n = firstRow = oldFirstRow == 0 ? tableview.getFirstRow() : oldFirstRow;
                if (maxRow < firstRow && (vScrollBar = spread.getScrollBarManager().getVScrollBar(spread.getVerticalCount() - 1)) != null) {
                    int maxRowPosition = Sheet.getRowY(book.getActiveSheet(), maxRow + 1);
                    int firstRowPosition = Sheet.getRowY(book.getActiveSheet(), tableview.getFirstRow());
                    int endRowPositon = Sheet.getRowY(book.getActiveSheet(), tableview.getEndRow());
                    vScrollBar.setValue(maxRowPosition - (endRowPositon - firstRowPosition));
                }
            }
        }
    }
}

