/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.immit.bill;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.cosmic.ctrl.ext.KDExt;
import com.kingdee.cosmic.ctrl.ext.immit.AbstractHyperLinkAssembler;
import com.kingdee.cosmic.ctrl.ext.immit.IExtCallback;
import com.kingdee.cosmic.ctrl.ext.immit.IHyperTabContext;
import com.kingdee.cosmic.ctrl.ext.immit.bill.BillProp;
import com.kingdee.cosmic.ctrl.ext.ui.icons.ResourceManager;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.dlg.FormulaWizardPopupForF7;
import com.kingdee.cosmic.ctrl.ext.util.MessageUtil;
import com.kingdee.cosmic.ctrl.kdf.table.ICell;
import com.kingdee.cosmic.ctrl.kdf.table.IRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.table.KDTableHelper;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.cosmic.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.cosmic.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.CommonCalculableProps;
import com.kingdee.cosmic.ctrl.swing.IKDEditor;
import com.kingdee.cosmic.ctrl.swing.KDCheckBox;
import com.kingdee.cosmic.ctrl.swing.KDComboBox;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDPromptBox;
import com.kingdee.cosmic.ctrl.swing.KDPromptSelector;
import com.kingdee.cosmic.ctrl.swing.KDWorkButton;
import com.kingdee.cosmic.ctrl.swing.event.SelectorEvent;
import com.kingdee.cosmic.ctrl.swing.event.SelectorListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;

public class BillHyperLinkAssembler
extends AbstractHyperLinkAssembler
implements IHyperTabContext {
    public static final String UI_ID_LIST = "ID_LIST";
    public static final String UI_READ_ONLY = "UI_READ_ONLY";
    public static final String UI_PATH_ALIAS = "UI_PATH_ALIAS";
    public static final String UI_LINK_TO = "UI_LINK_TO";
    public static final String UI_DETAIL = "UI_DETAIL";
    public static final String UI_FID = "UI_FID";
    public static final String UI_ID = "UI_ID";
    public static final String UI_APPID = "UI_APPID";
    private KDWorkButton delBtn;
    private KDWorkButton insertBtn;
    private KDWorkButton delParamBtn;
    private KDWorkButton insertParamBtn;
    private KDLabel reportLbl;
    private KDLabel paramLbl;
    private KDTable reportTable;
    private KDTable paramTable;
    private final String BILL_LIST = CtrlEXTMessages.getMLS("list", "\u5217\u8868");
    private final String BILL_DETAIL = CtrlEXTMessages.getMLS("form", "\u8868\u5355");
    private static final String SEPARATOR = "/";
    private List<Map<String, Object>> lastAssembled;
    private Color locked = new Color(220, 220, 220);
    public static final String PREFIX = "BILL_LINK:";
    protected KDPromptBox _targetFetcher;
    private RptBizSelector _rptSelector;
    private static final int COL_TABLE_PATH = 0;
    private static final int COL_TABLE_DESC = 1;
    private static final int COL_TABLE_LINK_TO = 2;
    private static final int COL_TABLE_READONLY = 3;
    private static final int COL_TABLE_FID = 4;
    private static final int COL_TABLE_ID = 5;
    private static final int COL_TABLE_APPID = 6;
    private static final int COL_PARAM_NO = 0;
    private static final int COL_PARAM_BILL_ID = 1;

    public BillHyperLinkAssembler(KDExt ext) {
        super(ext);
        this.initComps();
        this.initListeners();
    }

    private void initComps() {
        this.delBtn = new KDWorkButton((Icon)ResourceManager.getImageIcon("tbtn_Delete.gif"));
        this.insertBtn = new KDWorkButton((Icon)ResourceManager.getImageIcon("tbtn_Insert.gif"));
        this.delParamBtn = new KDWorkButton((Icon)ResourceManager.getImageIcon("tbtn_Delete.gif"));
        this.insertParamBtn = new KDWorkButton((Icon)ResourceManager.getImageIcon("tbtn_Insert.gif"));
        this.reportLbl = new KDLabel();
        this.paramLbl = new KDLabel();
        this.reportTable = new KDTable();
        this.paramTable = new KDTable();
        this.paramTable.getScriptManager().setScriptDisabled(true);
        this.reportLbl.setText(CtrlEXTMessages.getMLS("linkedSettings", "\u8054\u67e5\u8bbe\u7f6e"));
        this.paramLbl.setText(CtrlEXTMessages.getMLS("parameterSettings", "\u53c2\u6570\u8bbe\u7f6e"));
        this.initTables();
        this.setCustomInsets(new Insets(5, 5, 5, 5));
        TableLayout2 layout = new TableLayout2(4, 3);
        this.setLayout((LayoutManager)layout);
        layout.setRatableWidth(0, 1);
        layout.setFixedWidth(1, 22);
        layout.setFixedWidth(2, 22);
        layout.setFixedHeight(0, 22);
        layout.setRatableHeight(1, 1);
        layout.setFixedHeight(2, 22);
        layout.setRatableHeight(3, 1);
        layout.setRowSpacing(0, 5);
        layout.setRowSpacing(1, 10);
        layout.setRowSpacing(2, 5);
        layout.setColSpacing(1, 4);
        this.add((Component)this.reportLbl, TableLayout2.param((int)0, (int)0));
        this.add((Component)this.delBtn, TableLayout2.param((int)0, (int)2));
        this.add((Component)this.insertBtn, TableLayout2.param((int)0, (int)1));
        this.add((Component)this.delParamBtn, TableLayout2.param((int)2, (int)2));
        this.add((Component)this.insertParamBtn, TableLayout2.param((int)2, (int)1));
        this.add((Component)this.reportTable, TableLayout2.param((int)1, (int)0, (int)1, (int)2));
        this.add((Component)this.paramLbl, TableLayout2.param((int)2, (int)0));
        this.add((Component)this.paramTable, TableLayout2.param((int)3, (int)0, (int)3, (int)2));
    }

    private void initTables() {
        KDPromptBox f7FormulaWizard = new KDPromptBox();
        f7FormulaWizard.setHistoryRecordEnabled(false);
        f7FormulaWizard.setIcon(ResourceManager.getImageIcon("func_new.png").getImage());
        f7FormulaWizard.setSelector((KDPromptSelector)new FormulaWizardPopupForF7(this.ext, f7FormulaWizard));
        f7FormulaWizard.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                KDPromptBox f7 = (KDPromptBox)e.getSource();
                FormulaWizardPopupForF7 popup = (FormulaWizardPopupForF7)f7.getSelector();
                popup.setEditingData(f7.getText());
                popup.setImpresario((KDDialog)SwingUtilities.getWindowAncestor((Component)((Object)BillHyperLinkAssembler.this)));
            }
        });
        this.reportTable.getSelectManager().setSelectMode(2);
        this.reportTable.addColumns(7);
        this.reportTable.getColumn(0).setWidth(255);
        this.reportTable.getColumn(1).setWidth(130);
        this.reportTable.getColumn(2).setWidth(70);
        this.reportTable.getColumn(3).setWidth(40);
        this.reportTable.getColumn(4).getStyleAttributes().setHided(true);
        this.reportTable.getColumn(5).getStyleAttributes().setHided(true);
        this.reportTable.getColumn(6).getStyleAttributes().setHided(true);
        this.reportTable.addHeadRow();
        this.reportTable.getHeadRow(0).getCell(0).setValue((Object)CtrlEXTMessages.getMLS("billPath", "\u5355\u636e\u8def\u5f84"));
        this.reportTable.getHeadRow(0).getCell(1).setValue((Object)CtrlEXTMessages.getMLS("displayName", "\u663e\u793a\u540d\u79f0"));
        this.reportTable.getHeadRow(0).getCell(2).setValue((Object)CtrlEXTMessages.getMLS("linkTo", "\u8054\u67e5\u5230"));
        this.reportTable.getHeadRow(0).getCell(3).setValue((Object)CtrlEXTMessages.getMLS("readOnly", "\u53ea\u8bfb"));
        this.reportTable.getHeadRow(0).getCell(4).getStyleAttributes().setHided(true);
        this.reportTable.getHeadRow(0).getCell(5).getStyleAttributes().setHided(true);
        this.reportTable.getHeadRow(0).getCell(6).getStyleAttributes().setHided(true);
        this.reportTable.getIndexColumn().getStyleAttributes().setHided(true);
        KDTableHelper.setEnterKeyJumpOrientation((KDTable)this.reportTable, (int)0);
        this.paramTable.getSelectManager().setSelectMode(2);
        this.paramTable.addColumns(2);
        this.paramTable.getColumn(0).setWidth(60);
        this.paramTable.getColumn(0).getStyleAttributes().setLocked(true);
        this.paramTable.getColumn(1).setWidth(300);
        this.paramTable.addHeadRow();
        this.paramTable.getHeadRow(0).getCell(0).setValue((Object)CtrlEXTMessages.getMLS("serialNumber", "\u5e8f\u53f7"));
        this.paramTable.getHeadRow(0).getCell(1).setValue((Object)CtrlEXTMessages.getMLS("billID", "\u5355\u636eID"));
        this.paramTable.getIndexColumn().getStyleAttributes().setHided(true);
        ActionMap am = this.paramTable.getActionMap();
        am.remove("Copy");
        am.remove("Paste");
        am.remove("Cut");
        am.remove("Delete");
        am = this.reportTable.getActionMap();
        am.remove("Copy");
        am.remove("Paste");
        am.remove("Cut");
        am.remove("Delete");
        this._targetFetcher = new KDPromptBox();
        this._targetFetcher.setHistoryRecordEnabled(false);
        this._rptSelector = new RptBizSelector();
        this._targetFetcher.setSelector((KDPromptSelector)this._rptSelector);
        this.reportTable.getColumn(0).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this._targetFetcher));
        this.reportTable.getColumn(2).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)new KDComboBox((Object[])new String[]{this.BILL_LIST, this.BILL_DETAIL})));
        this.reportTable.getColumn(3).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)new KDCheckBox()));
        this.paramTable.getColumn(1).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)f7FormulaWizard));
    }

    private List<Object> getCurrentTransitionIDList() {
        Object ids;
        IRow row = this.reportTable.getRow(this.reportTable.getSelectManager().getActiveRowIndex());
        if (row == null) {
            return Collections.emptyList();
        }
        HashMap map = (HashMap)row.getUserObject();
        if (map == null) {
            map = new HashMap(4);
            row.setUserObject(map);
            map.put(UI_ID_LIST, new ArrayList());
        }
        if ((ids = map.get(UI_ID_LIST)) instanceof CommonCalculableProps[]) {
            ArrayList<Object> list = new ArrayList<Object>(((CommonCalculableProps[])ids).length);
            for (CommonCalculableProps commonCalculableProps : (CommonCalculableProps[])ids) {
                list.add(this.getFormula(commonCalculableProps));
            }
            return list;
        }
        return (List)ids;
    }

    private void initListeners() {
        this.delParamBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectIndex = BillHyperLinkAssembler.this.paramTable.getSelectManager().getActiveRowIndex();
                IRow rowRemoved = BillHyperLinkAssembler.this.paramTable.getRow(selectIndex);
                if (rowRemoved == null) {
                    return;
                }
                BillHyperLinkAssembler.this.paramTable.removeRow(selectIndex);
                BillHyperLinkAssembler.this.alignParamNo();
                List list = BillHyperLinkAssembler.this.getCurrentTransitionIDList();
                if (list != null) {
                    list.remove(rowRemoved.getCell(1).getValue());
                }
            }
        });
        this.insertParamBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BillHyperLinkAssembler.this.reportTable.getSelectManager().getActiveRowIndex() < 0) {
                    return;
                }
                int index = BillHyperLinkAssembler.this.paramTable.getSelectManager().getActiveRowIndex();
                IRow rowAdded = index < 0 ? BillHyperLinkAssembler.this.paramTable.addRow() : BillHyperLinkAssembler.this.paramTable.addRow(index + 1);
                BillHyperLinkAssembler.this.lockCell(rowAdded.getCell(0));
                BillHyperLinkAssembler.this.alignParamNo();
                BillHyperLinkAssembler.this.paramTable.getEditManager().editCellAt(rowAdded.getRowIndex(), 1);
            }
        });
        this.delBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BillHyperLinkAssembler.this.reportTable.removeRow(BillHyperLinkAssembler.this.reportTable.getSelectManager().getActiveRowIndex());
                BillHyperLinkAssembler.this.syncParams();
            }
        });
        this.insertBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = BillHyperLinkAssembler.this.reportTable.getSelectManager().getActiveRowIndex();
                IRow rowAdded = index < 0 ? BillHyperLinkAssembler.this.reportTable.addRow() : BillHyperLinkAssembler.this.reportTable.addRow(index);
                rowAdded.getCell(2).setValue((Object)BillHyperLinkAssembler.this.BILL_LIST);
                rowAdded.getCell(3).setValue((Object)false);
                BillHyperLinkAssembler.this.lockCell(rowAdded.getCell(3));
                BillHyperLinkAssembler.this.reportTable.getEditManager().editCellAt(rowAdded.getRowIndex(), 0);
                BillHyperLinkAssembler.this.syncParams();
            }
        });
        this.reportTable.getSelectManager().addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                BillHyperLinkAssembler.this.syncParams();
            }
        });
        this.reportTable.getEditManager().addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                KDTableUtil.setSelectedRow((KDTable)BillHyperLinkAssembler.this.reportTable, (int)e.getRowIndex());
            }

            public void editStopping(KDTEditEvent e) {
                int col = e.getColIndex();
                if (col == 0) {
                    if (!(e.getValue() instanceof BillProp) && (e.getOldValue() == null || e.getOldValue().equals(e.getValue()))) {
                        e.setCancel(true);
                        BillHyperLinkAssembler.this.reportTable.getEditManager().editingCanceled();
                        return;
                    }
                    IRow row = BillHyperLinkAssembler.this.reportTable.getRow(BillHyperLinkAssembler.this.reportTable.getSelectManager().getActiveRowIndex());
                    Object descValue = row.getCell(1).getValue();
                    BillProp billProp = (BillProp)e.getValue();
                    if (billProp == null) {
                        return;
                    }
                    if (descValue == null || !billProp.equals(e.getOldValue())) {
                        String[] pathSplit = billProp.getPathAlias().split(BillHyperLinkAssembler.SEPARATOR);
                        descValue = pathSplit[pathSplit.length - 1];
                        row.getCell(1).setValue(descValue);
                    }
                    row.getCell(4).setValue((Object)billProp.getFid());
                    row.getCell(5).setValue((Object)billProp.getId());
                    row.getCell(6).setValue((Object)billProp.getAppId());
                } else if (col == 2) {
                    IRow row = BillHyperLinkAssembler.this.reportTable.getRow(BillHyperLinkAssembler.this.reportTable.getSelectManager().getActiveRowIndex());
                    ICell cell = row.getCell(3);
                    if (BillHyperLinkAssembler.this.BILL_DETAIL.equals(e.getValue())) {
                        BillHyperLinkAssembler.this.unLockCell(cell);
                    } else {
                        cell.setValue((Object)false);
                        BillHyperLinkAssembler.this.lockCell(cell);
                    }
                }
            }
        });
        this.paramTable.getEditManager().addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editCanceled(KDTEditEvent e) {
                if (e.getOldValue() == null) {
                    BillHyperLinkAssembler.this.paramTable.removeRow(e.getRowIndex());
                    BillHyperLinkAssembler.this.alignParamNo();
                }
            }

            public void editStopping(KDTEditEvent e) {
                if (e.getColIndex() == 1) {
                    Object oldValue = e.getOldValue();
                    Object value = e.getValue();
                    if (value == null && oldValue == null) {
                        e.setCancel(true);
                        BillHyperLinkAssembler.this.paramTable.getEditManager().editingCanceled();
                        BillHyperLinkAssembler.this.alignParamNo();
                        return;
                    }
                    List list = BillHyperLinkAssembler.this.getCurrentTransitionIDList();
                    if (list != null) {
                        list.remove(oldValue);
                        if (e.getValue() != null) {
                            list.add(value);
                        }
                    }
                }
            }
        });
    }

    private void lockCell(ICell cell) {
        StyleAttributes sa = cell.getStyleAttributes();
        sa.setBackground(this.locked);
        sa.setLocked(true);
    }

    private void unLockCell(ICell cell) {
        StyleAttributes sa = cell.getStyleAttributes();
        sa.setBackground(null);
        sa.setLocked(false);
    }

    private void alignParamNo() {
        int rowCount = this.paramTable.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            ICell cell = this.paramTable.getRow(i).getCell(0);
            cell.setValue((Object)(i + 1));
        }
    }

    private void syncParams() {
        this.paramTable.removeRows();
        this.refreshParamTable(this.getCurrentTransitionIDList());
        if (this.paramTable.getRowCount() > 0) {
            this.paramTable.getSelectManager().select(0, 0);
        }
    }

    private void refreshParamTable(List<Object> idList) {
        if (idList == null || idList.isEmpty()) {
            return;
        }
        this.paramTable.removeRows();
        for (int i = 0; i < idList.size(); ++i) {
            IRow addedRow = this.paramTable.addRow();
            addedRow.getCell(1).setValue(idList.get(i));
            ICell noCell = addedRow.getCell(0);
            this.lockCell(noCell);
        }
        this.alignParamNo();
    }

    private void showMsgBox(String msg) {
        MessageUtil.msgboxInfo((Component)((Object)this), msg);
    }

    @Override
    public void setAssembledTargets(List<Map<String, Object>> paramMaps) {
        this.lastAssembled = null;
        this.reportTable.removeRows();
        this.paramTable.removeRows();
        if (paramMaps == null) {
            return;
        }
        int size = paramMaps.size();
        for (int i = 0; i < size; ++i) {
            Map map = paramMaps.get(i);
            map = (Map)((HashMap)map).clone();
            IRow rowAdded = this.reportTable.addRow();
            rowAdded.getCell(1).setValue(map.get("DISPLAY_NAME"));
            Object linkTo = map.get(UI_LINK_TO);
            rowAdded.getCell(2).setValue(linkTo);
            ICell readOnlyCell = rowAdded.getCell(3);
            if (this.BILL_LIST.equals(linkTo)) {
                this.lockCell(readOnlyCell);
                readOnlyCell.setValue((Object)false);
            } else {
                readOnlyCell.setValue((Object)Boolean.parseBoolean((String)map.get(UI_READ_ONLY)));
            }
            rowAdded.getCell(4).setValue(map.get(UI_FID));
            rowAdded.getCell(5).setValue(map.get(UI_ID));
            rowAdded.getCell(6).setValue(map.get(UI_APPID));
            rowAdded.getCell(0).setValue((Object)this.ext.getExtCallback().getEntityPath((String)map.get(UI_ID), (String)map.get(UI_APPID)));
            CommonCalculableProps[] idList = (CommonCalculableProps[])map.get(UI_ID_LIST);
            if (idList != null) {
                ArrayList<String> list = new ArrayList<String>(idList.length);
                for (CommonCalculableProps commonCalculableProps : idList) {
                    list.add(this.getFormula(commonCalculableProps));
                }
                map.put(UI_ID_LIST, list);
            }
            rowAdded.setUserObject((Object)map);
        }
        this.reportTable.getSelectManager().select(0, 0);
    }

    @Override
    public List<Map<String, Object>> getAssembledTargets() {
        this.lastAssembled = null;
        int count = this.reportTable.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow curRow;
            HashMap<String, String> map;
            if (this.lastAssembled == null) {
                this.lastAssembled = new ArrayList<Map<String, Object>>();
            }
            if ((map = (HashMap<String, String>)(curRow = this.reportTable.getRow(i)).getUserObject()) != null) {
                Object ids = map.get(UI_ID_LIST);
                if (ids instanceof CommonCalculableProps[]) {
                    map.put(UI_ID_LIST, (String)ids);
                } else {
                    List items = (List)ids;
                    if (items != null && !items.isEmpty()) {
                        CommonCalculableProps[] idList = new CommonCalculableProps[items.size()];
                        int size = items.size();
                        for (int j = 0; j < size; ++j) {
                            idList[j] = this.getCommonCalculableProps((String)items.get(j));
                        }
                        map.put(UI_ID_LIST, (String)idList);
                    }
                }
            }
            if (map == null) {
                map = new HashMap<String, String>();
            }
            map.put("ASSEMBLER_NAME", BillHyperLinkAssembler.class.getName());
            map.put("HYPERLINK_PREFIX", PREFIX);
            map.put("DISPLAY_NAME", (String)curRow.getCell(1).getValue());
            map.put(UI_LINK_TO, (String)curRow.getCell(2).getValue());
            map.put(UI_DETAIL, (String)((Object)Boolean.valueOf(this.BILL_DETAIL.equals(curRow.getCell(2).getValue()))));
            Object readOnlyVal = curRow.getCell(3).getValue();
            map.put(UI_READ_ONLY, readOnlyVal == null ? Boolean.FALSE.toString() : readOnlyVal.toString());
            map.put(UI_FID, curRow.getCell(4).getValue().toString());
            map.put(UI_ID, curRow.getCell(5).getValue().toString());
            map.put(UI_APPID, curRow.getCell(6).getValue().toString());
            this.lastAssembled.add(map);
        }
        return this.lastAssembled;
    }

    @Override
    public Map getSuggestedDefaultTarget() {
        return null;
    }

    @Override
    public boolean checkValid() {
        HashSet<String> allAlias = new HashSet<String>(8);
        int count = this.reportTable.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow curRow = this.reportTable.getRow(i);
            Object path = curRow.getCell(0).getValue();
            if (path == null) {
                this.showMsgBox(CtrlEXTMessages.getMLS("PageView_CN_DI", "\u7b2c") + (i + 1) + "\u884c\u7684\u5355\u636e\u8def\u5f84\u4e0d\u53ef\u4e3a\u7a7a\uff01");
                return false;
            }
            String desc = (String)curRow.getCell(1).getValue();
            if (desc == null) {
                this.showMsgBox(CtrlEXTMessages.getMLS("PageView_CN_DI", "\u7b2c") + (i + 1) + "\u884c\u7684\u663e\u793a\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a\uff01");
                return false;
            }
            if (!allAlias.add(desc)) {
                this.showMsgBox(CtrlEXTMessages.getMLS("displayNameConflict", "\u7b2c#1\u884c\u7684\u663e\u793a\u540d\u79f0 [#2] \u4e0e\u5176\u4ed6\u884c\u91cd\u590d\uff01").replace("#1", String.valueOf(i + 1)).replace("#2", desc));
                return false;
            }
            Map rowUserObject = (Map)curRow.getUserObject();
            List<Object> idList = this.getCurrentTransitionIDList();
            if (rowUserObject == null || idList == null || idList.isEmpty()) {
                this.showMsgBox(CtrlEXTMessages.getMLS("jointTargetConfig", "\u8054\u67e5\u76ee\u6807 [#1] \u6ca1\u6709\u914d\u7f6e\u4efb\u4f55\u5355\u636eID\uff01").replace("#1", curRow.getCell(1).getValue().toString()));
                return false;
            }
            if (this.BILL_DETAIL.equals(curRow.getCell(2).getValue()) && idList.size() > 1) {
                this.showMsgBox(CtrlEXTMessages.getMLS("jointTargetForm", "[#1]\u4e3a\u8054\u67e5\u5230\u201c\u8868\u5355\u201d\uff0c\u53ea\u80fd\u8bbe\u7f6e\u4e00\u6761\u5355\u636eID\uff01").replace("#1", curRow.getCell(1).getValue().toString()));
                return false;
            }
            int size = idList.size();
            for (int j = 0; j < size; ++j) {
                String formula = (String)idList.get(j);
                if (this.getCommonCalculableProps(formula) != null) continue;
                this.showMsgBox(CtrlEXTMessages.getMLS("formulaParseError", "\u516c\u5f0f\" #1 \"\u4e0d\u80fd\u88ab\u6b63\u786e\u89e3\u6790\uff01").replace("#1", formula));
                return false;
            }
        }
        return true;
    }

    @Override
    public String getHyperLinkPrefix() {
        return PREFIX;
    }

    @Override
    public Set<String> getAlias() {
        HashSet<String> alias = new HashSet<String>(8);
        int rowCount = this.reportTable.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            alias.add((String)this.reportTable.getCell(i, 1).getValue());
        }
        return alias;
    }

    @Override
    public String getDisplayName() {
        return CtrlEXTMessages.getMLS("billQuery", "\u5355\u636e\u8054\u67e5");
    }

    public void setSelectedBillState(IExtCallback callback) {
        IRow row = this.reportTable.getRow(this.reportTable.getSelectManager().getActiveRowIndex());
        String fid = (String)row.getCell(4).getValue();
        String id = (String)row.getCell(5).getValue();
        String appId = (String)row.getCell(6).getValue();
        String name = (String)row.getCell(1).getValue();
        BillProp prop = new BillProp(fid, id, name);
        prop.setAppId(appId);
        callback.setSelectedBill(prop);
    }

    protected class RptBizSelector
    implements KDPromptSelector {
        private BillProp billProp;
        private boolean isCancel;

        protected RptBizSelector() {
        }

        public void show() {
            IExtCallback callback = BillHyperLinkAssembler.this.ext.getExtCallback();
            BillHyperLinkAssembler.this.setSelectedBillState(callback);
            this.billProp = callback.fetchBillTarget();
            if (this.billProp == null) {
                this.isCancel = true;
                return;
            }
            this.isCancel = false;
        }

        public boolean isCanceled() {
            return this.isCancel;
        }

        public Object getData() {
            return this.billProp;
        }
    }
}

