/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.immit.customlinkage;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.KDExt;
import com.kingdee.cosmic.ctrl.ext.immit.AbstractHyperLinkAssembler;
import com.kingdee.cosmic.ctrl.ext.immit.IExtCallback;
import com.kingdee.cosmic.ctrl.ext.immit.IHyperTabContext;
import com.kingdee.cosmic.ctrl.ext.immit.ReportProperties;
import com.kingdee.cosmic.ctrl.ext.ui.icons.ResourceManager;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.dlg.FormulaWizardPopupForF7;
import com.kingdee.cosmic.ctrl.ext.util.MessageUtil;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import com.kingdee.cosmic.ctrl.kdf.table.ICell;
import com.kingdee.cosmic.ctrl.kdf.table.IColumn;
import com.kingdee.cosmic.ctrl.kdf.table.IRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.cosmic.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.cosmic.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.cosmic.ctrl.kds.exec.ExecutionContext;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtTransitionTarget;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ICalculableProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.IParameter;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ParameterImpl;
import com.kingdee.cosmic.ctrl.kds.model.expr.Expr;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExprContext;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.swing.IKDEditor;
import com.kingdee.cosmic.ctrl.swing.KDComboBox;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDPromptBox;
import com.kingdee.cosmic.ctrl.swing.KDPromptSelector;
import com.kingdee.cosmic.ctrl.swing.KDTabbedPane;
import com.kingdee.cosmic.ctrl.swing.KDWorkButton;
import com.kingdee.cosmic.ctrl.swing.event.SelectorEvent;
import com.kingdee.cosmic.ctrl.swing.event.SelectorListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;

public class CustomHyperLinkAssembler
extends AbstractHyperLinkAssembler
implements IHyperTabContext {
    public static final String PREFIX = "CUSTOM_JUMPER:";
    public static final String JAVA_CLASS_NAME = "JAVA_CLASS_NAME";
    public static final String JAVA_PARAMS = "JAVA_PARAMS";
    private KDWorkButton _delBtn;
    private KDWorkButton _insertBtn;
    private KDWorkButton _refreshParamBtn;
    private KDLabel _reportLbl;
    private KDLabel _paramLbl;
    private KDTable _reportTable;
    private KDTable _paramTable;
    private Color _locked = new Color(220, 220, 220);
    private Map<String, IParameter> _lastSynced;
    private IRow _currentRow;
    private List<Map<String, Object>> lastAssembled;
    private static final int COL_CUSTOM_ALIAS = 0;
    private static final int COL_JAVA_CLASS_PATH = 1;
    private static final int COL_P_NAME = 0;
    private static final int COL_P_VALUE = 1;
    private static final int COL_P_ALIAS = 2;
    private static final int COL_P_TYPE = 3;
    private static final int COL_P_REQUIRD = 4;
    public static final String SEPARATOR = "!";
    private KDLabel _labelParam;

    protected static final String getText() {
        return CtrlEXTMessages.getMLS("text", "\u6587\u672c");
    }

    protected static final String getNumber() {
        return CtrlEXTMessages.getMLS("number", "\u6570\u5b57");
    }

    protected static final String getDate() {
        return CtrlEXTMessages.getMLS("date", "\u65e5\u671f");
    }

    protected static final String getDateTime() {
        return CtrlEXTMessages.getMLS("timestamp", "\u65f6\u95f4\u6233");
    }

    protected static final String getTime() {
        return CtrlEXTMessages.getMLS("time", "\u65f6\u95f4");
    }

    protected static final String getBoolean() {
        return CtrlEXTMessages.getMLS("boolean", "\u5e03\u5c14");
    }

    protected static final String getUnknow() {
        return CtrlEXTMessages.getMLS("unknown", "\u672a\u77e5");
    }

    public CustomHyperLinkAssembler(KDExt ext) {
        super(ext);
        this.initComps();
        this.initListeners();
    }

    private void initComps() {
        ImageIcon iconDel = ResourceManager.getImageIcon("tbtn_Delete.gif");
        ImageIcon iconInsert = ResourceManager.getImageIcon("tbtn_Insert.gif");
        this._refreshParamBtn = new KDWorkButton((Icon)ResourceManager.getImageIcon("tbtn_Refresh.gif"));
        this._delBtn = new KDWorkButton((Icon)iconDel);
        this._insertBtn = new KDWorkButton((Icon)iconInsert);
        this._reportLbl = new KDLabel();
        this._paramLbl = new KDLabel();
        this._reportTable = new KDTable();
        this._reportTable.getScriptManager().setScriptDisabled(true);
        this._paramTable = new KDTable();
        this._paramTable.getScriptManager().setScriptDisabled(true);
        this._reportLbl.setText(CtrlEXTMessages.getMLS("linkedSettings", "\u8054\u67e5\u8bbe\u7f6e"));
        this._paramLbl.setText(CtrlEXTMessages.getMLS("parameterSettings", "\u53c2\u6570\u8bbe\u7f6e"));
        this.initTables();
        this.setCustomInsets(new Insets(5, 5, 5, 5));
        TableLayout2 layout = new TableLayout2(6, 5);
        this.setLayout((LayoutManager)layout);
        layout.setFixedWidth(0, 140);
        layout.setRatableWidth(1, 1);
        layout.setFixedWidth(2, 22);
        layout.setFixedWidth(3, 22);
        layout.setFixedWidth(4, 22);
        layout.setFixedHeight(0, 22);
        layout.setRatableHeight(1, 1);
        layout.setFixedHeight(4, 22);
        layout.setRatableHeight(5, 1);
        layout.setRowSpacing(0, 5);
        layout.setRowSpacing(1, 10);
        layout.setRowSpacing(2, 0);
        layout.setRowSpacing(3, 0);
        layout.setRowSpacing(4, 5);
        layout.setColSpacing(3, 4);
        layout.setColSpacing(2, 4);
        layout.setFixedHeight(2, 0);
        layout.setFixedHeight(3, 0);
        this.add((Component)this._reportLbl, TableLayout2.param((int)0, (int)0));
        this.add((Component)this._delBtn, TableLayout2.param((int)0, (int)4));
        this.add((Component)this._insertBtn, TableLayout2.param((int)0, (int)3));
        this.add((Component)this._reportTable, TableLayout2.param((int)1, (int)0, (int)1, (int)4));
        this.add((Component)this._paramLbl, TableLayout2.param((int)4, (int)0));
        this.add((Component)this._refreshParamBtn, TableLayout2.param((int)4, (int)4));
        this.add((Component)this._paramTable, TableLayout2.param((int)5, (int)0, (int)5, (int)4));
    }

    private void initListeners() {
        this._refreshParamBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomHyperLinkAssembler.this.syncParams(true);
            }
        });
        this._delBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IRow rowRemoved = CustomHyperLinkAssembler.this._reportTable.removeRow(CustomHyperLinkAssembler.this._reportTable.getSelectManager().getActiveRowIndex());
                if (rowRemoved != null) {
                    CustomHyperLinkAssembler.this.syncParams(false);
                }
            }
        });
        this._insertBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = CustomHyperLinkAssembler.this._reportTable.getSelectManager().getActiveRowIndex();
                IRow rowAdded = index < 0 ? CustomHyperLinkAssembler.this._reportTable.addRow() : CustomHyperLinkAssembler.this._reportTable.addRow(index);
                int rowIndex = rowAdded.getRowIndex();
                KDTableUtil.setSelectedRow((KDTable)CustomHyperLinkAssembler.this._reportTable, (int)rowIndex);
                CustomHyperLinkAssembler.this._reportTable.scrollToVisible(rowIndex, 0);
                CustomHyperLinkAssembler.this._reportTable.getEditManager().editCellAt(rowIndex, 0);
                CustomHyperLinkAssembler.this.syncParams(false);
            }
        });
        this._reportTable.getSelectManager().addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                CustomHyperLinkAssembler.this._currentRow = CustomHyperLinkAssembler.this._reportTable.getRow(CustomHyperLinkAssembler.this._reportTable.getSelectManager().getActiveRowIndex());
                if (CustomHyperLinkAssembler.this._currentRow.getCell(1).getValue() == null) {
                    CustomHyperLinkAssembler.this.syncParams(false);
                } else {
                    CustomHyperLinkAssembler.this.syncParams(true);
                }
            }
        });
        this._reportTable.getEditManager().addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                if (Boolean.TRUE.equals(e.getOldValue())) {
                    e.setCancel(true);
                }
                KDTableUtil.setSelectedRow((KDTable)CustomHyperLinkAssembler.this._reportTable, (int)e.getRowIndex());
            }

            public void editStopping(KDTEditEvent e) {
                int col = e.getColIndex();
                String edited = (String)e.getValue();
                int rowIndex = e.getRowIndex();
                IRow row = CustomHyperLinkAssembler.this._reportTable.getRow(rowIndex);
                if (col == 0) {
                    if (StringUtil.isEmptyString((String)edited)) {
                        return;
                    }
                    if (CustomHyperLinkAssembler.this.checkDupliAlias(edited, rowIndex)) {
                        CustomHyperLinkAssembler.this.showMsgBox(CtrlEXTMessages.getMLS("duplicateDisplayName", "\u663e\u793a\u540d\u79f0\u91cd\u590d\uff01"));
                        return;
                    }
                    if (CustomHyperLinkAssembler.this.checkTabsDupliAlias(edited)) {
                        return;
                    }
                    row.getCell(0).setValue((Object)edited);
                } else if (col == 1) {
                    ExtTransitionTarget oldTarget = (ExtTransitionTarget)row.getUserObject();
                    edited = (String)e.getValue();
                    if (!CustomHyperLinkAssembler.this.checkClassName(edited)) {
                        return;
                    }
                    String name = (String)row.getCell(0).getValue();
                    if (StringUtil.isEmptyString((String)name)) {
                        String[] classNames = edited.split("\\.");
                        String alias = classNames[classNames.length - 1];
                        int count = 1;
                        String tempAlias = alias;
                        while (CustomHyperLinkAssembler.this.checkDupliAlias(tempAlias, rowIndex)) {
                            tempAlias = alias;
                            tempAlias = tempAlias + count++;
                        }
                        row.getCell(0).setValue((Object)alias);
                    }
                    ExtTransitionTarget target = new ExtTransitionTarget(new ReportProperties(null, name, edited), CustomHyperLinkAssembler.this._lastSynced);
                    row.setUserObject((Object)target);
                    if (oldTarget == null || !edited.equals(oldTarget.getReportProps().getPath())) {
                        CustomHyperLinkAssembler.this.syncParams(true);
                    }
                }
            }
        });
        this._paramTable.getEditManager().addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editCanceled(KDTEditEvent e) {
                if (e.getColIndex() == 1 && e.getOldValue() == null) {
                    IRow rowRemoved = CustomHyperLinkAssembler.this._paramTable.removeRow(e.getRowIndex());
                    if (rowRemoved == null) {
                        return;
                    }
                    int activeRowIndex = CustomHyperLinkAssembler.this._reportTable.getSelectManager().getActiveRowIndex();
                    ExtTransitionTarget userObject = (ExtTransitionTarget)CustomHyperLinkAssembler.this._reportTable.getRow(activeRowIndex).getUserObject();
                    Object value = rowRemoved.getCell(0).getValue();
                    userObject.getParameters().remove(value);
                }
            }

            public void editStopping(KDTEditEvent e) {
                CustomHyperLinkAssembler.this.paramTableEditStopping(e);
            }
        });
    }

    private boolean checkDupliAlias(String edit, int rowIndex) {
        int count = this._reportTable.getRowCount();
        for (int i = 0; i < count; ++i) {
            ICell cell;
            if (rowIndex == i || (cell = this._reportTable.getCell(i, 0)).getValue() == null || !cell.getValue().equals(edit)) continue;
            return true;
        }
        return false;
    }

    private boolean checkTabsDupliAlias(String edit) {
        Component[] components;
        KDTabbedPane tabbedPane = (KDTabbedPane)this.getParent();
        for (Component component : components = tabbedPane.getComponents()) {
            IHyperTabContext tabContext;
            if (!(component instanceof IHyperTabContext) || component instanceof CustomHyperLinkAssembler || !(tabContext = (IHyperTabContext)((Object)component)).getAlias().contains(edit)) continue;
            this.showMsgBox(CtrlEXTMessages.getMLS("duplicateDisplayName2", "\u3010#1\u3011\u4e2d\u5b58\u5728\u76f8\u540c\u7684\u663e\u793a\u540d\u79f0\u3010#2\u3011").replace("#1", tabContext.getDisplayName()).replace("#2", edit));
            return true;
        }
        return false;
    }

    private void refreshParamTable(Map<String, IParameter> oldParams, Map<String, IParameter> newParams) {
        this._lastSynced = oldParams;
        this._paramTable.removeRows();
        if (oldParams == null) {
            this.setTipLabel();
            return;
        }
        if (newParams != null) {
            for (Map.Entry<String, IParameter> entry : newParams.entrySet()) {
                String key = entry.getKey();
                IParameter oldPi = oldParams.get(key);
                IParameter newPi = entry.getValue();
                if (oldParams.containsKey(key)) {
                    oldPi.setName(newPi.getName());
                    oldPi.setAlias(newPi.getAlias());
                    oldPi.setDataType(newPi.getDataType());
                    oldPi.setValue(newPi.getValue());
                    oldPi.setAvailableValues(newPi.getAvailableValues());
                    oldPi.setNullable(newPi.isNullable());
                    oldPi.setEditorClass(newPi.getEditorClass());
                    oldPi.setUserDefine(newPi.isUserDefine());
                    oldPi.setDescription(newPi.getDescription());
                    continue;
                }
                oldParams.put(key, newPi);
            }
            Set<String> oldParamKey = oldParams.keySet();
            ArrayList<String> delList = new ArrayList<String>();
            for (Map.Entry<String, IParameter> entry : oldParams.entrySet()) {
                String key = (String)entry.getKey();
                if (newParams.containsKey(key) || ((IParameter)entry.getValue()).isUserDefine()) continue;
                delList.add(key);
            }
            for (String key : delList) {
                oldParams.remove(key);
            }
        }
        Sheet sheet = MiscUtil.getActiveSpreadContext(this.ext).getBook().getActiveSheet();
        ExprContext ctx = sheet.getDeps().getExprContext();
        Cell cll = sheet.getActiveCell();
        if (cll == null) {
            cll = sheet.getCell(0, 0, true);
        }
        Set<String> set = oldParams.keySet();
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            ParameterImpl pi = (ParameterImpl)oldParams.get(iterator.next());
            IRow prow = this._paramTable.addRow();
            prow.setUserObject(pi.clone());
            prow.getCell(0).setValue((Object)pi.getName());
            ICell vCell = prow.getCell(1);
            String formula = pi.getFormula(ctx, cll);
            if (StringUtil.isEmptyString((String)formula)) {
                formula = pi.getFormula();
            }
            vCell.setValue((Object)formula);
            prow.getCell(2).setValue((Object)pi.getAlias());
            ICell tCell = prow.getCell(3);
            switch (pi.getDataType()) {
                case 0: {
                    tCell.setValue((Object)CustomHyperLinkAssembler.getText());
                    break;
                }
                case 1: {
                    tCell.setValue((Object)CustomHyperLinkAssembler.getNumber());
                    break;
                }
                case 2: {
                    tCell.setValue((Object)CustomHyperLinkAssembler.getDate());
                    break;
                }
                case 4: {
                    tCell.setValue((Object)CustomHyperLinkAssembler.getDateTime());
                    break;
                }
                case 5: {
                    tCell.setValue((Object)CustomHyperLinkAssembler.getTime());
                    break;
                }
                case 3: {
                    tCell.setValue((Object)CustomHyperLinkAssembler.getBoolean());
                    break;
                }
                default: {
                    tCell.setValue((Object)CustomHyperLinkAssembler.getUnknow());
                }
            }
            prow.getCell(4).setValue((Object)(pi.isNullable() ? Boolean.FALSE : Boolean.TRUE));
            vCell.getStyleAttributes().setLocked(Boolean.FALSE.booleanValue());
            vCell.getStyleAttributes().setBackground(Color.WHITE);
            if (!pi.isUserDefine()) continue;
            prow.getCell(0).getStyleAttributes().setLocked(false);
            prow.getCell(2).getStyleAttributes().setLocked(false);
            prow.getCell(3).getStyleAttributes().setLocked(false);
            prow.getCell(4).getStyleAttributes().setLocked(false);
            prow.getCell(0).getStyleAttributes().setBackground(Color.white);
            prow.getCell(2).getStyleAttributes().setBackground(Color.white);
            prow.getCell(3).getStyleAttributes().setBackground(Color.white);
            prow.getCell(4).getStyleAttributes().setBackground(Color.white);
        }
        this.setTipLabel();
    }

    private void initTables() {
        this._reportTable.getSelectManager().setSelectMode(2);
        this._reportTable.addColumns(2);
        this._reportTable.getColumn(0).setWidth(150);
        this._reportTable.getColumn(1).setWidth(320);
        this._reportTable.addHeadRow();
        IRow headRow = this._reportTable.getHeadRow(0);
        headRow.getCell(0).setValue((Object)CtrlEXTMessages.getMLS("displayName", "\u663e\u793a\u540d\u79f0"));
        headRow.getCell(1).setValue((Object)CtrlEXTMessages.getMLS("javaClassPath", "Java\u7c7b\u8def\u5f84"));
        this._reportTable.getIndexColumn().getStyleAttributes().setHided(true);
        ActionMap am = this._reportTable.getActionMap();
        am.remove("Copy");
        am.remove("Paste");
        am.remove("Cut");
        am.remove("Delete");
        this.initParamTable();
    }

    private void showMsgBox(String msg) {
        MessageUtil.msgboxInfo((Component)((Object)this), msg);
    }

    @Override
    public Set<String> getAlias() {
        HashSet<String> alias = new HashSet<String>(8);
        int rowCount = this._reportTable.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            alias.add((String)this._reportTable.getCell(i, 0).getValue());
        }
        return alias;
    }

    @Override
    public String getDisplayName() {
        return CtrlEXTMessages.getMLS("customizedQuery", "\u4ee3\u7801\u5b9a\u5236\u8054\u67e5");
    }

    @Override
    public boolean checkValid() {
        HashSet<String> aliasSet = new HashSet<String>(2);
        int count = this._reportTable.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow curRow = this._reportTable.getRow(i);
            String alias = (String)curRow.getCell(0).getValue();
            if (StringUtil.isEmptyString((String)alias)) {
                this.showMsgBox(CtrlEXTMessages.getMLS("emptyDisplayName", "\u663e\u793a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a"));
                return false;
            }
            if (aliasSet.contains(alias)) {
                this.showMsgBox(CtrlEXTMessages.getMLS("duplicateDisplayNameError", "\u663e\u793a\u540d\u79f0\u201c#1\u201d\u91cd\u590d").replace("#1", alias));
                return false;
            }
            String javaClassPath = (String)curRow.getCell(1).getValue();
            if (StringUtil.isEmptyString((String)javaClassPath)) {
                this.showMsgBox(CtrlEXTMessages.getMLS("emptyJavaClassPath", "Java\u7c7b\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a"));
                return false;
            }
            if (!this.checkClassName(javaClassPath)) {
                this.showMsgBox(CtrlEXTMessages.getMLS("classPathNotFound", "Java\u7c7b\u8def\u5f84\u201c#1\u201d\u627e\u4e0d\u5230\u76f8\u5173\u7684\u7c7b").replace("#1", javaClassPath));
                return false;
            }
            aliasSet.add(alias);
        }
        return true;
    }

    @Override
    public List<Map<String, Object>> getAssembledTargets() {
        this.lastAssembled = null;
        int count = this._reportTable.getRowCount();
        for (int i = 0; i < count; ++i) {
            if (this.lastAssembled == null) {
                this.lastAssembled = new ArrayList<Map<String, Object>>(4);
            }
            HashMap<String, Object> map = new HashMap<String, Object>(4);
            IRow curRow = this._reportTable.getRow(i);
            map.put("ASSEMBLER_NAME", CustomHyperLinkAssembler.class.getName());
            map.put("HYPERLINK_PREFIX", PREFIX);
            map.put("DISPLAY_NAME", curRow.getCell(0).getValue());
            map.put(JAVA_CLASS_NAME, curRow.getCell(1).getValue());
            ExtTransitionTarget target = (ExtTransitionTarget)curRow.getUserObject();
            map.put(JAVA_PARAMS, target.getParameters());
            this.lastAssembled.add(map);
        }
        return this.lastAssembled;
    }

    @Override
    public void setAssembledTargets(List<Map<String, Object>> list) {
        this.lastAssembled = null;
        this._reportTable.removeRows();
        if (list == null) {
            return;
        }
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Map<String, Object> map = list.get(i);
            IRow rowAdded = this._reportTable.addRow();
            String name = (String)map.get("DISPLAY_NAME");
            String className = (String)map.get(JAVA_CLASS_NAME);
            Map params = (Map)map.get(JAVA_PARAMS);
            rowAdded.getCell(0).setValue((Object)name);
            rowAdded.getCell(1).setValue((Object)className);
            rowAdded.setUserObject((Object)new ExtTransitionTarget(new ReportProperties(null, name, className), params));
        }
        this._reportTable.getSelectManager().select(0, 0);
    }

    @Override
    public Map getSuggestedDefaultTarget() {
        return null;
    }

    @Override
    public String getHyperLinkPrefix() {
        return PREFIX;
    }

    private String getNextParamName() {
        Map<Object, Object> params = new HashMap();
        int rowIndex = this._reportTable.getSelectManager().getActiveRowIndex();
        if (rowIndex >= 0) {
            params = ((ExtTransitionTarget)this._reportTable.getRow(rowIndex).getUserObject()).getParameters();
        }
        int i = 1;
        String paramName;
        while (params.get(paramName = "param" + i) != null) {
            ++i;
        }
        return paramName;
    }

    private void setTipLabel() {
        if (this._paramTable.getRowCount() > 0) {
            if (this._labelParam != null) {
                this._paramTable.remove((Component)this._labelParam);
            }
        } else {
            if (this._labelParam == null) {
                int width = this._paramTable.getWidth() == 0 ? 516 : this._paramTable.getWidth();
                int height = this._paramTable.getHeight() == 0 ? 185 : this._paramTable.getHeight();
                this._labelParam = new KDLabel(CtrlEXTMessages.getMLS("noParameterSettingsRequired", "\u65e0\u9700\u8bbe\u7f6e\u53c2\u6570\uff01"));
                this._labelParam.setBounds(width / 2 - 45, height / 2 - 10, 250, 20);
                this._labelParam.setForeground(Color.GRAY);
                this._labelParam.setFont(new Font(CtrlEXTMessages.getMLS("font", "\u5fae\u8f6f\u96c5\u9ed1"), 2, 16));
            }
            this._paramTable.add((Component)this._labelParam);
        }
    }

    private IParameter addParamRow() {
        int index = this._paramTable.getSelectManager().getActiveRowIndex();
        IRow rowAdded = index < 0 ? this._paramTable.addRow() : this._paramTable.addRow(index);
        String name = this.getNextParamName();
        ParameterImpl param = new ParameterImpl(name, name, 0, null, false);
        param.setUserDefine(true);
        rowAdded.getCell(0).getStyleAttributes().setLocked(false);
        rowAdded.getCell(2).getStyleAttributes().setLocked(false);
        rowAdded.getCell(3).getStyleAttributes().setLocked(false);
        rowAdded.getCell(4).getStyleAttributes().setLocked(false);
        rowAdded.getCell(0).getStyleAttributes().setBackground(Color.white);
        rowAdded.getCell(2).getStyleAttributes().setBackground(Color.white);
        rowAdded.getCell(3).getStyleAttributes().setBackground(Color.white);
        rowAdded.getCell(4).getStyleAttributes().setBackground(Color.white);
        rowAdded.getCell(0).setValue((Object)param.getName());
        rowAdded.getCell(2).setValue((Object)param.getAlias());
        rowAdded.getCell(3).setValue((Object)CustomHyperLinkAssembler.getText());
        rowAdded.getCell(4).setValue((Object)Boolean.TRUE);
        return param;
    }

    private boolean checkClassName(String className) {
        if (StringUtil.isEmptyString((String)className)) {
            return false;
        }
        String[] classNames = className.split("\\.");
        if (classNames[classNames.length - 1].indexOf("QingRpt") != 0) {
            this.showMsgBox(CtrlEXTMessages.getMLS("customLinkageClassMustStartWithQingRpt", "\u4ee3\u7801\u5b9a\u5236\u8054\u67e5\u76ee\u6807\u7c7b\u987b\u4ee5\u201cQingRpt\u201d\u5f00\u5934"));
            return false;
        }
        IExtCallback callback = this.ext.getExtCallback();
        Book book = MiscUtil.getActiveSpreadContext(this.ext).getBook();
        Map<String, String> msg = callback.checkCustomHyperLinkParams(className, book.getDataSetManager().getExecutionContext());
        String error = "";
        if (msg != null && !StringUtil.isEmptyString((String)(error = msg.get("ERROR")))) {
            this.showMsgBox(error);
            return false;
        }
        return true;
    }

    private void syncParams(boolean update) {
        int index = this._reportTable.getSelectManager().getActiveRowIndex();
        Map<String, IParameter> params = null;
        ExtTransitionTarget tt = null;
        IRow row = this._reportTable.getRow(index);
        if (index >= 0 && (tt = (ExtTransitionTarget)row.getUserObject()) != null) {
            params = tt.getParameters();
        }
        Map<String, IParameter> newParams = null;
        if (update) {
            try {
                if (tt == null) {
                    tt = new ExtTransitionTarget(new ReportProperties(null, (String)row.getCell(0).getValue(), (String)row.getCell(1).getValue()), null);
                    params = tt.getParameters();
                }
                newParams = this.updateParams(tt);
            }
            catch (Exception exception) {
                Throwable cause = exception.getCause();
                if (cause instanceof IllegalArgumentException) {
                    this.showMsgBox(cause.getMessage());
                }
                return;
            }
        }
        this.refreshParamTable(params, newParams);
        if (this._paramTable.getRowCount() > 0) {
            this._paramTable.getSelectManager().select(0, 0);
        }
    }

    private Map<String, IParameter> updateParams(ExtTransitionTarget tt) throws Exception {
        IExtCallback callback = this.ext.getExtCallback();
        Book book = MiscUtil.getActiveSpreadContext(this.ext).getBook();
        ExecutionContext ctx = book.getDataSetManager().getExecutionContext();
        return callback.fetchCustomHyperLinkParams(tt.getReportProps().getPath(), ctx);
    }

    private void paramTableEditStopping(KDTEditEvent e) {
        if (this._currentRow == null) {
            return;
        }
        Object userObject = this._currentRow.getUserObject();
        Map<String, IParameter> allParams = null;
        if (userObject instanceof ExtTransitionTarget) {
            ExtTransitionTarget target = (ExtTransitionTarget)userObject;
            allParams = target.getParameters();
        }
        if (allParams == null) {
            return;
        }
        IParameter param = allParams.get(this._paramTable.getCell(e.getRowIndex(), 0).getValue());
        if (param == null) {
            return;
        }
        this.paramTableEditStopping(e, param, allParams);
    }

    private void paramTableEditStopping(KDTEditEvent e, IParameter param, Map<String, IParameter> allParams) {
        int col = e.getColIndex();
        if (col == 0) {
            String name = (String)e.getValue();
            if (name.equals(param.getName())) {
                return;
            }
            if (this.isErrorParamName(name)) {
                this.showMsgBox(CtrlEXTMessages.getMLS("parameterNameMustStartWithLetter", "\u53c2\u6570\u540d\u5e94\u4ee5\u82f1\u6587\u5b57\u6bcd\u5f00\u5934\uff0c\u53ef\u8ddf\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u3002"));
                e.setCancel(true);
                return;
            }
            if (allParams.get(name) != null) {
                this.showMsgBox(CtrlEXTMessages.getMLS("duplicateParameterName", "\u53c2\u6570\u540d\u91cd\u590d!"));
                e.setCancel(true);
                return;
            }
            allParams.remove(param.getName());
            param.setName(name);
            allParams.put(name, param);
        } else if (col == 1) {
            Object value = e.getValue();
            this.setParamValue(param, (String)value);
        } else if (col == 2) {
            param.setAlias((String)e.getValue());
        } else if (col == 3) {
            String type = (String)e.getValue();
            if (CustomHyperLinkAssembler.getText().equals(type)) {
                param.setDataType(0);
            } else if (CustomHyperLinkAssembler.getNumber().equals(type)) {
                param.setDataType(1);
            } else if (CustomHyperLinkAssembler.getDate().equals(type)) {
                param.setDataType(2);
            } else if (CustomHyperLinkAssembler.getDateTime().equals(type)) {
                param.setDataType(4);
            } else if (CustomHyperLinkAssembler.getTime().equals(type)) {
                param.setDataType(5);
            } else if (CustomHyperLinkAssembler.getBoolean().equals(type)) {
                param.setDataType(3);
            }
        } else if (col == 4) {
            param.setNullable((Boolean)e.getValue() == false);
        }
    }

    private KDPromptBox createF7Component() {
        KDPromptBox f7FormulaWizard = new KDPromptBox();
        f7FormulaWizard.setHistoryRecordEnabled(false);
        f7FormulaWizard.setIcon(ResourceManager.getImageIcon("func_new.png").getImage());
        f7FormulaWizard.setSelector((KDPromptSelector)new FormulaWizardPopupForF7(this.ext, f7FormulaWizard));
        f7FormulaWizard.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                KDPromptBox f7 = (KDPromptBox)e.getSource();
                FormulaWizardPopupForF7 popup = (FormulaWizardPopupForF7)f7.getSelector();
                popup.setEditingData(f7.getText());
                popup.setImpresario((KDDialog)SwingUtilities.getWindowAncestor((Component)((Object)CustomHyperLinkAssembler.this)));
            }
        });
        return f7FormulaWizard;
    }

    private void initParamTable() {
        this._paramTable.getSelectManager().setSelectMode(2);
        this._paramTable.addColumns(5);
        IColumn colName = this._paramTable.getColumn(0);
        IColumn colalias = this._paramTable.getColumn(2);
        IColumn colDataType = this._paramTable.getColumn(3);
        IColumn colRequired = this._paramTable.getColumn(4);
        this._paramTable.getColumn(1).setWidth(185);
        colName.setWidth(85);
        colalias.setWidth(88);
        colDataType.setWidth(55);
        colRequired.setWidth(30);
        colName.getStyleAttributes().setBackground(this._locked);
        colalias.getStyleAttributes().setBackground(this._locked);
        colDataType.getStyleAttributes().setBackground(this._locked);
        colRequired.getStyleAttributes().setBackground(this._locked);
        colName.getStyleAttributes().setLocked(true);
        colalias.getStyleAttributes().setLocked(true);
        colDataType.getStyleAttributes().setLocked(true);
        colRequired.getStyleAttributes().setLocked(true);
        colDataType.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)new KDComboBox((Object[])new String[]{CustomHyperLinkAssembler.getText(), CustomHyperLinkAssembler.getNumber(), CustomHyperLinkAssembler.getDate(), CustomHyperLinkAssembler.getDateTime(), CustomHyperLinkAssembler.getTime(), CustomHyperLinkAssembler.getBoolean()})));
        this._paramTable.addHeadRow();
        IRow headRow = this._paramTable.getHeadRow(0);
        headRow.getCell(0).setValue((Object)CtrlEXTMessages.getMLS("KEY_NAME", "\u540d\u79f0"));
        headRow.getCell(1).setValue((Object)CtrlEXTMessages.getMLS("KEY_VALUE", "\u503c"));
        headRow.getCell(2).setValue((Object)CtrlEXTMessages.getMLS("displayName", "\u663e\u793a\u540d\u79f0"));
        headRow.getCell(3).setValue((Object)CtrlEXTMessages.getMLS("dataType", "\u6570\u636e\u7c7b\u578b"));
        headRow.getCell(4).setValue((Object)CtrlEXTMessages.getMLS("required", "\u5fc5\u586b"));
        this._paramTable.getIndexColumn().getStyleAttributes().setHided(true);
        ActionMap am = this._paramTable.getActionMap();
        am.remove("Copy");
        am.remove("Paste");
        am.remove("Cut");
        am.remove("Delete");
        KDPromptBox f7FormulaWizard = this.createF7Component();
        this._paramTable.getColumn(1).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)f7FormulaWizard));
    }

    private boolean isErrorParamName(String source) {
        if (StringUtil.isEmptyString((String)source)) {
            return true;
        }
        Pattern regxPattern = Pattern.compile("^[a-zA-Z][a-zA-Z0-9_]*$");
        Matcher m = regxPattern.matcher(source);
        return !m.matches();
    }

    private void setParamValue(IParameter param, String formula) {
        if (StringUtil.isEmptyString((String)formula)) {
            ((ICalculableProps)((Object)param)).setExpr(null);
        } else {
            Sheet sheet = MiscUtil.getActiveSpreadContext(this.ext).getBook().getActiveSheet();
            Cell cell = sheet.getActiveCell();
            Expr expr = sheet.getExpr(cell, formula);
            ((ICalculableProps)((Object)param)).setExpr(expr);
        }
    }
}

