/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.immit.datawalker;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.immit.AbstractExecutableHyperLinkExec;
import com.kingdee.cosmic.ctrl.ext.immit.datawalker.IHyperLinkJumper;
import com.kingdee.cosmic.ctrl.ext.immit.datawalker.SheetDataWalker;
import com.kingdee.cosmic.ctrl.ext.util.MessageUtil;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import com.kingdee.cosmic.ctrl.kds.expans.model.ExtConst;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExternalTargets;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.HyperlinkCalculableProps;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import java.awt.KeyboardFocusManager;

public class DataWalkerHyperLinkExec
extends AbstractExecutableHyperLinkExec {
    public void execute(String linkTo) {
        block9: {
            if (StringUtil.isEmptyString((String)linkTo)) {
                this.malformedHyperLink(linkTo);
                return;
            }
            Sheet sheet = this._guiExecutor.getSpreadContext().getBook().getActiveSheet();
            ExternalTargets externals = (ExternalTargets)((HyperlinkCalculableProps)sheet.getActiveCell().getExtProps(false).getFormulas(false).get(ExtConst.FORMULA_HYPERLINK)).getTargets().get("EXTERNAL");
            String clsName = (String)externals.getTargetsByName(linkTo).get("JAVA_CLASS_NAME");
            try {
                IHyperLinkJumper jumper = (IHyperLinkJumper)Class.forName(clsName).newInstance();
                jumper.jumpTo(new SheetDataWalker(sheet));
            }
            catch (InstantiationException e) {
                String info = CtrlEXTMessages.getMLS("javaJointTargetInitFailure", "Java\u8054\u67e5\u76ee\u6807\u5bf9\u8c61\u521d\u59cb\u5316\u5931\u8d25\uff01");
                this.showMsgBox(info);
                if (MiscUtil.shouldLog()) {
                    MiscUtil.log(4, info);
                    MiscUtil.log(e);
                }
            }
            catch (IllegalAccessException e) {
                String info = CtrlEXTMessages.getMLS("permissionDenied", "\u6743\u9650\u4e0d\u8db3\uff0c\u65e0\u6cd5\u521d\u59cb\u5316Java\u8054\u67e5\u76ee\u6807\u5bf9\u8c61\uff01");
                this.showMsgBox(info);
                if (MiscUtil.shouldLog()) {
                    MiscUtil.log(4, info);
                    MiscUtil.log(e);
                }
            }
            catch (ClassNotFoundException e) {
                String info = CtrlEXTMessages.getMLS("javaJointClassNotFound", "\u65e0\u6cd5\u627e\u5230Java\u8054\u67e5\u76ee\u6807\u7c7b\uff01");
                this.showMsgBox(info);
                if (MiscUtil.shouldLog()) {
                    MiscUtil.log(4, info);
                    MiscUtil.log(e);
                }
            }
            catch (Throwable t) {
                String info = CtrlEXTMessages.getMLS("javaJointUnknownException", "Java\u8054\u67e5\u76ee\u6807\u65f6\u53d1\u751f\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u53c2\u8003\u63a7\u5236\u53f0\u4fe1\u606f\uff01");
                this.showMsgBox(info);
                if (!MiscUtil.shouldLog()) break block9;
                MiscUtil.log(4, info);
                MiscUtil.log(t);
            }
        }
    }

    private void showMsgBox(String msg) {
        MessageUtil.msgboxWarning(null, msg);
    }

    private void malformedHyperLink(String linkTo) {
        if (MiscUtil.shouldLog()) {
            MiscUtil.log(4, CtrlEXTMessages.getMLS("invalidJavaJointLink", "\u975e\u6cd5\u7684Java\u8054\u67e5\u94fe\u63a5\uff01\u76ee\u6807Java\u8054\u67e5\u94fe\u63a5\u4fe1\u606f:") + linkTo);
        }
        MessageUtil.msgboxWarning(KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow(), CtrlEXTMessages.getMLS("invalidJavaJointLink", "\u975e\u6cd5\u7684Java\u8054\u67e5\u94fe\u63a5\uff01\u76ee\u6807Java\u8054\u67e5\u94fe\u63a5\u4fe1\u606f:"));
    }
}

