/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.immit.datawalker;

import com.kingdee.cosmic.ctrl.ext.immit.datawalker.IDataWalkerCommand;
import com.kingdee.cosmic.ctrl.ext.immit.datawalker.SheetDataWalker;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;

class GetValuesAtRowCommand
implements IDataWalkerCommand {
    GetValuesAtRowCommand() {
    }

    @Override
    public boolean execute(Sheet sheet, Object[] params) {
        if (!SheetDataWalker.checkParamsValid(params, 2, new Class[]{Integer.class})) {
            return false;
        }
        int targetRow = (Integer)params[0];
        int maxcol = sheet.getMaxColIndex() + 1;
        Variant[] values = new Variant[maxcol];
        for (int i = 0; i < maxcol; ++i) {
            Cell cell = sheet.getCell(targetRow, i, false);
            if (cell != null) {
                values[i] = cell.getValue();
                continue;
            }
            Cell firstCell = SheetDataWalker.getFirstCellForMerge(sheet, targetRow, i);
            if (firstCell == null) continue;
            values[i] = firstCell.getValue();
        }
        params[1] = values;
        return true;
    }
}

