/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.pd;

import com.kingdee.cosmic.ctrl.ext.pd.model.beans.BasicBean;
import com.kingdee.cosmic.ctrl.ext.pd.model.beans.CheckBoxBean;
import com.kingdee.cosmic.ctrl.ext.pd.model.beans.ComboBoxBean;
import com.kingdee.cosmic.ctrl.ext.pd.model.beans.DatePickerBean;
import com.kingdee.cosmic.ctrl.ext.pd.model.beans.LabelBean;
import com.kingdee.cosmic.ctrl.ext.pd.model.beans.TextFieldBean;
import com.kingdee.cosmic.ctrl.ext.pd.ui.embed.EmbedXLabel;
import com.kingdee.cosmic.ctrl.ext.pd.ui.embed.ParamEmbedXCheckBox;
import com.kingdee.cosmic.ctrl.ext.pd.ui.embed.ParamEmbedXComboBox;
import com.kingdee.cosmic.ctrl.ext.pd.ui.embed.ParamEmbedXDatePicker;
import com.kingdee.cosmic.ctrl.ext.pd.ui.embed.ParamEmbedXTextField;
import com.kingdee.cosmic.ctrl.ext.pe.beans.DefaultBeanInfoResolver;
import com.kingdee.cosmic.ctrl.ext.pe.propsheet.Property;
import com.kingdee.cosmic.ctrl.ext.pe.propsheet.PropertySheetPanel;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.cosmic.ctrl.kds.model.struct.event.GraphChangeListener;
import com.kingdee.cosmic.ctrl.kds.model.struct.event.GraphChangedEvent;
import com.kingdee.cosmic.ctrl.kds.model.struct.event.GraphPropertyChangedEvent;
import java.beans.BeanInfo;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyVetoException;
import javax.swing.UIManager;

public class ParamBeanBindingManager {
    private SpreadContext _context;
    private PropertySheetPanel _psp;
    private BasicBean basicBean;
    private TextFieldBean textBean;
    private ComboBoxBean comboBean;
    private DatePickerBean dateBean;
    private LabelBean labelBean;
    private CheckBoxBean checkBoxBean;
    private Object contextBean;
    private BeanPropertyChangeListener propertyChangeListener;

    public ParamBeanBindingManager(SpreadContext context, PropertySheetPanel psp) {
        this._context = context;
        this._psp = psp;
        this.init();
        this.initListeners();
    }

    private void init() {
        this.basicBean = new BasicBean();
        this.textBean = new TextFieldBean();
        this.comboBean = new ComboBoxBean();
        this.dateBean = new DatePickerBean();
        this.labelBean = new LabelBean();
        this.checkBoxBean = new CheckBoxBean();
        this.propertyChangeListener = new BeanPropertyChangeListener();
    }

    private void initListeners() {
        this._psp.addPropertySheetChangeListener(this.propertyChangeListener);
        this._context.addGraphChangeListener(new GraphChangeListener(){

            @Override
            public void changed(GraphChangedEvent e) {
                if (e.getType() == "Graph_PreDeselected") {
                    ParamBeanBindingManager.this.commitPropertySheetPanels();
                    return;
                }
                ParamBeanBindingManager.this.bindContextBean();
                EmbedhLayer ems = ParamBeanBindingManager.this._context.getBook().getActiveSheet().getEmbedments(false);
                if (ems != null && ems.selectionSize() > 1) {
                    ParamBeanBindingManager.this.setSomePropertiesEnabled(false);
                } else {
                    ParamBeanBindingManager.this.setSomePropertiesEnabled(true);
                }
                ParamBeanBindingManager.this.refreshPropertySheetPanels();
            }

            @Override
            public void propertyChanged(GraphPropertyChangedEvent e) {
                if (e.isBoundsChanged()) {
                    ParamBeanBindingManager.this.refreshPropertySheetPanels();
                }
            }
        });
    }

    public void commitPropertySheetPanels() {
        this._psp.getTable().commitEditing();
    }

    private void bindContextBean() {
        EmbedObject embed;
        Sheet sheet = this._context.getBook().getActiveSheet();
        EmbedhLayer ems = sheet.getEmbedments(false);
        this.contextBean = ems.selectionSize() == 1 ? ((embed = ems.getSelectedEmbed(0)) instanceof ParamEmbedXTextField ? this.textBean : (embed instanceof ParamEmbedXComboBox ? this.comboBean : (embed instanceof ParamEmbedXDatePicker ? this.dateBean : (embed instanceof EmbedXLabel ? this.labelBean : (embed instanceof ParamEmbedXCheckBox ? this.checkBoxBean : this.basicBean))))) : (ems.selectionSize() == 0 ? null : this.basicBean);
        if (this.contextBean != null) {
            ((BasicBean)this.contextBean).setSheet(sheet);
        }
        this.bind(this.contextBean);
    }

    private void bind(Object bean) {
        this.bind(bean, new DefaultBeanInfoResolver().getBeanInfo(bean));
    }

    private void bind(Object bean, BeanInfo beanInfo) {
        if (beanInfo == null) {
            this._psp.setProperties(new PropertyDescriptor[0]);
        } else {
            this._psp.setProperties(beanInfo.getPropertyDescriptors());
        }
        this.propertyChangeListener.bean = bean;
    }

    private void refreshPropertySheetPanels() {
        this._psp.readFromObject(this.contextBean, false);
    }

    private void setSomePropertiesEnabled(boolean enabled) {
    }

    private class BeanPropertyChangeListener
    implements PropertyChangeListener {
        private Object bean;

        private BeanPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Property prop = (Property)evt.getSource();
            try {
                prop.writeToObject(this.bean);
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof PropertyVetoException) {
                    UIManager.getLookAndFeel().provideErrorFeedback(ParamBeanBindingManager.this._psp);
                    prop.setValue(evt.getOldValue());
                }
                throw e;
            }
        }
    }
}

